/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base.project.spec;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.fmm.common.util.CommonFilterConditionUtil;
import kd.pmc.pmpd.common.util.FiledSetUtil;
import kd.pmc.pmpd.project.spec.ProjectSpecServcieHelper;
import kd.pmc.pmts.business.helper.PmtsTaskValueHelper;

public class ProjectSpecification
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String TBL_SIMILARPROJECT = "similarproject";
    private static final String TBL_REBUILD = "rebuild";
    private static final String TBL_GENERATEBYPROJECT = "generatebyproject";
    private static final String ENTITY = "pmpd_calcsimilarproj";

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName;
        if (event == null) {
            return;
        }
        super.propertyChanged(event);
        IDataEntityProperty dataEntityProperty = event.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            this.propertyChanged(changeData, propertyName);
        }
    }

    public void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        event.setCancel(true);
        this.showMMResplanno();
    }

    private void showMMResplanno() {
        DynamicObject mmresplanno = (DynamicObject)this.getModel().getValue("resourceplan");
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("pmpd_resourceplan");
        String entityId = this.getView().getEntityId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (mmresplanno != null) {
            baseShowParameter.setPkId(mmresplanno.getPkValue());
            baseShowParameter.setCustomParam("view", (Object)Boolean.TRUE);
            baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "resourceplan"));
            baseShowParameter.setAppId(entityType.getAppId());
            baseShowParameter.setCustomParam("ServiceAppId", (Object)entityType.getAppId());
            this.getView().showForm((FormShowParameter)baseShowParameter);
        }
    }

    private void propertyChanged(ChangeData changeData, String propertyName) {
        Object oldObject = changeData.getOldValue();
        Object newObject = changeData.getNewValue();
        DynamicObject propertyValueCDDE = changeData.getDataEntity();
        if (oldObject != null && newObject != null && oldObject.toString().equalsIgnoreCase(newObject.toString())) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"project")) {
            this.projectChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"resourceplan")) {
            this.resourceplanChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"materialmtcinfo")) {
            this.materialmtcinfoChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"workpackid")) {
            this.workpackChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"jobcard") && this.getPageCache().get("initProjectJc") == null) {
            this.jobcardChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"jobcardto") && this.getPageCache().get("initProjectTo") == null) {
            this.jobcardtoChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"jobcardma") && this.getPageCache().get("initProjectMa") == null) {
            this.jobcardmaChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        }
    }

    private void resourceplanChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        String projectResoucePlanLock = this.getView().getPageCache().get("projectresouceplanlock");
        Boolean bool = false;
        if (!"1".equals(projectResoucePlanLock)) {
            this.getView().getPageCache().put("projectresouceplanlock", "1");
            bool = true;
            if (newObject == null) {
                this.getModel().setValue("project", null);
            } else {
                DynamicObject resourceplan = (DynamicObject)newObject;
                Long id = resourceplan.getLong("id");
                List projectIds = ProjectSpecServcieHelper.getProjectToresoucePlan((Long)id);
                if (projectIds != null && !projectIds.isEmpty()) {
                    this.getModel().setValue("project", (Object)projectIds.toArray());
                } else {
                    this.getModel().setValue("project", null);
                }
            }
        }
        if (bool.booleanValue()) {
            this.getView().getPageCache().remove("projectresouceplanlock");
        }
    }

    private void jobcardmaChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        if (newObject != null) {
            HashSet<Long> jobCardSet = new HashSet<Long>();
            DynamicObject dyn = (DynamicObject)newObject;
            jobCardSet.add(dyn.getLong("id"));
            Map<String, Map<String, List<Map<String, Object>>>> data = this.invokeBizServiceWorkCardByCardIds(jobCardSet);
            if (data != null) {
                Map<Long, Map<String, Object>> mroOrderMap = this.getMrpOrder(data);
                List<Map<String, Object>> maCardMatCommandList = this.getMaCardMatCommand(data);
                this.setMaEntryEntity(maCardMatCommandList, rowIndex, mroOrderMap);
            }
        } else {
            this.getModel().setValue("jobcardma", null, rowIndex);
            this.getModel().setValue("mamroorder", null, rowIndex);
            this.getModel().setValue("entrymftmaterial", null, rowIndex);
            this.getModel().setValue("quantitydemand", null, rowIndex);
            this.getModel().setValue("maentrybaseunit", null, rowIndex);
            this.getModel().setValue("mabaseqty", (Object)1, rowIndex);
            this.getModel().setValue("qty", (Object)1, rowIndex);
            this.getModel().setValue("unitfield", null, rowIndex);
            this.getModel().setValue("madesc", null, rowIndex);
        }
    }

    private void jobcardtoChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        if (newObject != null) {
            HashSet<Long> jobCardSet = new HashSet<Long>();
            DynamicObject dyn = (DynamicObject)newObject;
            jobCardSet.add(dyn.getLong("id"));
            Map<String, Map<String, List<Map<String, Object>>>> data = this.invokeBizServiceWorkCardByCardIds(jobCardSet);
            if (data != null) {
                Map<Long, Map<String, Object>> mroOrderMap = this.getMrpOrder(data);
                List<Map<String, Object>> toCardToolDemandList = this.getToCardToolDemand(data);
                this.setToEntryEntity(toCardToolDemandList, rowIndex, mroOrderMap);
            }
        } else {
            this.getModel().setValue("jobcardto", null, rowIndex);
            this.getModel().setValue("tomroorder", null, rowIndex);
            this.getModel().setValue("tomaterial", null, rowIndex);
            this.getModel().setValue("entrybaseunit", null, rowIndex);
            this.getModel().setValue("tobaseqty", null, rowIndex);
            this.getModel().setValue("enrtyunit", null, rowIndex);
            this.getModel().setValue("toqty", (Object)1, rowIndex);
            this.getModel().setValue("todesc", null, rowIndex);
        }
    }

    private void jobcardChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        if (newObject != null) {
            HashSet<Long> jobCardSet = new HashSet<Long>();
            DynamicObject dyn = (DynamicObject)newObject;
            jobCardSet.add(dyn.getLong("id"));
            Map<String, Map<String, List<Map<String, Object>>>> data = this.invokeBizServiceWorkCardByCardIds(jobCardSet);
            if (data != null) {
                Map<Long, Map<String, Object>> mroOrderMap = this.getMrpOrder(data);
                List<Map<String, Object>> mrocardrouteList = this.getJcMrocardroute(data, Boolean.TRUE);
                this.setJcEntryEntity(mrocardrouteList, rowIndex, mroOrderMap);
            }
        } else {
            this.getModel().setValue("mroorder", null, rowIndex);
            this.getModel().setValue("workcategories", null, rowIndex);
            this.getModel().setValue("professiona", null, rowIndex);
            this.getModel().setValue("majorflag", null, rowIndex);
            this.getModel().setValue("largemajordescs", null, rowIndex);
            this.getModel().setValue("entryresourcestatus", null, rowIndex);
            this.getModel().setValue("describe", null, rowIndex);
        }
    }

    private void workpackChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        if (newObject != null) {
            String workPackId = (String)newObject;
            if (workPackId.length() > 0) {
                Set<Long> workPacks = this.getJobCardSet(workPackId);
                Map jobCardMap = ProjectSpecServcieHelper.getJobCardToWorkpack(workPacks);
                this.deleteEntryAllRow("pkgentryentity");
                this.deleteEntryAllRow("jcentryentity");
                this.deleteEntryAllRow("toentryentity");
                this.deleteEntryAllRow("maentryentity");
                if (!jobCardMap.isEmpty()) {
                    Map<String, Map<String, List<Map<String, Object>>>> data;
                    HashSet workAreas = new HashSet(jobCardMap.size());
                    for (Map.Entry entry : jobCardMap.entrySet()) {
                        if ((Long)entry.getValue() == 0L) continue;
                        workAreas.add(entry.getValue());
                    }
                    Map areaMap = ProjectSpecServcieHelper.getPlanningAreaToWorkArea(workAreas);
                    int i = 0;
                    HashMap<Long, Map<Long, Long>> areaJobCardMap = new HashMap<Long, Map<Long, Long>>(8);
                    for (Map.Entry entry : jobCardMap.entrySet()) {
                        HashMap map;
                        Object planArea = (Long)areaMap.get(entry.getValue());
                        if (planArea == null) {
                            planArea = 0L;
                        }
                        if ((map = (HashMap)areaJobCardMap.get(planArea)) == null) {
                            map = new HashMap(8);
                        }
                        map.put(entry.getKey(), areaMap.get(entry.getValue()));
                        areaJobCardMap.put((Long)planArea, map);
                    }
                    this.getModel().batchCreateNewEntryRow("pkgentryentity", areaJobCardMap.size());
                    LinkedHashSet<Long> planAreaSet = this.planAreaGetSort(areaJobCardMap);
                    LinkedHashMap areaJobCardSortMap = new LinkedHashMap();
                    for (Long planAreaId : planAreaSet) {
                        if (planAreaId == 0L) continue;
                        areaJobCardSortMap.put(planAreaId, areaJobCardMap.get(planAreaId));
                    }
                    for (Map.Entry areaJobCardMapEntry : areaJobCardSortMap.entrySet()) {
                        if ((Long)areaJobCardMapEntry.getKey() == 0L) continue;
                        this.getModel().setValue("newplanningarea", areaJobCardMapEntry.getKey(), i);
                        ++i;
                    }
                    Map areaJobCard0L = (Map)areaJobCardSortMap.get(0L);
                    if (areaJobCard0L != null) {
                        this.getModel().deleteEntryRow("pkgentryentity", i);
                    }
                    if ((data = this.invokeBizServiceAllWorkCard()) != null) {
                        this.setIWorkCardData(data);
                    }
                }
            }
        } else {
            this.deleteEntryAllRow("pkgentryentity");
            this.deleteEntryAllRow("jcentryentity");
            this.deleteEntryAllRow("toentryentity");
            this.deleteEntryAllRow("maentryentity");
        }
    }

    private LinkedHashSet<Long> planAreaGetSort(Map<Long, Map<Long, Long>> areaJobCardMap) {
        QFilter qFilter = new QFilter("id", "in", areaJobCardMap.keySet());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"fmm_planningarea_sort", (String)"fmm_planningarea", (String)"id,seqnumber", (QFilter[])qFilter.toArray(), null);){
            TreeMap<Long, Integer> varMap = new TreeMap<Long, Integer>();
            for (Row row : dataSet) {
                varMap.put(row.getLong("id"), row.getInteger("seqnumber"));
            }
            ArrayList list = new ArrayList(varMap.entrySet());
            LinkedHashSet linkedHashSet = list.stream().sorted(Comparator.comparing(e -> (Integer)e.getValue())).map(i -> (Long)i.getKey()).collect(Collectors.toCollection(LinkedHashSet::new));
            return linkedHashSet;
        }
    }

    private Map<String, Map<String, List<Map<String, Object>>>> invokeBizServiceWorkCardByCardIds(Set<Long> jobCardSet) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(10);
        Map<Long, Map<String, Object>> cardSearchDetail = this.getCardSearchDetail();
        Map data = null;
        for (Long card : jobCardSet) {
            HashSet<Long> cardIdSet = new HashSet<Long>();
            cardIdSet.add(card);
            Map<String, Object> stringObjectMap = cardSearchDetail.get(card);
            if (stringObjectMap == null) continue;
            stringObjectMap.put("cardId", cardIdSet);
            params.add(stringObjectMap);
        }
        data = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IWorkCardDataService", (String)"getBatchWorkCardData", (Object[])new Object[]{params, org.getLong("id")});
        return data;
    }

    private Map<String, Map<String, List<Map<String, Object>>>> invokeBizServiceAllWorkCard() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Map<Long, Map<String, Object>> projectMap = this.getProjectMap();
        Map<Long, Set<Long>> cardMap = this.getCardMap();
        Map data = null;
        ArrayList params = new ArrayList(10);
        for (Map.Entry<Long, Map<String, Object>> entry : projectMap.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            if (cardMap.get(entry.getKey()) != null) {
                map.put("cardId", cardMap.get(entry.getKey()));
            } else {
                map.put("cardId", new HashSet(10));
            }
            map.put("modelone", projectMap.get(entry.getKey()).get("modelone"));
            map.put("modeltwo", projectMap.get(entry.getKey()).get("modeltwo"));
            map.put("manuFacturer", projectMap.get(entry.getKey()).get("manuFacturer"));
            map.put("cabinconfigId", projectMap.get(entry.getKey()).get("cabinconfigId"));
            params.add(map);
        }
        data = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IWorkCardDataService", (String)"getBatchWorkCardData", (Object[])new Object[]{params, org.getLong("id")});
        return data;
    }

    Map<Long, Map<String, Object>> getCardSearchDetail() {
        HashMap<Long, Map<String, Object>> cardSearchDetailMap = new HashMap<Long, Map<String, Object>>(10);
        Map<Long, Map<String, Object>> projectMap = this.getProjectMap();
        Map<Long, Set<Long>> cardMap = this.getCardMap();
        for (Map.Entry<Long, Set<Long>> entry : cardMap.entrySet()) {
            for (Long cardId : cardMap.get(entry.getKey())) {
                cardSearchDetailMap.put(cardId, projectMap.get(entry.getKey()));
            }
        }
        return cardSearchDetailMap;
    }

    private Map<Long, Map<String, Object>> getProjectMap() {
        HashMap<Long, Map<String, Object>> projectMap = new HashMap<Long, Map<String, Object>>(10);
        DynamicObjectCollection dyObjs = (DynamicObjectCollection)this.getModel().getValue("project");
        ArrayList<Long> modelIds = new ArrayList<Long>();
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject dynamicObject : dyObjs) {
            ids.add(dynamicObject.getLong("fbasedataid.id"));
        }
        QFilter idsFilter = new QFilter("id", "in", ids);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"ProjectSpecServcieHelper_getProjectMap", (String)"pmpd_project", (String)"id,engineequipmodel.id,engineequipmodel.group.number,devices.engineequipmodel.number AS enginenumber,devices.engineequipmodel.group.number AS enginetype,cabinconfig", (QFilter[])new QFilter[]{idsFilter}, null);
        Object object = null;
        try {
            for (Row row : ds) {
                if (row.getLong("id") == null || row.getLong("id") == 0L) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(10);
                map.put("cabinconfigId", row.getLong("cabinconfig"));
                if ("modeltrd".equals(row.getString("enginetype"))) {
                    map.put("manuFacturer", row.getString("enginenumber"));
                }
                map.put("modelid", row.getLong("engineequipmodel.id"));
                modelIds.add(row.getLong("engineequipmodel.id"));
                map.put("modeltype", row.getString("engineequipmodel.group.number"));
                projectMap.put(row.getLong("id"), map);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        Map modelMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMrTypeConfigModelService", (String)"getParentTypesMap", (Object[])new Object[]{modelIds});
        for (Map.Entry entry : projectMap.entrySet()) {
            Map projectParamsMap = (Map)projectMap.get(entry.getKey());
            if (projectParamsMap.get("modelid") == null || modelMap.get(projectParamsMap.get("modelid")) == null) continue;
            ((Map)modelMap.get(projectParamsMap.get("modelid"))).put(projectParamsMap.get("modeltype") + "", (Long)projectParamsMap.get("modelid"));
            if (modelMap.get(projectParamsMap.get("modelid")) == null) continue;
            projectParamsMap.put("modelone", ((Map)modelMap.get(projectParamsMap.get("modelid"))).get("modelone"));
            projectParamsMap.put("modeltwo", ((Map)modelMap.get(projectParamsMap.get("modelid"))).get("modeltwo"));
        }
        return projectMap;
    }

    private Map<Long, Set<Long>> getCardMap() {
        DynamicObjectCollection dyObjs = (DynamicObjectCollection)this.getModel().getValue("project");
        HashSet<Long> ids = new HashSet<Long>(8);
        HashMap<Long, Set<Long>> cardMap = new HashMap<Long, Set<Long>>(10);
        for (DynamicObject dynamicObject : dyObjs) {
            ids.add(dynamicObject.getLong("fbasedataid.id"));
        }
        QFilter idsFilter = new QFilter("project", "in", ids);
        DynamicObjectCollection projectArr = QueryServiceHelper.query((String)"ProjectSpecServcieHelper_getWorkpack", (String)"pmpd_exec_workpack", (String)"project,entryentity.jobcard.id AS cardid", (QFilter[])new QFilter[]{idsFilter}, null);
        for (DynamicObject row : projectArr) {
            if (ObjectUtils.isEmpty((Object)row.getLong("project")) || row.getLong("project") == 0L) continue;
            if (cardMap.get(row.getLong("project")) == null) {
                cardMap.put(row.getLong("project"), new HashSet());
            }
            if (!ObjectUtils.isEmpty((Object)row.getLong("cardid"))) {
                ((Set)cardMap.get(row.getLong("project"))).add(row.getLong("cardid"));
                continue;
            }
            ((Set)cardMap.get(row.getLong("project"))).add(0L);
        }
        return cardMap;
    }

    private Set<Long> getJobCardSet(String workPackId) {
        HashSet<Long> workPacks = new HashSet<Long>(8);
        for (String workPack : workPackId.split(",")) {
            if (workPack == null || "".equals(workPack)) continue;
            workPacks.add(Long.parseLong(workPack));
        }
        return workPacks;
    }

    private void setIWorkCardData(Map<String, Map<String, List<Map<String, Object>>>> data) {
        Map<Long, Map<String, Object>> mroOrderMap = this.getMrpOrder(data);
        this.getPageCache().put("initProjectJc", "1");
        List<Map<String, Object>> mrocardrouteList = this.getJcMrocardroute(data, Boolean.FALSE);
        this.setJcEntryEntity(mrocardrouteList, -1, mroOrderMap);
        this.getPageCache().remove("initProjectJc");
        this.getPageCache().put("initProjectTo", "1");
        List<Map<String, Object>> toCardToolDemandList = this.getToCardToolDemand(data);
        this.setToEntryEntity(toCardToolDemandList, -1, mroOrderMap);
        this.getPageCache().remove("initProjectTo");
        this.getPageCache().put("initProjectMa", "1");
        List<Map<String, Object>> maCardMatCommandList = this.getMaCardMatCommand(data);
        this.setMaEntryEntity(maCardMatCommandList, -1, mroOrderMap);
        this.getPageCache().remove("initProjectMa");
    }

    private void setMaEntryEntity(List<Map<String, Object>> maCardMatCommandList, int rowIndex, Map<Long, Map<String, Object>> mroOrderMap) {
        if (!maCardMatCommandList.isEmpty()) {
            if (rowIndex == -1) {
                this.getModel().batchCreateNewEntryRow("maentryentity", maCardMatCommandList.size());
            } else if (maCardMatCommandList.size() > 1) {
                this.getPageCache().put("initProjectMa", "1");
                this.getModel().batchCreateNewEntryRow("maentryentity", maCardMatCommandList.size() - 1);
            }
            int toEntryEntitySize = this.getModel().getEntryCurrentRowIndex("maentryentity");
            if (toEntryEntitySize < 0) {
                toEntryEntitySize = 0;
            }
            for (int i = 0; i < maCardMatCommandList.size(); ++i) {
                int size = toEntryEntitySize + i;
                if (rowIndex >= 0) {
                    size = rowIndex + i;
                }
                this.getModel().setValue("jobcardma", maCardMatCommandList.get(i).get("jobcardma"), size);
                this.getModel().setValue("entrymftmaterial", maCardMatCommandList.get(i).get("entrymftmaterial"), size);
                this.getModel().setValue("quantitydemand", maCardMatCommandList.get(i).get("quantitydemand"), size);
                this.getModel().setValue("maentrybaseunit", maCardMatCommandList.get(i).get("maentrybaseunit"), size);
                this.getModel().setValue("mabaseqty", maCardMatCommandList.get(i).get("mabaseqty"), size);
                this.getModel().setValue("unitfield", maCardMatCommandList.get(i).get("unitfield"), size);
                this.getModel().setValue("qty", maCardMatCommandList.get(i).get("qty"), size);
                this.getModel().setValue("madesc", maCardMatCommandList.get(i).get("madesc"), size);
                if (mroOrderMap.isEmpty() || mroOrderMap.get(Long.parseLong(maCardMatCommandList.get(i).get("jobcardma").toString())) == null) continue;
                this.getModel().setValue("mamroorder", mroOrderMap.get(Long.parseLong(maCardMatCommandList.get(i).get("jobcardma").toString())).get("billno"), size);
            }
            if (maCardMatCommandList.size() > 1) {
                this.getPageCache().remove("initProjectMa");
            }
        }
    }

    private List<Map<String, Object>> getMaCardMatCommand(Map<String, Map<String, List<Map<String, Object>>>> data) {
        ArrayList<Map<String, Object>> cardMatCommandList = new ArrayList<Map<String, Object>>(8);
        for (Map.Entry<String, Map<String, List<Map<String, Object>>>> entry : data.entrySet()) {
            Map<String, List<Map<String, Object>>> map = entry.getValue();
            List<Map<String, Object>> maCardMatCommandList = map.get("cardmatcommand");
            if (maCardMatCommandList == null) continue;
            for (Map<String, Object> maCardMatCommand : maCardMatCommandList) {
                if (maCardMatCommand.get("errorinfo") != null) continue;
                HashMap<String, Object> maCardMatCommandMap = new HashMap<String, Object>(9);
                maCardMatCommandMap.put("jobcardma", entry.getKey());
                maCardMatCommandMap.put("entrymftmaterial", maCardMatCommand.get("entryentity.entrymaterial"));
                maCardMatCommandMap.put("quantitydemand", maCardMatCommand.get("entryentity.isrequireqtyset"));
                maCardMatCommandMap.put("maentrybaseunit", maCardMatCommand.get("entryentity.entrybaseunit"));
                maCardMatCommandMap.put("mabaseqty", maCardMatCommand.get("entryentity.baseqty"));
                maCardMatCommandMap.put("unitfield", maCardMatCommand.get("entryentity.enrtyunit"));
                maCardMatCommandMap.put("qty", maCardMatCommand.get("entryentity.entryqty"));
                maCardMatCommandMap.put("madesc", maCardMatCommand.get("entryentity.entryremark"));
                cardMatCommandList.add(maCardMatCommandMap);
            }
        }
        return cardMatCommandList;
    }

    private Map<Long, Map<String, Object>> getMrpOrder(Map<String, Map<String, List<Map<String, Object>>>> data) {
        HashSet jobcards = new HashSet(data.size());
        data.keySet().forEach(t -> jobcards.add(Long.parseLong(t)));
        Map mroOrderMap = ProjectSpecServcieHelper.getMroOrder(jobcards);
        return mroOrderMap;
    }

    private void setToEntryEntity(List<Map<String, Object>> cardToolDemandList, int rowIndex, Map<Long, Map<String, Object>> mroOrderMap) {
        if (!cardToolDemandList.isEmpty()) {
            if (rowIndex == -1) {
                this.getModel().batchCreateNewEntryRow("toentryentity", cardToolDemandList.size());
            } else if (cardToolDemandList.size() > 1) {
                this.getPageCache().put("initProjectTo", "1");
                this.getModel().batchCreateNewEntryRow("toentryentity", cardToolDemandList.size() - 1);
            }
            int toEntryEntitySize = this.getModel().getEntryCurrentRowIndex("toentryentity");
            if (toEntryEntitySize < 0) {
                toEntryEntitySize = 0;
            }
            for (int i = 0; i < cardToolDemandList.size(); ++i) {
                int size = toEntryEntitySize + i;
                if (rowIndex >= 0) {
                    size = rowIndex + i;
                }
                this.getModel().setValue("jobcardto", cardToolDemandList.get(i).get("jobcardto"), size);
                this.getModel().setValue("tomaterial", cardToolDemandList.get(i).get("tomaterial"), size);
                this.getModel().setValue("entrybaseunit", cardToolDemandList.get(i).get("entrybaseunit"), size);
                this.getModel().setValue("tobaseqty", cardToolDemandList.get(i).get("tobaseqty"), size);
                this.getModel().setValue("enrtyunit", cardToolDemandList.get(i).get("enrtyunit"), size);
                this.getModel().setValue("toqty", cardToolDemandList.get(i).get("toqty"), size);
                this.getModel().setValue("todesc", cardToolDemandList.get(i).get("todesc"), size);
                if (mroOrderMap.isEmpty() || mroOrderMap.get(Long.parseLong(cardToolDemandList.get(i).get("jobcardto").toString())) == null) continue;
                this.getModel().setValue("tomroorder", mroOrderMap.get(Long.parseLong(cardToolDemandList.get(i).get("jobcardto").toString())).get("billno"), size);
            }
            if (cardToolDemandList.size() > 1) {
                this.getPageCache().remove("initProjectTo");
            }
        }
    }

    private List<Map<String, Object>> getToCardToolDemand(Map<String, Map<String, List<Map<String, Object>>>> data) {
        ArrayList<Map<String, Object>> toCardToolDemandList = new ArrayList<Map<String, Object>>(8);
        for (Map.Entry<String, Map<String, List<Map<String, Object>>>> entry : data.entrySet()) {
            Map<String, List<Map<String, Object>>> map = entry.getValue();
            List<Map<String, Object>> cardToolDemandList = map.get("cardtooldemand");
            if (cardToolDemandList == null) continue;
            for (Map<String, Object> toCardToolDemand : cardToolDemandList) {
                if (toCardToolDemand.get("errorinfo") != null) continue;
                HashMap<String, Object> toCardToolDemandMap = new HashMap<String, Object>(8);
                toCardToolDemandMap.put("jobcardto", entry.getKey());
                toCardToolDemandMap.put("tomaterial", toCardToolDemand.get("entryentity.entrymaterial"));
                toCardToolDemandMap.put("entrybaseunit", toCardToolDemand.get("entryentity.entrybaseunit"));
                toCardToolDemandMap.put("tobaseqty", toCardToolDemand.get("entryentity.entrybaseqty"));
                toCardToolDemandMap.put("enrtyunit", toCardToolDemand.get("entryentity.enrtyunit"));
                toCardToolDemandMap.put("toqty", toCardToolDemand.get("entryentity.entryqty"));
                toCardToolDemandMap.put("todesc", toCardToolDemand.get("entryentity.entryremark"));
                toCardToolDemandList.add(toCardToolDemandMap);
            }
        }
        return toCardToolDemandList;
    }

    private List<Map<String, Object>> getJcMrocardroute(Map<String, Map<String, List<Map<String, Object>>>> data, boolean isMajorflag) {
        ArrayList<Map<String, Object>> jcentryentityList = new ArrayList<Map<String, Object>>(8);
        HashSet<Long> workcategories = new HashSet<Long>(8);
        for (Map.Entry<String, Map<String, List<Map<String, Object>>>> entry : data.entrySet()) {
            Map<String, List<Map<String, Object>>> map = entry.getValue();
            List<Map<String, Object>> mrocardrouteList = map.get("mrocardroute");
            if (mrocardrouteList == null) continue;
            for (Map<String, Object> mrocardroute : mrocardrouteList) {
                if (mrocardroute.get("errorinfo") != null || mrocardroute.get("group") == null || (Long)mrocardroute.get("group") == 0L) continue;
                workcategories.add((Long)mrocardroute.get("group"));
            }
        }
        Set WorkCategorieIds = ProjectSpecServcieHelper.getWorkCategorieForName(workcategories);
        for (Map.Entry<String, Map<String, List<Map<String, Object>>>> entry : data.entrySet()) {
            Map<String, List<Map<String, Object>>> map = entry.getValue();
            List<Map<String, Object>> mrocardrouteList = map.get("mrocardroute");
            for (Map<String, Object> mrocardroute : mrocardrouteList) {
                if (mrocardroute.get("errorinfo") != null) continue;
                Boolean majorflag = !ObjectUtils.isEmpty((Object)mrocardroute.get("largemajordesc")) && !"".equals(mrocardroute.get("largemajordesc"));
                if ((!WorkCategorieIds.contains(mrocardroute.get("group")) || !majorflag.booleanValue()) && WorkCategorieIds.contains(mrocardroute.get("group")) && !isMajorflag) continue;
                HashMap<String, Object> jcentryentity = new HashMap<String, Object>(5);
                jcentryentity.put("jobcard", entry.getKey());
                jcentryentity.put("majorflag", mrocardroute.get("majorflag"));
                jcentryentity.put("workcategories", mrocardroute.get("group"));
                jcentryentity.put("professiona", mrocardroute.get("maintrade"));
                jcentryentity.put("largemajordescs", mrocardroute.get("largemajordesc"));
                List<Map<String, Object>> cardimpexperienceList = map.get("cardimpexperience");
                StringBuilder describe = new StringBuilder();
                if (cardimpexperienceList != null && !cardimpexperienceList.isEmpty()) {
                    int i = 1;
                    for (Map<String, Object> cardimpexperience : cardimpexperienceList) {
                        if (cardimpexperience.get("entryentity.describe") == null) continue;
                        describe.append(i);
                        describe.append("\u3001");
                        describe.append(cardimpexperience.get("entryentity.describe"));
                        describe.append("\r\n");
                        ++i;
                    }
                }
                if (describe.length() > 0) {
                    jcentryentity.put("describe", describe);
                }
                jcentryentityList.add(jcentryentity);
            }
        }
        return jcentryentityList;
    }

    private void setJcEntryEntity(List<Map<String, Object>> jcentryentityList, int rowIndex, Map<Long, Map<String, Object>> mroOrderMap) {
        if (!jcentryentityList.isEmpty()) {
            int jcEntryEntitySize;
            HashMap<Long, ArrayList<Map<String, Object>>> jcentryentityListMap = new HashMap<Long, ArrayList<Map<String, Object>>>(12);
            HashSet<Long> workcategories = new HashSet<Long>(8);
            for (Map<String, Object> map : jcentryentityList) {
                workcategories.add((Long)map.get("workcategories"));
                ArrayList<Map<String, Object>> jcentryentitys = (ArrayList<Map<String, Object>>)jcentryentityListMap.get((Long)map.get("workcategories"));
                if (jcentryentitys == null) {
                    jcentryentitys = new ArrayList<Map<String, Object>>(8);
                }
                jcentryentitys.add(map);
                jcentryentityListMap.put((Long)map.get("workcategories"), jcentryentitys);
            }
            Map WorkCategorieMap = ProjectSpecServcieHelper.getWorkCategorieForId(workcategories);
            ArrayList jcentryentityListNew = new ArrayList(8);
            List workCategorieShowOrder = ProjectSpecServcieHelper.getWorkCategorieShowOrder();
            for (String string : workCategorieShowOrder) {
                if (WorkCategorieMap.get(string) == null) continue;
                jcentryentityListNew.addAll((Collection)jcentryentityListMap.get(WorkCategorieMap.get(string)));
                jcentryentityListMap.remove(WorkCategorieMap.get(string));
            }
            if (!jcentryentityListMap.isEmpty()) {
                for (Map.Entry entry : jcentryentityListMap.entrySet()) {
                    jcentryentityListNew.addAll((Collection)entry.getValue());
                }
            }
            if (rowIndex == -1) {
                // empty if block
            }
            if ((jcEntryEntitySize = this.getModel().getEntryCurrentRowIndex("jcentryentity")) < 0) {
                jcEntryEntitySize = 0;
            }
            this.getModel().beginInit();
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            tableValueSetter.addField("jobcard", new Object[0]);
            tableValueSetter.addField("majorflag", new Object[0]);
            tableValueSetter.addField("workcategories", new Object[0]);
            tableValueSetter.addField("professiona", new Object[0]);
            tableValueSetter.addField("largemajordescs_tag", new Object[0]);
            tableValueSetter.addField("describe", new Object[0]);
            tableValueSetter.addField("mroorder", new Object[0]);
            tableValueSetter.addField("entryresourcestatus", new Object[0]);
            for (int i = 0; i < jcentryentityListNew.size(); ++i) {
                int size = jcEntryEntitySize + i;
                if (rowIndex >= 0) {
                    size = rowIndex;
                    this.getModel().setValue("jobcard", ((Map)jcentryentityListNew.get(i)).get("jobcard"), size);
                    this.getModel().setValue("majorflag", ((Map)jcentryentityListNew.get(i)).get("majorflag"), size);
                    this.getModel().setValue("workcategories", ((Map)jcentryentityListNew.get(i)).get("workcategories"), size);
                    this.getModel().setValue("professiona", ((Map)jcentryentityListNew.get(i)).get("professiona"), size);
                    this.getModel().setValue("largemajordescs_tag", ((Map)jcentryentityListNew.get(i)).get("largemajordescs"), size);
                    this.getModel().setValue("describe", ((Map)jcentryentityListNew.get(i)).get("describe"), size);
                    if (mroOrderMap.isEmpty() || mroOrderMap.get(Long.parseLong(((Map)jcentryentityListNew.get(i)).get("jobcard").toString())) == null) continue;
                    this.getModel().setValue("mroorder", mroOrderMap.get(Long.parseLong(((Map)jcentryentityListNew.get(i)).get("jobcard").toString())).get("billno"), size);
                    this.getModel().setValue("entryresourcestatus", mroOrderMap.get(Long.parseLong(((Map)jcentryentityListNew.get(i)).get("jobcard").toString())).get("entryresourcestatus"), size);
                    continue;
                }
                Object mroorder = null;
                Object entryresourcestatus = null;
                if (!mroOrderMap.isEmpty() && mroOrderMap.get(Long.parseLong(((Map)jcentryentityListNew.get(i)).get("jobcard").toString())) != null) {
                    mroorder = mroOrderMap.get(Long.parseLong(((Map)jcentryentityListNew.get(i)).get("jobcard").toString())).get("billno");
                    entryresourcestatus = mroOrderMap.get(Long.parseLong(((Map)jcentryentityListNew.get(i)).get("jobcard").toString())).get("entryresourcestatus");
                }
                tableValueSetter.addRow(new Object[]{((Map)jcentryentityListNew.get(i)).get("jobcard"), ((Map)jcentryentityListNew.get(i)).get("majorflag"), ((Map)jcentryentityListNew.get(i)).get("workcategories"), ((Map)jcentryentityListNew.get(i)).get("professiona"), ((Map)jcentryentityListNew.get(i)).get("largemajordescs"), ((Map)jcentryentityListNew.get(i)).get("describe"), mroorder, entryresourcestatus});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            if (rowIndex < 0) {
                model.batchCreateNewEntryRow("jcentryentity", tableValueSetter);
            }
            this.getModel().endInit();
            this.getView().updateView("jcentryentity");
        }
    }

    private void deliverydateChange(Date deliveryDate) {
        Date createDate = (Date)this.getModel().getValue("createtime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyy-MM-dd");
        String s = sdf.format(createDate);
        try {
            Date createNewDate = sdf.parse(s);
            Long time = Math.abs(createNewDate.getTime() - deliveryDate.getTime());
            this.getModel().setValue("fixusetime", (Object)(time / 1000L / 60L / 60L / 24L));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void materialmtcinfoChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        if (newObject == null) {
            this.getModel().setValue("enginetype", null);
            this.getModel().setValue("fixusetime", (Object)0);
            this.getModel().setValue("mratype", null);
            this.getModel().setValue("engineequipmodel", null);
        } else {
            DynamicObject dy = (DynamicObject)newObject;
            if (dy.getDate("deliverydate") != null) {
                this.deliverydateChange(dy.getDate("deliverydate"));
            } else {
                this.getModel().setValue("fixusetime", (Object)0);
            }
            if (dy.getDynamicObject("enginetype") == null) {
                this.getModel().setValue("enginetype", null);
            } else {
                this.getModel().setValue("enginetype", (Object)dy.getDynamicObject("enginetype"));
            }
            if (dy.getDynamicObject("engineequipmodel") == null) {
                this.getModel().setValue("engineequipmodel", null);
            } else {
                this.getModel().setValue("engineequipmodel", (Object)dy.getDynamicObject("engineequipmodel"));
            }
            if (dy.getDynamicObject("mratype") == null) {
                this.getModel().setValue("mratype", null);
            } else {
                this.getModel().setValue("mratype", (Object)dy.getDynamicObject("mratype"));
            }
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit projectEdit;
        BasedataEdit fileEdit;
        BasedataEdit jobcardma;
        BasedataEdit jobcardto;
        BasedataEdit jobcard;
        BasedataEdit mrocardroute;
        BasedataEdit ctcontract;
        super.registerListener(e);
        BasedataEdit contract = (BasedataEdit)this.getControl("contract");
        if (contract != null) {
            contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((ctcontract = (BasedataEdit)this.getControl("ctcontract")) != null) {
            ctcontract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((mrocardroute = (BasedataEdit)this.getControl("mrocardroutes")) != null) {
            mrocardroute.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((jobcard = (BasedataEdit)this.getControl("jobcard")) != null) {
            jobcard.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((jobcardto = (BasedataEdit)this.getControl("jobcardto")) != null) {
            jobcardto.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((jobcardma = (BasedataEdit)this.getControl("jobcardma")) != null) {
            jobcardma.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((fileEdit = (BasedataEdit)this.getView().getControl("resourceplan")) != null) {
            fileEdit.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail);
            fileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((projectEdit = (BasedataEdit)this.getView().getControl("project")) != null) {
            projectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        RichTextEditor edit;
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)TBL_SIMILARPROJECT, (CharSequence)operateKey)) {
            if (this.getModel().getValue("id") == null || Long.parseLong(this.getModel().getValue("id").toString()) == 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\uff0c\u5728\u70b9\u51fb\u6309\u76f8\u4f3c\u9879\u76ee\u751f\u6210\u3002", (String)"ProjectSpecification_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getValue("org") == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u70b9\u51fb\u6309\u76f8\u4f3c\u9879\u76ee\u751f\u6210\u3002", (String)"ProjectSpecification_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getValue("project") == null || ((DynamicObjectCollection)this.getModel().getValue("project")).size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u70b9\u51fb\u6309\u76f8\u4f3c\u9879\u76ee\u751f\u6210\u3002", (String)"ProjectSpecification_22", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showBillFrom(ENTITY);
        } else if (StringUtils.equals((CharSequence)TBL_REBUILD, (CharSequence)operateKey)) {
            this.rebuild();
        } else if (StringUtils.equals((CharSequence)TBL_GENERATEBYPROJECT, (CharSequence)operateKey)) {
            if (this.getModel().getValue("project") == null || ((DynamicObjectCollection)this.getModel().getValue("project")).size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u70b9\u51fb\u6309\u9879\u76ee\u751f\u6210\u3002", (String)"ProjectSpecification_23", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showBillList();
        } else if (("save".equals(operateKey) || "submit".equals(operateKey)) && (edit = (RichTextEditor)this.getView().getControl("richtexteditorap")) != null) {
            this.getModel().setValue("richtexteditorap_data_tag", (Object)edit.getText());
        }
    }

    private void showBillList() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("pmpd_project_f7");
        showParameter.setBillFormId("pmpd_project");
        showParameter.setMultiSelect(false);
        showParameter.setShowTitle(false);
        showParameter.setShowFrequent(true);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("500");
        styleCss.setWidth("1000");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setF7Style(1);
        showParameter.setLookUp(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TBL_GENERATEBYPROJECT));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void rebuild() {
        DynamicObjectCollection project = (DynamicObjectCollection)this.getModel().getValue("project");
        if (project != null) {
            this.projectChange(project, null, null, 0);
            this.projectChange(null, project, null, 0);
        }
    }

    private void showBillFrom(String formId) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        DynamicObject org = (DynamicObject)dataModel.getValue("org");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("projectorg", (Object)org.getPkValue().toString());
        showParameter.setCustomParam("entitynumber", (Object)"pmpd_project_spec");
        showParameter.setCustomParam("sourceid", this.getModel().getValue("id"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TBL_SIMILARPROJECT));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (StringUtils.equals((CharSequence)TBL_SIMILARPROJECT, (CharSequence)e.getActionId())) {
            Map result = (Map)e.getReturnData();
            if (result == null) {
                return;
            }
            this.similarProjectToProjectSpec(result);
        } else if (StringUtils.equals((CharSequence)TBL_GENERATEBYPROJECT, (CharSequence)e.getActionId())) {
            ListSelectedRowCollection result = (ListSelectedRowCollection)e.getReturnData();
            if (result == null) {
                return;
            }
            this.generateNewProjectSpec(result.getPrimaryKeyValues()[0].toString());
        }
    }

    private void generateNewProjectSpec(String project) {
        DynamicObject projectSpecDyn = this.getProjectSpecForProject(project);
        if (projectSpecDyn == null) {
            return;
        }
        ArrayList<String> entryNameList = new ArrayList<String>(1);
        entryNameList.add("jcentryentity");
        entryNameList.add("maentryentity");
        entryNameList.add("toentryentity");
        entryNameList.add("pkgentryentity");
        ArrayList<String> noSetFiledList = new ArrayList<String>(3);
        noSetFiledList.add("id");
        noSetFiledList.add("billtype");
        noSetFiledList.add("billno");
        noSetFiledList.add("billstatus");
        noSetFiledList.add("creator");
        noSetFiledList.add("creator_id");
        noSetFiledList.add("createtime");
        noSetFiledList.add("modifier");
        noSetFiledList.add("modifier_id");
        noSetFiledList.add("modifytime");
        noSetFiledList.add("auditor");
        noSetFiledList.add("auditor_id");
        noSetFiledList.add("auditdate");
        noSetFiledList.add("org");
        noSetFiledList.add("org_id");
        noSetFiledList.add("project");
        noSetFiledList.add("expstartdate");
        noSetFiledList.add("expfinshdate");
        noSetFiledList.add("estperiod");
        noSetFiledList.add("resourceplan");
        noSetFiledList.add("seq");
        noSetFiledList.add("workpackid");
        noSetFiledList.add("workpacknumber");
        noSetFiledList.add("customer");
        noSetFiledList.add("contract");
        noSetFiledList.add("materialmtcinfo");
        noSetFiledList.add("mratype");
        noSetFiledList.add("maintenequipmodel");
        noSetFiledList.add("engineequipmodel");
        noSetFiledList.add("fixusetime");
        noSetFiledList.add("newworkcenter");
        noSetFiledList.add("workscopeins");
        noSetFiledList.add("checktype");
        noSetFiledList.add("newplanroom");
        this.getPageCache().put("initProjectJc", "1");
        this.getPageCache().put("initProjectTo", "1");
        this.getPageCache().put("initProjectMa", "1");
        FiledSetUtil.setNewDynamicObjectData((DynamicObject)projectSpecDyn, (IDataModel)this.getModel(), (IFormView)this.getView(), entryNameList, null, noSetFiledList);
        RichTextEditor edit = (RichTextEditor)this.getView().getControl("richtexteditorap");
        edit.setText((String)this.getModel().getValue("richtexteditorap_data_tag"));
        this.getPageCache().remove("initProjectJc");
        this.getPageCache().remove("initProjectTo");
        this.getPageCache().remove("initProjectMa");
        String workpackid = (String)this.getModel().getValue("workpackid");
        if (workpackid != null && workpackid.length() > 0) {
            Set<Long> jobCardSet = ProjectSpecServcieHelper.getJobCardToWorkpack(this.getJobCardSet(workpackid)).keySet();
            if (jobCardSet.isEmpty()) {
                this.deleteEntryAllRow("jcentryentity");
                this.deleteEntryAllRow("maentryentity");
                this.deleteEntryAllRow("toentryentity");
                this.deleteEntryAllRow("pkgentryentity");
            } else {
                this.compareJobcard("jcentryentity", "jobcard", jobCardSet);
                this.compareJobcard("maentryentity", "jobcardma", jobCardSet);
                this.compareJobcard("toentryentity", "jobcardto", jobCardSet);
                this.compareJobcard("pkgentryentity", "mrocardroutes", jobCardSet);
            }
        } else {
            this.deleteEntryAllRow("jcentryentity");
            this.deleteEntryAllRow("maentryentity");
            this.deleteEntryAllRow("toentryentity");
            this.deleteEntryAllRow("pkgentryentity");
        }
        int pkgEntryEntitySize = this.getModel().getEntryRowCount("pkgentryentity");
        for (int i = 0; i < pkgEntryEntitySize; ++i) {
            this.getModel().setValue("mrocardroutes", null, i);
        }
    }

    private void compareJobcard(String entry, String pro, Set<Long> jobCardSet) {
        int size = this.getModel().getEntryRowCount(entry);
        if (size == 0) {
            return;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject dyn;
            if (this.getModel().getValue(pro, i) instanceof DynamicObject) {
                dyn = (DynamicObject)this.getModel().getValue(pro, i);
                if (dyn != null && jobCardSet.contains(dyn.getLong("id"))) continue;
                list.add(i);
                continue;
            }
            if (!(this.getModel().getValue(pro, i) instanceof DynamicObjectCollection)) continue;
            dyn = (DynamicObjectCollection)this.getModel().getValue(pro, i);
            ArrayList<Long> joblist = new ArrayList<Long>(dyn.size());
            for (DynamicObject job : dyn) {
                if (!jobCardSet.contains(job.getLong("fbasedataid.id"))) continue;
                joblist.add(job.getLong("fbasedataid.id"));
            }
            if (joblist.isEmpty()) {
                list.add(i);
                continue;
            }
            this.getModel().setValue(pro, (Object)joblist.toArray(), i);
        }
        if (!list.isEmpty()) {
            int[] line = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                line[i] = (Integer)list.get(i);
            }
            this.getModel().deleteEntryRows(entry, line);
        }
    }

    private void similarProjectToProjectSpec(Map<String, String> result) {
        String similarProject = result.get("similarProject");
        Map similarProject1 = (Map)SerializationUtils.fromJsonString((String)similarProject, Map.class);
        for (Map.Entry stringSetEntry : similarProject1.entrySet()) {
            List projectIds = (List)stringSetEntry.getValue();
            if (projectIds == null || projectIds.isEmpty()) continue;
            this.generateNewProjectSpec((String)projectIds.get(0));
        }
    }

    private DynamicObject getProjectSpecForProject(String project) {
        DynamicObject[] dy1 = BusinessDataServiceHelper.load((String)"pmpd_project_spec", (String)"id,billno,project.id", (QFilter[])new QFilter[0]);
        Long id = 0L;
        block0: for (DynamicObject dynamicObject : dy1) {
            DynamicObjectCollection d = dynamicObject.getDynamicObjectCollection("project");
            for (DynamicObject dynamicObject2 : d) {
                if (!dynamicObject2.get(2).toString().equals(project)) continue;
                id = (Long)dynamicObject.get(0);
                continue block0;
            }
        }
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"pmpd_project_spec", (String)"id,billno", (QFilter[])new QFilter[]{idFilter});
        if (dy == null) {
            return null;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"pmpd_project_spec");
        return BusinessDataServiceHelper.loadSingle((Object)dy.get(0), (DynamicObjectType)mainEntityType);
    }

    private void projectChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        DynamicObjectCollection ob = (DynamicObjectCollection)newObject;
        if (ob == null || ob.isEmpty()) {
            this.getModel().setValue("expstartdate", null);
            this.getModel().setValue("expfinshdate", null);
            this.getModel().setValue("estperiod", null);
            this.getModel().setValue("customer", null);
            this.getModel().setValue("contract", null);
            this.getModel().setValue("workpackid", null);
            this.getModel().setValue("workpacknumber", null);
            this.getModel().setValue("materialmtcinfo", null);
            this.getModel().setValue("newworkcenter", null);
            this.getModel().setValue("checktype", null);
            this.getModel().setValue("workscopeins", null);
            this.getModel().setValue("newplanroom", null);
            this.getModel().setValue("maintenequipmodel", null);
            return;
        }
        DynamicObjectCollection dyObjs = (DynamicObjectCollection)newObject;
        if (!dyObjs.isEmpty()) {
            Long workCenterId;
            HashSet<Long> ids = new HashSet<Long>(8);
            for (DynamicObject dynamicObject : dyObjs) {
                ids.add(dynamicObject.getLong("fbasedataid.id"));
            }
            String projectResoucePlanLock = this.getView().getPageCache().get("projectresouceplanlock");
            Boolean bool = false;
            if (!"1".equals(projectResoucePlanLock)) {
                this.getView().getPageCache().put("projectresouceplanlock", "1");
                bool = true;
                Set resourcePlanIds = ProjectSpecServcieHelper.getresoucePlanToProject(ids);
                if (resourcePlanIds.isEmpty() || resourcePlanIds.size() != 1) {
                    this.getModel().setValue("resourceplan", null);
                } else {
                    this.getModel().setValue("resourceplan", resourcePlanIds.iterator().next());
                }
            }
            this.getModel().setValue("expstartdate", (Object)((DynamicObject)dyObjs.get(0)).getDate("fbasedataid.expstartdate"));
            this.getModel().setValue("expfinshdate", (Object)((DynamicObject)dyObjs.get(0)).getDate("fbasedataid.expfinshdate"));
            this.getModel().setValue("estperiod", (Object)((DynamicObject)dyObjs.get(0)).getBigDecimal("fbasedataid.estperiod"));
            if (((DynamicObject)dyObjs.get(0)).get("fbasedataid.customer") == null) {
                this.getModel().setValue("customer", null);
            } else {
                this.getModel().setValue("customer", (Object)((DynamicObject)dyObjs.get(0)).getDynamicObject("fbasedataid.customer"));
            }
            this.setContract(dyObjs);
            if (((DynamicObject)dyObjs.get(0)).get("fbasedataid.engineequipmodel.id") == null) {
                this.getModel().setValue("maintenequipmodel", null);
            } else {
                this.getModel().setValue("maintenequipmodel", (Object)((DynamicObject)dyObjs.get(0)).getLong("fbasedataid.engineequipmodel.id"));
            }
            if (((DynamicObject)dyObjs.get(0)).get("fbasedataid.devices") == null) {
                this.getModel().setValue("materialmtcinfo", null);
            } else {
                this.getModel().setValue("materialmtcinfo", (Object)((DynamicObject)dyObjs.get(0)).getDynamicObject("fbasedataid.devices"));
            }
            DynamicObject project = (DynamicObject)((DynamicObject)dyObjs.get(0)).get("fbasedataid");
            if (project != null && !ObjectUtils.isEmpty((Object)(workCenterId = this.getWorkCenterByProjectId(project.getPkValue())))) {
                this.getModel().setValue("newworkcenter", (Object)workCenterId);
            }
            if (((DynamicObject)dyObjs.get(0)).get("fbasedataid.workscope") == null) {
                this.getModel().setValue("workscopeins", null);
            } else {
                this.getModel().setValue("workscopeins", (Object)((DynamicObject)dyObjs.get(0)).getDynamicObject("fbasedataid.workscope"));
            }
            if (((DynamicObject)dyObjs.get(0)).get("fbasedataid.fixlevel") == null) {
                this.getModel().setValue("checktype", null);
            } else {
                this.getModel().setValue("checktype", (Object)((DynamicObject)dyObjs.get(0)).getDynamicObject("fbasedataid.fixlevel"));
            }
            if (((DynamicObject)dyObjs.get(0)).get("fbasedataid.planroom") == null) {
                this.getModel().setValue("newplanroom", null);
            } else {
                this.getModel().setValue("newplanroom", (Object)((DynamicObject)dyObjs.get(0)).getDynamicObject("fbasedataid.planroom"));
            }
            Map workpackMap = ProjectSpecServcieHelper.getWorkpack(ids);
            if (!workpackMap.isEmpty()) {
                StringBuilder idSB = new StringBuilder();
                StringBuilder numberSB = new StringBuilder();
                HashSet manageIds = new HashSet(workpackMap.size());
                for (Map.Entry workpackEntry : workpackMap.entrySet()) {
                    idSB.append(workpackEntry.getKey());
                    idSB.append(",");
                    if (workpackEntry.getValue() == null || (Long)workpackEntry.getValue() == 0L) continue;
                    manageIds.add(workpackEntry.getValue());
                }
                Set names = ProjectSpecServcieHelper.getCustomerWorkpackToName(manageIds);
                for (String name : names) {
                    if (name.isEmpty()) continue;
                    numberSB.append(name);
                    numberSB.append(",");
                }
                if (idSB.length() > 0) {
                    // empty if block
                }
                this.getModel().setValue("workpackid", (Object)idSB.substring(0, idSB.length() - 1));
                if (numberSB.length() > 0) {
                    this.getModel().setValue("workpacknumber", (Object)numberSB.substring(0, numberSB.length() - 1));
                }
            } else {
                this.getModel().setValue("workpackid", null);
                this.getModel().setValue("workpacknumber", null);
            }
            if (bool.booleanValue()) {
                this.getView().getPageCache().remove("projectresouceplanlock");
            }
        }
    }

    private Long getWorkCenterByProjectId(Object pkValue) {
        QFilter[] qFilters = new QFilter("id", "=", pkValue).toArray();
        DynamicObject dObj = QueryServiceHelper.queryOne((String)"pmpd_project", (String)"workcenter.id", (QFilter[])qFilters);
        return dObj == null ? 0L : dObj.getLong("workcenter.id");
    }

    private void setContract(DynamicObjectCollection dyObjs) {
        this.deleteEntryAllRow("contractentryentity");
        HashSet<Long> ids = new HashSet<Long>(8);
        for (DynamicObject dynobj : dyObjs) {
            if (dynobj.get("fbasedataid.entryentity") == null || dynobj.getDynamicObjectCollection("fbasedataid.entryentity").size() <= 0) continue;
            DynamicObjectCollection contractEntity = dynobj.getDynamicObjectCollection("fbasedataid.entryentity");
            for (DynamicObject contract : contractEntity) {
                ids.add(contract.getLong("saleconstract"));
            }
        }
        if (!ids.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("contractentryentity", ids.size());
            int i = 0;
            for (Long id : ids) {
                this.getModel().setValue("ctcontract", (Object)id, i);
                ++i;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"contract") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"ctcontract")) {
            FormShowParameter f = evt.getFormShowParameter();
            f.setCaption(ResManager.loadKDString((String)"\u9500\u552e\u5408\u540c", (String)"ProjectSpecification_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            evt.setFormShowParameter(f);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"mrocardroutes")) {
            this.removeUnMainWork(qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"jobcard")) {
            this.jobcardF7(qfilters, "jcentryentity", key);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"jobcardto")) {
            this.jobcardF7(qfilters, "toentryentity", key);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"jobcardma")) {
            this.jobcardF7(qfilters, "maentryentity", key);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"project")) {
            this.projectF7(qfilters, key);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"resourceplan")) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter resourcePlanFilterConditon = CommonFilterConditionUtil.getResourcePlanFilterConditon();
            QFilter qFilter = new QFilter("overdevice", "!=", (Object)0);
            qFilters.add(qFilter);
            qFilters.add(resourcePlanFilterConditon);
            formShowParameter.getListFilterParameter().setQFilters(qFilters);
        }
        if (!qfilters.isEmpty()) {
            listShowParameter.getListFilterParameter().getQFilters().addAll(qfilters);
        }
    }

    private void projectF7(List<QFilter> qfilters, String key) {
        DynamicObject resourceplan = (DynamicObject)this.getModel().getValue("resourceplan");
        if (resourceplan != null) {
            Long resourceplanId = resourceplan.getLong("id");
            List ids = ProjectSpecServcieHelper.getProjectToresoucePlan((Long)resourceplanId);
            QFilter qFilter = new QFilter("id", "in", (Object)ids);
            qfilters.add(qFilter);
        }
    }

    private void removeUnMainWork(List<QFilter> qfilters) {
        String workPackId = (String)this.getModel().getValue("workpackid");
        Set<Long> workPacks = this.getJobCardSet(workPackId);
        Set showCards = ProjectSpecServcieHelper.getJobCardToWorkpackByImportWorkMark(workPacks);
        QFilter qFilter = new QFilter("id", "in", (Object)showCards);
        qfilters.add(qFilter);
    }

    private void jobcardF7(List<QFilter> qfilters, String entryEntity, String key) {
        String workpackid = (String)this.getModel().getValue("workpackid");
        if (workpackid != null && workpackid.length() > 0) {
            Set jobCardSet = ProjectSpecServcieHelper.getJobCardToWorkpack(this.getJobCardSet(workpackid)).keySet();
            QFilter qFilter = new QFilter("id", "in", jobCardSet);
            qfilters.add(qFilter);
        } else {
            QFilter qFilter = new QFilter("id", "in", null);
            qfilters.add(qFilter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String richtexteditorap = (String)this.getModel().getValue("richtexteditorap_data_tag");
        if (richtexteditorap != null) {
            RichTextEditor edit = (RichTextEditor)this.getView().getControl("richtexteditorap");
            edit.setText(richtexteditorap);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"billtype"});
    }

    private void deleteEntryAllRow(String entryEntity) {
        int size = this.getModel().getEntryRowCount(entryEntity);
        if (size == 0) {
            return;
        }
        int[] line = new int[size];
        for (int i = 0; i < size; ++i) {
            line[i] = i;
        }
        this.getModel().deleteEntryRows(entryEntity, line);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("createmaintask".equals(e.getOperateKey())) {
            this.createmaintask();
        }
    }

    private void createmaintask() {
        DynamicObjectCollection dynColl = (DynamicObjectCollection)this.getModel().getValue("pkgentryentity");
        if (dynColl.size() > 0) {
            HashMap<Long, DynamicObject> planAreaMap = new HashMap<Long, DynamicObject>(dynColl.size());
            for (DynamicObject dyn : dynColl) {
                DynamicObject planarea = dyn.getDynamicObject("newplanningarea");
                if (planarea == null || planarea.getLong("id") == 0L) continue;
                planAreaMap.put(planarea.getLong("id"), planarea);
            }
            if (!planAreaMap.isEmpty()) {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                Date date = new Date();
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(planAreaMap.size());
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"pmts_task");
                DynamicObjectCollection projects = (DynamicObjectCollection)this.getModel().getValue("project");
                for (DynamicObject project : projects) {
                    String[] code = CodeRuleServiceHelper.getBatchNumber((String)"pmts_task", (DynamicObject)new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmts_task")), (String)String.valueOf(org.getLong("id")), (int)planAreaMap.size());
                    long[] ids = ID.genLongIds((int)planAreaMap.size());
                    int i = 0;
                    for (Map.Entry entry : planAreaMap.entrySet()) {
                        DynamicObject planarea = (DynamicObject)entry.getValue();
                        DynamicObject task = new DynamicObject((DynamicObjectType)entityType);
                        task.set("id", (Object)ids[i]);
                        if (code.length == 0) {
                            task.set("number", (Object)ID.genStringId());
                        } else {
                            task.set("number", (Object)code[i]);
                        }
                        task.set("projectnum", (Object)project.getDynamicObject("fbasedataid"));
                        task.set("status", (Object)Character.valueOf('A'));
                        task.set("enable", (Object)1);
                        task.set("createorg", (Object)org);
                        task.set("org", (Object)org);
                        task.set("useorg", (Object)org);
                        task.set("scheduletype", (Object)"1");
                        task.set("timeunit", (Object)"1");
                        task.set("durationunit", (Object)1394029198330301440L);
                        task.set("createtime", (Object)date);
                        task.set("creator", (Object)BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user"));
                        task.set("taskstatus", (Object)"1");
                        task.set("executestatus", (Object)"1");
                        task.set("ctrlstrategy", (Object)5);
                        task.set("masterid", (Object)ids[i]);
                        task.set("plantype", (Object)BusinessDataServiceHelper.loadSingle((Object)1437660575319473152L, (String)"fmm_plantype"));
                        task.set("name", (Object)planarea.getString("name"));
                        task.set("planarea", (Object)planarea);
                        list.add(task);
                        ++i;
                    }
                }
                if (!list.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                    BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])list.toArray(new DynamicObject[0]));
                    PmtsTaskValueHelper.setTaskOrderNo(list);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u4e3b\u8ba1\u5212\u6210\u529f\u3002", (String)"ProjectSpecification_8", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

