/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base.team;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.MutexFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmbd.common.util.CommonUtils;
import kd.pmc.pmpd.common.enums.ProjectTeamEnum;
import kd.pmc.pmpd.common.util.ProjectTeamUtils;

public class ProjectTeamAdjustmentEdit
extends AbstractFormPlugin
implements RowClickEventListener {
    private static String GROUPID = "EDIT";
    private static final Log logger = LogFactory.getLog(ProjectTeamAdjustmentEdit.class);

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        if (this.getPageCache().get(GROUPID) != null) {
            String oldId = this.getPageCache().get(GROUPID);
            MutexFactory.createDataMutex().release(oldId, "pmpd_projectteam_adjm", GROUPID);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map paramsMap = this.getView().getFormShowParameter().getCustomParams();
        if (paramsMap.get("teamId") != null) {
            String id = paramsMap.get("teamId").toString();
            this.setLock(id);
            this.initData(Long.parseLong(id));
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName;
        if (event == null) {
            return;
        }
        super.propertyChanged(event);
        IDataEntityProperty dataEntityProperty = event.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            this.propertyChanged(changeData, propertyName);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"addnode")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            if (entryGrid.getSelectRows().length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u201c\u9879\u76ee\u4eba\u529b\u8d44\u6e90\u201d\uff0c\u518d\u8fdb\u884c\u6dfb\u52a0\u3002", (String)"ProjectTeamAdjustmentEdit_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
            this.addNode(entryGrid.getSelectRows());
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"delnode")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("addentryentity");
            if (entryGrid.getSelectRows().length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u201c\u56e2\u961f\u6210\u5458\u201d\uff0c\u518d\u8fdb\u884c\u79fb\u9664\u3002", (String)"ProjectTeamAdjustmentEdit_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
            this.delNode(entryGrid.getSelectRows());
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) {
            this.save(e);
        }
    }

    private void save(BeforeDoOperationEventArgs e) {
        String teamId = (String)this.getModel().getValue("teamname");
        String id = (String)this.getModel().getValue("id");
        DynamicObjectCollection teamColl = this.getModel().getEntryEntity("addentryentity");
        DynamicObject projectTeamObj = ProjectTeamUtils.getProjectTeam((Long)Long.parseLong(id));
        if (this.getPageCache().get(GROUPID) != null && !id.equals(this.getPageCache().get(GROUPID))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5176\u4ed6\u7528\u6237\u6b63\u5728\u7f16\u8f91\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"ProjectTeamAdjustmentEdit_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            e.setCancel(true);
            return;
        }
        if (projectTeamObj != null) {
            if (!ProjectTeamEnum.AUDIT.getValue().equals(projectTeamObj.getString("billstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5ba1\u6838\u8be5\u5355\u636e\uff0c\u518d\u8fdb\u884c\u56e2\u961f\u8c03\u6574\u3002", (String)"ProjectTeamAdjustmentEdit_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                e.setCancel(true);
                return;
            }
            this.updateProjectTeamObj(projectTeamObj, teamId, teamColl);
        }
    }

    private void updateProjectTeamObj(DynamicObject projectTeamObj, String teamId, DynamicObjectCollection teamColl) {
        DynamicObjectCollection dynColl = projectTeamObj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection userDynColl = null;
        Date date = new Date();
        HashSet<Long> userSet = new HashSet<Long>(16);
        HashMap productTeamDetailsMap = new HashMap(16);
        Long id = projectTeamObj.getLong("id");
        DynamicObjectCollection teamDynamicObjectColl = projectTeamObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject teamObj : teamDynamicObjectColl) {
            DynamicObjectCollection teamUserRowsObjs = teamObj.getDynamicObjectCollection("subentryentity");
            Iterator iterator = teamUserRowsObjs.iterator();
            while (iterator.hasNext()) {
                DynamicObject teamUserRow = (DynamicObject)iterator.next();
                if (!ProjectTeamEnum.ADD.getValue().equals(teamUserRow.getString("memberstatus"))) continue;
                HashMap<String, Object> UsersDetailsMap = new HashMap<String, Object>(4);
                UsersDetailsMap.put("id", id);
                UsersDetailsMap.put("entryentity.id", teamObj.getLong("id"));
                UsersDetailsMap.put("role", teamUserRow.getString("role.id"));
                UsersDetailsMap.put("enterprisehmrespo", teamUserRow.getLong("enterprisehmrespo.id"));
                UsersDetailsMap.put("addteamdata", teamUserRow.getDate("addteamdata"));
                productTeamDetailsMap.put(teamObj.getLong("id") + "" + teamUserRow.getLong("enterprisehmrespo.id"), UsersDetailsMap);
                userSet.add(teamUserRow.getLong("enterprisehmrespo.id"));
            }
        }
        if (dynColl != null && !dynColl.isEmpty()) {
            for (DynamicObject teamDyn : dynColl) {
                if (teamDyn.getLong("id") != Long.parseLong(teamId)) continue;
                userDynColl = teamDyn.getDynamicObjectCollection("subentryentity");
                for (DynamicObject dynamicObject : userDynColl) {
                    if (!ProjectTeamEnum.ADD.getValue().equals(dynamicObject.getString("memberstatus"))) continue;
                    Iterator teamIt = teamColl.iterator();
                    boolean isLeave = true;
                    while (teamIt.hasNext()) {
                        DynamicObject teamUser = (DynamicObject)teamIt.next();
                        Long oldUserId = dynamicObject.getLong("enterprisehmrespo.id");
                        Long newUserId = teamUser.getLong("addname.id");
                        teamDyn.getLong("id");
                        Long.parseLong((String)this.getModel().getValue("teamname"));
                        if (!oldUserId.equals(newUserId)) continue;
                        isLeave = false;
                        teamIt.remove();
                        Boolean oldIsMain = dynamicObject.getBoolean("ismain");
                        Boolean newIsMain = teamUser.getBoolean("ismain");
                        if (!oldIsMain.equals(newIsMain)) {
                            dynamicObject.set("ismain", (Object)newIsMain);
                        }
                        String oldRole = dynamicObject.getString("role.id");
                        String newRole = teamUser.getString("role.id");
                        if (oldRole != null && newRole != null && oldRole.equals(newRole)) break;
                        dynamicObject.set("role", (Object)teamUser.getDynamicObject("role"));
                        break;
                    }
                    if (!isLeave) continue;
                    productTeamDetailsMap.remove(Long.parseLong((String)this.getModel().getValue("teamname")) + "" + dynamicObject.getLong("enterprisehmrespo.id"));
                    dynamicObject.set("memberstatus", (Object)ProjectTeamEnum.LEAVE.getValue());
                    dynamicObject.set("leaveteamdata", (Object)date);
                }
            }
        }
        if (!teamColl.isEmpty() && userDynColl != null) {
            for (DynamicObject teamUser : teamColl) {
                DynamicObject user = new DynamicObject(userDynColl.getDynamicObjectType());
                user.set("enterprisehmrespo", (Object)teamUser.getLong("addname.id"));
                user.set("ismain", (Object)teamUser.getBoolean("ismain"));
                user.set("addteamdata", (Object)date);
                user.set("memberstatus", (Object)ProjectTeamEnum.ADD.getValue());
                user.set("role", (Object)teamUser.getString("role.id"));
                userDynColl.add((Object)user);
            }
        }
        HashMap productMap = new HashMap(16);
        ArrayList productTeamDetailsList = new ArrayList(16);
        if (userDynColl != null && !userDynColl.isEmpty()) {
            for (DynamicObject dynamicObject : userDynColl) {
                if (dynamicObject.getLong("enterprisehmrespo.id") == 0L || !ProjectTeamEnum.ADD.getValue().equals(dynamicObject.getString("memberstatus"))) continue;
                HashMap<String, Object> UsersDetailsMap = new HashMap<String, Object>(4);
                UsersDetailsMap.put("id", id);
                UsersDetailsMap.put("role", dynamicObject.getString("role.id"));
                UsersDetailsMap.put("enterprisehmrespo", dynamicObject.getLong("enterprisehmrespo.id"));
                UsersDetailsMap.put("addteamdata", dynamicObject.getDate("addteamdata"));
                UsersDetailsMap.put("entryentity.id", Long.parseLong((String)this.getModel().getValue("teamname")));
                productTeamDetailsMap.remove(Long.parseLong((String)this.getModel().getValue("teamname")) + "" + dynamicObject.getLong("enterprisehmrespo.id"));
                productTeamDetailsList.add(UsersDetailsMap);
                userSet.add(dynamicObject.getLong("enterprisehmrespo.id"));
            }
            if (!productTeamDetailsMap.isEmpty()) {
                for (Map.Entry entry : productTeamDetailsMap.entrySet()) {
                    productTeamDetailsList.add(entry.getValue());
                }
            }
            productMap.put(id, productTeamDetailsList);
        }
        List updateDynObjs = null;
        if (!productMap.isEmpty()) {
            updateDynObjs = ProjectTeamUtils.copyToEnterpriseHmResPo(productMap, userSet);
        }
        if (updateDynObjs != null && !updateDynObjs.isEmpty()) {
            int n = updateDynObjs.size() % 5000 == 0 ? updateDynObjs.size() / 5000 : updateDynObjs.size() / 5000 + 1;
            List averagelist = ProjectTeamUtils.averageAssign((List)updateDynObjs, (int)n);
            for (List list : averagelist) {
                DynamicObject[] dynamicObjectarr = list.toArray(new DynamicObject[list.size()]);
                SaveServiceHelper.save((DynamicObject[])dynamicObjectarr);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projectTeamObj});
    }

    private void delNode(int[] lines) {
        HashSet<Long> userSet = new HashSet<Long>(16);
        for (int i : lines) {
            DynamicObject dyn = (DynamicObject)this.getModel().getValue("addname", i);
            userSet.add(dyn.getLong("id"));
        }
        this.getModel().deleteEntryRows("addentryentity", lines);
        if (!userSet.isEmpty()) {
            int[] line = this.getModel().batchCreateNewEntryRow("entryentity", userSet.size());
            int i = 0;
            for (Long user : userSet) {
                this.getModel().setValue("enterprisehmrespo", (Object)user, line[i]);
                ++i;
            }
        }
    }

    private void addNode(int[] lines) {
        HashSet<Long> userSet = new HashSet<Long>(16);
        for (int i : lines) {
            DynamicObject dyn = (DynamicObject)this.getModel().getValue("enterprisehmrespo", i);
            userSet.add(dyn.getLong("id"));
        }
        this.getModel().deleteEntryRows("entryentity", lines);
        if (!userSet.isEmpty()) {
            int[] line = this.getModel().batchCreateNewEntryRow("addentryentity", userSet.size());
            int i = 0;
            for (Long user : userSet) {
                this.getModel().setValue("addname", (Object)user, line[i]);
                this.getModel().setValue("ismain", (Object)Boolean.TRUE, line[i]);
                ++i;
            }
        }
    }

    private void propertyChanged(ChangeData changeData, String propertyName) {
        Object oldObject = changeData.getOldValue();
        Object newObject = changeData.getNewValue();
        DynamicObject propertyValueCDDE = changeData.getDataEntity();
        if (oldObject != null && newObject != null && oldObject.toString().equalsIgnoreCase(newObject.toString())) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"teamname") && newObject != null) {
            this.teamNameChange();
        }
    }

    private void teamNameChange() {
        int i;
        Set userSet = ProjectTeamUtils.getUsers();
        String teamId = (String)this.getModel().getValue("teamname");
        String id = (String)this.getModel().getValue("id");
        Map teamUserMap = ProjectTeamUtils.getUserForTeam((Long)Long.parseLong(id), (Long)Long.parseLong(teamId));
        userSet.removeAll(teamUserMap.keySet());
        this.getModel().deleteEntryData("entryentity");
        this.getModel().deleteEntryData("addentryentity");
        if (!userSet.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("entryentity", userSet.size());
            i = 0;
            for (Long l : userSet) {
                this.getModel().setValue("enterprisehmrespo", (Object)l, i);
                ++i;
            }
        }
        if (!teamUserMap.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("addentryentity", teamUserMap.size());
            i = 0;
            for (Map.Entry entry : teamUserMap.entrySet()) {
                this.getModel().setValue("addname", entry.getKey(), i);
                this.getModel().setValue("ismain", ((Map)entry.getValue()).get("entryentity.subentryentity.ismain"), i);
                this.getModel().setValue("role", ((Map)entry.getValue()).get("entryentity.subentryentity.role.id"), i);
                ++i;
            }
        }
    }

    private void initData(Long id) {
        QFilter idsFilter;
        String selectFields = CommonUtils.getSelects((String[])new String[]{"id", "billno", "billname", "pmpdproject.id", "entryentity", "entryentity.teamname"});
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"pmpd_projectteam", (String)selectFields, (QFilter[])new QFilter[]{idsFilter = new QFilter("id", "=", (Object)id)});
        if (dyn != null) {
            this.getModel().setValue("id", (Object)id);
            this.getModel().setValue("teambillno", (Object)dyn.getString("billno"));
            this.getModel().setValue("teambillname", (Object)dyn.getString("billname"));
            this.getModel().setValue("pmpdproject", (Object)dyn.getLong("pmpdproject.id"));
            DynamicObjectCollection teamDynColl = dyn.getDynamicObjectCollection("entryentity");
            if (teamDynColl != null && !teamDynColl.isEmpty()) {
                List<ComboItem> teamInfos = this.getAllTeamInfo(teamDynColl);
                ComboEdit mulComboEdit = (ComboEdit)this.getView().getControl("teamname");
                mulComboEdit.setComboItems(teamInfos);
                this.getModel().setValue("teamname", (Object)((DynamicObject)teamDynColl.get(0)).getString("id"));
                this.teamNameChange();
            }
        }
    }

    private List<ComboItem> getAllTeamInfo(DynamicObjectCollection teamDynColl) {
        ArrayList<ComboItem> teamInfos = new ArrayList<ComboItem>(16);
        for (int i = 0; i < teamDynColl.size(); ++i) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(((DynamicObject)teamDynColl.get(i)).getString("teamname")));
            item.setValue(((DynamicObject)teamDynColl.get(i)).getString("id"));
            teamInfos.add(item);
        }
        return teamInfos;
    }

    private void setLock(String id) {
        Map lockMap = MutexFactory.createDataMutex().getLockInfo(id, "pmc", "pmpd_projectteam_adjm");
        if (lockMap == null) {
            if (MutexFactory.createDataMutex().require(id, "pmc", "pmpd_projectteam_adjm", GROUPID, true)) {
                this.getPageCache().put(GROUPID, id);
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_save"});
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u6b63\u5728\u8c03\u6574\u8be5\u5355\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ProjectTeamAdjustmentEdit_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_save"});
            String userid = (String)lockMap.get("userid");
            QFilter filer = new QFilter("id", "=", (Object)Long.parseLong(userid));
            DynamicObject user = QueryServiceHelper.queryOne((String)"bos_usergroup_user", (String)"id,name", (QFilter[])new QFilter[]{filer});
            if (user != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format(ResManager.loadKDString((String)"\u7528\u6237%s\u6b63\u5728PC\u7aef\u8c03\u6574\u8be5\u5355\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectTeamAdjustmentEdit_5", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), user.getString("name")));
                this.getView().showTipNotification(sb.toString());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u6b63\u5728\u8c03\u6574\u8be5\u5355\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ProjectTeamAdjustmentEdit_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

