/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.bigtask;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.pmc.pmpd.business.workhour.WorkHourTemplateHelper;
import kd.pmc.pmpd.common.bigtask.BigTaskHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.model.IndustryWorkHourModifiedData;
import kd.pmc.pmpd.common.model.StageTemplateModifiedData;
import kd.pmc.pmpd.common.model.WorkHourTemplateChangeTaskDto;
import org.apache.commons.collections4.MapUtils;

public class WorkHourTemplateChangeTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(WorkHourTemplateChangeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        String taskName = ResManager.loadKDString((String)"[\u5de5\u65f6\u6a21\u677f\u53d8\u66f4\u4efb\u52a1]", (String)"WorkHourTemplateChangeTask_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
        LOG.info("{}Start execution. params: {}", (Object)taskName, params);
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"WorkHourTemplateChangeTask_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), null);
        Map dataMap = (Map)params.get("data");
        if (MapUtils.isEmpty((Map)dataMap)) {
            this.feedbackCustomdata(BigTaskHelper.warn((String)taskName, (String)ResManager.loadKDString((String)"\u6ca1\u6709\u6570\u636e\u53ef\u4ee5\u6267\u884c\u3002", (String)"WorkHourTemplateChangeTask_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0])));
            return;
        }
        WorkHourTemplateChangeTaskDto dto = this.convert2WorkHourTemplateChangeTaskDto(dataMap);
        boolean isEstimatedWorkHourTemplate = dto.isEstimatedWorkHourTemplate();
        Map templateId2ModifiedData = dto.getTemplateId2ModifiedData();
        Table templateId2EstimatedBillTable = WorkHourTemplateHelper.getTemplateId2EstimatedBillTable((boolean)isEstimatedWorkHourTemplate, (List)dto.getEstimatedBillIds());
        ArrayList estimatedBillIds = Lists.newArrayList((Iterable)templateId2EstimatedBillTable.columnKeySet());
        int totalSize = estimatedBillIds.size();
        this.feedbackProgress(0, String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u6709%d\u6761\u5de5\u65f6\u4f30\u7b97\u5355\u5f15\u7528\u4e86\u8be5\u6a21\u677f\uff0c\u6b63\u5728\u91cd\u65b0\u751f\u6210...", (String)"WorkHourTemplateChangeTask_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), totalSize), null);
        int batchSize = WorkHourTemplateHelper.getBatchSizeFromAppParam();
        int times = totalSize / batchSize;
        times = totalSize % batchSize != 0 ? times + 1 : times;
        for (int i = 0; i < times; ++i) {
            int startIndex = i * batchSize;
            int endIndex = Math.min(startIndex + batchSize, totalSize);
            try {
                WorkHourTemplateHelper.regenerateEstimatedBill((boolean)isEstimatedWorkHourTemplate, (Object[])estimatedBillIds.subList(startIndex, endIndex).toArray(), (Table)templateId2EstimatedBillTable);
            }
            catch (CloneNotSupportedException e) {
                throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[]{e.getMessage()});
            }
            this.feedbackProgress(this.calculateProgress(endIndex, totalSize), String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5206\u6279\u5904\u7406\u4e2d\uff0c\u6bcf\u6279%1$d\u5f20\uff0c\u5df2\u5b8c\u6210 %2$d/%3$d\u5f20", (String)"WorkHourTemplateChangeTask_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), batchSize, endIndex, totalSize), null);
        }
        this.feedbackProgress(99, ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210\u6a21\u677f\u53d8\u66f4\u62a5\u544a...", (String)"WorkHourTemplateChangeTask_5", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), null);
        WorkHourTemplateHelper.generateReportFromTemplate((boolean)isEstimatedWorkHourTemplate, (long)dto.getUserId(), (long)dto.getCreageOrgId(), (Map)templateId2ModifiedData, (Table)templateId2EstimatedBillTable);
        this.feedbackCustomdata(BigTaskHelper.success((String)taskName, (Object)totalSize));
    }

    private int calculateProgress(int completedSize, int totalSize) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(0);
        return Integer.parseInt(numberFormat.format((float)completedSize / (float)totalSize * 100.0f));
    }

    private WorkHourTemplateChangeTaskDto convert2WorkHourTemplateChangeTaskDto(Map<String, Object> dataMap) {
        Object estimatedBillIdsObj;
        WorkHourTemplateChangeTaskDto result = new WorkHourTemplateChangeTaskDto();
        result.setUserId(ObjectConverterWrapper.getLong((Object)dataMap.get("userId")).longValue());
        result.setCreageOrgId(ObjectConverterWrapper.getLong((Object)dataMap.get("creageOrgId")).longValue());
        result.setEstimatedWorkHourTemplate(ObjectConverterWrapper.getBoolean((Object)dataMap.get("estimatedWorkHourTemplate")).booleanValue());
        Object templateId2ModifiedDataObj = dataMap.get("templateId2ModifiedData");
        if (templateId2ModifiedDataObj instanceof Map) {
            Map id2ModifiedData = (Map)templateId2ModifiedDataObj;
            HashMap templateId2ModifiedData = Maps.newHashMapWithExpectedSize((int)id2ModifiedData.size());
            for (Map.Entry entry : id2ModifiedData.entrySet()) {
                List modifiedDatas = templateId2ModifiedData.computeIfAbsent(Long.parseLong((String)entry.getKey()), k -> new ArrayList(10));
                for (Map modifiedDataMap : (List)entry.getValue()) {
                    modifiedDatas.add(this.convert2IndustryWorkHourModifiedDataDto(modifiedDataMap));
                }
            }
            result.setTemplateId2ModifiedData((Map)templateId2ModifiedData);
        }
        if ((estimatedBillIdsObj = dataMap.get("estimatedBillIds")) instanceof List) {
            result.setEstimatedBillIds((List)estimatedBillIdsObj);
        }
        return result;
    }

    private List<StageTemplateModifiedData> convert2StageTemplateModifiedDataDto(Object obj) {
        if (obj instanceof List) {
            List modifiedDatas = (List)obj;
            ArrayList<StageTemplateModifiedData> result = new ArrayList<StageTemplateModifiedData>(10);
            for (Map modifiedDataMap : modifiedDatas) {
                StageTemplateModifiedData modifiedData = new StageTemplateModifiedData();
                for (Map.Entry modifiedDataEntry : modifiedDataMap.entrySet()) {
                    Object value = modifiedDataEntry.getValue();
                    switch ((String)modifiedDataEntry.getKey()) {
                        case "stage": {
                            modifiedData.setStage(ObjectConverterWrapper.getInt(value).intValue());
                            break;
                        }
                        case "percentage": {
                            modifiedData.setPercentage(ObjectConverterWrapper.getBigDecimal(value));
                            break;
                        }
                        case "oldPercentage": {
                            modifiedData.setOldPercentage(ObjectConverterWrapper.getBigDecimal(value));
                            break;
                        }
                    }
                }
                result.add(modifiedData);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private IndustryWorkHourModifiedData convert2IndustryWorkHourModifiedDataDto(Map<String, Object> modifiedDataMap) {
        IndustryWorkHourModifiedData modifiedData = new IndustryWorkHourModifiedData();
        for (Map.Entry<String, Object> modifiedDataEntry : modifiedDataMap.entrySet()) {
            Object value = modifiedDataEntry.getValue();
            switch (modifiedDataEntry.getKey()) {
                case "industryOneId": {
                    modifiedData.setIndustryOneId(ObjectConverterWrapper.getLong((Object)value).longValue());
                    break;
                }
                case "industryId": {
                    modifiedData.setIndustryId(ObjectConverterWrapper.getLong((Object)value).longValue());
                    break;
                }
                case "routineWorkHour": {
                    modifiedData.setRoutineWorkHour(ObjectConverterWrapper.getBigDecimal((Object)value));
                    break;
                }
                case "nonRoutineWorkHour": {
                    modifiedData.setNonRoutineWorkHour(ObjectConverterWrapper.getBigDecimal((Object)value));
                    break;
                }
                case "totalHours": {
                    modifiedData.setTotalHours(ObjectConverterWrapper.getBigDecimal((Object)value));
                    break;
                }
                case "oldRoutineWorkHour": {
                    modifiedData.setOldRoutineWorkHour(ObjectConverterWrapper.getBigDecimal((Object)value));
                    break;
                }
                case "oldNonRoutineWorkHour": {
                    modifiedData.setOldNonRoutineWorkHour(ObjectConverterWrapper.getBigDecimal((Object)value));
                    break;
                }
                case "oldTotalHours": {
                    modifiedData.setOldTotalHours(ObjectConverterWrapper.getBigDecimal((Object)value));
                    break;
                }
                case "stageTemplateModifiedDataList": {
                    modifiedData.setStageTemplateModifiedDataList(this.convert2StageTemplateModifiedDataDto(value));
                    break;
                }
            }
        }
        return modifiedData;
    }
}

