/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.business.helper.TXServiceHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.util.WorkPackVersionUtils;
import kd.pmc.pmpd.common.util.WorkPackageUtils;

public final class WorkPackUtils {
    private WorkPackUtils() {
    }

    public static void getContractInfo(AbstractFormPlugin formPlugin, long customerId, long contractId) {
        IFormView formView = formPlugin.getView();
        if (contractId != 0L) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u4fe1\u606f\u5df2\u5b58\u5728\u3002", (String)"WorkPackUtils_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"conm_salcontractf7", (boolean)false);
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        filters.add(new QFilter("validstatus", "=", (Object)"B"));
        if (customerId != 0L) {
            filters.add(new QFilter("customer", "=", (Object)customerId));
        }
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "contractno"));
        formView.showForm((FormShowParameter)listShowParameter);
    }

    public static Set<String> getContractInfoFields() {
        return Sets.newHashSet((Object[])new String[]{"contractid", "contractno", "jabcard_contractid", "jabcard_contractno", "iscontractworkpack", "entry_modifier_id", "entry_modifytime"});
    }

    public static void addDataChangeType(IPageCache pageCache, String type) {
        Set<String> dataChangeTypes = WorkPackUtils.getDataChangeType(pageCache);
        dataChangeTypes.add(type);
        pageCache.put("dataChangeType", SerializationUtils.toJsonString(dataChangeTypes));
    }

    public static Set<String> getDataChangeType(IPageCache pageCache) {
        String dataChangeTypeJson = pageCache.get("dataChangeType");
        return StringUtils.isEmpty((CharSequence)dataChangeTypeJson) ? Sets.newHashSetWithExpectedSize((int)3) : (Set)SerializationUtils.fromJsonString((String)dataChangeTypeJson, HashSet.class);
    }

    public static void saveContractInfo(DynamicObject dynamicObject, ListSelectedRow selectedContractRow) {
        if (selectedContractRow == null) {
            return;
        }
        Long contractId = (Long)selectedContractRow.getPrimaryKeyValue();
        String contractNo = selectedContractRow.getNumber();
        dynamicObject.set("contractid", (Object)contractId);
        dynamicObject.set("contractno", (Object)contractNo);
        DynamicObjectCollection entryCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        DataEntityPropertyCollection properties = entryCollection.getDynamicObjectType().getProperties();
        IDataEntityProperty contractIdProp = (IDataEntityProperty)properties.get((Object)"jabcard_contractid");
        IDataEntityProperty contractNoProp = (IDataEntityProperty)properties.get((Object)"jabcard_contractno");
        IDataEntityProperty isContractWorkPackageProp = (IDataEntityProperty)properties.get((Object)"iscontractworkpack");
        for (DynamicObject entry : entryCollection) {
            contractIdProp.setValueFast((Object)entry, (Object)contractId);
            contractNoProp.setValueFast((Object)entry, (Object)contractNo);
            isContractWorkPackageProp.setValueFast((Object)entry, (Object)true);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public static void viewDifferenceReport(AbstractFormPlugin formPlugin, long workPackId, String billListKey, Map<String, Object> params) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pmpd_difference_report", (boolean)false);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u5dee\u5f02\u62a5\u544a", (String)"WorkPackUtils_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        filters.add(new QFilter("workpackageid", "=", (Object)workPackId));
        filters.add(new QFilter("ishistory", "=", (Object)Character.valueOf('0')));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, StringUtils.isBlank((CharSequence)billListKey) ? "report" : billListKey));
        listShowParameter.setCustomParams(params);
        OpenStyle openStyle = listShowParameter.getOpenStyle();
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("70%");
        styleCss.setHeight("70%");
        openStyle.setInlineStyleCss(styleCss);
        formPlugin.getView().showForm((FormShowParameter)listShowParameter);
    }

    private static List<Object[]> addWorkCardByReportSelection(DynamicObject dataEntity, Map<Long, DynamicObject> workPackEntryIdMap) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
        boolean isContractWorkPackage = dataEntity.getDynamicObjectType().getName().equals("pmpd_contract_workpack");
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject workPackgeEntry : collection) {
            Long entryId = (Long)workPackgeEntry.getPkValue();
            DynamicObject workCard = workPackEntryIdMap.get(entryId);
            if (workCard == null) continue;
            paramsList.add(new Object[]{workCard.getPkValue(), workPackgeEntry.getPkValue()});
            WorkPackageUtils.fillJobCardInfo((DynamicObject)workPackgeEntry, (DynamicObject)workCard, (boolean)isContractWorkPackage);
        }
        return paramsList;
    }

    public static boolean handleSelectedWorkCard(Map<String, Long> selectedWorkCardMap, DynamicObject workPack) {
        if (selectedWorkCardMap.isEmpty()) {
            return false;
        }
        Map<Long, Long> selectedReportMap = selectedWorkCardMap.entrySet().stream().collect(Collectors.toMap(entry -> Long.parseLong((String)entry.getKey()), Map.Entry::getValue));
        Map<Long, DynamicObject> workCardCache = WorkPackUtils.loadWorkCardBySelection(selectedReportMap);
        Map<Long, DynamicObject> workPackEntryMap = WorkPackUtils.buildWorkPackEntryMap(selectedReportMap, workCardCache);
        List<Object[]> paramsList = WorkPackUtils.addWorkCardByReportSelection(workPack, workPackEntryMap);
        TXServiceHelper.executeWithTX(() -> {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{workPack});
            WorkPackVersionUtils.update4WorkCard((List)paramsList);
            WorkPackUtils.updateDifferenceReportBySelection(selectedReportMap);
        });
        return true;
    }

    private static void updateDifferenceReportBySelection(Map<Long, Long> selectedReportMap) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_difference_report");
        EntryProp entryProp = (EntryProp)dataEntityType.getProperty("entryentity");
        DynamicObjectType entryEntityType = entryProp.getDynamicCollectionItemPropertyType();
        ArrayList updateDataEntites = Lists.newArrayListWithExpectedSize((int)selectedReportMap.size());
        ArrayList updateEntryEntites = Lists.newArrayListWithExpectedSize((int)selectedReportMap.size());
        for (Map.Entry<Long, Long> entry : selectedReportMap.entrySet()) {
            DynamicObject dataEntity = new DynamicObject((DynamicObjectType)dataEntityType, (Object)entry.getKey());
            dataEntity.set("ishistory", (Object)Character.valueOf('1'));
            updateDataEntites.add(dataEntity);
            DynamicObject entryEntity = new DynamicObject(entryEntityType, (Object)entry.getValue());
            entryEntity.set("isselect", (Object)true);
            updateEntryEntites.add(entryEntity);
        }
        SaveServiceHelper.update((DynamicObject[])updateDataEntites.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])updateEntryEntites.toArray(new DynamicObject[0]));
    }

    public static Set<String> getWorkCardInfoFields(boolean isContractWorkPack) {
        HashSet<String> fieldKeys = new HashSet<String>(16);
        fieldKeys.add("customer_jobcardno");
        fieldKeys.add("customer_jobcardversion");
        fieldKeys.add("jobcard_id");
        fieldKeys.add("jobcard");
        fieldKeys.add("jobcardtitle");
        fieldKeys.add("workcategory_id");
        fieldKeys.add("programno");
        fieldKeys.add("auxiliarycode");
        fieldKeys.add("pagination");
        fieldKeys.add("ismultipage");
        fieldKeys.add("fieldsource");
        if (isContractWorkPack) {
            fieldKeys.add("programhours");
            fieldKeys.add("workcardhours");
        } else {
            fieldKeys.add("riskjobcard");
            fieldKeys.add("isfirstexecute");
            fieldKeys.add("outsource");
        }
        return fieldKeys;
    }

    public static void showMultiPageProcessingList(AbstractFormPlugin formPlugin, List<Object> executeWorkPackageIdList) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pmpd_pagination_selector", (boolean)false);
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        List executeWorkPackagePaginationIdList = WorkPackageUtils.listExecuteWorkPackagePaginationId(executeWorkPackageIdList);
        filters.add(new QFilter("id", "in", (Object)executeWorkPackagePaginationIdList));
        filters.add(new QFilter("ishistory", "=", (Object)Character.valueOf('0')));
        listShowParameter.setCustomParam("currentIdList", (Object)executeWorkPackagePaginationIdList);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "multiPage"));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("90%");
        styleCss.setHeight("90%");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        formPlugin.getView().showForm((FormShowParameter)listShowParameter);
    }

    private static Map<Long, DynamicObject> loadWorkCardBySelection(Map<Long, Long> reportMap) {
        Map<Long, Long> selectedWorkCardMap = WorkPackUtils.getSelectedWorkCardMap(reportMap);
        if (selectedWorkCardMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet selectFields = Sets.newHashSet((Object[])new String[]{"cardname", "group_id", "refwordcard.number", "cardnumid", "refwordcard.totalhours", "riskcard", "pageentity.pageseq", "pageentity.pagesumhours", "firstexe", "isom"});
        Map cache = BusinessDataServiceHelper.loadFromCache((Object[])selectedWorkCardMap.values().toArray(), (DynamicObjectType)EntityMetadataCache.getSubDataEntityType((String)"mpdm_mrocardroute", (Collection)selectFields));
        HashMap<Long, DynamicObject> report2WorkCard = new HashMap<Long, DynamicObject>(16);
        for (Map.Entry<Long, Long> entry : selectedWorkCardMap.entrySet()) {
            report2WorkCard.put(entry.getKey(), (DynamicObject)cache.get(entry.getValue()));
        }
        return report2WorkCard;
    }

    private static Map<Long, DynamicObject> buildWorkPackEntryMap(Map<Long, Long> reportMap, Map<Long, DynamicObject> workCardCache) {
        String selectFields = "id, entry_workpack.workpackentryid";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", reportMap.keySet())};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"listWorkPackEntryId", (String)"pmpd_difference_report", (String)selectFields, (QFilter[])filters, null);){
            if (dataSet.isEmpty()) {
                Map<Long, DynamicObject> map = Collections.emptyMap();
                return map;
            }
            HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
            for (Row row : dataSet) {
                Long workPackEntryId = ObjectConverterWrapper.getLong((Object)row.get(1));
                if (workPackEntryId == 0L) continue;
                result.put(workPackEntryId, workCardCache.get(ObjectConverterWrapper.getLong((Object)row.get(0))));
            }
            HashMap<Long, DynamicObject> hashMap = result;
            return hashMap;
        }
    }

    private static Map<Long, Long> getSelectedWorkCardMap(Map<Long, Long> returnMap) {
        String selectFields = "id, entryentity.jobcard";
        QFilter[] filters = new QFilter[]{new QFilter("entryentity", "in", returnMap.values())};
        try (DataSet dataSet = ORM.create().queryDataSet("getSelectedWorkCardIdSet", "pmpd_difference_report", selectFields, filters);){
            if (dataSet.isEmpty()) {
                Map<Long, Long> map = Collections.emptyMap();
                return map;
            }
            HashMap<Long, Long> result = new HashMap<Long, Long>(16);
            for (Row row : dataSet) {
                result.put(ObjectConverterWrapper.getLong((Object)row.get(0)), ObjectConverterWrapper.getLong((Object)row.get(1)));
            }
            HashMap<Long, Long> hashMap = result;
            return hashMap;
        }
    }

    public static void showVersionReport(IFormView formView, QFilter filter) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pmpd_workpack_versionrpt", (boolean)false);
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        filters.add(filter);
        formView.showForm((FormShowParameter)listShowParameter);
    }

    public static boolean boundProject(long manageId) {
        QFilter[] filters = new QFilter[]{new QFilter("manageid", "=", (Object)manageId)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"boundProject", (String)"pmpd_exec_workpack", (String)"project", (QFilter[])filters, null);){
            for (Row row : dataSet) {
                Long projectId = ObjectConverterWrapper.getLong((Object)row.get(0));
                if (projectId == 0L) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static boolean hasWorkOrder(long workPackageId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)workPackageId)};
        String selectFields = "entryentity.jobno, entryentity.customer_jobcardstatus";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"hasWorkOrder", (String)"pmpd_exec_workpack", (String)selectFields, (QFilter[])filters, null);){
            for (Row row : dataSet) {
                String customerWorkCardStatus = ObjectConverterWrapper.getString((Object)row.get(1));
                if (WorkPackageUtils.checkCustomerWorkCardStatus((String)customerWorkCardStatus)) continue;
                String jobNo = ObjectConverterWrapper.getString((Object)row.get(0));
                if (!StringUtils.isNotBlank((CharSequence)jobNo)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static Map<String, List<Long>> getWorkPackageIdByName(Object manageId, Set<String> names) {
        QFilter[] filters = new QFilter[]{new QFilter("manageid", "=", manageId), new QFilter("name", "in", names)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getWorkPackageIdByName", (String)"pmpd_exec_workpack", (String)"id, name", (QFilter[])filters, null);){
            HashMap<String, List> resultMap = new HashMap<String, List>(16);
            for (Row row : dataSet) {
                List ids = resultMap.computeIfAbsent(row.getString(1), k -> new ArrayList(10));
                ids.add(row.getLong(0));
            }
            HashMap<String, List> hashMap = resultMap;
            return hashMap;
        }
    }

    public static DynamicObject[] updateVersionDifferenceReport(Map<String, Long> name2ProjectId, Map<String, List<Long>> workPackageIdMap) {
        ArrayList allWorkPackageId = new ArrayList(10);
        for (Map.Entry<String, List<Long>> entry : workPackageIdMap.entrySet()) {
            allWorkPackageId.addAll(entry.getValue());
        }
        String selectFields = "project_id, workpack_id";
        QFilter[] filters = new QFilter[]{new QFilter("workpack_id", "in", allWorkPackageId)};
        DynamicObject[] differenceReportArray = BusinessDataServiceHelper.load((String)"pmpd_workpack_versionrpt", (String)selectFields, (QFilter[])filters);
        Map differenceReportMap = Arrays.stream(differenceReportArray).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("workpack_id"), Function.identity(), (k1, k2) -> k1));
        for (Map.Entry<String, List<Long>> entry : workPackageIdMap.entrySet()) {
            Long projectId = name2ProjectId.get(entry.getKey());
            if (projectId == null) continue;
            List<Long> workPackageIds = entry.getValue();
            for (Long workPackageId : workPackageIds) {
                DynamicObject differenceReport = (DynamicObject)differenceReportMap.get(workPackageId);
                if (differenceReport == null) continue;
                differenceReport.set("project_id", (Object)projectId);
            }
        }
        return differenceReportArray;
    }
}

