/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.helper;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class WorkloadRptQueryHelper {
    public static DataSet getWorkLoadData(ReportQueryParam param) {
        param.getFilter().getQFilters();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        block16: for (FilterItemInfo f : param.getFilter().getFilterItems()) {
            if (Objects.isNull(f.getValue())) continue;
            String name = f.getPropName();
            Object value = f.getValue();
            switch (name) {
                case "year": {
                    continue block16;
                }
                case "range": {
                    continue block16;
                }
                case "rpttype": {
                    continue block16;
                }
                case "estiapproachtime_startdate": {
                    filters.add(new QFilter("estiapproachtime", ">=", value));
                    continue block16;
                }
                case "estiapproachtime_enddate": {
                    filters.add(new QFilter("estiapproachtime", "<=", value));
                    continue block16;
                }
                case "pulishstatus": {
                    List collect = ((Stream)Arrays.stream(String.valueOf(value).split(",")).sequential()).filter(s -> StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList());
                    filters.add(new QFilter(name, "in", collect));
                    continue block16;
                }
            }
            filters.add(new QFilter(name, "in", value instanceof DynamicObject ? ((DynamicObject)value).get("id") : value));
        }
        DynamicObjectCollection rscoll = QueryServiceHelper.query((String)"pmpd_resourceplan", (String)"billno", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        Set nos = rscoll.stream().collect(HashSet::new, (l1, dy) -> l1.add(dy.getString("billno")), (l1, l2) -> l2.addAll(l1));
        DynamicObjectCollection allcoll = QueryServiceHelper.query((String)"pmpd_resourceplan", (String)"id,pulishstatus", (QFilter[])new QFilter("billno", "in", (Object)nos).toArray());
        List ypIDs = allcoll.stream().filter(c1 -> StringUtils.equals((CharSequence)c1.getString("pulishstatus"), (CharSequence)"0")).map(c2 -> c2.getLong("id")).collect(Collectors.toList());
        List<Long> scIDs = allcoll.stream().filter(c1 -> StringUtils.equals((CharSequence)c1.getString("pulishstatus"), (CharSequence)"1")).map(c2 -> c2.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("resourceplan.id", "in", ypIDs);
        Calendar c = Calendar.getInstance();
        c.setTime((Date)param.getFilter().getFilterItem("year").getValue());
        filter.and(new QFilter("entryentity.year", "=", (Object)c.get(1)));
        DataSet set = QueryServiceHelper.queryDataSet((String)"QUERY_WORKLOAD", (String)"pmpd_monthhourbill", (String)WorkloadRptQueryHelper.getSelects(), (QFilter[])filter.toArray(), (String)"");
        return WorkloadRptQueryHelper.buildMonthDataSet(set, param, scIDs);
    }

    private static DataSet buildBalanceSet(DataSet wktotalrs, DataSet pdwktotalrs, DataSetBuilder bldataSetBuilder, int size, String type) {
        int i;
        String[] fieldNames;
        WorkloadRptQueryHelper.buildFirstRow(type, size, bldataSetBuilder);
        ArrayList<Object> wkls = new ArrayList<Object>(2);
        ArrayList<Object> pdls = new ArrayList<Object>(2);
        ArrayList<Object> blls = new ArrayList<Object>(2);
        for (Row wkrow : wktotalrs.copy().updateField("professiona", String.format("'%s'", WorkloadRptQueryHelper.getGzlDisplayname()))) {
            fieldNames = wktotalrs.getRowMeta().getFieldNames();
            for (i = 0; i < fieldNames.length; ++i) {
                if (!Objects.equals(wktotalrs.getRowMeta().getDataType(i), DataType.BigDecimalType)) continue;
                wkls.add(wkrow.getBigDecimal(i));
            }
        }
        for (Row pdrow : pdwktotalrs.copy().updateField("professiona", String.format("'%s'", WorkloadRptQueryHelper.getSclDisplayname()))) {
            fieldNames = pdwktotalrs.getRowMeta().getFieldNames();
            for (i = 0; i < fieldNames.length; ++i) {
                if (!Objects.equals(pdwktotalrs.getRowMeta().getDataType(i), DataType.BigDecimalType)) continue;
                pdls.add(pdrow.getBigDecimal(i));
            }
        }
        for (int i2 = 0; i2 < wkls.size(); ++i2) {
            BigDecimal b1 = (BigDecimal)wkls.get(i2);
            BigDecimal b2 = (BigDecimal)pdls.get(i2);
            blls.add(b2.subtract(b1));
        }
        wkls.add(0);
        wkls.add(WorkloadRptQueryHelper.getBlDisplayname());
        wkls.add(WorkloadRptQueryHelper.getGzlDisplayname());
        wkls.addAll(Lists.newArrayList(Collections.nCopies(size, 0)));
        bldataSetBuilder.append(wkls.toArray());
        pdls.add(0);
        pdls.add(WorkloadRptQueryHelper.getBlDisplayname());
        pdls.add(WorkloadRptQueryHelper.getSclDisplayname());
        pdls.addAll(Lists.newArrayList(Collections.nCopies(size, 0)));
        bldataSetBuilder.append(pdls.toArray());
        blls.add(1);
        blls.add(WorkloadRptQueryHelper.getBlDisplayname());
        blls.add(WorkloadRptQueryHelper.getRsDisplayname());
        blls.addAll(Lists.newArrayList(Collections.nCopies(size, 0)));
        bldataSetBuilder.append(blls.toArray());
        return bldataSetBuilder.build();
    }

    private static DataSet buildMonthDataSet(DataSet set, ReportQueryParam param, List<Long> ids) {
        DataSet result = WorkloadRptQueryHelper.createMonthDateSet(set, param, ids);
        return result;
    }

    private static DataSet createMonthDateSet(DataSet sourSet, ReportQueryParam param, List<Long> ids) {
        List<Map> wkrowMaps = WorkloadRptQueryHelper.getWorkLoadMonthMaps(sourSet);
        wkrowMaps.sort((m1, m2) -> {
            int i1 = (Integer)m1.get("proidseq");
            int i2 = (Integer)m2.get("proidseq");
            return i1 - i2;
        });
        Map wkgrpMap = wkrowMaps.stream().collect(Collectors.groupingBy(map -> map.get("professiona"), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
        DataSetBuilder wkdataSetBuilder = WorkloadRptQueryHelper.createMonthDataSetBuilder();
        DataSet wkrs = WorkloadRptQueryHelper.getMonthDateSet(wkgrpMap, wkdataSetBuilder, WorkloadRptQueryHelper.getWlDisplayname());
        DataSet wktotalrs = WorkloadRptQueryHelper.buildTotalRow(wkrs, WorkloadRptQueryHelper.getGzlDisplayname());
        List<Long> proids = wkrowMaps.stream().map(map -> (Long)map.get("proid")).collect(Collectors.toList());
        List<Map> pdrowMaps = WorkloadRptQueryHelper.getProductivityMonthMaps(proids, param);
        Map pdgrpMap = pdrowMaps.stream().collect(Collectors.groupingBy(map -> map.get("professiona"), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
        pdgrpMap = WorkloadRptQueryHelper.sortMapByKeyAsc(pdgrpMap, wkgrpMap);
        DataSetBuilder pddataSetBuilder = WorkloadRptQueryHelper.createMonthDataSetBuilder();
        DataSet pdrs = WorkloadRptQueryHelper.getMonthDateSet(pdgrpMap, pddataSetBuilder, WorkloadRptQueryHelper.getPdDisplayname());
        DataSet pdtotalrs = WorkloadRptQueryHelper.buildTotalRow(pdrs, WorkloadRptQueryHelper.getSclDisplayname());
        String[] wkfieldNames = wkrs.getRowMeta().getFieldNames();
        String[] pdfieldNames = pdrs.getRowMeta().getFieldNames();
        pdfieldNames = Arrays.stream(pdfieldNames).map(f -> f.concat(" as ").concat("pd_").concat((String)f)).collect(Collectors.toList()).toArray(new String[0]);
        Arrays.stream(pdfieldNames).map(f -> "pd_".concat((String)f)).collect(Collectors.toList());
        DataSet joinDataSet = wkrs.join(pdrs, JoinType.INNER).on("professiona", "professiona").select(wkfieldNames, pdfieldNames).finish();
        DataSet tempset = joinDataSet.executeSql(String.format("select %s", WorkloadRptQueryHelper.getJoinSelects(wkfieldNames)));
        DataSetBuilder detailbuilder = WorkloadRptQueryHelper.createMonthDataSetBuilder();
        WorkloadRptQueryHelper.buildFirstRow(WorkloadRptQueryHelper.getBlDetailDisplayname(), 12, detailbuilder);
        DataSet detailset = detailbuilder.build().union(tempset);
        DataSetBuilder bldataSetBuilder = WorkloadRptQueryHelper.createMonthDataSetBuilder();
        DataSet blset = WorkloadRptQueryHelper.buildBalanceSet(wktotalrs, pdtotalrs, bldataSetBuilder, 12, WorkloadRptQueryHelper.getBlDisplayname());
        FilterItemInfo filterItem = param.getFilter().getFilterItem("rpttype");
        DataSet unionrs = WorkloadRptQueryHelper.createMonthDataSetBuilder().build();
        if (filterItem.getValue().toString().contains("1")) {
            unionrs = unionrs.union(wkrs.union(wktotalrs));
        }
        if (filterItem.getValue().toString().contains("2")) {
            unionrs = unionrs.union(pdrs.union(pdtotalrs));
        }
        if (filterItem.getValue().toString().contains("4")) {
            unionrs = unionrs.union(detailset);
        }
        if (filterItem.getValue().toString().contains("3")) {
            unionrs = unionrs.union(blset);
        }
        return unionrs;
    }

    private static String getJoinSelects(String[] wkfieldNames) {
        ArrayList<String> ls = new ArrayList<String>(2);
        for (int i = 0; i < wkfieldNames.length; ++i) {
            String field = wkfieldNames[i];
            if (field.contains("istotal") || field.contains("type") || field.contains("professiona") || field.contains("_int")) {
                ls.add(field);
                continue;
            }
            String s = "pd_".concat(field).concat(" - ").concat(field).concat(" as ").concat(field);
            ls.add(s);
        }
        return Joiner.on((String)",").join(ls);
    }

    private static List<Map> getProductivityMonthMaps(List<Long> ids, ReportQueryParam param) {
        return Lists.newArrayList();
    }

    public static Date getFirstOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        return calendar.getTime();
    }

    public static Date getLastOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        return calendar.getTime();
    }

    private static DataSet getMonthDateSet(Map<Object, List<Map>> grpMap, DataSetBuilder wkdataSetBuilder, String type) {
        WorkloadRptQueryHelper.buildFirstRow(type, Month.values().length, wkdataSetBuilder);
        for (Map.Entry<Object, List<Map>> me : grpMap.entrySet()) {
            ArrayList ls = Lists.newArrayList(Collections.nCopies(12, BigDecimal.ZERO));
            Map<Object, List<Map>> monthMap = me.getValue().stream().collect(Collectors.groupingBy(map -> map.get("month")));
            for (Map.Entry<Object, List<Map>> mo : monthMap.entrySet()) {
                int month = (Integer)mo.getKey();
                BigDecimal totalhour = mo.getValue().stream().map(map -> new BigDecimal(map.get("totalhour").toString())).reduce(BigDecimal::add).get();
                ls.set(month - 1, totalhour.setScale(0, RoundingMode.HALF_UP));
            }
            ls.add(0);
            ls.add(WorkloadRptQueryHelper.getWlDisplayname());
            ls.add(me.getKey());
            ls.addAll(Lists.newArrayList(Collections.nCopies(12, 0)));
            wkdataSetBuilder.append(ls.toArray());
        }
        DataSet rset = wkdataSetBuilder.build();
        return rset;
    }

    private static List<Map> getWorkLoadMonthMaps(DataSet sourSet) {
        Iterator iterator = sourSet.iterator();
        ArrayList<Map> rowMaps = new ArrayList<Map>(2);
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            for (Month m : Month.values()) {
                BigDecimal bigDecimal = row.getBigDecimal(m.getDisplayName(TextStyle.FULL, Locale.ENGLISH).toLowerCase());
                if (bigDecimal.compareTo(BigDecimal.ZERO) <= 0) continue;
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                if (Objects.isNull(row.get("proid")) || Objects.isNull(row.get("professiona"))) continue;
                rowMap.put("professiona", row.getString("professiona"));
                rowMap.put("month", m.getValue());
                rowMap.put("totalhour", bigDecimal);
                rowMap.put("proid", row.getLong("proid"));
                rowMap.put("proidseq", row.getInteger("proidseq"));
                rowMaps.add(rowMap);
            }
        }
        return rowMaps;
    }

    private static DataSet buildTotalRow(DataSet rset, String gzlDisplayname) {
        DataSetBuilder dataSetBuilder = Algo.create((String)WorkloadRptQueryHelper.class.getName()).createDataSetBuilder(rset.getRowMeta());
        String[] fieldNames = rset.getRowMeta().getFieldNames();
        ArrayList<String> sumStr = new ArrayList<String>(2);
        ArrayList<Object> valueStr = new ArrayList<Object>(2);
        valueStr.add(1);
        valueStr.add(gzlDisplayname);
        valueStr.add(WorkloadRptQueryHelper.getHjDisplayname());
        for (int i = 0; i < fieldNames.length; ++i) {
            if (!Objects.equals(rset.getRowMeta().getDataType(i), DataType.BigDecimalType)) continue;
            sumStr.add(String.format("SUM(%s)", fieldNames[i]));
            valueStr.add(0);
        }
        DataSet totalrs = rset.copy().executeSql(String.format("select %s", Joiner.on((String)",").join(sumStr)));
        ArrayList<Object> allObjs = new ArrayList<Object>(2);
        for (Row rs : totalrs) {
            for (String field : totalrs.getRowMeta().getFieldNames()) {
                allObjs.add(rs.get(field));
            }
        }
        allObjs.addAll(valueStr);
        dataSetBuilder.append(allObjs.toArray());
        return dataSetBuilder.build();
    }

    private static void buildFirstRow(String type, int length, DataSetBuilder dataSetBuilder) {
        ArrayList firstrow = Lists.newArrayList(Collections.nCopies(length, BigDecimal.ZERO));
        firstrow.add(2);
        firstrow.add(type);
        firstrow.add(type);
        firstrow.addAll(Lists.newArrayList(Collections.nCopies(length, 0)));
        dataSetBuilder.append(firstrow.toArray());
    }

    private static DataSetBuilder createMonthDataSetBuilder() {
        List<String> fields = Arrays.stream(Month.values()).map(m -> m.getDisplayName(TextStyle.SHORT, Locale.ENGLISH)).collect(Collectors.toList());
        List intfields = Arrays.stream(Month.values()).map(m -> String.format("%s_int", m.getDisplayName(TextStyle.SHORT, Locale.ENGLISH))).collect(Collectors.toList());
        fields.add("istotal");
        fields.add("type");
        fields.add("professiona");
        fields.addAll(intfields);
        List<DataType> types = Arrays.stream(Month.values()).map(m -> DataType.BigDecimalType).collect(Collectors.toList());
        List inttypes = Arrays.stream(Month.values()).map(m -> DataType.IntegerType).collect(Collectors.toList());
        types.add((DataType)DataType.IntegerType);
        types.add((DataType)DataType.StringType);
        types.add((DataType)DataType.StringType);
        types.addAll(inttypes);
        RowMeta rowMeta = new RowMeta(fields.toArray(new String[fields.size()]), types.toArray(new DataType[types.size()]));
        return Algo.create((String)WorkloadRptQueryHelper.class.getName()).createDataSetBuilder(rowMeta);
    }

    private static String getSelects() {
        ArrayList<String> ls = new ArrayList<String>(2);
        ls.add("resourceplan");
        ls.add("entryentity.industry.name as professiona");
        ls.add("entryentity.industry.id as proid");
        ls.add("entryentity.industry.seqnumtwo as proidseq");
        for (Month m : Month.values()) {
            String s = m.getDisplayName(TextStyle.FULL, Locale.ENGLISH).toLowerCase();
            ls.add(String.format("entryentity.%s as %s", s, s));
        }
        return Joiner.on((String)",").join(ls);
    }

    private static String getWlDisplayname() {
        return ResManager.loadKDString((String)"\u884c\u4e1a\u5de5\u4f5c\u91cf", (String)"WorkloadRptQueryHelper_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private static String getBlDisplayname() {
        return ResManager.loadKDString((String)"\u6c47\u603b\u5e73\u8861", (String)"WorkloadRptQueryHelper_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private static String getPdDisplayname() {
        return ResManager.loadKDString((String)"\u884c\u4e1a\u751f\u4ea7\u529b", (String)"WorkloadRptQueryHelper_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private static String getHjDisplayname() {
        return ResManager.loadKDString((String)"\u5408 \u8ba1\uff1a", (String)"WorkloadRptQueryHelper_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private static String getRsDisplayname() {
        return ResManager.loadKDString((String)"\u5e73\u8861\u7ed3\u679c\uff1a", (String)"WorkloadRptQueryHelper_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private static String getBlDetailDisplayname() {
        return ResManager.loadKDString((String)"\u884c\u4e1a\u5e73\u8861", (String)"WorkloadRptQueryHelper_6", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private static String getGzlDisplayname() {
        return ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf", (String)"WorkloadRptQueryHelper_7", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private static String getSclDisplayname() {
        return ResManager.loadKDString((String)"\u751f\u4ea7\u529b", (String)"WorkloadRptQueryHelper_8", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    public static Map sortMapByKeyAsc(Map map, Map cmap) {
        final List collect = cmap.keySet().stream().collect(Collectors.toList());
        TreeMap sortMap = new TreeMap(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int p1 = collect.indexOf(o1);
                int p2 = collect.indexOf(o2);
                return p1 - p2;
            }
        });
        sortMap.putAll(map);
        return sortMap;
    }
}

