/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.specialbill;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class SpecialBillPlugin
extends AbstractBillPlugIn {
    protected static final String CONTRACTNO = "contractno";
    protected static final String ISCONTRACT = "iscontract";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit saleconstractno = (TextEdit)this.getControl(CONTRACTNO);
        saleconstractno.addClickListener((ClickListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)CONTRACTNO, (CharSequence)key)) {
            this.showContractF7();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (StringUtils.equals((CharSequence)CONTRACTNO, (CharSequence)actionId)) {
            if (returnData == null) {
                return;
            }
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            this.getModel().setValue("contract", listSelectedRow.getPrimaryKeyValue());
            this.getModel().setValue(CONTRACTNO, (Object)listSelectedRow.getNumber());
            this.getModel().setValue("contractname", (Object)listSelectedRow.getName());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMustInput((Boolean)this.getModel().getValue(ISCONTRACT));
        this.setSupEndDate();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)ISCONTRACT, (CharSequence)name)) {
            this.setMustInput((Boolean)this.getModel().getValue(ISCONTRACT));
        } else if (StringUtils.equals((CharSequence)CONTRACTNO, (CharSequence)name)) {
            ChangeData changeData = e.getChangeSet()[0];
            Object newValue = changeData.getNewValue();
            if (newValue == null || StringUtils.isEmpty((CharSequence)newValue.toString())) {
                this.getModel().setValue("contract", (Object)0L);
                this.getModel().setValue("contractname", null);
            }
        } else if (StringUtils.equals((CharSequence)"supbegindate", (CharSequence)name)) {
            this.setSupEndDate();
        } else if (StringUtils.equals((CharSequence)"supenddate", (CharSequence)name)) {
            this.setSupEndDate();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IDataModel dm = this.getModel();
        if (dm == null) {
            return;
        }
        int ordinal = dm.getProperty("contract").getOrdinal();
        dm.getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
    }

    private void setSupEndDate() {
        Date supbegindate = (Date)this.getModel().getValue("supbegindate");
        Date supenddate = (Date)this.getModel().getValue("supenddate");
        if (supbegindate != null) {
            DateTimeEdit endDateEdit = (DateTimeEdit)this.getControl("supenddate");
            endDateEdit.setMinDate(supbegindate);
            DateTimeEdit beginDateEdit = (DateTimeEdit)this.getControl("supbegindate");
            beginDateEdit.setMaxDate(supenddate);
        } else if (supbegindate == null && supenddate != null) {
            DateTimeEdit beginDateEdit = (DateTimeEdit)this.getControl("supbegindate");
            beginDateEdit.setMaxDate(supenddate);
        } else if (supbegindate != null && supenddate == null) {
            DateTimeEdit endDateEdit = (DateTimeEdit)this.getControl("supenddate");
            endDateEdit.setMinDate(supbegindate);
        }
    }

    private void setMustInput(boolean isMustInput) {
        TextEdit contract = (TextEdit)this.getControl(CONTRACTNO);
        contract.setMustInput(isMustInput);
        TextProp property = (TextProp)contract.getProperty();
        property.setMustInput(isMustInput);
    }

    private void showContractF7() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"conm_salcontractf7", (boolean)false);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CONTRACTNO));
        QFilter filter = new QFilter("billstatus", "=", (Object)"C").and("validstatus", "=", (Object)"B");
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        filters.add(filter);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

