/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ApplicationWorkScopeImportPlugin
extends BatchImportPlugin {
    private static final Log LOG = LogFactory.getLog(ApplicationWorkScopeImportPlugin.class);
    private String workDetailSplit = "\\+";
    private Map<String, List<DynamicObject>> workScopeTpls = new ConcurrentHashMap<String, List<DynamicObject>>();
    private Map<Long, List<Object>> workcateDetails = new ConcurrentHashMap<Long, List<Object>>();

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ThreeTuple<Set<String>, Set<Long>, Set<String>> refData = this.getAllWorkDetailNumber(rowdatas);
        Map<String, Map<String, Object>> workDetailsMap = this.queryAllWorkCateDetail((Set)refData.item1);
        this.queryWorkScopeTpl((Set)refData.item3);
        Map<Object, DynamicObject> entryWorkScope = null;
        String type = (String)this.ctx.getOption().get("importtype");
        if (type != null && type.contains("override") && !CollectionUtils.isEmpty((Collection)((Collection)refData.item2))) {
            entryWorkScope = this.queryAllWorkScope((Set)refData.item2);
        }
        this.saveAndValidatorWorkScope(rowdatas, logger, workDetailsMap, entryWorkScope);
        return super.save(rowdatas, logger);
    }

    public void saveAndValidatorWorkScope(List<ImportBillData> rowdatas, ImportLogger logger, Map<String, Map<String, Object>> workDetailsMap, Map<Object, DynamicObject> entryWorkScope) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        MainEntityType workScopeType = EntityMetadataCache.getDataEntityType((String)"mpdm_workscopeins");
        String comboType = (String)((ComboProp)workScopeType.getProperty("combotype")).getDefValue();
        String combosymbol = (String)((ComboProp)workScopeType.getProperty("combosymbol")).getDefValue();
        EntryProp workcategory = (EntryProp)workScopeType.getProperty("workcategory");
        String connector = (String)((ComboProp)workcategory.getDynamicCollectionItemPropertyType().getProperty("connector")).getDefValue();
        while (iterator.hasNext()) {
            ImportBillData importBillData = iterator.next();
            JSONObject data = importBillData.getData();
            JSONArray entryentity = data.getJSONArray("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryentity)) continue;
            int errorSize = 0;
            int size = entryentity.size();
            ArrayList<DynamicObject> workScopes = new ArrayList<DynamicObject>(size);
            long[] ids = ID.genLongIds((int)entryentity.size());
            for (Object obj : entryentity) {
                String workDetail;
                JSONObject require = (JSONObject)obj;
                Object entryPk = require.get((Object)"id");
                JSONObject workscope = require.getJSONObject("workscope");
                if (workscope != null || StringUtils.isEmpty((CharSequence)(workDetail = require.getString("workdetail")))) continue;
                String[] workDetails = workDetail.split(this.workDetailSplit);
                StringJoiner errorMsg = new StringJoiner(",");
                String workScopeTpl = require.getString("workscopetpl");
                this.validatorDetailExsist(errorMsg, workDetails, workDetailsMap, workScopeTpl);
                this.validatorWorkScopeTplExsist(errorMsg, workScopeTpl);
                if (errorMsg.length() > 0) {
                    ++errorSize;
                    logger.log(require.getInteger("rowNum"), errorMsg.toString()).fail();
                    continue;
                }
                require.remove((Object)"workdetail");
                long id = ids[--size];
                DynamicObject oldWorkScope = entryWorkScope == null ? null : entryWorkScope.get(entryPk);
                DynamicObject workScope = null;
                workScope = StringUtils.isNotEmpty((CharSequence)workScopeTpl) ? this.createWrokScopeWithTpl(oldWorkScope, workScopeType, id, workDetailsMap, workDetails, this.workScopeTpls.get(workScopeTpl)) : this.createWrokScope(oldWorkScope, workScopeType, id, workDetailsMap, workDetails, comboType, combosymbol, connector);
                workscope = new JSONObject();
                workscope.put("importprop", (Object)"id");
                workscope.put("id", workScope.get("id"));
                require.put("workscope", (Object)workscope);
                workScopes.add(workScope);
            }
            if (errorSize > 0) {
                iterator.remove();
                continue;
            }
            OperationResult result = SaveServiceHelper.saveOperate((String)"mpdm_workscopeins", (DynamicObject[])workScopes.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (result.isSuccess()) continue;
            StringJoiner msg = new StringJoiner("\u3002", ResManager.loadKDString((String)"\u5de5\u4f5c\u5185\u5bb9\u5f15\u5165\u5931\u8d25", (String)"ApplicationWorkScopeImportPlugin_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), "");
            for (IOperateInfo info : result.getAllErrorOrValidateInfo()) {
                msg.add(info.getMessage());
            }
            logger.log(data.getInteger("rowNum"), msg.toString()).fail();
            iterator.remove();
        }
    }

    private void validatorWorkScopeTplExsist(StringJoiner errorMsg, String workScopeTpl) {
        if (StringUtils.isNotEmpty((CharSequence)workScopeTpl) && this.workScopeTpls != null && this.workScopeTpls.get(workScopeTpl) == null) {
            errorMsg.add(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u5185\u5bb9\u6a21\u677f\uff1a%s \u4e0d\u5b58\u5728\u6216\u65e0\u6548\u3002", (String)"ApplicationWorkScopeImportPlugin_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), workScopeTpl));
        }
    }

    private void validatorDetailExsist(StringJoiner errorMsg, String[] workDetails, Map<String, Map<String, Object>> workDetailsMap, String workScopeTpl) {
        List<DynamicObject> tplCates = StringUtils.isEmpty((CharSequence)workScopeTpl) ? null : this.workScopeTpls.get(workScopeTpl);
        for (String detailNum : workDetails) {
            Map<String, Object> detailMap = workDetailsMap.get(detailNum);
            if (detailMap == null) {
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u5185\u5bb9\u660e\u7ec6\uff1a%s \u4e0d\u5b58\u5728\u6216\u65e0\u6548\u6216\u6ca1\u6709\u7ed1\u5b9a\u5de5\u4f5c\u5185\u5bb9\u7c7b\u522b\u3002", (String)"ApplicationWorkScopeImportPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), detailNum));
                continue;
            }
            if (tplCates == null || tplCates.isEmpty()) continue;
            Long cId = (Long)detailMap.get("cId");
            boolean flag = false;
            for (DynamicObject tplCate : tplCates) {
                long workcatePk = tplCate.getLong("workcate");
                if (workcatePk != cId) continue;
                flag = true;
            }
            if (flag) continue;
            errorMsg.add(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u5185\u5bb9\u6a21\u677f\uff1a%1$s \u4e0d\u5b58\u5728\u5de5\u4f5c\u5185\u5bb9\u660e\u7ec6\uff1a%2$s\u3002", (String)"ApplicationWorkScopeImportPlugin_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), workScopeTpl, detailNum));
        }
    }

    private DynamicObject createWrokScopeWithTpl(DynamicObject oldWorkScope, MainEntityType workScopeType, long id, Map<String, Map<String, Object>> workDetailsMap, String[] workDetails, List<DynamicObject> tplCate) {
        String wDetail;
        DynamicObject workScope;
        DynamicObject dynamicObject = workScope = oldWorkScope == null ? new DynamicObject((DynamicObjectType)workScopeType, (Object)id) : oldWorkScope;
        if (CollectionUtils.isEmpty(tplCate) || CollectionUtils.isEmpty(this.workcateDetails)) {
            return workScope;
        }
        HashMap<Object, Map<String, Object>> detailMap = new HashMap<Object, Map<String, Object>>(workDetails.length);
        for (String workDetail : workDetails) {
            Map<String, Object> detail = workDetailsMap.get(workDetail);
            if (detail == null) continue;
            detailMap.put(detail.get("id"), detail);
        }
        Map<Long, List<Object>> workcateDetailMap = this.workcateDetails;
        DynamicObject workCate = tplCate.get(0);
        Object tplPk = workCate.get("id");
        String combotype = workCate.getString("combotype");
        String combosymbol = workCate.getString("combosymbol");
        workScope.set("workscopetpl_id", tplPk);
        workScope.set("combotype", (Object)combotype);
        workScope.set("combosymbol", (Object)combosymbol);
        DynamicObjectCollection workcategory = workScope.getDynamicObjectCollection("workcategory");
        workcategory.clear();
        StringBuilder wsDetailString = new StringBuilder();
        for (DynamicObject cate : tplCate) {
            StringJoiner typeDesc = new StringJoiner(combosymbol);
            Long workCatePk = cate.getLong("workcate");
            List<Object> details = workcateDetailMap.get(workCatePk);
            int priority = cate.getInt("priority");
            String connector = cate.getString("connector");
            String cateName = "";
            DynamicObject workCateObj = workcategory.addNew();
            workCateObj.set("priority", (Object)priority);
            workCateObj.set("workcate_id", (Object)workCatePk);
            workCateObj.set("connector", (Object)connector);
            if (CollectionUtils.isEmpty(details)) continue;
            Map detailOne = (Map)detailMap.get(details.get(0));
            if (detailOne != null) {
                cateName = (String)detailOne.get("cn");
            }
            DynamicObjectCollection detailEntries = workCateObj.getDynamicObjectCollection("workdetail");
            detailEntries.clear();
            for (Object detailPk : details) {
                Map detail = (Map)detailMap.get(detailPk);
                DynamicObject detailObj = detailEntries.addNew();
                detailObj.set("details_id", detailPk);
                if (detail == null) {
                    detailObj.set("select", (Object)"0");
                    continue;
                }
                String dn = (String)detail.get("n");
                detailObj.set("select", (Object)"1");
                typeDesc.add(dn);
            }
            String typeDetail = "";
            typeDetail = typeDesc.length() > 0 && StringUtils.equals((CharSequence)"B", (CharSequence)combotype) ? cateName + connector + typeDesc.toString() : typeDesc.toString();
            if (typeDetail.length() <= 0) continue;
            wsDetailString.append(typeDetail).append(connector);
            workCateObj.set("typedesc_tag", (Object)typeDetail);
            if (typeDesc.length() > 255) {
                workCateObj.set("typedesc", (Object)typeDetail.substring(0, 255));
                continue;
            }
            workCateObj.set("typedesc", (Object)typeDetail);
        }
        if (wsDetailString.length() > 0) {
            wsDetailString.deleteCharAt(wsDetailString.length() - 1);
        }
        if ((wDetail = wsDetailString.toString()).length() > 255) {
            workScope.set("contentdetail", (Object)wDetail.substring(0, 255));
        } else {
            workScope.set("contentdetail", (Object)wDetail);
        }
        workScope.set("contentdetail_tag", (Object)wDetail);
        workScope.set("status", (Object)"C");
        return workScope;
    }

    public DynamicObject createWrokScope(DynamicObject oldWorkScope, MainEntityType workScopeType, long id, Map<String, Map<String, Object>> workDetailsMap, String[] workDetails, String comboType, String combosymbol, String connector) {
        String wDetail;
        DynamicObject workScope = oldWorkScope == null ? new DynamicObject((DynamicObjectType)workScopeType, (Object)id) : oldWorkScope;
        comboType = oldWorkScope == null ? comboType : oldWorkScope.getString("comboType");
        combosymbol = oldWorkScope == null ? combosymbol : oldWorkScope.getString("combosymbol");
        DynamicObjectCollection workcategory = workScope.getDynamicObjectCollection("workcategory");
        workcategory.clear();
        workScope.set("combotype", (Object)comboType);
        workScope.set("combosymbol", (Object)combosymbol);
        workScope.set("enable", (Object)"1");
        int seq = 1;
        LinkedHashMap<Long, List> workScopeMap = new LinkedHashMap<Long, List>(8);
        for (String detailNum : workDetails) {
            Map<String, Object> detailMap = workDetailsMap.get(detailNum);
            if (detailMap == null) continue;
            Long workCateId = (Long)detailMap.get("cId");
            List detailPks = workScopeMap.computeIfAbsent(workCateId, v -> new ArrayList(workDetails.length));
            detailPks.add(detailNum);
        }
        StringBuilder wsDetailString = new StringBuilder();
        for (Map.Entry entry : workScopeMap.entrySet()) {
            StringJoiner typeDesc = new StringJoiner(combosymbol);
            Long workCatePk = (Long)entry.getKey();
            List detailNums = (List)entry.getValue();
            Map<String, Object> detailMapOne = workDetailsMap.get(detailNums.get(0));
            String workCateName = (String)detailMapOne.get("cn");
            DynamicObject workCate = workcategory.addNew();
            workCate.set("priority", (Object)seq);
            workCate.set("workcate_id", (Object)workCatePk);
            workCate.set("connector", (Object)connector);
            ++seq;
            DynamicObjectCollection details = workCate.getDynamicObjectCollection("workdetail");
            details.clear();
            for (String detailNum : detailNums) {
                DynamicObject detail = details.addNew();
                Map<String, Object> detailMap = workDetailsMap.get(detailNum);
                if (detailMap == null) continue;
                String detailName = (String)detailMap.get("n");
                detail.set("details_id", detailMap.get("id"));
                detail.set("select", (Object)"1");
                typeDesc.add(detailName);
            }
            String typeDetail = "";
            typeDetail = typeDesc.length() > 0 && StringUtils.equals((CharSequence)"B", (CharSequence)comboType) ? workCateName + connector + typeDesc.toString() : typeDesc.toString();
            if (typeDetail.length() <= 0) continue;
            wsDetailString.append(typeDetail).append(connector);
            workCate.set("typedesc_tag", (Object)typeDetail);
            if (typeDesc.length() > 255) {
                workCate.set("typedesc", (Object)typeDetail.substring(0, 255));
                continue;
            }
            workCate.set("typedesc", (Object)typeDetail);
        }
        if (wsDetailString.length() > 0) {
            wsDetailString.deleteCharAt(wsDetailString.length() - 1);
        }
        if ((wDetail = wsDetailString.toString()).length() > 255) {
            workScope.set("contentdetail", (Object)wDetail.substring(0, 255));
        } else {
            workScope.set("contentdetail", (Object)wDetail);
        }
        workScope.set("contentdetail_tag", (Object)wDetail);
        workScope.set("status", (Object)"C");
        return workScope;
    }

    public Map<String, Map<String, Object>> queryAllWorkCateDetail(Set<String> workDetailNumbers) {
        if (CollectionUtils.isEmpty(workDetailNumbers)) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        QFilter qFilter = new QFilter("number", "in", workDetailNumbers);
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection workDetails = QueryServiceHelper.query((String)"mpdm_workscopedetail", (String)"id,number,name", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)workDetails)) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        Map<Long, DynamicObject> detailMap = workDetails.stream().collect(Collectors.toMap(i -> i.getLong(0), i -> i));
        qFilter = new QFilter("detailentry.workdetail", "in", detailMap.keySet());
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection workcates = QueryServiceHelper.query((String)"mpdm_workcategory", (String)"id,name,detailentry.workdetail", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)workcates)) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        HashMap<String, Map<String, Object>> details = new HashMap<String, Map<String, Object>>(workcates.size());
        for (DynamicObject workcate : workcates) {
            Long detailPk = workcate.getLong(2);
            Long workcatePk = workcate.getLong(0);
            DynamicObject detail = detailMap.get(detailPk);
            String detailNum = detail.getString(1);
            String name = detail.getString(2);
            String cn = workcate.getString(1);
            if (detailNum == null) continue;
            Map detailCate = details.computeIfAbsent(detailNum, v -> new HashMap(2));
            detailCate.put("id", detailPk);
            detailCate.put("cId", workcatePk);
            detailCate.put("n", name);
            detailCate.put("cn", cn);
        }
        return details;
    }

    public ThreeTuple<Set<String>, Set<Long>, Set<String>> getAllWorkDetailNumber(List<ImportBillData> rowdatas) {
        HashSet<String> workDetailNumbers = new HashSet<String>(10);
        HashSet<Long> entryPks = new HashSet<Long>(8);
        HashSet<String> workScopeTpl = new HashSet<String>(2);
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            JSONArray entryentity = data.getJSONArray("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryentity)) continue;
            for (Object obj : entryentity) {
                String workDetail;
                JSONObject workscope;
                JSONObject require = (JSONObject)obj;
                Object entryId = require.get((Object)"id");
                if (entryId != null) {
                    try {
                        entryPks.add(Long.valueOf(String.valueOf(entryId)));
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
                if ((workscope = require.getJSONObject("workscope")) != null) continue;
                String tplNum = require.getString("workscopetpl");
                if (StringUtils.isNotEmpty((CharSequence)tplNum)) {
                    workScopeTpl.add(tplNum);
                }
                if (StringUtils.isEmpty((CharSequence)(workDetail = require.getString("workdetail")))) continue;
                String[] workDetails = workDetail.split(this.workDetailSplit);
                workDetailNumbers.addAll(Arrays.asList(workDetails));
            }
        }
        return new ThreeTuple(workDetailNumbers, entryPks, workScopeTpl);
    }

    public Map<Object, DynamicObject> queryAllWorkScope(Set<Long> pks) {
        DynamicObject[] workScopes;
        QFilter qFilter = new QFilter("entryentity.id", "in", pks);
        qFilter.and("entryentity.workscope", "!=", (Object)0L);
        DynamicObjectCollection workscpoes = QueryServiceHelper.query((String)this.mainEntityType.getName(), (String)"entryentity.id,entryentity.workscope", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)workscpoes)) {
            return null;
        }
        Map<Object, Object> workScopePkMap = workscpoes.stream().collect(Collectors.toMap(i -> i.get(1), i -> i.get(0)));
        HashMap<Object, DynamicObject> workScopeMap = new HashMap<Object, DynamicObject>(workScopePkMap.size());
        for (DynamicObject workScope : workScopes = BusinessDataServiceHelper.load((Object[])workScopePkMap.keySet().toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"mpdm_workscopeins"))) {
            Object entryPk = workScopePkMap.get(workScope.getPkValue());
            if (entryPk == null) continue;
            workScopeMap.put(String.valueOf(entryPk), workScope);
        }
        return workScopeMap;
    }

    public void queryWorkScopeTpl(Set<String> workScopeTplNums) {
        if (CollectionUtils.isEmpty(workScopeTplNums)) {
            return;
        }
        if (this.workScopeTpls.size() > 0) {
            workScopeTplNums.removeAll(this.workScopeTpls.keySet());
        }
        QFilter qFilter = new QFilter("number", "in", workScopeTplNums);
        qFilter.and("workcategory.workcate.enable", "=", (Object)"1");
        DynamicObjectCollection workScopeTpls = QueryServiceHelper.query((String)"mpdm_workscope", (String)"id,number,combotype,combosymbol,workcategory.priority priority,workcategory.workcate workcate,workcategory.connector connector", (QFilter[])qFilter.toArray(), (String)"number,workcategory.priority");
        this.workScopeTpls.putAll(workScopeTpls.stream().collect(Collectors.groupingBy(i -> i.getString("number"))));
        Set workcates = workScopeTpls.stream().map(i -> i.getLong("workcate")).collect(Collectors.toSet());
        if (this.workcateDetails.size() > 0) {
            workcates.removeAll(this.workcateDetails.keySet());
        }
        QFilter filter = new QFilter("id", "in", workcates);
        filter.and("detailentry.workdetail.enable", "=", (Object)"1");
        DynamicObjectCollection cateDetails = QueryServiceHelper.query((String)"mpdm_workcategory", (String)"id,detailentry.workdetail", (QFilter[])filter.toArray(), (String)"detailentry.seq");
        this.workcateDetails.putAll(cateDetails.stream().collect(Collectors.groupingBy(i -> i.getLong("id"), Collectors.mapping(i -> i.get(1), Collectors.toList()))));
    }
}

