/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmps.business.standplan.ApproachApplicationHelper;

public class ApproachApplicationConfEidtPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    private static final List<String> FIX_FIELD = Lists.newArrayList((Object[])new String[]{"fcustomerid", "fequipmentid", "ffixmodelid", "fworkcenterid", "ffixlevelid", "fstarttime", "fendtime", "fduration", "fapplicantid", "fcreatorid", "fapplydate", "fcreatetime"});
    private static final String SELECT_PROPERTIES = "id,customer fcustomerid,billno,applicant fapplicantid,creator fcreatorid,applydate fapplydate,createtime fcreatetime,entryentity.id entryid,entryentity.seq seq,entryentity.equipment fequipmentid,entryentity.fixmodel ffixmodelid,entryentity.workcenter fworkcenterid,entryentity.fixlevel ffixlevelid,entryentity.starttime fstarttime,entryentity.endtime fendtime,entryentity.duration fduration,entryentity.resourceplanno fresourceplanno";

    public void beforeBindData(EventObject e) {
        int i;
        super.beforeBindData(e);
        DynamicObject obj = ApproachApplicationHelper.getDistinctConf();
        if (obj != null) {
            obj = BusinessDataServiceHelper.loadSingle((Object)obj.get("id"), (String)"pmpd_appdistinctconf");
            obj.set("number", (Object)"");
            BillModel dataModel = (BillModel)this.getModel();
            dataModel.createNewData((Object)obj);
        }
        if ((i = this.getModel().getEntryRowCount("entryentity")) > 0) {
            this.initSelectFields(0);
            this.setDisplanFieldName();
            this.getModel().setDataChanged(false);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.getModel().setValue("startdate", (Object)calendar.getTime());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit mainOrgField = (BasedataEdit)this.getControl("orgs");
        mainOrgField.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter[] filters = new QFilter[]{new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE), new QFilter("view.number", "=", (Object)"ProjectManageSchemeDefault")};
            Map structureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org", (QFilter[])filters);
            if (!structureMap.isEmpty()) {
                HashSet ids = Sets.newHashSetWithExpectedSize((int)structureMap.size());
                for (Map.Entry entry : structureMap.entrySet()) {
                    ids.add(((DynamicObject)entry.getValue()).get("org_id"));
                }
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", (Object)ids));
            }
        });
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        treeEntryGrid.addHyperClickListener(this::hyperLinkClick);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String key = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)key)) {
            this.clearSelectField();
        }
    }

    private void clearSelectField() {
        IDataModel dataModel = this.getModel();
        for (String s : FIX_FIELD) {
            dataModel.beginInit();
            dataModel.setValue(s, (Object)Boolean.FALSE);
            dataModel.endInit();
            this.getView().updateView(s);
        }
    }

    private void initSelectField() {
        IDataModel dataModel = this.getModel();
        StringJoiner fields = new StringJoiner(",");
        StringJoiner fieldNames = new StringJoiner(" ");
        int index = dataModel.getEntryCurrentRowIndex("entryentity");
        for (String s : FIX_FIELD) {
            Boolean select = (Boolean)dataModel.getValue(s);
            if (!select.booleanValue()) continue;
            FieldEdit control = (FieldEdit)this.getControl(s);
            fieldNames.add(control.getProperty().getDisplayName().getLocaleValue());
            fields.add(s);
        }
        dataModel.setValue("selectfields", (Object)fields.toString(), index);
        dataModel.setValue("fields", (Object)fieldNames.toString(), index);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (FIX_FIELD.contains(key)) {
            int count = this.getModel().getEntryRowCount("entryentity");
            if (count <= 0) {
                this.getModel().beginInit();
                this.getModel().setValue(key, (Object)Boolean.FALSE);
                this.getModel().endInit();
                this.getView().updateView(key);
                return;
            }
            this.initSelectField();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        this.clearSelectField();
        int index = evt.getRow();
        this.initSelectFields(index);
    }

    public void initSelectFields(int index) {
        String[] fields;
        IDataModel dataModel = this.getModel();
        String selectfields = (String)dataModel.getValue("selectfields", index);
        if (StringUtils.isEmpty((CharSequence)selectfields)) {
            return;
        }
        for (String field : fields = selectfields.split(",")) {
            dataModel.setValue(field, (Object)Boolean.TRUE);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        int index = e.getRowIndexs()[0];
        int count = this.getModel().getEntryRowCount("entryentity");
        int ind = count > 0 && index > 0 ? index - 1 : 0;
        this.clearSelectField();
        if (count > 0) {
            this.initSelectFields(ind);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"distinct", (CharSequence)key) && args.getOperationResult().isSuccess()) {
            this.queryDistinct();
            this.hiddenFlex();
        }
    }

    private void hiddenFlex() {
        Container filterinfo = (Container)this.getView().getControl("filterinfo");
        filterinfo.setCollapse(true);
        Container fieldinfo = (Container)this.getView().getControl("fieldinfo");
        fieldinfo.setCollapse(true);
    }

    protected void queryDistinct() {
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        Long pk = (Long)this.getView().getFormShowParameter().getCustomParam("appappId");
        QFilter qFilter = new QFilter("id", "=", (Object)pk);
        dataModel.deleteEntryData("treeentryentity");
        DynamicObjectCollection data = QueryServiceHelper.query((String)"pmpd_approachapplication", (String)SELECT_PROPERTIES, (QFilter[])qFilter.toArray(), (String)"entryentity.seq");
        if (CollectionUtils.isEmpty((Collection)data)) {
            return;
        }
        Set entryIds = data.stream().map(i -> i.get("entryid")).collect(Collectors.toSet());
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"id", "pid", "approve", "billno", "customer", "sequ", "equipment", "fixmodel", "fixlevel", "starttime", "endtime", "workcenter", "duration", "applicant", "creater", "applydate", "createdate", "resourceplanno"});
        DynamicObject conf = this.getModel().getDataEntity();
        data.beginInit();
        for (DynamicObject item : data) {
            Object entryId = item.get("entryid");
            tableValueSetter.addRow(new Object[]{entryId, null, item.get("id"), item.get("billno"), item.get("fcustomerid"), item.get("seq"), item.get("fequipmentid"), item.get("ffixmodelid"), item.get("ffixlevelid"), item.get("fstarttime"), item.get("fendtime"), item.get("fworkcenterid"), item.get("fduration"), item.get("fapplicantid"), item.get("fcreatorid"), item.get("fapplydate"), item.get("fcreatetime"), item.get("fresourceplanno")});
            Set pks = ApproachApplicationHelper.getSameDataPks((DynamicObject)conf, (DynamicObject)item, entryIds);
            if (CollectionUtils.isEmpty((Collection)pks)) continue;
            DataSet dataSet = ApproachApplicationHelper.queryDistinctData((Set)pks);
            Throwable throwable = null;
            try {
                for (Row row : dataSet) {
                    tableValueSetter.addRow(new Object[]{-row.getLong("entryid").longValue(), entryId, row.get("pk"), row.get("billno"), row.get("customer"), row.get("seq"), row.get("equipment"), row.get("fixmodel"), row.get("fixlevel"), row.get("starttime"), row.get("endtime"), row.get("workcenter"), row.get("duration"), row.get("applicant"), row.get("creator"), row.get("applydate"), row.get("createtime"), row.get("resourceplanno")});
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        dataModel.batchCreateNewEntryRow("treeentryentity", tableValueSetter);
        data.endInit();
        dataModel.setDataChanged(false);
        this.getView().updateView("treeentryentity");
    }

    protected void hyperLinkClick(HyperLinkClickEvent event) {
        int index = event.getRowIndex();
        Object pk = this.getModel().getValue("approve", index);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("pmpd_approachapplication");
        showParameter.setPkId(pk);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void setDisplanFieldName() {
        int count = this.getModel().getEntryRowCount("entryentity");
        for (int i = 1; i < count; ++i) {
            String field = (String)this.getModel().getValue("selectfields", i);
            if (StringUtils.isEmpty((CharSequence)field)) continue;
            String[] fields = field.split(",");
            StringJoiner fieldNames = new StringJoiner(" ");
            for (String s : fields) {
                FieldEdit control = (FieldEdit)this.getControl(s);
                fieldNames.add(control.getProperty().getDisplayName().getLocaleValue());
            }
            this.getModel().setValue("fields", (Object)fieldNames.toString(), i);
        }
    }
}

