/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.pmc.pmpd.common.enums.ConstructionUnitEnum;
import kd.pmc.pmpd.common.helper.control.DateTimeEditHelper;

public class ApproachApplicationEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener {
    private static final int DEFAULT_SCALE = 10;
    private static final String ADVCON_SPLITTIME = "advconap";
    private static final String CACHEKEY_SELECTEDROW = "selectedRow";
    private static final String OP_ROW_CLOSE = "rowclose";
    private static final String OP_ROW_UNCLOSE = "rowunclose";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit equipment = (BasedataEdit)this.getControl("equipment");
        if (equipment != null) {
            equipment.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (OP_ROW_CLOSE.equals(operateKey) || OP_ROW_UNCLOSE.equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ApproachApplicationEditPlugin_8", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            HashSet entryIds = Sets.newHashSetWithExpectedSize((int)selectRows.length);
            for (int selectRow : selectRows) {
                entryIds.add(((DynamicObject)entryEntity.get(selectRow)).getPkValue());
            }
            OperateOption option = formOperate.getOption();
            option.setVariableValue("selectedEntryIds", SerializationUtils.toJsonString((Object)entryIds));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("equipment".equals(beforeF7SelectEvent.getProperty().getName())) {
            DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
            if (customer == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5ba2\u6237\u3002", (String)"ApproachApplicationEditPlugin_10", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            beforeF7SelectEvent.addCustomQFilter(this.getMaterialOwnerFilter(customer.getPkValue()));
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
            IDataEntityProperty property = basedataEdit.getProperty();
            LocaleString displayName = property.getDisplayName();
            formShowParameter.setCaption(displayName.getLocaleValue());
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        if (this.getSelectedRowFromCache() == row) {
            return;
        }
        this.updateSpiltTimeEntryState(row);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if ("entryentity".equals(e.getEntryProp().getName())) {
            this.getPageCache().remove(CACHEKEY_SELECTEDROW);
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            int rowIndex = rowDataEntities[rowDataEntities.length - 1].getRowIndex();
            this.getView().setVisible((Boolean)this.getModel().getValue("isapplysegment", rowIndex), new String[]{ADVCON_SPLITTIME});
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if ("entryentity".equals(e.getEntryProp().getName())) {
            this.getPageCache().remove(CACHEKEY_SELECTEDROW);
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            entryGrid.entryRowClick(Integer.valueOf(entryCurrentRowIndex));
        }
    }

    private int getSelectedRowFromCache() {
        String str = this.getPageCache().get(CACHEKEY_SELECTEDROW);
        return StringUtils.isEmpty((CharSequence)str) ? -1 : Integer.parseInt(str);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("applyorg", (Object)RequestContext.get().getOrgId());
    }

    public void afterLoadData(EventObject e) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            dynamicObject.set("exactduration", dynamicObject.get("duration"));
        }
    }

    public void afterCopyData(EventObject e) {
        BillModel billModel = (BillModel)e.getSource();
        billModel.setValue("applyorg", (Object)RequestContext.get().getOrgId());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        this.initDataTimeEdit(view);
        view.setVisible((Boolean)this.getModel().getValue("isapplysegment", 0), new String[]{ADVCON_SPLITTIME});
        this.caclTrt();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (name) {
            case "starttime": {
                this.dateTimeChanged(changeData, true);
                break;
            }
            case "endtime": {
                this.dateTimeChanged(changeData, false);
                break;
            }
            case "segmentstarttime": 
            case "segmentendtime": {
                this.splitDateTimeChanged(changeData);
                break;
            }
            case "exactduration": {
                this.exactDurationChanged(changeData);
                break;
            }
            case "duration": {
                this.durationChanged(changeData);
                break;
            }
            case "durationunit": {
                this.durationUnitChanged(changeData);
                break;
            }
            case "unitlength": {
                this.unitLengthChanged(changeData);
                break;
            }
            case "isapplysegment": {
                this.getView().setVisible((Boolean)changeData.getNewValue(), new String[]{ADVCON_SPLITTIME});
                break;
            }
            case "workcenter": {
                int entryRowCount = this.getModel().getEntryRowCount("subentryentity");
                if (entryRowCount <= 0) break;
                this.setEntryFieldValue("segmentworkcenter", changeData.getNewValue(), 0, changeData.getRowIndex());
                break;
            }
            case "equipment": 
            case "model": {
                this.verifyDateOverlap(changeData.getRowIndex());
                break;
            }
            case "customer": {
                this.customerChanged(changeData);
                break;
            }
            case "fixmodel": {
                this.fixModelChanged(changeData);
                break;
            }
        }
    }

    private void verifyDateOverlap(int rowIndex) {
        boolean isNullEndTime;
        DynamicObject equipment = (DynamicObject)this.getModel().getValue("equipment", rowIndex);
        if (equipment == null) {
            return;
        }
        DynamicObject model = (DynamicObject)this.getModel().getValue("model", rowIndex);
        if (model == null) {
            return;
        }
        Date startTime = (Date)this.getModel().getValue("starttime", rowIndex);
        boolean isNullStartTime = startTime == null;
        Date endTime = (Date)this.getModel().getValue("endtime", rowIndex);
        boolean bl = isNullEndTime = endTime == null;
        if (isNullStartTime && isNullEndTime) {
            return;
        }
        Long equipmentId = (Long)equipment.getPkValue();
        Long modelId = (Long)model.getPkValue();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String tipPrefix = String.format(ResManager.loadKDString((String)"\u201c\u68c0\u4fee\u8bbe\u5907\u6ce8\u518c\u53f7\u201d: %1$s\uff0c\u201c\u68c0\u4fee\u8bbe\u5907\u7c7b\u578b\u201d: %2$s\uff0c\u5b58\u5728\u91cd\u53e0\u7684\u9884\u8ba1\u65f6\u95f4\u884c\uff1a", (String)"ApproachApplicationEditPlugin_9", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), equipment.getString("name"), model.getString("number"));
        StringBuilder sb = new StringBuilder(tipPrefix);
        int size = entryEntity.size();
        for (int i = 0; i < size; ++i) {
            boolean isOverlap;
            boolean isSameRow;
            if (i == rowIndex) continue;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            boolean bl2 = isSameRow = equipmentId.equals(dynamicObject.getLong("equipment_id")) && modelId.equals(dynamicObject.getLong("model_id"));
            if (!isSameRow) continue;
            Date comparedStartTime = dynamicObject.getDate("starttime");
            Date comparedEndTime = dynamicObject.getDate("endtime");
            if (comparedStartTime == null || comparedEndTime == null) continue;
            boolean bl3 = isOverlap = !isNullStartTime && startTime.compareTo(comparedStartTime) >= 0 && startTime.compareTo(comparedEndTime) <= 0 || !isNullEndTime && endTime.compareTo(comparedStartTime) >= 0 && endTime.compareTo(comparedEndTime) <= 0;
            if (!isOverlap) continue;
            sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c", (String)"ApproachApplicationEditPlugin_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), i + 1)).append('\uff0c');
        }
        int strLength = sb.length();
        if (strLength > tipPrefix.length()) {
            sb.setCharAt(strLength - 1, '\u3002');
            this.getView().showErrorNotification(sb.toString());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
        if (collection.isEmpty()) {
            return;
        }
        int ordinal = collection.getDynamicObjectType().getProperty("exactduration").getOrdinal();
        for (DynamicObject dynamicObject : collection) {
            dynamicObject.getDataEntityState().setBizChanged(ordinal, false);
        }
    }

    private void durationUnitChanged(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        Date startTime = (Date)this.getModel().getValue("starttime", rowIndex);
        Date endTime = (Date)this.getModel().getValue("endtime", rowIndex);
        this.calculateDuration(rowIndex, startTime, endTime);
    }

    private void unitLengthChanged(ChangeData changeData) {
        int scale = (Integer)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        BigDecimal exactDuration = (BigDecimal)this.getModel().getValue("exactduration", rowIndex);
        this.updateDurationValue(exactDuration, scale, rowIndex);
    }

    private void exactDurationChanged(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        BigDecimal exactDuration = (BigDecimal)changeData.getNewValue();
        int scale = (Integer)this.getModel().getValue("unitlength", rowIndex);
        this.updateDurationValue(exactDuration, scale, rowIndex);
    }

    private void updateDurationValue(BigDecimal exactDuration, int scale, int rowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue("duration", (Object)exactDuration.setScale(scale, RoundingMode.HALF_UP), rowIndex);
        this.getModel().endInit();
        this.getView().updateView("duration", rowIndex);
    }

    private void durationChanged(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        BigDecimal duration = (BigDecimal)changeData.getNewValue();
        int scale = (Integer)this.getModel().getValue("unitlength", rowIndex);
        duration = duration.setScale(scale, RoundingMode.HALF_UP);
        this.getModel().beginInit();
        this.getModel().setValue("duration", (Object)duration, rowIndex);
        this.getModel().setValue("exactduration", (Object)duration, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("duration", rowIndex);
        this.getView().updateView("exactduration", rowIndex);
    }

    private ConstructionUnitEnum getUnitEnum(DynamicObject unit) {
        return unit == null ? ConstructionUnitEnum.DAY : ConstructionUnitEnum.forValue((String)unit.getString("number"));
    }

    private void dateTimeChanged(ChangeData changeData, boolean isStartDateTimeKey) {
        Date endTime;
        Date startTime;
        Date changedDateTime = (Date)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        int entryRowCount = this.getModel().getEntryRowCount("subentryentity");
        if (entryRowCount > 0) {
            this.setEntryFieldValue(isStartDateTimeKey ? "segmentstarttime" : "segmentendtime", changedDateTime, 0, rowIndex);
        }
        if (changedDateTime == null) {
            return;
        }
        DateTimeEdit startDateTimeEdit = (DateTimeEdit)this.getControl("segmentstarttime");
        DateTimeEdit endDateTimeEdit = (DateTimeEdit)this.getControl("segmentendtime");
        if (isStartDateTimeKey) {
            startDateTimeEdit.setMinDate(changedDateTime);
            endDateTimeEdit.setMinDate(changedDateTime);
            startTime = changedDateTime;
            endTime = (Date)this.getModel().getValue("endtime", rowIndex);
        } else {
            startDateTimeEdit.setMaxDate(changedDateTime);
            endDateTimeEdit.setMaxDate(changedDateTime);
            startTime = (Date)this.getModel().getValue("starttime", rowIndex);
            endTime = changedDateTime;
        }
        ArrayList<String> msgList = new ArrayList<String>();
        if (startTime != null && endTime != null) {
            if (startTime.compareTo(endTime) >= 0) {
                this.getModel().setValue("endtime", null, rowIndex, -1);
                DateTimeEditHelper.recoveryMaxDate((IFormView)this.getView(), (String)"segmentstarttime");
                DateTimeEditHelper.recoveryMaxDate((IFormView)this.getView(), (String)"segmentendtime");
                msgList.add(String.format(ResManager.loadKDString((String)"\u201c\u8fdb\u573a\u4fe1\u606f\u201d\u7b2c%d\u884c, \u201c\u9884\u8ba1\u79bb\u573a\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u201c\u9884\u8ba1\u8fdb\u573a\u65f6\u95f4\u201d\u3002", (String)"ApproachApplicationEditPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), rowIndex + 1));
            } else {
                this.calculateDuration(rowIndex, startTime, endTime);
            }
        }
        DynamicObject equipment = (DynamicObject)this.getModel().getValue("equipment", rowIndex);
        DynamicObject model = (DynamicObject)this.getModel().getValue("model", rowIndex);
        if (equipment != null && model != null) {
            String tipPrefix = String.format(ResManager.loadKDString((String)"\u201c\u68c0\u4fee\u8bbe\u5907\u6ce8\u518c\u53f7\u201d: %1$s\uff0c\u201c\u68c0\u4fee\u8bbe\u5907\u7c7b\u578b\u201d: %2$s\uff0c\u5b58\u5728\u91cd\u53e0\u7684\u9884\u8ba1\u65f6\u95f4\u884c\uff1a", (String)"ApproachApplicationEditPlugin_9", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), equipment.getString("name"), model.getString("number"));
            this.verifyDateOverlap(changedDateTime, rowIndex, msgList, "entryentity", tipPrefix, "starttime", "endtime", equipment, model);
        }
        if (!msgList.isEmpty()) {
            if (msgList.size() == 1) {
                this.getView().showTipNotification((String)msgList.get(0));
                return;
            }
            String msg = String.join((CharSequence)"\n", msgList);
            this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u751f\u9519\u8bef", (String)"ApproachApplicationEditPlugin_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), msg, MessageTypes.Default);
        }
    }

    private void calculateDuration(int rowIndex, Date startTime, Date endTime) {
        if (startTime != null && endTime != null) {
            long dValue = endTime.getTime() - startTime.getTime();
            ConstructionUnitEnum durationUnit = this.getUnitEnum((DynamicObject)this.getModel().getValue("durationunit"));
            BigDecimal duration = BigDecimal.valueOf(dValue).divide(durationUnit.getValue(), 10, RoundingMode.HALF_UP);
            this.getModel().setValue("exactduration", (Object)duration, rowIndex);
        }
    }

    private void verifyDateOverlap(Date changedDateTime, int rowIndex, List<String> msgList, String entryKey, String prefix, String startTimeKey, String endTimeKey, DynamicObject equipment, DynamicObject model) {
        boolean isSubEntry = equipment == null || model == null;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryKey);
        StringBuilder sb = new StringBuilder(prefix);
        int size = entryEntity.size();
        for (int i = 0; i < size; ++i) {
            if (i == rowIndex) continue;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            if (!isSubEntry) {
                boolean isSameRow;
                boolean bl = isSameRow = equipment.getPkValue().equals(dynamicObject.getLong("equipment_id")) && model.getPkValue().equals(dynamicObject.getLong("model_id"));
                if (!isSameRow) continue;
            }
            Date comparedStartTime = dynamicObject.getDate(startTimeKey);
            Date comparedEndTime = dynamicObject.getDate(endTimeKey);
            if (comparedStartTime == null || comparedEndTime == null || changedDateTime.compareTo(comparedStartTime) < 0 || changedDateTime.compareTo(comparedEndTime) > 0) continue;
            sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c", (String)"ApproachApplicationEditPlugin_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), i + 1)).append('\uff0c');
        }
        int strLength = sb.length();
        if (strLength > prefix.length()) {
            sb.setCharAt(strLength - 1, '\u3002');
            msgList.add(sb.toString());
        }
    }

    private void splitDateTimeChanged(ChangeData changeData) {
        Date changedDateTime = (Date)changeData.getNewValue();
        if (changedDateTime == null) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        int parentRowIndex = changeData.getParentRowIndex();
        ArrayList<String> msgList = new ArrayList<String>();
        if (this.getModel().getValue("starttime", parentRowIndex) == null) {
            msgList.add(String.format(ResManager.loadKDString((String)"\u201c\u8fdb\u573a\u4fe1\u606f\u201d\u7b2c%d\u884c, \u201c\u9884\u8ba1\u8fdb\u573a\u65f6\u95f4\u201d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8f93\u5165\u201c\u9884\u8ba1\u8fdb\u573a\u65f6\u95f4\u201d\u3002", (String)"ApproachApplicationEditPlugin_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), parentRowIndex + 1));
        }
        if (this.getModel().getValue("endtime", parentRowIndex) == null) {
            msgList.add(String.format(ResManager.loadKDString((String)"\u201c\u8fdb\u573a\u4fe1\u606f\u201d\u7b2c%d\u884c, \u201c\u9884\u8ba1\u79bb\u573a\u65f6\u95f4\u201d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8f93\u5165\u201c\u9884\u8ba1\u79bb\u573a\u65f6\u95f4\u201d\u3002", (String)"ApproachApplicationEditPlugin_5", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), parentRowIndex + 1));
        }
        Date startTime = (Date)this.getModel().getValue("segmentstarttime", rowIndex, parentRowIndex);
        Date endTime = (Date)this.getModel().getValue("segmentendtime", rowIndex, parentRowIndex);
        if (startTime != null && endTime != null && startTime.compareTo(endTime) >= 0) {
            this.setEntryFieldValue("segmentendtime", null, rowIndex, parentRowIndex);
            msgList.add(String.format(ResManager.loadKDString((String)"\u201c\u5206\u6bb5\u65f6\u95f4\u201d\u7b2c%d\u884c, \u201c\u5206\u6bb5\u5360\u7528\u7ed3\u675f\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u201c\u5206\u6bb5\u5360\u7528\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"ApproachApplicationEditPlugin_6", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
        String tipPrefix = ResManager.loadKDString((String)"\u201c\u5206\u6bb5\u65f6\u95f4\u201d\u5b58\u5728\u91cd\u53e0\u7684\u5206\u6bb5\u5360\u7528\u65f6\u95f4\u884c\uff1a", (String)"ApproachApplicationEditPlugin_7", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
        this.verifyDateOverlap(changedDateTime, rowIndex, msgList, "subentryentity", tipPrefix, "segmentstarttime", "segmentendtime", null, null);
    }

    private void setEntryFieldValue(String entryField, Object value, int rowIndex, int parentRowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue(entryField, value, rowIndex, parentRowIndex);
        this.getModel().endInit();
        this.getView().updateView(entryField, rowIndex, parentRowIndex);
    }

    private void initDataTimeEdit(IFormView view) {
        Date endDateTime;
        TimeZone timeZone = DateTimeEditHelper.getTimeZone((IFormView)view, (String)"starttime");
        String minFormatString = DateTimeEditHelper.getMinFormatString((TimeZone)timeZone);
        String maxFormatString = DateTimeEditHelper.getMaxFormatString((TimeZone)timeZone);
        DateTimeEditHelper.setDefaultSelectedDate((IFormView)view, (String)"entryentity", (String)minFormatString, (List)Lists.newArrayList((Object[])new String[]{"starttime"}));
        DateTimeEditHelper.setDefaultSelectedDate((IFormView)view, (String)"entryentity", (String)maxFormatString, (List)Lists.newArrayList((Object[])new String[]{"endtime"}));
        DateTimeEditHelper.setDefaultSelectedDate((IFormView)view, (String)"subentryentity", (String)minFormatString, (List)Lists.newArrayList((Object[])new String[]{"segmentstarttime"}));
        DateTimeEditHelper.setDefaultSelectedDate((IFormView)view, (String)"subentryentity", (String)maxFormatString, (List)Lists.newArrayList((Object[])new String[]{"segmentendtime"}));
        Date startDateTime = (Date)this.getModel().getValue("starttime", 0);
        DateTimeEdit startDateTimeEdit = (DateTimeEdit)this.getControl("segmentstarttime");
        DateTimeEdit endDateTimeEdit = (DateTimeEdit)this.getControl("segmentendtime");
        if (startDateTime != null) {
            startDateTimeEdit.setMinDate(startDateTime);
            endDateTimeEdit.setMinDate(startDateTime);
        }
        if ((endDateTime = (Date)this.getModel().getValue("endtime", 0)) != null) {
            startDateTimeEdit.setMaxDate(endDateTime);
            endDateTimeEdit.setMaxDate(endDateTime);
        }
    }

    private void updateSpiltTimeEntryState(int row) {
        this.getView().setVisible((Boolean)this.getModel().getValue("isapplysegment", row), new String[]{ADVCON_SPLITTIME});
        this.getPageCache().put(CACHEKEY_SELECTEDROW, Integer.toString(row));
        IFormView view = this.getView();
        view.sendFormAction(view);
        TimeZone timeZone = DateTimeEditHelper.getTimeZone((IFormView)view, (String)"segmentstarttime");
        DateTimeEditHelper.setDefaultSelectedDate((IFormView)view, (String)"subentryentity", (String)DateTimeEditHelper.getMinFormatString((TimeZone)timeZone), (List)Lists.newArrayList((Object[])new String[]{"segmentstarttime"}));
        DateTimeEditHelper.setDefaultSelectedDate((IFormView)view, (String)"subentryentity", (String)DateTimeEditHelper.getMaxFormatString((TimeZone)timeZone), (List)Lists.newArrayList((Object[])new String[]{"segmentendtime"}));
        DateTimeEdit startDateTimeEdit = (DateTimeEdit)this.getControl("segmentstarttime");
        DateTimeEdit endDateTimeEdit = (DateTimeEdit)this.getControl("segmentendtime");
        Date startTime = (Date)this.getModel().getValue("starttime", row);
        Date endTime = (Date)this.getModel().getValue("endtime", row);
        if (startTime != null) {
            startDateTimeEdit.setMinDate(startTime);
            endDateTimeEdit.setMinDate(startTime);
        } else {
            DateTimeEditHelper.recoveryMinDate((IFormView)view, (String)"segmentstarttime");
            DateTimeEditHelper.recoveryMinDate((IFormView)view, (String)"segmentendtime");
        }
        if (endTime != null) {
            startDateTimeEdit.setMaxDate(endTime);
            endDateTimeEdit.setMaxDate(endTime);
        } else {
            DateTimeEditHelper.recoveryMaxDate((IFormView)view, (String)"segmentstarttime");
            DateTimeEditHelper.recoveryMaxDate((IFormView)view, (String)"segmentendtime");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"distinct", (CharSequence)key)) {
            this.showDistinctConfForm();
        } else if (OP_ROW_CLOSE.equals(key) || OP_ROW_UNCLOSE.equals(key)) {
            OperationResult operationResult = args.getOperationResult();
            if (operationResult != null) {
                operationResult.getSuccessPkIds().remove(this.getModel().getDataEntity().getPkValue());
            }
        } else if ("audit".equals(key)) {
            this.getView().invokeOperation("refresh");
        } else if ("unaudit".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showDistinctConfForm() {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("pmpd_appdistinctconf");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("appappId", this.getModel().getDataEntity().getPkValue());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public QFilter getMaterialOwnerFilter(Object pk) {
        return new QFilter("operator.id", "=", pk);
    }

    public void customerChanged(ChangeData changeData) {
        String confirmCust = this.getPageCache().get("confirmCust");
        if (StringUtils.isNotEmpty((CharSequence)confirmCust)) {
            this.getPageCache().remove("confirmCust");
            return;
        }
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        if (oldValue != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u201c\u5ba2\u6237\u201d\u5c06\u6e05\u7a7a\u201c\u68c0\u4fee\u8bbe\u5907\u6ce8\u518c\u53f7\u201d\u6570\u636e", (String)"ApproachApplicationEditPlugin_11", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u66f4\u6539\u5417\uff1f", (String)"WorkHourEstimateBillEdit_12", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("customer", (IFormPlugin)this), null, String.valueOf(oldValue.getPkValue()));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("customer".equals(callBackId)) {
            this.customerConfirmCallBack(event);
        }
    }

    public void customerConfirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Cancel) {
            Long originalId = Long.parseLong(event.getCustomVaule());
            this.getPageCache().put("confirmCust", "1");
            this.getModel().setValue("customer", (Object)originalId);
        } else {
            this.clearEquipmentData();
        }
    }

    public void clearEquipmentData() {
        int count = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < count; ++i) {
            this.getModel().setValue("equipment", null, i);
        }
    }

    private void fixModelChanged(ChangeData changeData) {
        DynamicObject model = (DynamicObject)changeData.getNewValue();
        if (model == null) {
            this.getModel().setValue("model", null, changeData.getRowIndex());
            return;
        }
        Long id = (Long)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMrTypeConfigModelService", (String)"getMrTypeModelId", (Object[])new Object[]{model.getPkValue()});
        if (id == null || id == 0L) {
            return;
        }
        this.getModel().setValue("model", (Object)id, changeData.getRowIndex());
    }

    protected void caclTrt() {
        if (this.getView().getFormShowParameter().getStatus() != OperationStatus.ADDNEW) {
            return;
        }
        int count = this.getModel().getEntryRowCount("entryentity");
        if (count < 1) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            Date startTime = (Date)this.getModel().getValue("starttime", i);
            Date endTime = (Date)this.getModel().getValue("endtime", i);
            if (startTime == null || endTime == null || startTime.compareTo(endTime) >= 0) continue;
            long dValue = endTime.getTime() - startTime.getTime();
            int scale = (Integer)this.getModel().getValue("unitlength", i);
            ConstructionUnitEnum durationUnit = this.getUnitEnum((DynamicObject)this.getModel().getValue("durationunit"));
            BigDecimal duration = BigDecimal.valueOf(dValue).divide(durationUnit.getValue(), scale == 0 ? 10 : scale, RoundingMode.HALF_UP);
            this.getModel().setValue("exactduration", (Object)duration, i);
        }
    }
}

