/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.schedule.formplugin.CronStruct;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.util.CollectionUtils;

public class AutocalHourSettingPlugin
extends AbstractFormPlugin {
    private static final String taskplanid = "2S+FNV4EUWJ=";
    private static final String taskplanEntity = "sch_schedule";
    private static final String jobEntity = "sch_job";
    private static final String BTNOK = "btnok";
    private static final String STATUS = "status";
    private static final String PLAN = "plan";
    private static final String ENTRYENTITY = "entryentity";
    private static final String JOBNUMID = "jobnumber.id";
    private static final String PARAMVALUE = "paramvalue";
    private static final String EXCEPTION = "exception";
    private static final String FILTERSTR_TAG = "filterstr_tag";
    private static final String FILTERSTR = "filterstr";
    private static final String PARAMNAME = "paramname";
    private static final String ISCURMONTH = "iscurmonth";
    private static final String DATAFILTERSTR_TAG = "datafilterstr_tag";
    private static final String DATAFILTER = "datafilter";
    private static final String FIXED = "fixed";
    private static final String NOTFIXED = "notfixed";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK, EXCEPTION});
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        TextEdit edit = (TextEdit)grid.getFieldEdits().get(1);
        edit.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)taskplanid, (String)taskplanEntity);
        if (Objects.nonNull(taskObj)) {
            this.getModel().setValue("isenable", (Object)(!StringUtils.equals((CharSequence)taskObj.getString(STATUS), (CharSequence)"0") ? 1 : 0));
            ComboEdit comboEdit = (ComboEdit)this.getControl("updateday");
            ComboProp comboProp = (ComboProp)comboEdit.getProperty();
            String day = this.getDay(taskObj);
            List collect = comboProp.getComboItems().stream().filter(cp -> StringUtils.equals((CharSequence)cp.getValue(), (CharSequence)day)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                this.getModel().setValue("updateday", (Object)((ValueMapItem)collect.get(0)).getValue());
            }
            this.getModel().setValue("updatetime", (Object)this.getTime(taskObj));
            Map<String, String> jobParams = this.getJobParams();
            this.getModel().setValue("range", (Object)(Boolean.parseBoolean(jobParams.get(ISCURMONTH)) ? "1" : "2"));
            String filterstr = jobParams.get(FILTERSTR);
            this.getModel().setValue(FILTERSTR_TAG, (Object)filterstr);
            this.getModel().setValue(EXCEPTION, (Object)this.switchCondition(filterstr));
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 2);
            this.getModel().setValue(DATAFILTERSTR_TAG, (Object)jobParams.get(FIXED), 0);
            this.getModel().setValue(DATAFILTER, (Object)this.switchCondition(jobParams.get(FIXED)), 0);
            this.getModel().setValue("hourtype", (Object)FIXED, 0);
            this.getModel().setValue(DATAFILTERSTR_TAG, (Object)jobParams.get(NOTFIXED), 1);
            this.getModel().setValue(DATAFILTER, (Object)this.switchCondition(jobParams.get(NOTFIXED)), 1);
            this.getModel().setValue("hourtype", (Object)NOTFIXED, 1);
        }
    }

    private String switchCondition(String filterstr) {
        String valuestr = "";
        if (StringUtils.isNotBlank((CharSequence)filterstr)) {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterstr, FilterCondition.class);
            valuestr = this.convertFilterCondition(condition);
        }
        return valuestr;
    }

    private String getDay(DynamicObject taskObj) {
        String plan = taskObj.getString(PLAN);
        CronStruct parse = CronStruct.parse((String)plan);
        return parse.getDayOfMonth();
    }

    private Map<String, String> getJobParams() {
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)1541306945527403520L, (String)"pmpd_schjobparams");
        HashMap<String, String> rsMap = new HashMap<String, String>(2);
        rsMap.put(ISCURMONTH, Boolean.toString(taskObj.getBoolean(ISCURMONTH)));
        rsMap.put(FILTERSTR, taskObj.getString(FILTERSTR_TAG));
        rsMap.put(FIXED, taskObj.getString("fixed_tag"));
        rsMap.put(NOTFIXED, taskObj.getString("notfixed_tag"));
        return rsMap;
    }

    private int getTime(DynamicObject taskObj) {
        String plan = taskObj.getString(PLAN);
        CronStruct parse = CronStruct.parse((String)plan);
        return Integer.parseInt(parse.getHours()) * 3600 + Integer.parseInt(parse.getMinutes()) * 60 + Integer.parseInt(parse.getSeconds());
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "btnok": {
                this.updatePlan();
                break;
            }
            case "exception": {
                this.showConditonUI(this.getModel().getValue(FILTERSTR_TAG) == null ? "" : (String)this.getModel().getValue(FILTERSTR_TAG), EXCEPTION);
                break;
            }
            case "datafilter": {
                EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
                int focusRow = grid.getEntryState().getFocusRow();
                this.showConditonUI(this.getModel().getValue(DATAFILTERSTR_TAG, focusRow) == null ? "" : (String)this.getModel().getValue(DATAFILTERSTR_TAG), DATAFILTER);
            }
        }
    }

    private void showConditonUI(String filterstr, String actionid) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("pmpd_rsplan_conditionui");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(FILTERSTR, (Object)filterstr);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionid));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent cle) {
        super.closedCallBack(cle);
        if (StringUtils.equals((CharSequence)cle.getActionId(), (CharSequence)EXCEPTION)) {
            Object returnData = cle.getReturnData();
            String valuestr = "";
            String filterstr = "";
            if (Objects.nonNull(returnData)) {
                FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)returnData.toString(), FilterCondition.class);
                filterstr = returnData.toString();
                valuestr = this.convertFilterCondition(condition);
                this.getModel().setValue(FILTERSTR_TAG, (Object)filterstr);
                this.getModel().setValue(EXCEPTION, (Object)valuestr);
            }
        } else if (StringUtils.equals((CharSequence)cle.getActionId(), (CharSequence)DATAFILTER)) {
            Object returnData = cle.getReturnData();
            String valuestr = "";
            String filterstr = "";
            EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
            int focusRow = grid.getEntryState().getFocusRow();
            if (Objects.nonNull(returnData)) {
                FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)returnData.toString(), FilterCondition.class);
                filterstr = returnData.toString();
                valuestr = this.convertFilterCondition(condition);
                this.getModel().setValue(DATAFILTERSTR_TAG, (Object)filterstr, focusRow);
                this.getModel().setValue(DATAFILTER, (Object)valuestr, focusRow);
            }
        }
    }

    protected String convertFilterCondition(FilterCondition filterCondition) {
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)"pmpd_resourceplan");
        List simpleFilterRows = filterCondition.getFilterRow();
        Iterator simpleFilterRowIterator = simpleFilterRows.iterator();
        StringBuilder filterStr = new StringBuilder();
        ArrayList<SimpleFilterRow> filterRow = new ArrayList<SimpleFilterRow>(16);
        FilterCondition fc = new FilterCondition();
        int row = 1;
        int size = simpleFilterRows.size();
        while (simpleFilterRowIterator.hasNext()) {
            SimpleFilterRow simpleFilterRow = (SimpleFilterRow)simpleFilterRowIterator.next();
            String leftBracket = simpleFilterRow.getLeftBracket();
            String rightBracket = simpleFilterRow.getRightBracket();
            simpleFilterRow.setLeftBracket("");
            simpleFilterRow.setRightBracket("");
            String logicDesc = "";
            String logic = simpleFilterRow.getLogic();
            logicDesc = "1".equals(logic) ? ResManager.loadKDString((String)" \u6216\u8005", (String)"ResourceRigisterConfigEdit_14", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)" \u5e76\u4e14", (String)"ResourceRigisterConfigEdit_15", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            String fieldName = simpleFilterRow.getFieldName();
            List filterValues = simpleFilterRow.getValue();
            UserService userService = new UserService();
            if (fieldName.endsWith("_mmc_formula") && filterValues != null && !filterValues.isEmpty()) {
                simpleFilterRow.setValue(new ArrayList(0));
            } else {
                filterRow.add(simpleFilterRow);
                fc.setFilterRow(filterRow);
                FilterBuilder fb = new FilterBuilder(mainType, fc, false);
                fb.setUserService((IUserService)userService);
                fb.buildFilter(false);
                filterRow.clear();
                if (size == row) {
                    filterStr.append(leftBracket).append(fb.getFilterString().trim()).append(rightBracket).append(' ');
                } else {
                    filterStr.append(leftBracket).append(fb.getFilterString().trim()).append(rightBracket).append(logicDesc).append(' ');
                }
            }
            simpleFilterRow.setLeftBracket(leftBracket);
            simpleFilterRow.setRightBracket(rightBracket);
            ++row;
        }
        return filterStr.toString();
    }

    private void updatePlan() {
        Object[] objects;
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)taskplanid, (String)taskplanEntity);
        if (Objects.nonNull(taskObj)) {
            Boolean isenable = (Boolean)this.getModel().getValue("isenable");
            if (isenable.booleanValue()) {
                taskObj.set(STATUS, (Object)"1");
            } else {
                taskObj.set(STATUS, (Object)"0");
            }
            String plan = taskObj.getString(PLAN);
            CronStruct parse = CronStruct.parse((String)plan);
            String day = (String)this.getModel().getValue("updateday");
            if (StringUtils.isNotBlank((CharSequence)day)) {
                parse.setDayOfMonth(day);
            } else {
                parse.setDayOfMonth("1");
            }
            int time = (Integer)this.getModel().getValue("updatetime");
            if (time > 0) {
                parse.setHours("" + time / 3600);
                parse.setMinutes("" + time % 3600 / 60);
                parse.setSeconds("" + time % 60);
            } else {
                parse.setHours("0");
                parse.setMinutes("0");
                parse.setSeconds("0");
            }
            taskObj.set(PLAN, (Object)parse.toString());
            String range = (String)this.getModel().getValue("range");
            DynamicObject jobparams = BusinessDataServiceHelper.loadSingle((Object)1541306945527403520L, (String)"pmpd_schjobparams");
            jobparams.set(ISCURMONTH, (Object)Boolean.toString(StringUtils.equals((CharSequence)range, (CharSequence)"1")));
            String filterstr = (String)this.getModel().getValue(FILTERSTR_TAG);
            jobparams.set(FILTERSTR_TAG, (Object)filterstr);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            List fixcolls = entryEntity.stream().filter(e -> StringUtils.equals((CharSequence)e.getString("hourtype"), (CharSequence)FIXED)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(fixcolls)) {
                jobparams.set("fixed_tag", (Object)((DynamicObject)fixcolls.get(0)).getString(DATAFILTERSTR_TAG));
            } else {
                jobparams.set("fixed_tag", (Object)"");
            }
            List notfixcolls = entryEntity.stream().filter(e -> StringUtils.equals((CharSequence)e.getString("hourtype"), (CharSequence)NOTFIXED)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(notfixcolls)) {
                jobparams.set("notfixed_tag", (Object)((DynamicObject)notfixcolls.get(0)).getString(DATAFILTERSTR_TAG));
            } else {
                jobparams.set("notfixed_tag", (Object)"");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{jobparams});
        }
        if ((objects = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskObj})).length > 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u8ba1\u7b97\u8bbe\u7f6e\u6210\u529f\u3002", (String)"AutocalHourSettingPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        switch (e.getProperty().getName()) {
            case "exception": {
                if (!StringUtils.isBlank((Object)changeSet[0].getNewValue())) break;
                this.getModel().setValue(FILTERSTR_TAG, (Object)"");
                break;
            }
            case "datafilter": {
                if (!StringUtils.isBlank((Object)changeSet[0].getNewValue())) break;
                this.getModel().setValue(DATAFILTERSTR_TAG, (Object)"", changeSet[0].getRowIndex());
            }
        }
    }
}

