/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ModelImportPlugin
extends AbstractFormPlugin {
    private static final String MODEL_ENTITYNAME = "mpdm_maintenequipmodel";
    private static final String ENGMODEL_ENTITYNAME = "mpdm_engineequipmodel";
    protected String entryCode;
    protected String fixModelNumberField;
    protected String fixEngModelNumberField;
    private static Map<String, Long> MODELLEVEL = new HashMap<String, Long>(4);
    private static Map<String, Long> ENGMODELLEVEL;

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map data = e.getSourceData();
        if (this.entryCode != null) {
            this.dealEntryModel((JSONObject)data, e);
        } else {
            this.dealModel((JSONObject)data, e);
        }
    }

    private void dealModel(JSONObject data, BeforeImportDataEventArgs e) {
        if (this.fixModelNumberField != null) {
            this.queryAndSetModel(data, true, e, 0);
        }
        if (this.fixEngModelNumberField != null) {
            this.queryAndSetModel(data, false, e, 0);
        }
    }

    private void dealEntryModel(JSONObject data, BeforeImportDataEventArgs e) {
        JSONArray entry = data.getJSONArray(this.entryCode);
        if (entry == null || entry.size() == 0) {
            return;
        }
        int index = 0;
        for (Object obj : entry) {
            if (this.fixModelNumberField != null) {
                this.queryAndSetModel((JSONObject)obj, true, e, index);
            }
            if (this.fixEngModelNumberField != null) {
                this.queryAndSetModel((JSONObject)obj, false, e, index);
            }
            ++index;
        }
    }

    private void queryAndSetModel(JSONObject obj, boolean model, BeforeImportDataEventArgs e, int index) {
        Object pk;
        JSONObject fixModel;
        String modelName = this.fixModelNumberField;
        if (!model) {
            modelName = this.fixEngModelNumberField;
        }
        if ((fixModel = obj.getJSONObject(modelName)) == null) {
            return;
        }
        String fieldName = null;
        if (fixModel.containsKey((Object)"number")) {
            fieldName = "number";
        } else if (fixModel.containsKey((Object)"name")) {
            fieldName = "name";
        }
        if (fieldName == null) {
            return;
        }
        String fieldValue = fixModel.getString(fieldName);
        String group = fixModel.getString("group");
        if (model) {
            pk = this.queryModel(fieldName, fieldValue, group);
            if (StringUtils.isNotEmpty((CharSequence)group) && pk == null) {
                ArrayList<String> msgs = new ArrayList<String>(1);
                msgs.add(String.format(this.modelErrorMsg(), group, fieldValue));
                e.setCancelMessages(Integer.valueOf(index), Integer.valueOf(0), msgs);
                e.setCancel(true);
                return;
            }
        } else {
            pk = this.queryEngModel(fieldName, fieldValue, group);
            if (StringUtils.isNotEmpty((CharSequence)group) && pk == null) {
                ArrayList<String> msgs = new ArrayList<String>(1);
                msgs.add(String.format(this.engModelErrorMsg(), group, fieldValue));
                e.setCancelMessages(Integer.valueOf(index), Integer.valueOf(0), msgs);
                e.setCancel(true);
                return;
            }
        }
        if (pk != null) {
            fixModel.put("importprop", (Object)"id");
            fixModel.put("id", pk);
        }
    }

    private Object queryEngModel(String fieldName, String fieldValue, String group) {
        QFilter qFilter = new QFilter(fieldName, "=", (Object)fieldValue);
        Long groupPk = ENGMODELLEVEL.get(group);
        if (groupPk != null) {
            qFilter.and("group", "=", (Object)groupPk);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryModel", (String)ENGMODEL_ENTITYNAME, (String)"id,group", (QFilter[])qFilter.toArray(), (String)"group");){
            if (dataSet.hasNext()) {
                Object object = dataSet.next().get(0);
                return object;
            }
        }
        return null;
    }

    public String modelErrorMsg() {
        return ResManager.loadKDString((String)"\u901a\u8fc7\u5c42\u7ea7\u7c7b\u578b\uff1a%1$s\u672a\u5230\u68c0\u4fee\u578b\u53f7\uff1a%2$s\u3002", (String)"ModelImportPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    public String engModelErrorMsg() {
        return ResManager.loadKDString((String)"\u901a\u8fc7\u5c42\u7ea7\u7c7b\u578b\uff1a%1$s\u672a\u627e\u5230\u53d1\u52a8\u673a\u578b\u53f7\uff1a%2$s\u3002", (String)"ModelImportPlugin_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private Object queryModel(String fieldName, String fieldValue, String group) {
        QFilter qFilter = new QFilter(fieldName, "=", (Object)fieldValue);
        Long groupPk = MODELLEVEL.get(group);
        if (groupPk != null) {
            qFilter.and("group", "=", (Object)groupPk);
        }
        qFilter.and("status", "=", (Object)"C");
        Object firstVal = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryModel", (String)MODEL_ENTITYNAME, (String)"id,group", (QFilter[])qFilter.toArray(), (String)"group");){
            if (dataSet.hasNext()) {
                if (StringUtils.isEmpty((CharSequence)group)) {
                    group = "L2";
                    groupPk = MODELLEVEL.get(group);
                }
                if (groupPk == null) {
                    Object var9_9 = null;
                    return var9_9;
                }
                int index = 0;
                for (Row row : dataSet) {
                    if (index == 0) {
                        firstVal = row.get(0);
                    }
                    if (groupPk != null && groupPk.longValue() == row.getLong(1).longValue()) {
                        Object object = row.get(0);
                        return object;
                    }
                    ++index;
                }
            }
        }
        return firstVal;
    }

    static {
        MODELLEVEL.put("L1", 1539702903093082112L);
        MODELLEVEL.put("L1-MPD", 1539703216357259264L);
        MODELLEVEL.put("L2", 1539703538169428992L);
        MODELLEVEL.put("L3", 1539703862640785408L);
        ENGMODELLEVEL = new HashMap<String, Long>(4);
        ENGMODELLEVEL.put("L1", 1547002459732362240L);
        ENGMODELLEVEL.put("L2", 1547003402418962432L);
        ENGMODELLEVEL.put("L3", 1547003655025115136L);
    }
}

