/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.util.GanttCommandUtils;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mvc.base.BaseModel;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.common.enums.ExecuteStatusEnum;
import kd.pmc.pmpd.common.util.NoseToTailUtil;
import org.apache.commons.lang3.time.DateUtils;

public class NoseToTailEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String[] FIELDS_DETAIL = new String[]{"sectionresource", "sectionstarttime", "sectionendtime"};
    private static final String[] FIELDS_ENTITY = new String[]{"approach", "resourceplan", "preintervalday", "nextintervalday", "estiapproachtime1", "estideparttime1"};
    private static final String BAR_SORT = "sort";
    private static final String BAR_MODIFYDAY = "modifyday";
    private static final String BAR_NEWENTRY = "newentry";
    private static final String BAR_DELETEENTRY = "deleteentry";
    private static final String NOCHANGE = "nochange";
    private static final String BREAKCONFIRM = "breakConfirm";

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        String key = event.getFieldName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"resourceplan") && rowIndex >= 0) {
            Long resourceId = (Long)this.getModel().getValue("resourceplan_id", rowIndex);
            this.showResourcePlan(resourceId, "pmpd_resourceplan");
        }
    }

    private void showResourcePlan(Long resourceId, String formId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)resourceId);
        showParameter.setFormId(formId);
        showParameter.setPageId(Long.toString(RequestContext.get().getCurrUserId()).concat("_").concat(Long.toString(resourceId)));
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getPageCache().put(NOCHANGE, "true");
        Object number = this.getModel().getValue("number");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        boolean exists = QueryServiceHelper.exists((String)"pmpd_nosetotail", (QFilter[])new QFilter[]{new QFilter("number", "=", number)});
        if (exists) {
            this.customerDisable();
        } else {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String customIdStr = (String)formShowParameter.getCustomParam("customer");
            Long resourcePlanId = (Long)formShowParameter.getCustomParam("resourceplan");
            if (StringUtils.isNotBlank((CharSequence)customIdStr)) {
                this.getModel().setItemValueByID("customer", (Object)Long.parseLong(customIdStr));
                ArrayList entity = Lists.newArrayListWithExpectedSize((int)4);
                entity.add(0L);
                entity.add(resourcePlanId);
                entity.add(0);
                entity.add(0);
                entity.add(null);
                entity.add(null);
                this.batchCreateEntryRow("entryentity", FIELDS_ENTITY, Collections.singletonList(entity));
                this.getView().updateView("entryentity");
            }
        }
        if (entryEntity != null && entryEntity.size() > 0) {
            this.setCalValue(entryEntity);
            DynamicObject resourcePlan = (DynamicObject)this.getModel().getValue("resourceplan", 0);
            this.addResourcePlanDeatil(resourcePlan, 0);
        }
        this.getPageCache().remove(NOCHANGE);
    }

    private void customerDisable() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"customer"});
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryentity.size(); ++i) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"approach", "resourceplan"});
        }
        this.getModel().setValue("issort", (Object)Boolean.TRUE);
    }

    public void registerListener(EventObject e) {
        BasedataEdit resourceplan;
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit approach = (BasedataEdit)this.getControl("approach");
        if (approach != null) {
            approach.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((resourceplan = (BasedataEdit)this.getControl("resourceplan")) != null) {
            resourceplan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
        if (Objects.isNull(customer)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5ba2\u6237\u3002", (String)"NoseToTailEditPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Long customerId = (Long)customer.getPkValue();
        ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
        if ("resourceplan".equals(evt.getProperty().getName())) {
            QFilter qFilter = new QFilter("customer", "=", (Object)customerId);
            qFilter.and(new QFilter("version", "=", (Object)0L));
            qFilter.and(new QFilter("pulishstatus", "=", (Object)"0"));
            qFilter.and(new QFilter("estiapproachtime", ">", (Object)NoseToTailUtil.getTodayEnd()));
            qFilter.and(new QFilter("isnosetotail", "=", (Object)"0"));
            qFilter.and(new QFilter("executestatus", "not in", Arrays.asList(ExecuteStatusEnum.DEPARTURE.getValue(), ExecuteStatusEnum.CANCEL.getValue())));
            int row = evt.getRow();
            ArrayList<Long> ids = new ArrayList<Long>();
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject resourceplan;
                if (i == row || !Objects.nonNull(resourceplan = ((DynamicObject)entryentity.get(i)).getDynamicObject("resourceplan"))) continue;
                ids.add(resourceplan.getLong("id"));
            }
            if (!CollectionUtils.isEmpty(ids)) {
                qFilter.and(new QFilter("id", "not in", ids));
            }
            showParam.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(key)) {
            FormOperate operate = (FormOperate)args.getSource();
            boolean confirm = operate.getOption().containsVariable("confirm");
            if (!confirm) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                Date preStartDate = new Date(0L);
                Date preEndDate = new Date(0L);
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entryEntity.get(i);
                    Date startDate = entry.getDate("estiapproachtime1");
                    Date endDate = entry.getDate("estideparttime1");
                    Object dayObj = entry.get("preintervalday");
                    int preDay = 0;
                    if (dayObj != null) {
                        preDay = Integer.parseInt(dayObj.toString());
                    }
                    boolean startIsNull = false;
                    if (startDate == null) {
                        startDate = new Date(Long.MAX_VALUE);
                        startIsNull = true;
                    }
                    if (i != 0) {
                        int days;
                        if (startDate.before(preStartDate)) {
                            this.saveConfirm(args);
                            return;
                        }
                        if (!startIsNull && (days = NoseToTailUtil.getDiffDay((Date)preEndDate, (Date)startDate)) != preDay) {
                            this.saveConfirm(args);
                            return;
                        }
                    }
                    if (i == entryEntity.size() - 1) {
                        Object nextDayObj = entry.get("nextintervalday");
                        int nextDay = 0;
                        if (nextDayObj != null) {
                            nextDay = Integer.parseInt(nextDayObj.toString());
                        }
                        if (nextDay != 0) {
                            this.saveConfirm(args);
                            return;
                        }
                    }
                    preStartDate = startDate;
                    preEndDate = endDate;
                }
            }
            this.sort("estiapproachtime1", "estideparttime1");
        } else if ("break".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u518d\u8fdb\u884c\u62c6\u5206\u3002", (String)"NoseToTailEditPlugin_5", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (entryEntity.size() == selectRows.length) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0d\u8981\u9009\u62e9\u6240\u6709\u5206\u5f55\u8fdb\u884c\u62c6\u5206\u3002", (String)"NoseToTailEditPlugin_6", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener listener = new ConfirmCallBackListener(BREAKCONFIRM, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u62c6\u5206\u4f1a\u5c06\u6240\u9009\u5206\u5f55\u884c\u4ece\u8be5nose to tail\u4e2d\u5220\u9664\uff0c\u62c6\u5206\u81f3\u53e6\u4e00\u4e2a\u65b0nose to tail\u4e2d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"NoseToTailEditPlugin_9", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, listener);
        }
    }

    private void saveConfirm(BeforeDoOperationEventArgs args) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("saveConfirm", (IFormPlugin)this);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"pmpd_resourceplan", (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        String infoMsg = ResManager.loadKDString((String)"Nose To Tail\u5206\u5f55\u884c\u7684\u95f4\u9694\u5929\u6570\u4fee\u6539\uff0c\u5c06\u4f1a\u66f4\u65b0\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u7684\u9884\u8ba1\u8fdb\u573a\u65f6\u95f4\u3001\u9884\u8ba1\u79bb\u573a\u65f6\u95f4\u3002", (String)"NoseToTailEditPlugin_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
        String titleMsg = ResManager.loadKDString((String)"Nose To Tail\u6570\u636e\u66f4\u65b0\u786e\u8ba4\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"NoseToTailEditPlugin_10", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(titleMsg, infoMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
        args.setCancel(true);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if (StringUtils.equals((CharSequence)e.getEntryProp().getName(), (CharSequence)"entryentity")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"break"});
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if (StringUtils.equals((CharSequence)e.getEntryProp().getName(), (CharSequence)"entryentity")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"break"});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String actionID = evt.getCallBackId();
        if (evt.getResult() == MessageBoxResult.Yes) {
            switch (actionID) {
                case "saveConfirm": {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("confirm", String.valueOf(Boolean.TRUE));
                    this.getView().invokeOperation("save", operateOption);
                    break;
                }
                case "customerConfirm": {
                    this.getModel().setValue("modifystatus", (Object)Boolean.FALSE);
                    this.getModel().setValue("issort", (Object)Boolean.FALSE);
                    this.deleteEntry("entryentity");
                    this.deleteEntry("detailtentry");
                    break;
                }
                case "breakConfirm": {
                    EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                    int[] selectRows = entryGrid.getSelectRows();
                    DynamicObject noseDym = NoseToTailUtil.getNoseToTailById((Long)((Long)this.getModel().getValue("id")));
                    DynamicObjectCollection dynamicObjectCollection = noseDym.getDynamicObjectCollection("entryentity");
                    ArrayList<DynamicObject> otherList = new ArrayList<DynamicObject>(selectRows.length);
                    for (int i = selectRows.length - 1; i >= 0; --i) {
                        DynamicObject remove = dynamicObjectCollection.remove(selectRows[i]);
                        otherList.add(remove);
                    }
                    NoseToTailUtil.sortEntity((DynamicObjectCollection)dynamicObjectCollection);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{noseDym});
                    DynamicObject otherNoseDym = ORM.create().newDynamicObject("pmpd_nosetotail");
                    long id = ID.genLongId();
                    otherNoseDym.set("id", (Object)id);
                    String number = CodeRuleServiceHelper.getNumber((String)"pmpd_nosetotail", (DynamicObject)otherNoseDym, (String)"");
                    otherNoseDym.set("number", (Object)number);
                    otherNoseDym.set("customer", noseDym.get("customer"));
                    otherNoseDym.set("status", (Object)"A");
                    otherNoseDym.set("enable", (Object)"1");
                    otherNoseDym.set("creator", (Object)RequestContext.get().getCurrUserId());
                    otherNoseDym.set("createtime", (Object)new Date());
                    otherNoseDym.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    otherNoseDym.set("modifytime", (Object)new Date());
                    DynamicObjectCollection otherEntryEntity = otherNoseDym.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dynamicObject : otherList) {
                        DynamicObject entry = otherEntryEntity.addNew();
                        entry.set("approach", dynamicObject.get("approach"));
                        entry.set("nextintervalday", dynamicObject.get("nextintervalday"));
                        entry.set("preintervalday", dynamicObject.get("preintervalday"));
                        entry.set("resourceplan", dynamicObject.get("resourceplan"));
                        NoseToTailUtil.updateApprochNoseId((Long)dynamicObject.getLong("approach_id"), (Long)id);
                        NoseToTailUtil.updatePlanNoseId((Long)dynamicObject.getLong("resourceplan_id"), (Long)id, (int)0);
                    }
                    NoseToTailUtil.sortEntity((DynamicObjectCollection)otherEntryEntity);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{otherNoseDym});
                    Object openType = this.getView().getFormShowParameter().getCustomParam("opentype");
                    if (openType != null && StringUtils.equals((CharSequence)"gantt", (CharSequence)openType.toString())) {
                        this.getView().close();
                        IFormView parentView = this.getView().getParentView();
                        FormShowParameter formShowParamter = GanttCommandUtils.createFormShowParamter((long)((Long)otherNoseDym.getPkValue()), (String)"pmpd_nosetotail_popup");
                        formShowParamter.getOpenStyle().setShowType(ShowType.Modal);
                        formShowParamter.setCustomParam("opentype", (Object)"gantt");
                        parentView.showForm(formShowParamter);
                        this.getView().sendFormAction(parentView);
                        break;
                    }
                    BaseModel model = (BaseModel)this.getModel();
                    model.load((Object)((Long)this.getModel().getValue("id")));
                    this.getView().updateView();
                    BaseShowParameter baseShowParameter = new BaseShowParameter();
                    baseShowParameter.setFormId("pmpd_nosetotail");
                    baseShowParameter.setStatus(OperationStatus.EDIT);
                    baseShowParameter.setPkId(otherNoseDym.getPkValue());
                    baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)baseShowParameter);
                    break;
                }
            }
        } else if (StringUtils.equals((CharSequence)actionID, (CharSequence)"customerConfirm")) {
            this.getPageCache().put("customerChange", "true");
            String oldCustomerId = this.getPageCache().get("oldCustomerId");
            this.getModel().setItemValueByID("customer", (Object)Long.parseLong(oldCustomerId));
        }
    }

    private void deleteEntry(String entryTag) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryTag);
        int size = entryentity.size();
        if (size != 0) {
            int[] line = new int[size];
            for (int i = 0; i < size; ++i) {
                line[i] = i;
            }
            this.getModel().deleteEntryRows(entryTag, line);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String string = key = op != null ? op.getOperateKey() : "";
        if (StringUtils.equals((CharSequence)key, (CharSequence)"save")) {
            if (!args.getOperationResult().isSuccess()) {
                return;
            }
            Long pkValue = (Long)args.getOperationResult().getSuccessPkIds().get(0);
            this.customerDisable();
            BillModel model = (BillModel)this.getModel();
            model.load((Object)pkValue);
            this.getView().updateView();
            this.getView().setEnable(Boolean.TRUE, new String[]{"break"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get(NOCHANGE)) && !StringUtils.equals((CharSequence)"number", (CharSequence)name)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"break"});
        }
        if (StringUtils.equals((CharSequence)"resourceplan", (CharSequence)name)) {
            DynamicObject resourcePlan = (DynamicObject)this.getModel().getValue("resourceplan", rowIndex);
            this.setCalValue(this.getModel().getEntryEntity("entryentity"));
            this.addResourcePlanDeatil(resourcePlan, rowIndex);
        } else if (StringUtils.equals((CharSequence)"nextintervalday", (CharSequence)name)) {
            String daysNoChange = this.getPageCache().get("daysNoChange");
            if (StringUtils.isNotBlank((CharSequence)daysNoChange)) {
                return;
            }
            Object newValue = changeData.getNewValue();
            if (Objects.nonNull(newValue)) {
                Map<Integer, Integer> lineDiffMap = this.getRowDiffDayMap();
                int size = this.getModel().getEntryEntity("entryentity").size();
                if (rowIndex < size - 1) {
                    this.getModel().setValue("preintervalday", newValue, rowIndex + 1);
                }
                for (int i = rowIndex; i < size; ++i) {
                    Integer diffDays = lineDiffMap.get(i);
                    int nextRowIndex = i + 1;
                    DynamicObject resourcePlan = (DynamicObject)this.getModel().getValue("resourceplan", nextRowIndex);
                    if (!Objects.nonNull(resourcePlan)) continue;
                    this.getModel().setValue("estiapproachtime1", (Object)DateUtils.addDays((Date)resourcePlan.getDate("estiapproachtime"), (int)diffDays), nextRowIndex);
                    this.getModel().setValue("estideparttime1", (Object)DateUtils.addDays((Date)resourcePlan.getDate("estideparttime"), (int)diffDays), nextRowIndex);
                }
                this.validateDate();
            } else {
                this.restoreDayChange(changeData, rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)"customer", (CharSequence)name)) {
            String customerChange = this.getPageCache().get("customerChange");
            if (StringUtils.isBlank((CharSequence)customerChange) && Objects.nonNull(changeData.getOldValue())) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("customerConfirm", (IFormPlugin)this);
                this.getPageCache().put("oldCustomerId", ((DynamicObject)changeData.getOldValue()).getPkValue().toString());
                this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u5ba2\u6237\u5c06\u6e05\u7a7a\u6240\u6709\u6570\u636e\uff0c\u662f\u5426\u66f4\u6539\u3002", (String)"NoseToTailEditPlugin_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
            } else {
                this.getPageCache().remove("customerChange");
            }
        }
    }

    private void validateDate() {
        int size = this.getModel().getEntryEntity("entryentity").size();
        ArrayList<String> errorRows = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            Date startTime = (Date)this.getModel().getValue("estiapproachtime1", i);
            if (!Objects.nonNull(startTime) || startTime.getTime() > NoseToTailUtil.getTodayEnd().getTime()) continue;
            errorRows.add(Integer.toString(i + 1));
        }
        if (!CollectionUtils.isEmpty(errorRows)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u9884\u8ba1\u8fdb\u573a\u65f6\u95f4\u5c0f\u4e8e\u660e\u5929\u3002", (String)"NoseToTailEditPlugin_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", errorRows)));
        }
    }

    private void restoreDayChange(ChangeData changeData, int rowIndex) {
        this.getPageCache().put("daysNoChange", "true");
        this.getModel().setValue("nextintervalday", changeData.getOldValue(), rowIndex);
        this.getPageCache().remove("daysNoChange");
    }

    private Map<Integer, Integer> getRowDiffDayMap() {
        int size = this.getModel().getEntryEntity("entryentity").size();
        int diffDays = 0;
        HashMap<Integer, Integer> lineDiffMap = new HashMap<Integer, Integer>(size);
        for (int i = 0; i < size; ++i) {
            if (i != size - 1) {
                Integer nextDays = (Integer)this.getModel().getValue("nextintervalday", i);
                DynamicObject beforePlan = (DynamicObject)this.getModel().getValue("resourceplan", i);
                DynamicObject afterPlan = (DynamicObject)this.getModel().getValue("resourceplan", i + 1);
                if (Objects.isNull(beforePlan) || Objects.isNull(afterPlan)) {
                    diffDays += 0;
                } else {
                    int nextDays1 = NoseToTailUtil.getDiffDay((Date)beforePlan.getDate("estideparttime"), (Date)afterPlan.getDate("estiapproachtime"));
                    diffDays = nextDays - nextDays1 + diffDays;
                }
            }
            lineDiffMap.put(i, diffDays);
        }
        return lineDiffMap;
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        DynamicObject resourcePlan = (DynamicObject)this.getModel().getValue("resourceplan", row);
        this.addResourcePlanDeatil(resourcePlan, row);
    }

    private void addResourcePlanDeatil(DynamicObject resourcePlan, int row) {
        DynamicObjectCollection detailtEntry;
        int size;
        Integer diffDay = 0;
        if (row != 0) {
            Map<Integer, Integer> rowDiffDayMap = this.getRowDiffDayMap();
            diffDay = rowDiffDayMap.get(row - 1);
        }
        if ((size = (detailtEntry = this.getModel().getEntryEntity("detailtentry")).size()) > 0) {
            int[] line = new int[size];
            for (int i = 0; i < size; ++i) {
                line[i] = i;
            }
            this.getModel().deleteEntryRows("detailtentry", line);
        }
        if (Objects.isNull(resourcePlan)) {
            return;
        }
        Long resourcePlanId = (Long)resourcePlan.getPkValue();
        ArrayList<List<Object>> details = new ArrayList<List<Object>>();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)resourcePlanId, (String)"pmpd_resourceplan");
        DynamicObjectCollection entryRepair = dynamicObject.getDynamicObjectCollection("entry_repair");
        for (DynamicObject object : entryRepair) {
            ArrayList detail = Lists.newArrayListWithExpectedSize((int)3);
            detail.add(object.getLong("sectionresource_id"));
            detail.add(DateUtils.addDays((Date)object.getDate("sectionstarttime"), (int)diffDay));
            detail.add(DateUtils.addDays((Date)object.getDate("sectionendtime"), (int)diffDay));
            details.add(detail);
        }
        this.batchCreateEntryRow("detailtentry", FIELDS_DETAIL, details);
        this.getView().updateView("detailtentry");
    }

    private void batchCreateEntryRow(String entryKey, String[] fields, List<List<Object>> values) {
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tvs = new TableValueSetter(fields);
        for (List<Object> value : values) {
            tvs.addRow(value.toArray());
        }
        model.batchCreateNewEntryRow(entryKey, tvs);
        model.endInit();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operateKey = evt.getOperationKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)BAR_SORT)) {
            this.sort("estiapproachtime1", "estideparttime1");
            this.customerDisable();
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)BAR_MODIFYDAY)) {
            Boolean isSort = (Boolean)this.getModel().getValue("issort");
            if (!isSort.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6392\u5e8f\u540e\u518d\u4fee\u6539\u95f4\u9694\u5929\u6570\u3002", (String)"NoseToTailEditPlugin_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean modifyStatus = (Boolean)this.getModel().getValue("modifystatus");
            this.getModel().setValue("modifystatus", (Object)(modifyStatus == false ? 1 : 0));
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int i = 1; i < entryEntity.size(); ++i) {
                DynamicObject resourcePlan = ((DynamicObject)entryEntity.get(i)).getDynamicObject("resourceplan");
                if (resourcePlan == null) continue;
                String executeStatus = resourcePlan.getString("executestatus");
                if (!Arrays.asList(ExecuteStatusEnum.ENTRANCE.getValue(), ExecuteStatusEnum.DEPARTURE.getValue(), ExecuteStatusEnum.CANCEL.getValue()).contains(executeStatus)) continue;
                this.getView().setEnable(Boolean.FALSE, i - 1, new String[]{"nextintervalday"});
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)BAR_NEWENTRY) || StringUtils.equals((CharSequence)operateKey, (CharSequence)BAR_DELETEENTRY)) {
            this.getModel().setValue("issort", (Object)Boolean.FALSE);
        }
    }

    private void sort(String startTimeField, String endTimeField) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int size = entryEntity.size();
        if (size == 0) {
            return;
        }
        List collect = entryEntity.stream().filter(x -> Objects.nonNull(x.get("resourceplan")) || Objects.nonNull(x.get("approach"))).sorted(Comparator.comparing(x -> Objects.isNull(x.getDate(startTimeField)) ? new Date(Long.MAX_VALUE) : x.getDate(startTimeField))).collect(Collectors.toList());
        int[] line = new int[size];
        for (int i = 0; i < size; ++i) {
            line[i] = i;
        }
        this.getModel().deleteEntryRows("entryentity", line);
        ArrayList<List<Object>> entityList = new ArrayList<List<Object>>(collect.size());
        for (int i = 0; i < collect.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)collect.get(i);
            ArrayList entity = Lists.newArrayListWithExpectedSize((int)4);
            entity.add(dynamicObject.getLong("approach_id"));
            entity.add(dynamicObject.getLong("resourceplan_id"));
            if (i == 0) {
                entity.add(0);
            } else {
                Object days = ((List)entityList.get(i - 1)).get(3);
                entity.add(days);
            }
            Date preEnd = dynamicObject.getDate(endTimeField);
            Date nextStart = null;
            if (i < collect.size() - 1) {
                nextStart = ((DynamicObject)collect.get(i + 1)).getDate(startTimeField);
            }
            if (Objects.nonNull(preEnd) && Objects.nonNull(nextStart)) {
                int days = NoseToTailUtil.getDiffDay((Date)preEnd, (Date)nextStart);
                entity.add(days);
            } else {
                entity.add(0);
            }
            entity.add(dynamicObject.getDate(startTimeField));
            entity.add(dynamicObject.getDate(endTimeField));
            entityList.add(entity);
        }
        this.batchCreateEntryRow("entryentity", FIELDS_ENTITY, entityList);
        this.getView().updateView("entryentity");
        DynamicObject resourcePlan = (DynamicObject)this.getModel().getValue("resourceplan", 0);
        this.addResourcePlanDeatil(resourcePlan, 0);
    }

    private void setCalValue(DynamicObjectCollection afterEntryEntity) {
        for (int i = 0; i < afterEntryEntity.size(); ++i) {
            DynamicObject resourcePlan = (DynamicObject)this.getModel().getValue("resourceplan", i);
            if (!Objects.nonNull(resourcePlan)) continue;
            this.getModel().setValue("estiapproachtime1", resourcePlan.get("estiapproachtime"), i);
            this.getModel().setValue("estideparttime1", resourcePlan.get("estideparttime"), i);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }
}

