/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.TimeZone;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.GroupFieldsUniqueValidateResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmpd.common.helper.control.DateTimeEditHelper;
import kd.pmc.pmps.business.standplan.PlanRoomHelper;

public class PlanRoomEditPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"resplannum"});
        BasedataEdit projects = (BasedataEdit)this.getControl("projects");
        projects.addBeforeF7SelectListener(this::projectBeforeSelect);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "planroom": {
                this.buildPlanRoomEntry();
                break;
            }
            case "resplannum": {
                this.resourcePlanChanged(e);
                break;
            }
            case "occstarttime": {
                Date date = (Date)e.getChangeSet()[0].getNewValue();
                this.timeChanged(date, true, "occendtime");
                this.buildPlanRoomEntry();
                break;
            }
            case "occendtime": {
                Date date2 = (Date)e.getChangeSet()[0].getNewValue();
                this.timeChanged(date2, false, "occstarttime");
                this.buildPlanRoomEntry();
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.timeChanged((Date)this.getModel().getValue("occstarttime"), true, "occendtime");
        this.timeChanged((Date)this.getModel().getValue("occendtime"), false, "occstarttime");
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            this.getModel().setValue("applyorg", (Object)RequestContext.get().getOrgId());
            this.getModel().setDataChanged(false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initDefaultSelectedDate();
        this.setResourcePlanProject();
    }

    private void setResourcePlanProject() {
        Long resPlan = (Long)this.getModel().getValue("resplan");
        if (resPlan == null || resPlan == 0L) {
            return;
        }
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"pmpd_resourceplan", (String)"entry_project.projcet", (QFilter[])new QFilter("id", "=", (Object)resPlan).toArray());
        if (objs.isEmpty()) {
            return;
        }
        Object[] pks = objs.stream().map(i -> i.get(0)).toArray();
        this.getModel().setValue("projects", (Object)pks);
        this.getModel().setDataChanged(false);
    }

    protected void initDefaultSelectedDate() {
        TimeZone timeZone = DateTimeEditHelper.getTimeZone((IFormView)this.getView(), (String)"occstarttime");
        String minFormatString = DateTimeEditHelper.getMinFormatString((TimeZone)timeZone);
        String maxFormatString = DateTimeEditHelper.getMaxFormatString((TimeZone)timeZone);
        DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)minFormatString, (List)Lists.newArrayList((Object[])new String[]{"occstarttime"}));
        DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)maxFormatString, (List)Lists.newArrayList((Object[])new String[]{"occendtime"}));
    }

    private void timeChanged(Date date, boolean isStartTime, String field) {
        long sec = 1000L;
        if (!isStartTime) {
            sec = -sec;
        }
        if (date != null) {
            date = new Date(date.getTime() + sec);
        }
        DateTimeEdit timeEdit = (DateTimeEdit)this.getControl(field);
        if (isStartTime) {
            if (date == null) {
                date = new Date(0L);
            }
            timeEdit.setMinDate(date);
        } else {
            if (date == null) {
                date = new Date(100000000000000L);
            }
            timeEdit.setMaxDate(date);
        }
    }

    private void resourcePlanChanged(PropertyChangedArgs e) {
        String resPlanNum = (String)e.getChangeSet()[0].getNewValue();
        if (StringUtils.isEmpty((CharSequence)resPlanNum)) {
            this.getModel().setValue("resplan", null);
            this.getModel().setValue("equipment", null);
            this.getModel().setValue("model", null);
            this.getModel().setValue("fixmodel", null);
            this.getModel().setValue("projects", null);
        }
    }

    private void buildPlanRoomEntry() {
        DynamicObject dy = this.getModel().getDataEntity(true);
        PlanRoomHelper.setPlanRoomResource((DynamicObject)dy);
        this.getView().updateView("entryentity");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)"resplannum", (CharSequence)key)) {
            this.showResourcePlanForm();
        }
    }

    private void showResourcePlanForm() {
        this.getView().invokeOperation("selectrepl");
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
    }

    private void resourcePlanCloseBack(ClosedCallBackEvent event) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String key = args.getOperateKey();
        if ((StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key)) && operationResult != null && !operationResult.isSuccess()) {
            this.changeErrorMsg(operationResult);
        }
    }

    public void changeErrorMsg(OperationResult operationResult) {
        ValidateResultCollection validateResultCollection = operationResult.getValidateResult();
        List validateResults = validateResultCollection.getValidateErrors();
        for (ValidateResult validateResult : validateResults) {
            List errorInfos;
            if (!(validateResult instanceof GroupFieldsUniqueValidateResult) || !((GroupFieldsUniqueValidateResult)validateResult).getFieldKeys().contains("resplannum") || CollectionUtils.isEmpty((Collection)(errorInfos = validateResult.getAllErrorInfo()))) continue;
            OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(0);
            String resNum = (String)this.getModel().getValue("resplannum");
            errorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u7f16\u7801 \u503c \u201c%s\u201d \u5df2\u5b58\u5728\u8ba1\u5212\u5ba4\u5360\u7528\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PlanRoomEditPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), resNum));
        }
    }

    private void projectBeforeSelect(BeforeF7SelectEvent event) {
        if ("click".equals(event.getSourceMethod())) {
            event.setCancel(true);
            this.getView().invokeOperation("selectpro");
        }
    }
}

