/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmps.business.standplan.PlanRoomHelper;

public class PlanRoomPrinterEditPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String resourcePlanPks = (String)formShowParameter.getCustomParam("resourcePlanPks");
        String projectPk = (String)formShowParameter.getCustomParam("projectPk");
        this.createPrintEntry(projectPk, resourcePlanPks);
    }

    private void createPrintEntry(String projectPk, String resourcePlanPk) {
        DynamicObjectCollection dynamicObjects = this.queryPlanRoomPrinters(projectPk, resourcePlanPk);
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return;
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"resource"});
        for (DynamicObject obj : dynamicObjects) {
            tableValueSetter.addRow(new Object[]{obj.get(0)});
        }
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow("entryentity", tableValueSetter);
        dataModel.endInit();
        this.getView().updateView("entryentity");
    }

    public DynamicObjectCollection queryPlanRoomPrinters(String projectPk, String resourcePlanPk) {
        QFilter qFilter = new QFilter("projects.fbasedataid", "=", (Object)Long.valueOf(projectPk));
        if (StringUtils.isNotEmpty((CharSequence)resourcePlanPk)) {
            qFilter.or("resplan", "=", (Object)Long.valueOf(resourcePlanPk));
        }
        QFilter qFilter1 = new QFilter("billstatus", "=", (Object)"C");
        DynamicObjectCollection resourceObjs = PlanRoomHelper.queryPrinterResource(null);
        if (CollectionUtils.isEmpty((Collection)resourceObjs)) {
            return null;
        }
        List resource = resourceObjs.stream().map(i -> i.get(0)).collect(Collectors.toList());
        qFilter1.and("entryentity.resource", "in", resource);
        qFilter1.and(qFilter);
        return QueryServiceHelper.query((String)"pmpd_planroomuse", (String)"entryentity.resource", (QFilter[])qFilter1.toArray());
    }
}

