/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import java.util.Calendar;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmps.business.task.helper.TaskHelper;

public class ResourcePlanConf
extends AbstractFormPlugin {
    protected String schedule_num = "pmpd_resourceplan_totalnum_SKDP_S";
    protected String job_num = "pmpd_resourceplan_totalnum_SKDJ_S";
    protected String taskdefine_num = "ResourcePlanTotalNumScheduleTask";
    protected String class_name = "kd.pmc.pmps.business.task.job.ResourcePlanTotalNumScheduleTask";

    public void afterCreateNewData(EventObject e) {
        DynamicObject sch = TaskHelper.querySchedule((String)this.schedule_num);
        if (sch == null) {
            return;
        }
        String repeatmode = sch.getString("repeatmode");
        if (StringUtils.equals((CharSequence)"n", (CharSequence)repeatmode)) {
            return;
        }
        this.getModel().setValue("status", (Object)StringUtils.equals((CharSequence)"1", (CharSequence)sch.getString("status")));
        String plan = sch.getString("plan");
        if (plan == null) {
            return;
        }
        String[] cronTemp = plan.split(" ");
        int sec = Integer.parseInt(cronTemp[0]);
        int min = Integer.parseInt(cronTemp[1]);
        int hour = Integer.parseInt(cronTemp[2]);
        this.getModel().setValue("updatetime", (Object)(sec + min * 60 + hour * 3600));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.updateSchPlan();
    }

    private void updateSchPlan() {
        DynamicObject sch = TaskHelper.querySchedule((String)this.schedule_num);
        if (sch == null) {
            sch = this.createSchedule();
        }
        if (sch == null) {
            this.getView().showErrorNotification(this.errorMsg());
            return;
        }
        sch.set("repeatmode", (Object)"def");
        sch.set("cyclenum", (Object)1);
        Integer time = (Integer)this.getModel().getValue("updatetime");
        int hour = time / 3600;
        int min = time % 3600 / 60;
        int sec = time % 3600 % 60;
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        calendar.set(11, hour);
        calendar.set(12, min);
        calendar.set(13, sec);
        sch.set("starttime", (Object)calendar.getTime());
        calendar.add(1, 100);
        sch.set("endtime", (Object)calendar.getTime());
        sch.set("plan", (Object)(sec + " " + min + " " + hour + " * * ?"));
        sch.set("status", (Object)((Boolean)this.getModel().getValue("status") != false ? "1" : "0"));
        OperationResult result = TaskHelper.saveSchedule((DynamicObject)sch);
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(this.errorMsg());
        }
    }

    public String errorMsg() {
        return ResManager.loadKDString((String)"\u8fdb\u573a\u67b6\u6b21\u8bbe\u7f6e\u5931\u8d25\uff0c\u672a\u751f\u6210\u8c03\u5ea6\u8ba1\u5212\u3002", (String)"ResourcePlanConf_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private DynamicObject createSchedule() {
        DynamicObject job = this.getJob();
        if (job == null) {
            return null;
        }
        DynamicObject schedule = TaskHelper.createSchedule();
        schedule.set("number", (Object)this.schedule_num);
        schedule.set("name", job.get("name"));
        schedule.set("job", (Object)job);
        DynamicObject jobEntry = schedule.getDynamicObjectCollection("entryentity").addNew();
        jobEntry.set("jobnumber", (Object)job);
        return schedule;
    }

    private DynamicObject getJob() {
        DynamicObject job = TaskHelper.queryTaskObj((String)"sch_job", (String)this.job_num);
        if (job != null) {
            return job;
        }
        DynamicObject taskDefine = TaskHelper.queryTaskObj((String)"sch_taskdefine", (String)this.taskdefine_num);
        job = TaskHelper.createJob();
        job.set("number", (Object)this.job_num);
        job.set("name", taskDefine.get("name"));
        job.set("jobtype", (Object)"BIZ");
        job.set("taskclassname", (Object)taskDefine);
        job.set("classname", (Object)this.class_name);
        job.set("runbyuser", (Object)RequestContext.get().getCurrUserId());
        job.set("status", (Object)"1");
        job.set("runmode", (Object)"0");
        job.set("runconcurrent", (Object)Boolean.TRUE);
        job.set("runorder", (Object)"0");
        job.set("strategy", (Object)"1");
        OperationResult result = SaveServiceHelper.saveOperate((String)"sch_taskdefine", (DynamicObject[])new DynamicObject[]{job}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            return null;
        }
        taskDefine.set("id", result.getSuccessPkIds().get(0));
        return taskDefine;
    }
}

