/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmc.pmpd.common.consts.ResourcePlanConst;
import kd.pmc.pmpd.common.enums.ConstructionUnitEnum;
import kd.pmc.pmpd.common.helper.DateTimeCheckHelper;
import kd.pmc.pmpd.common.helper.control.DateTimeEditHelper;
import kd.pmc.pmpd.common.helper.control.DecimalEditHelper;
import kd.pmc.pmpd.common.util.MileStoneTplUtils;
import kd.pmc.pmpd.common.util.TimeResult;
import org.apache.commons.lang3.time.DateUtils;

public class ResourcePlanEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final int DEFAULT_SCALE = 10;

    public void registerListener(EventObject e) {
        BasedataEdit workscopedetail;
        BasedataEdit color;
        BasedataEdit equipment;
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl("projcet");
        if (project != null) {
            project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((equipment = (BasedataEdit)this.getControl("overdevice")) != null) {
            equipment.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((color = (BasedataEdit)this.getControl("labelcolor")) != null) {
            color.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if ((workscopedetail = (BasedataEdit)this.getControl("workscopedetail")) != null) {
            workscopedetail.addBeforeF7SelectListener(this::workScopeDetailBeforeF7Select);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name = e.getEntryProp().getName();
        IDataModel dataModel = this.getModel();
        if ("entry_repair".equals(name)) {
            RowDataEntity firstEntry;
            int firstIndex;
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            RowDataEntity lastEntity = rowDataEntities[rowDataEntities.length - 1];
            int lastIndex = lastEntity.getRowIndex();
            dataModel.setValue("sectionendtime", this.getModel().getValue("estideparttime"), lastIndex);
            if (lastIndex > 0) {
                this.getModel().setValue("sectionendtime", null, lastIndex - 1);
            }
            if ((firstIndex = (firstEntry = rowDataEntities[0]).getRowIndex()) == 0) {
                dataModel.setValue("sectionstarttime", dataModel.getValue("estiapproachtime"), firstIndex);
            }
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                this.setWorkScopeDetail(rowDataEntity.getRowIndex());
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("projcet".equals(name)) {
            Object[] pkIds;
            List customQFilters = beforeF7SelectEvent.getCustomQFilters();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry_project");
            if (!entryEntity.isEmpty() && (pkIds = entryEntity.stream().filter(dynamicObject -> dynamicObject.getLong("projcet_id") != 0L).map(dynamicObject -> dynamicObject.get("projcet_id")).toArray()).length > 0) {
                customQFilters.add(new QFilter("id", "not in", (Object)pkIds));
            }
        } else if ("overdevice".equals(name)) {
            DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
            if (customer == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5ba2\u6237\u3002", (String)"ApproachApplicationEditPlugin_10", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            beforeF7SelectEvent.addCustomQFilter(this.getMaterialOwnerFilter(customer.getPkValue()));
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
            IDataEntityProperty property = basedataEdit.getProperty();
            LocaleString displayName = property.getDisplayName();
            formShowParameter.setCaption(displayName.getLocaleValue());
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        Control control = (Control)afterF7SelectEvent.getSource();
        if ("labelcolor".equals(control.getKey())) {
            this.fillColor(false);
        }
    }

    private void fillColor(boolean init) {
        DynamicObject labelColor = (DynamicObject)this.getModel().getValue("labelcolor");
        String color = null;
        if (labelColor == null) {
            if (init) {
                return;
            }
        } else {
            color = labelColor.getString("color");
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("bc", color);
        this.getView().updateControlMetadata("btn_color", params);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            if (this.getPageCache().get("operateKey") != null) {
                return;
            }
            this.refreshAllDurationValue();
            this.fillOriginalEstimateTime();
            this.checkTimeChange(args, operateKey);
        } else if ("cancel".equals(operateKey)) {
            RefObject afterConfirm = new RefObject();
            boolean hasCancelReason = formOperate.getOption().tryGetVariableValue("hasCancelReason", afterConfirm);
            if (!hasCancelReason) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("pmpd_resourceplan_cancel");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cancelCallBack"));
                this.getView().showForm(showParameter);
                args.setCancel(true);
            }
        } else if ("entrance".equals(operateKey) || "departure".equals(operateKey)) {
            RefObject afterConfirm = new RefObject();
            boolean hasTime = formOperate.getOption().tryGetVariableValue("startDate", afterConfirm);
            if (!hasTime) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("pmpd_resourceplan_time");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCustomParam("optionType", (Object)operateKey);
                Long id = (Long)this.getModel().getValue("id");
                if (id == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ResourcePlanEditPlugin_14", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                showParameter.setCustomParam("id", (Object)id);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "timeCallBack"));
                this.getView().showForm(showParameter);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        OperationResult result = args.getOperationResult();
        if (result != null) {
            if (StringUtils.equals((CharSequence)"cancelvalidation", (CharSequence)operateKey) && result.isSuccess()) {
                this.getView().invokeOperation("cancel");
            } else if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) && result.isSuccess()) {
                this.getView().invokeOperation("refresh");
            } else if (StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey) && result.isSuccess()) {
                this.getView().invokeOperation("refresh");
            }
            if (StringUtils.equals((CharSequence)"entrancevalidation", (CharSequence)operateKey) && result.isSuccess()) {
                this.getView().invokeOperation("entrance");
            }
            if (StringUtils.equals((CharSequence)"departurevalidation", (CharSequence)operateKey) && result.isSuccess()) {
                this.getView().invokeOperation("departure");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)"cancelCallBack", (CharSequence)actionId)) {
            Object returnData2 = event.getReturnData();
            if (Objects.nonNull(returnData2)) {
                OperateOption cancelOption = OperateOption.create();
                cancelOption.setVariableValue("cancelReason", (String)((Map)returnData2).get("cancelReason"));
                cancelOption.setVariableValue("hasCancelReason", "true");
                this.getView().invokeOperation("cancel", cancelOption);
            }
        } else if (StringUtils.equals((CharSequence)"timeCallBack", (CharSequence)actionId) && Objects.nonNull(returnData = event.getReturnData())) {
            OperateOption cancelOption = OperateOption.create();
            Map returnMap = (Map)returnData;
            cancelOption.setVariableValue("startDate", (String)returnMap.get("startDate"));
            String endDate = (String)returnMap.get("endDate");
            if (StringUtils.isNotBlank((CharSequence)endDate)) {
                cancelOption.setVariableValue("endDate", (String)returnMap.get("endDate"));
            }
            this.getView().invokeOperation((String)returnMap.get("optionType"), cancelOption);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if ("entry_project".equals(e.getEntryProp().getName())) {
            int[] rowIndexs;
            ArrayList<Integer> isReverseWritingIndexs = new ArrayList<Integer>();
            for (int rowIndex2 : rowIndexs = e.getRowIndexs()) {
                boolean isReverseWriting = (Boolean)this.getModel().getValue("isreversewriting", rowIndex2);
                if (!isReverseWriting) continue;
                isReverseWritingIndexs.add(rowIndex2);
            }
            if (isReverseWritingIndexs.isEmpty()) {
                return;
            }
            e.setCancel(true);
            int size = isReverseWritingIndexs.size();
            String formatStr = ResManager.loadKDString((String)"\u201c\u9879\u76ee\u4fe1\u606f\u201d\u7b2c%d\u884c\u7531\u9879\u76ee\u53cd\u5199, \u4e0d\u5141\u8bb8\u5220\u884c\u3002", (String)"ResourcePlanEditPlugin_12", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
            if (size == 1) {
                this.getView().showTipNotification(String.format(formatStr, (Integer)isReverseWritingIndexs.get(0) + 1));
            } else {
                StringBuilder errorMsg = new StringBuilder();
                for (Integer isReverseWritingIndex : isReverseWritingIndexs) {
                    errorMsg.append(String.format(formatStr, isReverseWritingIndex + 1)).append('\n');
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u884c\u6821\u9a8c", (String)"ResourcePlanEditPlugin_13", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), errorMsg.toString(), MessageTypes.Default);
            }
            int[] normalRowIndexs = Arrays.stream(rowIndexs).filter(rowIndex -> !isReverseWritingIndexs.contains(rowIndex)).toArray();
            if (ArrayUtils.isNotEmpty((int[])normalRowIndexs)) {
                this.getModel().beginInit();
                this.getModel().deleteEntryRows("entry_project", normalRowIndexs);
                this.getModel().endInit();
                this.getView().updateView("entry_project");
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
    }

    public void afterCopyData(EventObject e) {
        BillModel billModel = (BillModel)e.getSource();
        billModel.setValue("org", (Object)RequestContext.get().getOrgId());
        this.clearDirtyEntryRow(billModel, "entry_project");
        this.getModel().setEntryCurrentRowIndex("entry_project", 0);
        this.getModel().deleteEntryData("entry_contract");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initDefaultSelectedDate();
        this.setMinDate();
        this.initEntryDateRange();
        this.disableSort();
        DecimalEditHelper.setScale((IFormView)this.getView(), (int)((Integer)this.getModel().getValue("unitlength")), (List)ResourcePlanConst.DURATION_KEYS);
        this.updateTimeLengthScale((Integer)this.getModel().getValue("unitlength"));
        this.hiddenTabPage();
        BigDecimal repairCycle4Day = this.convert2Day((BigDecimal)this.getModel().getValue("repaircycle"));
        this.fillRepairCycleSplitValue(repairCycle4Day);
        this.getModel().setDataChanged(false);
        this.fillColor(true);
    }

    protected void disableSort() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry_repair");
        List controls = entryGrid.getControls();
        for (Control control : controls) {
            entryGrid.setColumnProperty(control.getKey(), "sort", (Object)Boolean.FALSE);
        }
    }

    protected void initEntryDateRange() {
        Date endDateTime;
        Date startDateTime = (Date)this.getModel().getValue("estiapproachtime");
        DateTimeEdit startDateTimeEdit = (DateTimeEdit)this.getControl("sectionstarttime");
        DateTimeEdit endDateTimeEdit = (DateTimeEdit)this.getControl("sectionendtime");
        if (startDateTime != null) {
            Calendar instance = Calendar.getInstance();
            instance.setTime(startDateTime);
            instance.set(13, 0);
            Date time = instance.getTime();
            startDateTimeEdit.setMinDate(time);
            endDateTimeEdit.setMinDate(time);
        }
        if ((endDateTime = (Date)this.getModel().getValue("estideparttime")) != null) {
            Calendar instance = Calendar.getInstance();
            instance.setTime(endDateTime);
            instance.set(13, 59);
            Date time = instance.getTime();
            startDateTimeEdit.setMaxDate(time);
            endDateTimeEdit.setMaxDate(time);
        }
    }

    protected void setMinDate() {
        DateTimeEdit dateTimeEdit;
        Date date = (Date)this.getModel().getValue("estiapproachtime");
        if (date != null) {
            dateTimeEdit = (DateTimeEdit)this.getControl("estideparttime");
            dateTimeEdit.setMinDate(date);
        }
        if ((date = (Date)this.getModel().getValue("preapproachtime")) != null) {
            dateTimeEdit = (DateTimeEdit)this.getControl("predeparttime");
            dateTimeEdit.setMinDate(date);
        }
        if ((date = (Date)this.getModel().getValue("realapproachtime")) != null) {
            dateTimeEdit = (DateTimeEdit)this.getControl("realdeparttime");
            dateTimeEdit.setMinDate(date);
        }
    }

    protected void initDefaultSelectedDate() {
        TimeZone timeZone = DateTimeEditHelper.getTimeZone((IFormView)this.getView(), (String)"estiapproachtime");
        String minFormatString = DateTimeEditHelper.getMinFormatString((TimeZone)timeZone);
        String maxFormatString = DateTimeEditHelper.getMaxFormatString((TimeZone)timeZone);
        DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)minFormatString, (List)ResourcePlanConst.HEAD_STARTDATETIME_KEYS);
        DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)maxFormatString, (List)ResourcePlanConst.HEAD_ENDDATETIME_KEYS);
        DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)"entry_repair", (String)minFormatString, (List)ResourcePlanConst.ENTRY_STARTDATETIME_KEYS);
        DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)"entry_repair", (String)maxFormatString, (List)ResourcePlanConst.ENTRY_ENDDATETIME_KEYS);
    }

    private void hiddenTabPage() {
        try {
            ListView parentView = (ListView)this.getView().getParentView();
            if (parentView.getBillFormId().equals("pmpd_resourceplan_simu")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tabpage_contract", "tabpageap2"});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        super.propertyChanged(event);
        String name = event.getProperty().getName();
        ChangeData changeSet = event.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        switch (name) {
            case "estiapproachtime": {
                this.estiApproachTimeChanged((Date)newValue);
                this.changePlanTime();
                this.fillDefRepairTime(name, "sectionstarttime");
                this.changeEntryStartTime((Date)newValue);
                break;
            }
            case "estideparttime": {
                this.estiDepartTimeChanged((Date)newValue);
                this.changePlanTime();
                this.fillDefRepairTime(name, "sectionendtime");
                this.changeEntryEndTime((Date)newValue);
                break;
            }
            case "realapproachtime": {
                this.realApproachTimeChanged((Date)newValue);
                break;
            }
            case "realdeparttime": {
                this.realDepartTimeChanged((Date)newValue);
                break;
            }
            case "preapproachtime": {
                this.preApproachTimeChanged((Date)newValue);
                break;
            }
            case "predeparttime": {
                this.preDepartTimeChanged((Date)newValue);
                break;
            }
            case "unitlength": {
                DecimalEditHelper.setScale((IFormView)this.getView(), (int)((Integer)newValue), (List)ResourcePlanConst.DURATION_KEYS);
                BigDecimal repairCycle4Day = this.convert2Day((BigDecimal)this.getModel().getValue("repaircycle"));
                this.fillRepairCycleSplitValue(repairCycle4Day);
                this.updateTimeLengthScale((Integer)newValue);
                this.refreshTimeLength();
                break;
            }
            case "constructionunit": {
                this.refreshAllDurationValue((DynamicObject)changeSet.getOldValue(), (DynamicObject)changeSet.getNewValue());
                this.refreshTimeLength();
                break;
            }
            case "sectionstarttime": {
                this.subsectionDateTimeChanged((Date)newValue, changeSet.getRowIndex(), true);
                break;
            }
            case "sectionendtime": {
                this.subsectionDateTimeChanged((Date)newValue, changeSet.getRowIndex(), false);
                break;
            }
            case "realstarttime": {
                this.occupancyDateTimeChanged((Date)newValue, changeSet.getRowIndex(), true);
                break;
            }
            case "realendtime": {
                this.occupancyDateTimeChanged((Date)newValue, changeSet.getRowIndex(), false);
                break;
            }
            case "repaircycle": {
                this.repairCycleChanged((BigDecimal)newValue);
                break;
            }
            case "mianworkcenter": {
                this.mianworkcenterChanged(changeSet);
                break;
            }
            case "sectionresource": {
                this.sectionresourceChaged(changeSet);
                break;
            }
            case "timelength": {
                this.timelengthChaged(changeSet);
                break;
            }
            case "plantpl": {
                this.fillMilestoneEntry();
                break;
            }
            case "repaircycleday": {
                this.changePlanTime();
                break;
            }
            case "workcenter": {
                this.fillDefWorkCenter();
                break;
            }
            case "workscope": {
                this.workScopeChanged();
                break;
            }
            case "workscopedetail": {
                this.workScopeDetailChanged(event);
                break;
            }
            case "workrepaircycle": {
                this.getModel().setValue("workrepaircycle", (Object)((BigDecimal)newValue).setScale(0, RoundingMode.UP));
                break;
            }
            case "customer": {
                this.customerChanged(changeSet);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DynamicObjectType mainEntityType = dataEntity.getDynamicObjectType();
        int splitOrdinal = mainEntityType.getProperty("repaircyclesplit").getOrdinal();
        dataEntityState.setBizChanged(splitOrdinal, false);
    }

    private void clearEntryField(String entryField, int rowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue(entryField, null, rowIndex);
        this.getModel().endInit();
        this.getView().updateView(entryField, rowIndex);
    }

    private void occupancyDateTimeChanged(Date changedDateTime, int rowIndex, boolean isStartDateTimeChanged) {
        Date endDateTime;
        Date startDateTime;
        if (changedDateTime == null) {
            return;
        }
        if (isStartDateTimeChanged) {
            startDateTime = changedDateTime;
            endDateTime = (Date)this.getModel().getValue("realendtime");
        } else {
            startDateTime = (Date)this.getModel().getValue("realstarttime");
            endDateTime = changedDateTime;
        }
        if (startDateTime != null && endDateTime != null && startDateTime.compareTo(endDateTime) >= 0) {
            this.clearEntryField("realendtime", rowIndex);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c\u68c0\u4fee\u573a\u5730\u65f6\u95f4\u201d\u7b2c%d\u884c, \u201c\u5b9e\u9645\u5360\u7528\u7ed3\u675f\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u201c\u5b9e\u9645\u5360\u7528\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"ResourcePlanEditPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
    }

    private void subsectionDateTimeChanged(Date changedDateTime, int rowIndex, boolean isStartDateTimeChanged) {
        Date endDateTime;
        Date startDateTime;
        int entryRowCount;
        if (changedDateTime == null) {
            return;
        }
        if (!isStartDateTimeChanged && (entryRowCount = this.getModel().getEntryRowCount("entry_repair")) != rowIndex + 1) {
            this.getModel().setValue("sectionstarttime", (Object)DateUtils.addMinutes((Date)changedDateTime, (int)1), rowIndex + 1);
        }
        ArrayList<String> msgList = new ArrayList<String>();
        if (this.getModel().getValue("estiapproachtime") == null) {
            msgList.add(ResManager.loadKDString((String)"\u201c\u9884\u8ba1\u8fdb\u573a\u65f6\u95f4\u201d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8f93\u5165\u201c\u9884\u8ba1\u8fdb\u573a\u65f6\u95f4\u201d\u3002", (String)"ResourcePlanEditPlugin_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
        if (!isStartDateTimeChanged && this.getModel().getValue("estideparttime") == null) {
            msgList.add(ResManager.loadKDString((String)"\u201c\u9884\u8ba1\u79bb\u573a\u65f6\u95f4\u201d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8f93\u5165\u201c\u9884\u8ba1\u79bb\u573a\u65f6\u95f4\u201d\u3002", (String)"ResourcePlanEditPlugin_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
        if (isStartDateTimeChanged) {
            startDateTime = changedDateTime;
            endDateTime = (Date)this.getModel().getValue("sectionendtime", rowIndex);
        } else {
            startDateTime = (Date)this.getModel().getValue("sectionstarttime", rowIndex);
            endDateTime = changedDateTime;
        }
        if (startDateTime != null && endDateTime != null && startDateTime.compareTo(endDateTime) >= 0) {
            this.clearEntryField("sectionendtime", rowIndex);
            msgList.add(String.format(ResManager.loadKDString((String)"\u201c\u68c0\u4fee\u573a\u5730\u65f6\u95f4\u201d\u7b2c%d\u884c, \u201c\u5206\u6bb5\u5360\u7528\u7ed3\u675f\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u201c\u5206\u6bb5\u5360\u7528\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"ResourcePlanEditPlugin_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
        this.setDurationValue("timelength", startDateTime, endDateTime, rowIndex, (Integer)this.getModel().getValue("unitlength"), (DynamicObject)this.getModel().getValue("constructionunit"));
    }

    private void estiApproachTimeChanged(Date startDateTime) {
        if (startDateTime == null) {
            DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)"estiapproachtime", (boolean)true);
        }
        DateTimeCheckHelper.startDateTimeChanged((IFormView)this.getView(), (Date)startDateTime, (String)"estideparttime", (String)ResManager.loadKDString((String)"\u9884\u8ba1\u79bb\u573a\u65f6\u95f4>\u9884\u8ba1\u8fdb\u573a\u65f6\u95f4", (String)"ResourcePlanEditPlugin_7", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), endDateTime -> this.setDurationValue("repaircycle", startDateTime, (Date)endDateTime));
        if (startDateTime != null) {
            Calendar instance = Calendar.getInstance();
            instance.setTime(startDateTime);
            instance.set(13, 0);
            Date time = instance.getTime();
            this.getModel().setValue("preapproachtime", (Object)startDateTime);
            DateTimeEdit startDateTimeEdit = (DateTimeEdit)this.getControl("sectionstarttime");
            startDateTimeEdit.setMinDate(time);
            DateTimeEdit endDateTimeEdit = (DateTimeEdit)this.getControl("sectionendtime");
            endDateTimeEdit.setMinDate(time);
        }
    }

    private void realApproachTimeChanged(Date startDateTime) {
        if (startDateTime == null) {
            DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)"realapproachtime", (boolean)true);
        }
        DateTimeCheckHelper.startDateTimeChanged((IFormView)this.getView(), (Date)startDateTime, (String)"realdeparttime", (String)ResManager.loadKDString((String)"\u5b9e\u9645\u79bb\u573a\u65f6\u95f4>\u5b9e\u9645\u8fdb\u573a\u65f6\u95f4", (String)"ResourcePlanEditPlugin_8", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), endDateTime -> this.setDurationValue("realrepaircycle", startDateTime, (Date)endDateTime));
    }

    private void preApproachTimeChanged(Date startDateTime) {
        if (startDateTime == null) {
            DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)"preapproachtime", (boolean)true);
        }
        DateTimeCheckHelper.startDateTimeChanged((IFormView)this.getView(), (Date)startDateTime, (String)"predeparttime", (String)ResManager.loadKDString((String)"\u9884\u8ba1\u5b8c\u5de5\u65f6\u95f4>\u9884\u8ba1\u5f00\u5de5\u65f6\u95f4", (String)"ResourcePlanEditPlugin_9", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), endDateTime -> this.setDurationValue("workrepaircycle", startDateTime, (Date)endDateTime));
    }

    private void estiDepartTimeChanged(Date endDateTime) {
        if (endDateTime == null) {
            DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)"estideparttime", (boolean)false);
        }
        DateTimeCheckHelper.endDateTimeChanged((IFormView)this.getView(), (Date)endDateTime, (String)"estiapproachtime", (String)"estideparttime", startDateTime -> this.setDurationValue("repaircycle", (Date)startDateTime, endDateTime));
        if (endDateTime != null) {
            Calendar instance = Calendar.getInstance();
            instance.setTime(endDateTime);
            instance.set(13, 59);
            Date time = instance.getTime();
            this.getModel().setValue("predeparttime", (Object)endDateTime);
            DateTimeEdit startDateTimeEdit = (DateTimeEdit)this.getControl("sectionstarttime");
            startDateTimeEdit.setMaxDate(time);
            DateTimeEdit endDateTimeEdit = (DateTimeEdit)this.getControl("sectionendtime");
            endDateTimeEdit.setMaxDate(time);
        }
    }

    private void realDepartTimeChanged(Date endDateTime) {
        if (endDateTime == null) {
            DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)"realdeparttime", (boolean)false);
        }
        DateTimeCheckHelper.endDateTimeChanged((IFormView)this.getView(), (Date)endDateTime, (String)"realapproachtime", (String)"realdeparttime", startDateTime -> this.setDurationValue("realrepaircycle", (Date)startDateTime, endDateTime));
    }

    private void preDepartTimeChanged(Date endDateTime) {
        if (endDateTime == null) {
            DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)"predeparttime", (boolean)false);
        }
        DateTimeCheckHelper.endDateTimeChanged((IFormView)this.getView(), (Date)endDateTime, (String)"preapproachtime", (String)"predeparttime", startDateTime -> this.setDurationValueUp("workrepaircycle", (Date)startDateTime, endDateTime, -1, 0));
    }

    private void setDurationValue(String durationKey, Date startDateTime, Date endDateTime) {
        this.setDurationValue(durationKey, startDateTime, endDateTime, -1, 10, (DynamicObject)this.getModel().getValue("constructionunit"));
    }

    private void setDurationValue(String durationKey, Date startDateTime, Date endDateTime, int index, int scale, DynamicObject constructionunit) {
        IDataModel model = this.getView().getModel();
        if (startDateTime == null || endDateTime == null) {
            model.setValue(durationKey, (Object)BigDecimal.ZERO, index);
            return;
        }
        BigDecimal duration = this.calculateDurationValue(startDateTime, endDateTime, scale, constructionunit);
        model.setValue(durationKey, (Object)duration, index);
    }

    private void setDurationValueUp(String durationKey, Date startDateTime, Date endDateTime, int index, int scale) {
        if (startDateTime == null || endDateTime == null) {
            return;
        }
        DynamicObject constructionunit = (DynamicObject)this.getModel().getValue("constructionunit");
        IDataModel model = this.getView().getModel();
        long dValue = endDateTime.getTime() - startDateTime.getTime();
        ConstructionUnitEnum unit = this.getUnitEnum(constructionunit);
        BigDecimal duration = BigDecimal.valueOf(dValue).divide(unit.getValue(), scale, RoundingMode.UP);
        model.setValue(durationKey, (Object)duration, index);
    }

    private BigDecimal calculateDurationValue(Date startDateTime, Date endDateTime, int scale, DynamicObject constructionunit) {
        long dValue = endDateTime.getTime() - startDateTime.getTime();
        ConstructionUnitEnum unit = this.getUnitEnum(constructionunit);
        return BigDecimal.valueOf(dValue).divide(unit.getValue(), scale, RoundingMode.HALF_UP);
    }

    private void refreshAllDurationValue() {
        int scale = (Integer)this.getModel().getValue("unitlength");
        this.getModel().beginInit();
        for (String durationKey : ResourcePlanConst.DURATION_KEYS) {
            BigDecimal durationValue = (BigDecimal)this.getModel().getValue(durationKey);
            this.getModel().setValue(durationKey, (Object)durationValue.setScale(scale, RoundingMode.HALF_UP));
        }
        this.getModel().endInit();
        for (String durationKey : ResourcePlanConst.DURATION_KEYS) {
            this.getView().updateView(durationKey);
        }
    }

    private void refreshAllDurationValue(DynamicObject oldUnit, DynamicObject newUnit) {
        this.getModel().beginInit();
        Date estiApproachTime = (Date)this.getModel().getValue("estiapproachtime");
        Date estiDepartTime = (Date)this.getModel().getValue("estideparttime");
        this.setDurationValue("repaircycle", estiApproachTime, estiDepartTime);
        BigDecimal repairCycle = (BigDecimal)this.getModel().getValue("repaircycle");
        Date realApproachTime = (Date)this.getModel().getValue("realapproachtime");
        Date realDepartTime = (Date)this.getModel().getValue("realdeparttime");
        this.setDurationValue("realrepaircycle", realApproachTime, realDepartTime);
        Date startTime = (Date)this.getModel().getValue("preapproachtime");
        Date endTime = (Date)this.getModel().getValue("predeparttime");
        this.setDurationValueUp("workrepaircycle", startTime, endTime, -1, 0);
        this.getModel().setValue("repaircycleroundup", (Object)repairCycle.setScale(0, 0));
        this.getModel().endInit();
        this.getView().updateView("repaircycle");
        this.getView().updateView("repaircycleroundup");
        this.getView().updateView("realrepaircycle");
        this.getView().updateView("workrepaircycle");
    }

    private void repairCycleChanged(BigDecimal newValue) {
        BigDecimal repairCycle4Day = this.convert2Day(newValue);
        this.getModel().beginInit();
        this.getModel().setValue("repaircycleroundup", (Object)newValue.setScale(0, 0).intValue());
        this.getModel().setValue("repaircycleday", (Object)repairCycle4Day);
        this.fillRepairCycleSplitValue(repairCycle4Day);
        this.getModel().endInit();
        this.getView().updateView("repaircyclesplit");
        this.getView().updateView("repaircycleroundup");
        this.getView().updateView("repaircycleday");
    }

    private BigDecimal convert2Day(BigDecimal repairCycle) {
        ConstructionUnitEnum unitEnum = this.getUnitEnum((DynamicObject)this.getModel().getValue("constructionunit"));
        return unitEnum == ConstructionUnitEnum.DAY ? repairCycle : repairCycle.multiply(unitEnum.getValue()).divide(ConstructionUnitEnum.DAY.getValue(), 10, RoundingMode.HALF_UP);
    }

    private void fillRepairCycleSplitValue(BigDecimal repairCycle4Day) {
        int scale = (Integer)this.getModel().getValue("unitlength");
        repairCycle4Day = repairCycle4Day.setScale(scale, 4);
        BigDecimal day = repairCycle4Day.setScale(0, 1);
        BigDecimal decimal = repairCycle4Day.subtract(day).multiply(BigDecimal.valueOf(24L)).setScale(2, 4);
        String spiltStr = day.stripTrailingZeros().toPlainString() + " Day " + decimal.stripTrailingZeros().toPlainString() + " Hr";
        this.getModel().setValue("repaircyclesplit", (Object)spiltStr);
    }

    private ConstructionUnitEnum getUnitEnum(DynamicObject unit) {
        return unit == null ? ConstructionUnitEnum.DAY : ConstructionUnitEnum.forValue((String)unit.getString("number"));
    }

    private void clearDirtyEntryRow(BillModel billModel, String entrykey) {
        int entryRowCount = billModel.getEntryRowCount(entrykey);
        if (entryRowCount == 0) {
            billModel.appendEntryRow(entrykey, 0, 1);
        } else if (entryRowCount > 1) {
            int[] arrays = IntStream.range(1, entryRowCount).toArray();
            billModel.deleteEntryRows(entrykey, arrays);
        }
        DynamicObject entryEntity = billModel.getEntryEntity(entrykey, 0);
        if (entryEntity != null) {
            entryEntity.getDataEntityState().setDirty(false);
        }
    }

    private void mianworkcenterChanged(ChangeData changeData) {
        int index = changeData.getRowIndex();
        Boolean newValue = (Boolean)changeData.getNewValue();
        if (newValue.booleanValue()) {
            int count = this.getModel().getEntryRowCount("entry_repair");
            for (int i = 0; i < count; ++i) {
                if (i == index) continue;
                this.updateMianWorkCenter(Boolean.FALSE, i);
            }
            this.getModel().setValue("workcenter", this.getModel().getValue("sectionresource", index));
        } else {
            this.getModel().setValue("workcenter", null);
        }
    }

    private void updateMianWorkCenter(Boolean value, int index) {
        this.getModel().beginInit();
        this.getModel().setValue("mianworkcenter", (Object)value, index);
        this.getModel().endInit();
        this.getView().updateView("mianworkcenter", index);
    }

    private void sectionresourceChaged(ChangeData changeSet) {
        int index = changeSet.getRowIndex();
        DynamicObject workcenter = (DynamicObject)changeSet.getNewValue();
        if (workcenter == null) {
            this.getModel().setValue("profitworkcenter", (Object)Boolean.FALSE, changeSet.getRowIndex());
            return;
        }
        Boolean mainworkcenter = (Boolean)this.getModel().getValue("mianworkcenter", index);
        if (mainworkcenter.booleanValue()) {
            this.getModel().setValue("workcenter", (Object)workcenter);
        }
    }

    @Deprecated
    protected void updateTimeLength(DynamicObject oldUnit, DynamicObject newUnit) {
    }

    protected void refreshTimeLength() {
        int count = this.getModel().getEntryRowCount("entry_repair");
        for (int i = 0; i < count; ++i) {
            this.getModel().beginInit();
            Date startTime = (Date)this.getModel().getValue("sectionstarttime", i);
            Date endTime = (Date)this.getModel().getValue("sectionendtime", i);
            this.setDurationValue("timelength", startTime, endTime, i, (Integer)this.getModel().getValue("unitlength"), (DynamicObject)this.getModel().getValue("constructionunit"));
            this.getModel().endInit();
            this.getView().updateView("timelength", i);
        }
    }

    protected void timelengthChaged(ChangeData changeSet) {
        int index = changeSet.getRowIndex();
        IDataModel model = this.getModel();
        BigDecimal timeLegth = (BigDecimal)changeSet.getNewValue();
        if (timeLegth == null) {
            return;
        }
        model.beginInit();
        model.setValue("timelength", (Object)timeLegth.setScale((Integer)this.getModel().getValue("unitlength") + 1, 1), index);
        model.endInit();
        this.getView().updateView("timelength", index);
    }

    protected void fillMilestoneEntry() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject planTpl = (DynamicObject)model.getValue("plantpl");
        model.deleteEntryData("milestoneentry");
        if (planTpl == null) {
            return;
        }
        DynamicObject planTemp = BusinessDataServiceHelper.loadSingle((Object)planTpl.getPkValue(), (String)"pmpd_milestonetpl");
        BigDecimal repaircycleday = (BigDecimal)this.getModel().getValue("repaircycleday");
        Date estiApproachTime = (Date)this.getModel().getValue("estiapproachtime");
        Map milestoneTimes = estiApproachTime == null ? null : MileStoneTplUtils.calTplTime((DynamicObject)planTemp, (Date)estiApproachTime, (BigDecimal)repaircycleday);
        DynamicObjectCollection milestones = planTemp.getDynamicObjectCollection("treeentryentity");
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"milestonename", "planbegin", "percent", "milestoneid", "mitstarttime"});
        for (DynamicObject milestone : milestones) {
            String biztype = milestone.getString("biztype");
            if (!StringUtils.equals((CharSequence)"A", (CharSequence)biztype)) continue;
            Long id = milestone.getLong("id");
            TimeResult timeResult = milestoneTimes == null ? null : (TimeResult)milestoneTimes.get(id);
            tableValueSetter.addRow(new Object[]{milestone.get("milestonename"), milestone.get("planbegin"), milestone.get("percent"), milestone.get("id"), timeResult == null ? null : timeResult.getBeginDate()});
        }
        model.beginInit();
        model.batchCreateNewEntryRow("milestoneentry", tableValueSetter);
        model.endInit();
        this.getView().updateView("milestoneentry");
    }

    private void changePlanTime() {
        if (!this.hasHandelTime()) {
            this.fillMilestoneEntry();
        } else {
            this.getPageCache().put("changeCount", "1");
        }
    }

    protected void checkTimeChange(BeforeDoOperationEventArgs args, String operateKey) {
        DynamicObject obj = this.getModel().getDataEntity();
        Iterable iterable = obj.getDataEntityState().getBizChangedProperties();
        boolean flag = false;
        for (IDataEntityProperty property : iterable) {
            if (!StringUtils.equals((CharSequence)"estiapproachtime", (CharSequence)property.getName()) && !StringUtils.equals((CharSequence)"repaircycleday", (CharSequence)property.getName())) continue;
            flag = true;
            break;
        }
        boolean bl = flag = flag && this.hasChangeCount();
        if (flag) {
            args.setCancel(true);
            this.getPageCache().put("operateKey", operateKey);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8ba1\u5212\u68c0\u4fee\u5468\u671f\u7684\u65f6\u95f4\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u662f\u5426\u91cd\u65b0\u6267\u884c\u91cc\u7a0b\u7891\u8ba1\u5212\u65f6\u95f4\u7684\u8fd0\u7b97\uff1f", (String)"ResourcePlanEditPlugin_18", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("timeChangeConfrim"));
        }
    }

    private boolean hasChangeCount() {
        return this.getPageCache().get("changeCount") != null;
    }

    protected boolean hasHandelTime() {
        DynamicObjectCollection milestoneentry = this.getModel().getEntryEntity("milestoneentry");
        boolean flag = false;
        for (DynamicObject dynamicObject : milestoneentry) {
            Date date = dynamicObject.getDate("mitstarttime");
            if (date == null) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String key = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (StringUtils.equals((CharSequence)"timeChangeConfrim", (CharSequence)key)) {
            if (MessageBoxResult.Yes == result) {
                this.fillMilestoneEntry();
            }
            this.getView().invokeOperation(this.getPageCache().get("operateKey"));
            this.getPageCache().remove("operateKey");
        } else if ("customer".equals(key)) {
            this.customerConfirmCallBack(event);
        }
    }

    protected void fillDefRepair() {
        IDataModel dataModel = this.getModel();
        dataModel.createNewEntryRow("entry_repair");
        Object workCenter = dataModel.getValue("workcenter");
        dataModel.setValue("sectionresource", workCenter, 0);
        dataModel.setValue("sectionstarttime", dataModel.getValue("estiapproachtime"), 0);
        dataModel.setValue("sectionendtime", dataModel.getValue("estideparttime"), 0);
        if (workCenter != null) {
            dataModel.setValue("mianworkcenter", (Object)Boolean.TRUE, 0);
        }
    }

    protected void fillDefRepairTime(String headField, String entryField) {
        IDataModel dataModel = this.getModel();
        Object newData = dataModel.getValue(headField);
        int count = dataModel.getEntryRowCount("entry_repair");
        if (count > 1) {
            return;
        }
        if (count == 0) {
            this.fillDefRepair();
            return;
        }
        Object oldData = dataModel.getValue(entryField, 0);
        if (oldData == null) {
            dataModel.setValue(entryField, newData, 0);
        }
    }

    protected void fillDefWorkCenter() {
        IDataModel dataModel = this.getModel();
        Object newData = dataModel.getValue("workcenter");
        int count = dataModel.getEntryRowCount("entry_repair");
        if (count > 1) {
            for (int i = 0; i < count; ++i) {
                Boolean mainWorkCenter = (Boolean)dataModel.getValue("mianworkcenter", i);
                if (!mainWorkCenter.booleanValue()) continue;
                dataModel.setValue("sectionresource", newData, i);
                return;
            }
            return;
        }
        if (count == 0) {
            this.fillDefRepair();
            return;
        }
        Object oldData = dataModel.getValue("sectionresource", 0);
        if (oldData == null || ((Boolean)dataModel.getValue("mianworkcenter", 0)).booleanValue()) {
            dataModel.setValue("sectionresource", newData, 0);
            dataModel.setValue("mianworkcenter", (Object)Boolean.TRUE, 0);
        }
    }

    protected void workScopeDetailBeforeF7Select(BeforeF7SelectEvent event) {
        DynamicObject workscope = (DynamicObject)this.getModel().getValue("workscope");
        if (workscope == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5de5\u4f5c\u5185\u5bb9\u201d\u3002", (String)"ResourcePlanEditPlugin_19", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        DynamicObjectCollection workCateDetails = workscope.getDynamicObjectCollection("workcatedetails");
        Set ids = workCateDetails.stream().map(i -> i.get("fbasedataid_id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", ids);
        event.getCustomQFilters().add(qFilter);
    }

    public void workScopeChanged() {
        boolean workScopeChanged = StringUtils.equals((CharSequence)"true", (CharSequence)this.getPageCache().get("workscopechange"));
        boolean workScopetplChanged = StringUtils.equals((CharSequence)"true", (CharSequence)this.getPageCache().get("workscopetplchange"));
        if (!workScopeChanged && !workScopetplChanged && this.getModel().getValue("workscope") != null) {
            return;
        }
        int count = this.getModel().getEntryRowCount("entry_repair");
        if (count < 1) {
            return;
        }
        DynamicObject workScope = (DynamicObject)this.getModel().getValue("workscope");
        if (workScope != null) {
            DynamicObjectCollection workCateDetails = workScope.getDynamicObjectCollection("workcatedetails");
            Object[] ids = workCateDetails.stream().map(i -> i.get("fbasedataid_id")).toArray();
            for (int i2 = 0; i2 < count; ++i2) {
                this.getModel().setValue("workscopedetail", (Object)ids, i2);
            }
        } else {
            for (int i3 = 0; i3 < count; ++i3) {
                this.getModel().setValue("workscopedetail", null, i3);
            }
        }
    }

    public void workScopeDetailChanged(PropertyChangedArgs event) {
        ChangeData changeData = event.getChangeSet()[0];
        DynamicObjectCollection newValue = (DynamicObjectCollection)changeData.getNewValue();
        DynamicObject workscope = (DynamicObject)this.getModel().getValue("workscope");
        if (CollectionUtils.isEmpty((Collection)newValue)) {
            this.getModel().setValue("workspdetails", null, changeData.getRowIndex());
            return;
        }
        String combosymbol = workscope.getString("combosymbol");
        StringJoiner desc = new StringJoiner(combosymbol);
        for (DynamicObject value : newValue) {
            desc.add(value.getDynamicObject("fbasedataid").getString("name"));
        }
        this.getModel().setValue("workspdetails", (Object)desc.toString(), changeData.getRowIndex());
    }

    public void updateTimeLengthScale(int scale) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("entry_repair", "setColEditorProp", new Object[]{"timelength", "sc", scale});
    }

    public void customerChanged(ChangeData changeData) {
        String confirmCust = this.getPageCache().get("confirmCust");
        if (StringUtils.isNotEmpty((CharSequence)confirmCust)) {
            this.getPageCache().remove("confirmCust");
            return;
        }
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        if (oldValue != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u201c\u5ba2\u6237\u201d\u5c06\u6e05\u7a7a\u201c\u68c0\u4fee\u8bbe\u5907\u6ce8\u518c\u53f7\u201d\u6570\u636e", (String)"ApproachApplicationEditPlugin_11", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u66f4\u6539\u5417\uff1f", (String)"WorkHourEstimateBillEdit_12", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("customer", (IFormPlugin)this), null, String.valueOf(oldValue.getPkValue()));
        }
    }

    public void customerConfirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Cancel) {
            Long originalId = Long.parseLong(event.getCustomVaule());
            this.getPageCache().put("confirmCust", "1");
            this.getModel().setValue("customer", (Object)originalId);
            this.getModel().endInit();
        } else {
            this.getModel().setValue("overdevice", null);
        }
    }

    public QFilter getMaterialOwnerFilter(Object pk) {
        return new QFilter("operator.id", "=", pk);
    }

    private void changeEntryStartTime(Date newValue) {
        int i = this.getModel().getEntryRowCount("entry_repair");
        if (i > 0) {
            this.getModel().setValue("sectionstarttime", (Object)newValue, 0);
        }
    }

    private void changeEntryEndTime(Date newValue) {
        int i = this.getModel().getEntryRowCount("entry_repair");
        if (i > 0) {
            this.getModel().setValue("sectionendtime", (Object)newValue, i - 1);
        }
    }

    private void fillOriginalEstimateTime() {
        Object value = this.getModel().getValue("originalestiapproachtime");
        if (value == null) {
            this.getModel().setValue("originalestiapproachtime", this.getModel().getValue("estiapproachtime"));
            this.getModel().setValue("originalestideparttime", this.getModel().getValue("estideparttime"));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        int count;
        String entryName = e.getEntryProp().getName();
        if ("entry_repair".equals(entryName) && (count = this.getModel().getEntryRowCount(entryName)) > 0) {
            this.getModel().setValue("sectionendtime", this.getModel().getValue("estideparttime"), count - 1);
        }
    }

    private void setWorkScopeDetail(int rowIndex) {
        DynamicObject workScope = (DynamicObject)this.getModel().getValue("workscope");
        if (workScope != null) {
            DynamicObjectCollection workCateDetails = workScope.getDynamicObjectCollection("workcatedetails");
            Object[] ids = workCateDetails.stream().map(i -> i.get("fbasedataid_id")).toArray();
            this.getModel().setValue("workscopedetail", (Object)ids, rowIndex);
        }
    }
}

