/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;

public class ResourcePlanEstimatePlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (Objects.equals(this.getModel().getValue("isestimate"), Boolean.TRUE)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"uncancelestimate"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"cancelestimate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"uncancelestimate"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancelestimate"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (operate instanceof Push && "estimate".equals(operate.getOperateKey())) {
            if (this.isNotSave() || this.isCancelEstimate()) {
                args.setCancel(true);
            } else {
                args.setCancel(true);
                this.push((Push)operate);
            }
        } else if (StringUtils.equals((CharSequence)"cancelestimate", (CharSequence)operate.getOperateKey()) && this.isNotSave()) {
            args.setCancel(true);
        } else if (StringUtils.equals((CharSequence)"uncancelestimate", (CharSequence)operate.getOperateKey()) && this.isNotSave()) {
            args.setCancel(true);
        }
    }

    private boolean isCancelEstimate() {
        boolean iscancel;
        Object estimate = this.getModel().getValue("isestimate");
        boolean bl = iscancel = Objects.isNull(estimate) || Objects.equals(Boolean.FALSE, estimate);
        if (iscancel) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u65e0\u9700\u8fdb\u884c\u5de5\u65f6\u4f30\u7b97\u3002", (String)"ResourcePlanEstimatePlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
        return iscancel;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (StringUtils.equals((CharSequence)"cancelestimate", (CharSequence)args.getOperateKey())) {
            if (CollectionUtils.isNotEmpty((Collection)args.getOperationResult().getSuccessPkIds())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"uncancelestimate"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancelestimate"});
            }
            this.getModel().setDataChanged(false);
        }
        if (StringUtils.equals((CharSequence)"uncancelestimate", (CharSequence)args.getOperateKey())) {
            if (CollectionUtils.isNotEmpty((Collection)args.getOperationResult().getSuccessPkIds())) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"uncancelestimate"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"cancelestimate"});
            }
            this.getModel().setDataChanged(false);
        }
    }

    private boolean isNotSave() {
        boolean isnotsave;
        Object id = this.getModel().getValue("id");
        boolean bl = isnotsave = Objects.isNull(id) || Objects.equals(id, 0L);
        if (isnotsave) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ResourcePlanEstimatePlugin_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
        return isnotsave;
    }

    private void push(Push push) {
        long targetEstimatedBillId;
        Object billno = this.getModel().getValue("billno");
        Object id = this.getModel().getValue("id");
        QFilter[] filters = new QFilter[2];
        filters[0] = new QFilter("resourceplan", "=", billno);
        int count = 0;
        long singleEstimatedBillId = 0L;
        long multiEstimatedBillId = 0L;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_hour_estimate", (String)"id, effectivestatus", (QFilter[])filters, null);){
            for (Row row : dataSet) {
                Long estimatedBillId = row.getLong(0);
                if (count++ == 0) {
                    singleEstimatedBillId = estimatedBillId;
                }
                if (!"1".equals(row.getString(1))) continue;
                multiEstimatedBillId = estimatedBillId;
            }
        }
        long l = targetEstimatedBillId = count == 1 ? singleEstimatedBillId : multiEstimatedBillId;
        if (targetEstimatedBillId == 0L) {
            this.doPush(push, id);
        } else {
            this.doEdit(targetEstimatedBillId);
        }
    }

    private void doEdit(Object id) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("pmpd_hour_estimate");
        billShowParameter.setPkId(id);
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("90%");
        styleCss.setWidth("90%");
        billShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        billShowParameter.setHasRight(true);
        billShowParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void doPush(Push push, Object id) {
        Map parameter = push.getParameter();
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(push.getEntityId());
        pushArgs.setTargetEntityNumber(parameter.getOrDefault("targetbill", "pmpd_hour_estimate"));
        pushArgs.setHasRight(ObjectConverterWrapper.getBoolean(parameter.get("ishasright")).booleanValue());
        pushArgs.setRuleId(ObjectConverterWrapper.getString(parameter.get("ruleid")));
        ArrayList selectedRows = Lists.newArrayList((Object[])new ListSelectedRow[]{new ListSelectedRow(id)});
        pushArgs.setSelectedRows((List)selectedRows);
        ConvertOperationResult convertResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (convertResult.isSuccess() && convertResult.getCachePageIds().size() + convertResult.getTargetBillIds().size() != 0) {
            if (convertResult.getCachePageIds().size() + convertResult.getTargetBillIds().size() == 1) {
                this.showTargetBill(this.getView(), pushArgs, convertResult);
            } else {
                Push.showMultiTargetBills((IFormView)this.getView(), (PushArgs)pushArgs, (ConvertOperationResult)convertResult, (boolean)false);
            }
        } else {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)pushArgs, (ConvertOperationResult)convertResult);
        }
    }

    private void showTargetBill(IFormView view, PushArgs pushArgs, ConvertOperationResult convertResult) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(convertResult.loadTargetLayoutFormId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("90%");
        styleCss.setWidth("90%");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        if (convertResult.getTargetBillIds().isEmpty()) {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCachePageId((String)convertResult.getCachePageIds().get(0));
        } else {
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setPkId(convertResult.getTargetBillIds().iterator().next());
        }
        showParameter.setHasRight(true);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.getCustomParams().put("botptag_of_datasource", String.valueOf(true));
        showParameter.addCustPlugin("kd.bos.form.plugin.botp.ConvertTrackerEdit");
        showParameter.getCustomParams().put("showreport", String.valueOf(false));
        if (StringUtils.isNotBlank((CharSequence)pushArgs.getAppId())) {
            showParameter.getCustomParams().put("checkRightAppId", pushArgs.getAppId());
        }
        String resultJson = SerializationUtils.toJsonString((Object)convertResult);
        this.getPageCache().put("ConvertOperationResult", resultJson);
        view.showForm((FormShowParameter)showParameter);
    }
}

