/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.pmc.pmpd.common.enums.ResourcePublicStatusEnum;
import kd.pmc.pmps.business.standplan.ResourcePlanHelper;

public class ResourcePlanListPlugin
extends AbstractListPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String publishStatus = (String)showParameter.getCustomParam("pulishstatus");
        if (StringUtils.equals((CharSequence)publishStatus, (CharSequence)ResourcePublicStatusEnum.PRE.getValue())) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u2014\u9884\u6392", (String)"ResourcePlanListPlugin_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String pulishStatus = (String)this.getView().getFormShowParameter().getCustomParam("pulishstatus");
        if (StringUtils.equals((CharSequence)pulishStatus, (CharSequence)ResourcePublicStatusEnum.EXECUTE.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "tbldel", "tblsubmit", "tblcheck", "executeoperation", "bartrackup"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"barpush", "updatebtn"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"enternumset", (CharSequence)key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("pmpd_resourceplanconf");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        } else if (StringUtils.equals((CharSequence)"enternumupdate", (CharSequence)key)) {
            ResourcePlanHelper.updateEnterTotalNumber();
            ((ListView)this.getView()).refresh();
        } else if ("cancel".equals(key)) {
            RefObject afterConfirm = new RefObject();
            boolean hasCancelReason = operate.getOption().tryGetVariableValue("hasCancelReason", afterConfirm);
            if (!hasCancelReason) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("pmpd_resourceplan_cancel");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cancelCallBack"));
                this.getView().showForm(showParameter);
                args.setCancel(true);
            }
        } else if ("cancelvalidation".equals(key) || "entrancevalidation".equals(key) || "departurevalidation".equals(key)) {
            ListView view = (ListView)this.getView();
            int size = view.getSelectedRows().getPrimaryKeyValues().length;
            if (size != 1) {
                if ("cancelvalidation".equals(key)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u6267\u884c\u53d6\u6d88\u64cd\u4f5c\u3002", (String)"ResourcePlanListPlugin_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                } else if ("entrancevalidation".equals(key)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u6267\u884c\u5165\u573a\u64cd\u4f5c\u3002", (String)"ResourcePlanListPlugin_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                } else if ("departurevalidation".equals(key)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u6267\u884c\u79bb\u573a\u64cd\u4f5c\u3002", (String)"ResourcePlanListPlugin_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
            }
        } else if ("entrance".equals(key) || "departure".equals(key)) {
            RefObject afterConfirm = new RefObject();
            boolean hasTime = operate.getOption().tryGetVariableValue("startDate", afterConfirm);
            if (!hasTime) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("pmpd_resourceplan_time");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCustomParam("optionType", (Object)key);
                showParameter.setCustomParam("id", args.getListSelectedData().get(0).getPrimaryKeyValue());
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "timeCallBack"));
                this.getView().showForm(showParameter);
                args.setCancel(true);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        ListView view;
        super.setFilter(e);
        String pulishStatus = (String)this.getView().getFormShowParameter().getCustomParam("pulishstatus");
        if (StringUtils.isNotBlank((CharSequence)pulishStatus)) {
            e.getQFilters().add(new QFilter("pulishstatus", "=", (Object)pulishStatus));
        }
        if (this.getView().getParentView() instanceof ListView && StringUtils.equals((CharSequence)(view = (ListView)this.getView().getParentView()).getBillFormId(), (CharSequence)"pmpd_monthhourbill")) {
            e.getQFilters().add(new QFilter("pulishstatus", "=", (Object)"0"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        OperationResult result = args.getOperationResult();
        if (Objects.nonNull(result) && result.isSuccess()) {
            if (StringUtils.equals((CharSequence)"cancelvalidation", (CharSequence)operateKey)) {
                this.getView().invokeOperation("cancel");
            }
            if (StringUtils.equals((CharSequence)"entrancevalidation", (CharSequence)operateKey)) {
                this.getView().invokeOperation("entrance");
            }
            if (StringUtils.equals((CharSequence)"departurevalidation", (CharSequence)operateKey)) {
                this.getView().invokeOperation("departure");
            }
            if (StringUtils.equals((CharSequence)"departure", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"entrance", (CharSequence)operateKey)) {
                ((ListView)this.getView()).refresh();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)"cancelCallBack", (CharSequence)actionId)) {
            Object returnData2 = event.getReturnData();
            if (Objects.nonNull(returnData2)) {
                OperateOption cancelOption = OperateOption.create();
                cancelOption.setVariableValue("cancelReason", (String)((Map)returnData2).get("cancelReason"));
                cancelOption.setVariableValue("hasCancelReason", "true");
                this.getView().invokeOperation("cancel", cancelOption);
            }
        } else if (StringUtils.equals((CharSequence)"timeCallBack", (CharSequence)actionId) && Objects.nonNull(returnData = event.getReturnData())) {
            OperateOption cancelOption = OperateOption.create();
            Map returnMap = (Map)returnData;
            cancelOption.setVariableValue("startDate", (String)returnMap.get("startDate"));
            String endDate = (String)returnMap.get("endDate");
            if (StringUtils.isNotBlank((CharSequence)endDate)) {
                cancelOption.setVariableValue("endDate", (String)returnMap.get("endDate"));
            }
            this.getView().invokeOperation((String)returnMap.get("optionType"), cancelOption);
        }
    }
}

