/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;

public class ResourcePlanProjectMileStonePlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid projectEntry = (EntryGrid)this.getControl("entry_project");
        if (projectEntry != null) {
            projectEntry.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int rowCount = this.getModel().getEntryRowCount("entry_project");
        long projectId = 0L;
        if (rowCount > 0) {
            projectId = (Long)this.getModel().getValue("projcet_id", 0);
        }
        this.showMileStone(projectId);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        if (row >= 0) {
            long projectId = (Long)this.getModel().getValue("projcet_id", row);
            this.showMileStone(projectId);
        }
    }

    private void showMileStone(long projectId) {
        String pageId = this.getPageCache().get("projectmilestone");
        if (StringUtils.isBlank((CharSequence)pageId)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("fmm_project_milestone");
            formShowParameter.setCustomParam("projectid", (Object)projectId);
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("project_milestone");
            this.getView().showForm(formShowParameter);
            pageId = formShowParameter.getPageId();
            this.getPageCache().put("projectmilestone", pageId);
        } else {
            IFormView view = this.getView().getView(pageId);
            view.getFormShowParameter().setCustomParam("projectid", (Object)projectId);
            view.invokeOperation("refresh");
            this.getView().sendFormAction(view);
        }
    }
}

