/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ResourcePlanRecordListPlugin
extends AbstractListPlugin {
    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        Set ids = pageData.stream().map(data -> data.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pmpd_resourceplan_record", (String)"id,adjustresult_tag,remark_tag", (QFilter[])new QFilter("id", "in", ids).toArray());
        Map<Long, String> rsmap = coll.stream().collect(Collectors.toMap(co -> co.getLong("id"), co -> co.getString("adjustresult_tag")));
        Map<Long, String> rmmap = coll.stream().collect(Collectors.toMap(co -> co.getLong("id"), co -> co.getString("remark_tag")));
        for (DynamicObject data2 : pageData) {
            data2.set("adjustresult", (Object)rsmap.get(data2.getLong("id")));
            data2.set("remark", (Object)rmmap.get(data2.getLong("id")));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (StringUtils.equals((CharSequence)args.getOperateKey(), (CharSequence)"alterremark")) {
            BillList billList = (BillList)this.getControl("billlistap");
            Object focusRowPkId = billList.getFocusRowPkId();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"pmpd_resourceplan_record");
            this.showAlterRemarkForm(dynamicObject);
        }
    }

    private void showAlterRemarkForm(DynamicObject dynamicObject) {
        String remark = dynamicObject.getString("remark_tag");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pmpd_alterremarkui");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "alterremark"));
        formShowParameter.getCustomParams().put("remark", remark);
        formShowParameter.getCustomParams().put("id", dynamicObject.get("id"));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        super.closedCallBack(callBackEvent);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refreshData();
    }
}

