/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.standplan;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmc.pmpd.common.helper.DateTimeCheckHelper;
import kd.pmc.pmpd.common.helper.control.DateTimeEditHelper;

public class ResourcePlanTimeEditPlugin
extends AbstractFormPlugin {
    private static final String KEY_BTNOK = "btnok";
    private static final String REALAPPROACHTIME = "realapproachtime";
    private static final String REALDEPARTTIME = "realdeparttime";
    private static final String OPTIONTYPE = "optionType";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String optionType = (String)showParameter.getCustomParam(OPTIONTYPE);
        if (StringUtils.equals((CharSequence)optionType, (CharSequence)"departure")) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u79bb\u573a\u64cd\u4f5c", (String)"ResourcePlanTimeEditPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5165\u573a\u64cd\u4f5c", (String)"ResourcePlanTimeEditPlugin_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String optionType = (String)this.getView().getFormShowParameter().getCustomParam(OPTIONTYPE);
        Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject resourcePlan = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmpd_resourceplan", (String)"realapproachtime, realdeparttime");
        Date startDate = resourcePlan.getDate(REALAPPROACHTIME);
        Date endTime = resourcePlan.getDate(REALDEPARTTIME);
        this.getModel().setValue(REALAPPROACHTIME, (Object)startDate);
        this.getModel().setValue(REALDEPARTTIME, (Object)endTime);
        if (StringUtils.equals((CharSequence)optionType, (CharSequence)"departure")) {
            if (startDate != null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{REALAPPROACHTIME});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{REALDEPARTTIME});
            this.getModel().setValue(REALDEPARTTIME, (Object)new Date());
        }
    }

    public void afterBindData(EventObject e) {
        Date startDate;
        super.afterBindData(e);
        TimeZone timeZone = DateTimeEditHelper.getTimeZone((IFormView)this.getView(), (String)REALAPPROACHTIME);
        String optionType = (String)this.getView().getFormShowParameter().getCustomParam(OPTIONTYPE);
        String formatString = DateTimeEditHelper.getMinFormatString((TimeZone)timeZone);
        DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)formatString, Collections.singletonList(REALAPPROACHTIME));
        if (StringUtils.equals((CharSequence)optionType, (CharSequence)"departure")) {
            formatString = DateTimeEditHelper.getMaxFormatString((TimeZone)timeZone);
            DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)formatString, Collections.singletonList(REALDEPARTTIME));
        }
        if ((startDate = (Date)this.getModel().getValue(REALAPPROACHTIME)) != null) {
            DateTimeEdit dateTimeEdit = (DateTimeEdit)this.getControl(REALDEPARTTIME);
            dateTimeEdit.setMinDate(startDate);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String optionType = (String)this.getView().getFormShowParameter().getCustomParam(OPTIONTYPE);
        if (StringUtils.equals((CharSequence)optionType, (CharSequence)"departure")) {
            String name = e.getProperty().getName();
            ChangeData changeSet = e.getChangeSet()[0];
            Object newValue = changeSet.getNewValue();
            if (StringUtils.equals((CharSequence)REALAPPROACHTIME, (CharSequence)name)) {
                Date startDateTime = (Date)newValue;
                if (startDateTime == null) {
                    DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)REALAPPROACHTIME, (boolean)true);
                }
                DateTimeCheckHelper.startDateTimeChanged((IFormView)this.getView(), (Date)startDateTime, (String)REALDEPARTTIME, (String)ResManager.loadKDString((String)"\u5b9e\u9645\u79bb\u573a\u65f6\u95f4>\u5b9e\u9645\u8fdb\u573a\u65f6\u95f4", (String)"ResourcePlanEditPlugin_8", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), null);
            } else if (StringUtils.equals((CharSequence)REALDEPARTTIME, (CharSequence)name)) {
                Date endDateTime = (Date)newValue;
                if (endDateTime == null) {
                    DateTimeEditHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)REALDEPARTTIME, (boolean)false);
                }
                DateTimeCheckHelper.endDateTimeChanged((IFormView)this.getView(), (Date)endDateTime, (String)REALAPPROACHTIME, (String)REALDEPARTTIME, null);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        boolean success = args.getOperationResult().isSuccess();
        if ("confirm".equals(operateKey) && success) {
            Date startDate = (Date)this.getModel().getValue(REALAPPROACHTIME);
            Date endDate = (Date)this.getModel().getValue(REALDEPARTTIME);
            String optionType = (String)this.getView().getFormShowParameter().getCustomParam(OPTIONTYPE);
            if (StringUtils.equals((CharSequence)optionType, (CharSequence)"departure") && !endDate.after(startDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5b9e\u9645\u79bb\u573a\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u201c\u5b9e\u9645\u8fdb\u573a\u65f6\u95f4\u201d\u3002", (String)"ResourcePlanDateValidator_1", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]));
                return;
            }
            Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            HashMap<String, String> returnMap = new HashMap<String, String>(2);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            returnMap.put("startDate", sdf.format(startDate));
            if (StringUtils.equals((CharSequence)optionType, (CharSequence)"departure")) {
                returnMap.put("endDate", sdf.format(endDate));
            }
            returnMap.put(OPTIONTYPE, optionType);
            returnMap.put("id", id.toString());
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }
}

