/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.utils;

import java.util.HashSet;
import java.util.Set;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.property.EntryProp;

public class BillModelUtils {
    public static void reloadFields(IBillModel billModel, Set<String> fieldKeys, Runnable refreshViewRunnable) {
        billModel.beginInit();
        billModel.syncDataFromDB(fieldKeys);
        billModel.endInit();
        billModel.setDataChanged(false);
        if (refreshViewRunnable != null) {
            refreshViewRunnable.run();
        }
    }

    public static void reloadEntry(IBillView billView, String entryKey) {
        IBillModel billModel = (IBillModel)billView.getModel();
        IDataEntityProperty property = billModel.getProperty(entryKey);
        if (property instanceof EntryProp) {
            HashSet<String> fieldKeys = new HashSet<String>(16);
            BillModelUtils.addEntryFields((EntryProp)property, fieldKeys);
            BillModelUtils.reloadFields(billModel, fieldKeys, () -> billView.updateView(entryKey));
        }
    }

    private static void addEntryFields(EntryProp entryProp, Set<String> fieldKeys) {
        DataEntityPropertyCollection properties = entryProp.getDynamicCollectionItemPropertyType().getProperties();
        int size = properties.size();
        for (int i = 2; i < size; ++i) {
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)properties.get(i);
            if (StringUtils.isEmpty((CharSequence)dataEntityProperty.getAlias()) && dataEntityProperty.isDbIgnore()) continue;
            if (dataEntityProperty instanceof EntryProp) {
                BillModelUtils.addEntryFields((EntryProp)dataEntityProperty, fieldKeys);
                continue;
            }
            fieldKeys.add(dataEntityProperty.getName());
        }
        fieldKeys.add(entryProp.getName() + ".seq");
    }
}

