/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workbench;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttDecoratorSingleton;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttPageShowModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttResourceDecoratorSingleton;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttSummarySingleton;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskMoveSingleton;
import kd.bd.mpdm.common.gantt.ganttmodel.TaskFilterDecoratorSingleton;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ResourceWorkBenchOrgListPlugin
extends AbstractListPlugin {
    private static final String NAME_SUFFIX = ".name";
    private static final String NUMBER_SUFFIX = ".number";
    private static final String CACHEKEY_ORG = "bill_ctrlorgids";
    private static final String CACHEKEY_ORG_CAPTION = "org_caption";

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String mainOrg = this.getMainOrg();
        if (StringUtils.isEmpty((CharSequence)mainOrg)) {
            return;
        }
        String fieldName = args.getFieldName();
        if ((mainOrg + NAME_SUFFIX).equals(fieldName) || (mainOrg + NUMBER_SUFFIX).equals(fieldName)) {
            args.addCustomQFilter(new QFilter("id", "in", this.getCtrlUnitOrgIds()));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String mainOrg = this.getMainOrg();
        if (StringUtils.isEmpty((CharSequence)mainOrg)) {
            return;
        }
        String mainOrgName = mainOrg + NAME_SUFFIX;
        String mainOrgNumber = mainOrg + NUMBER_SUFFIX;
        args.getCommonFilterColumns().stream().filter(filterColumn -> {
            String fieldName = filterColumn.getFieldName();
            return mainOrgNumber.equals(fieldName) || mainOrgName.equals(fieldName);
        }).findFirst().ifPresent(filterColumn -> {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            commonFilterColumn.setMulti(false);
            commonFilterColumn.setMustInput(true);
            List comboItems = commonFilterColumn.getComboItems();
            if (comboItems.isEmpty()) {
                this.getPageCache().put(CACHEKEY_ORG_CAPTION, commonFilterColumn.getCaption().getLocaleValue());
            }
        });
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        GanttPageShowModel pageShowModel = new GanttPageShowModel();
        pageShowModel.setIsTaskBorderShow(Boolean.TRUE);
        pageShowModel.setIsLineShow(Boolean.TRUE);
        pageShowModel.setIsRowCheckBoxShow(Boolean.TRUE);
        pageShowModel.setNormalBarsShow(Boolean.TRUE);
        pageShowModel.setWeekedBgShow(Boolean.FALSE);
        GanttCacheUtils.cacheBigObject((String)this.getView().getPageId(), (String)"defaultPageShowSet", (Object)pageShowModel);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        GanttTaskMoveSingleton.getSingleInstance().registerDragCommand("pmpd_resourceplan", billFormId, "kd.pmc.pmpd.formplugin.workbench.command.DragResourcePlanCommand");
        GanttDecoratorSingleton.getSingleInstance().registerDecoratorClass("pmpd_resourceplan", "kd.pmc.pmpd.formplugin.workbench.decorator.ResourceDragDecorator");
        GanttResourceDecoratorSingleton.getSingleInstance().registerDecoratorClass("mpdm_workcenter_info", "kd.pmc.pmpd.formplugin.workbench.decorator.ResourcePlanFeatureNumDecorator");
        GanttSummarySingleton.getSingleInstance().registerSummaryImplClass("pmpd_resourceplan", billFormId, "kd.pmc.pmps.business.gantt.ResourceSummaryDataServiceImpl");
        TaskFilterDecoratorSingleton.getSingleInstance().registerDecoratorClass("pmpd_resourceplan", billFormId, "kd.pmc.pmpd.formplugin.workbench.decorator.ResourceTaskFilterDecorator");
        this.getPageCache().put("needFilterFields", SerializationUtils.toJsonString(Arrays.asList("projectorg.name", "org.name")));
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String mainOrg = this.getMainOrg();
        if (StringUtils.isEmpty((CharSequence)mainOrg)) {
            return;
        }
        String fieldName = args.getFieldName();
        if ((mainOrg + NAME_SUFFIX).equals(fieldName) || (mainOrg + NUMBER_SUFFIX).equals(fieldName)) {
            args.addCustomQFilter(new QFilter("id", "in", this.getCtrlUnitOrgIds()));
        }
    }

    private String getMainOrg() {
        IListView listView = (IListView)this.getView();
        return ((BillEntityType)listView.getListModel().getDataEntityType()).getMainOrg();
    }

    private Set<Object> getCtrlUnitOrgIds() {
        String cacheJson = this.getPageCache().get(CACHEKEY_ORG);
        if (cacheJson != null) {
            return (Set)SerializationUtils.fromJsonString((String)cacheJson, Set.class);
        }
        QFilter[] filters = new QFilter[]{new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE), new QFilter("view.number", "=", (Object)"ProjectManageSchemeDefault")};
        Map structureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org", (QFilter[])filters);
        if (structureMap.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet ids = Sets.newHashSetWithExpectedSize((int)structureMap.size());
        for (Map.Entry entry : structureMap.entrySet()) {
            ids.add(((DynamicObject)entry.getValue()).get("org_id"));
        }
        this.getPageCache().put(CACHEKEY_ORG, SerializationUtils.toJsonString((Object)ids));
        return ids;
    }
}

