/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workinghours;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.business.workhour.WorkHourTemplateHelper;
import kd.pmc.pmpd.common.bigtask.BigTaskHelper;
import kd.pmc.pmpd.common.helper.DateTimeCheckHelper;
import kd.pmc.pmpd.formplugin.workinghours.CalculateFactory;
import kd.pmc.pmpd.formplugin.workinghours.strategy.ICalculateStrategy;

public abstract class AbstractWorkHourTemplateEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String SIMILAR_PROJECT = "similarProject";
    private static final String BAR_PROJECT = "bar_project";
    protected static final String BAR_CALCULATE = "bar_calculate";
    private static final String BAR_VIEW_HISTORY = "bar_viewhistory";
    private static final String OP_CHANGE = "change";
    private static final String OP_AUDIT = "audit";
    private static final String CALLBACKID_CALCULATE = "calculate";
    private static final String CALLBACKID_CHANGE = "change";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit industryEdit = (BasedataEdit)this.getControl("industry");
        if (industryEdit != null) {
            industryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Date effectiveDate = (Date)this.getModel().getValue("effectivedate");
        if (effectiveDate != null) {
            this.setMinDate(effectiveDate);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("industry".equals(beforeF7SelectEvent.getProperty().getName())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (entryEntity.isEmpty()) {
                return;
            }
            Set existedIndustryIds = entryEntity.stream().map(dynamicObject -> dynamicObject.getLong("industry_id")).collect(Collectors.toSet());
            List customQFilters = beforeF7SelectEvent.getCustomQFilters();
            customQFilters.add(new QFilter("id", "not in", existedIndustryIds));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BAR_PROJECT.equals(itemKey)) {
            DynamicObject obj = this.getModel().getDataEntity(true);
            OperationResult saveResult = SaveServiceHelper.saveOperate((String)this.getModel().getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)OperateOption.create());
            if (saveResult.isSuccess()) {
                if (this.getModel().getValue("similarprojectscheme") != null) {
                    this.getSimilarProject();
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u76f8\u4f3c\u9879\u76ee\u65b9\u6848\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u76f8\u4f3c\u9879\u76ee\u65b9\u6848\u3002", (String)"AbstractWorkHourTemplateEditPlugin_5", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            }
        } else if (BAR_CALCULATE.equals(itemKey)) {
            this.showAlgorithmConfigForm();
        } else if (BAR_VIEW_HISTORY.equals(itemKey)) {
            this.showHistory();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (OP_AUDIT.equals(formOperate.getOperateKey())) {
            String status = (String)this.getModel().getValue("status");
            if ("D".equals(status)) {
                formOperate.getOption().setVariableValue("enableIds", String.valueOf(this.getModel().getValue("id")));
            }
        } else if (args.getSource() instanceof Save || args.getSource() instanceof Submit) {
            if (((DynamicObjectCollection)this.getModel().getValue("similarproject")).size() != 0) {
                this.getModel().setValue("tempsourcetype", (Object)Character.valueOf('A'));
            } else {
                this.getModel().setValue("tempsourcetype", (Object)Character.valueOf('B'));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("change".equals(operateKey) && operationResult.isSuccess()) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getPageCache().put("refreshList", "1");
        } else if (OP_AUDIT.equals(operateKey) && operationResult.isSuccess()) {
            FormOperate formOperate = (FormOperate)args.getSource();
            OperateOption option = formOperate.getOption();
            String enableIdStr = option.getVariableValue("enableIds", "");
            if (StringUtils.isEmpty((CharSequence)enableIdStr)) {
                return;
            }
            long createOrgId = (Long)this.getModel().getValue("createorg_id");
            ArrayList templateIds = Lists.newArrayList((Object[])new Long[]{Long.parseLong(enableIdStr)});
            try {
                WorkHourTemplateHelper.afterAudit((AbstractFormPlugin)this, (String)this.getView().getEntityId(), (List)templateIds, (long)createOrgId);
            }
            catch (Exception exception) {
                this.rollback();
                throw exception;
            }
        }
    }

    private void rollback() {
        this.getModel().setValue("status", (Object)"D");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isshowmessage", "false");
        this.getView().invokeOperation("save", operateOption);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("effectivedate".equals(name)) {
            this.effectiveDateChanged(changeData);
        } else if ("expirationdate".equals(name)) {
            this.expirationDateChanged(changeData);
        } else if ("checktype".equals(name)) {
            DynamicObject checktypeDObj = (DynamicObject)this.getModel().getValue("checktype");
            if (checktypeDObj != null) {
                long value = (Long)checktypeDObj.getPkValue();
                String fields = "checklevel";
                QFilter[] qFilters = new QFilter("id", "=", (Object)value).toArray();
                DynamicObject dobj = QueryServiceHelper.queryOne((String)"mpdm_checktype", (String)fields, (QFilter[])qFilters);
                this.getModel().setValue("checklevel", dobj == null ? "" : Long.valueOf(dobj.getLong("checklevel")));
            } else {
                this.getModel().setValue("checklevel", (Object)"");
            }
        }
        if (this.getView().getPageCache().get("tag") == null) {
            if ("similarprojectscheme".equals(name)) {
                this.getView().getPageCache().put("tag", "1");
                this.getModel().setValue("similarproject", (Object)new Long[]{0L});
            } else if ("similarproject".equals(name)) {
                this.getView().getPageCache().put("tag", "1");
                this.getModel().setValue("similarprojectscheme", (Object)"");
            }
        } else {
            this.getView().getPageCache().remove("tag");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (SIMILAR_PROJECT.equals(actionId) && returnData instanceof Map) {
            Map returnMap = (Map)returnData;
            this.similarProjectCallBack(returnMap);
        } else if (CALLBACKID_CALCULATE.equals(actionId) && returnData instanceof String) {
            String method = (String)returnData;
            DynamicObjectCollection collection = (DynamicObjectCollection)this.getModel().getValue("similarproject");
            List<Object> projectIds = collection.stream().map(dynamicObject -> dynamicObject.get("fbasedataid_id")).collect(Collectors.toList());
            ICalculateStrategy calculateStrategy = CalculateFactory.get(method);
            if (this.calculate(calculateStrategy, projectIds)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u5de5\u65f6\u6210\u529f\u3002", (String)"AbstractWorkHourTemplateEditPlugin_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            }
        } else if ("change".equals(actionId) && returnData instanceof Map) {
            BigTaskHelper.showBigTaskResult((IFormView)this.getView(), (Map)((Map)returnData), data -> this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6a21\u677f\u53d8\u66f4\u6210\u529f\u3002", (String)"AbstractWorkHourTemplateEditPlugin_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0])));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IFormView parentView;
        super.beforeClosed(e);
        String refreshList = this.getPageCache().get("refreshList");
        if (StringUtils.isNotEmpty((CharSequence)refreshList) && (parentView = this.getView().getParentView()) instanceof ListView) {
            ((ListView)parentView).refresh();
        }
    }

    protected abstract boolean calculate(ICalculateStrategy var1, List<Object> var2);

    private void similarProjectCallBack(Map<String, Object> returnMap) {
        String paramId = (String)returnMap.getOrDefault("paramid", "0");
        this.getModel().setValue("similarprojectscheme", (Object)Long.parseLong(paramId));
        String projectJson = (String)returnMap.get(SIMILAR_PROJECT);
        if (StringUtils.isBlank((CharSequence)projectJson)) {
            return;
        }
        Map number2PorjectId = (Map)SerializationUtils.fromJsonString((String)projectJson, HashMap.class);
        if (number2PorjectId.isEmpty()) {
            return;
        }
        String number = (String)this.getModel().getValue("number");
        List projectIds = (List)number2PorjectId.get(number);
        if (projectIds == null || projectIds.isEmpty()) {
            return;
        }
        Object[] pkIds = new Object[projectIds.size()];
        int size = projectIds.size();
        for (int i = 0; i < size; ++i) {
            pkIds[i] = Long.parseLong((String)projectIds.get(i));
        }
        this.getModel().setValue("similarproject", (Object)pkIds);
    }

    private void effectiveDateChanged(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        DateTimeCheckHelper.startDateTimeChanged((IFormView)this.getView(), (Date)((Date)newValue), (String)"expirationdate", (String)ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f>\u751f\u6548\u65e5\u671f", (String)"AbstractWorkHourTemplateEditPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), null);
        if (newValue != null) {
            Date value = (Date)newValue;
            this.setMinDate(value);
        }
    }

    private void expirationDateChanged(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        DateTimeCheckHelper.endDateTimeChanged((IFormView)this.getView(), (Date)((Date)newValue), (String)"effectivedate", (String)"expirationdate", null);
    }

    public void getSimilarProject() {
        DynamicObject dObj = (DynamicObject)this.getModel().getValue("similarprojectscheme");
        long similarprojectschemeId = Long.parseLong(dObj.getPkValue().toString());
        String selectField = "id";
        QFilter qFilter = new QFilter("number", "=", this.getModel().getValue("number"));
        String entityName = this.getView().getEntityId();
        DynamicObject currentEntityIdObj = QueryServiceHelper.queryOne((String)entityName, (String)selectField, (QFilter[])qFilter.toArray());
        if (currentEntityIdObj != null) {
            long currentEntityId = (Long)currentEntityIdObj.get("id");
            Map o = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pmpd", (String)"ISimilarProjectService", (String)"getSimilarProject", (Object[])new Object[]{currentEntityId, similarprojectschemeId});
            String resultStringJson = (String)o.get("result");
            this.getView().getPageCache().put("tag", "1");
            if (!("[]".equals(resultStringJson) || "".equals(resultStringJson) || ObjectUtils.isEmpty((Object)resultStringJson))) {
                String resultString = resultStringJson.substring(1).substring(0, resultStringJson.length() - 2);
                String[] resultStrings = resultString.split(",");
                List<Long> projectIds = Arrays.stream(resultStrings).map(str -> Long.parseLong(str.trim())).collect(Collectors.toList());
                Long[] projectIdsArr = projectIds.toArray(new Long[projectIds.size()]);
                this.getModel().setValue("similarproject", (Object)projectIdsArr);
            } else {
                this.getModel().setValue("similarproject", (Object)new Long[]{0L});
            }
        }
    }

    private void setMinDate(Date effectiveDate) {
        DateTimeEdit dateTimeEdit = (DateTimeEdit)this.getControl("expirationdate");
        if (dateTimeEdit != null) {
            dateTimeEdit.setMinDate(effectiveDate);
        }
    }

    private void showHistory() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)this.getModel().getDataEntityType().getName(), (boolean)false);
        listShowParameter.setFormId("pmpd_view_listf7");
        listShowParameter.setCustomParam("number", this.getModel().getValue("number"));
        FormConfig formConfig = this.getView().getFormShowParameter().getFormConfig();
        String caption = String.format(ResManager.loadKDString((String)"%s\u5386\u53f2\u6570\u636e", (String)"AbstractWorkHourTemplateEditPlugin_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), formConfig.getCaption().getLocaleValue());
        listShowParameter.setCaption(caption);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showAlgorithmConfigForm() {
        DynamicObjectCollection collection = (DynamicObjectCollection)this.getModel().getValue("similarproject");
        if (collection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76f8\u4f3c\u9879\u76ee\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u76f8\u4f3c\u9879\u76ee\u3002", (String)"AbstractWorkHourTemplateEditPlugin_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pmpd_algorithm_config");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKID_CALCULATE));
        this.getView().showForm(formShowParameter);
    }
}

