/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workinghours;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.pmc.pmpd.formplugin.workinghours.strategy.AverageValueStrategy;
import kd.pmc.pmpd.formplugin.workinghours.strategy.GymnasticsStrategy;
import kd.pmc.pmpd.formplugin.workinghours.strategy.ICalculateStrategy;
import kd.pmc.pmpd.formplugin.workinghours.strategy.MaximumValueStrategy;
import kd.pmc.pmpd.formplugin.workinghours.strategy.MedianValueStrategy;
import kd.pmc.pmpd.formplugin.workinghours.strategy.MinimumValueStrategy;

class CalculateFactory {
    private static final Map<String, ICalculateStrategy> STRATEGY_MAP = Maps.newHashMapWithExpectedSize((int)5);

    CalculateFactory() {
    }

    static ICalculateStrategy get(String calculateMethod) {
        return STRATEGY_MAP.get(calculateMethod);
    }

    static ICalculateStrategy getAverageValueStrategy() {
        return STRATEGY_MAP.get("average");
    }

    static {
        STRATEGY_MAP.put("min", new MinimumValueStrategy());
        STRATEGY_MAP.put("max", new MaximumValueStrategy());
        STRATEGY_MAP.put("average", new AverageValueStrategy());
        STRATEGY_MAP.put("median", new MedianValueStrategy());
        STRATEGY_MAP.put("gymnastics", new GymnasticsStrategy());
    }
}

