/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workinghours;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class EstWorkloadReportFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    String DISPLAY = "display";
    DynamicObjectCollection rowData = new DynamicObjectCollection();

    public void initialize() {
        super.initialize();
        OrgEdit orgEdit = (OrgEdit)this.getControl("projectorg");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        if (!ObjectUtils.isEmpty((Object)reportList)) {
            reportList.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date statisticalyearDate;
        String name = e.getProperty().getName();
        if ("display".equals(name)) {
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)this.DISPLAY, (String)SerializationUtils.toJsonString((Object)this.getModel().getValue("display")));
        }
        if ("statisticalyear".equals(name) && (statisticalyearDate = (Date)this.getModel().getValue("statisticalyear")) != null) {
            this.setBeginTime(statisticalyearDate);
            this.setEndTime(statisticalyearDate);
        }
        if ("begintime".equals(name) || "endtime".equals(name)) {
            Date date;
            Object time = this.getModel().getValue("begintime");
            if (!ObjectUtils.isEmpty((Object)time)) {
                date = EstWorkloadReportFormPlugin.setDateHMSToEndString((Date)time);
                this.getModel().setValue("begintime", (Object)date);
            }
            if (!ObjectUtils.isEmpty((Object)(time = this.getModel().getValue("endtime")))) {
                date = EstWorkloadReportFormPlugin.setDateHMSToEndString((Date)time);
                this.getModel().setValue("endtime", (Object)date);
            }
        }
    }

    public static Date setDateHMSToZero(Date date) {
        if (!ObjectUtils.isEmpty((Object)date)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        return new Date();
    }

    public static Date setDateHMSToEndString(Date date) {
        if (!ObjectUtils.isEmpty((Object)date)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 59);
            return cal.getTime();
        }
        return new Date();
    }

    public void afterCreateNewData(EventObject e) {
        Boolean display;
        long orgId = RequestContext.get().getOrgId();
        List orgIds = this.getOrgIds();
        if (!orgIds.contains(orgId)) {
            orgId = orgIds.size() > 0 ? (Long)orgIds.get(0) : 0L;
        }
        this.getModel().setValue("projectorg", (Object)orgId);
        Date date = new Date(System.currentTimeMillis());
        this.setBeginTime(date);
        this.setEndTime(date);
        this.getModel().setValue("statisticalyear", (Object)date);
        String setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)this.DISPLAY);
        if (!ObjectUtils.isEmpty((Object)setting) && !ObjectUtils.isEmpty((Object)(display = (Boolean)SerializationUtils.fromJsonString((String)setting, Boolean.class)))) {
            this.getModel().setValue("display", (Object)display);
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        this.rowData = rowData;
        Date yearDate = (Date)this.getModel().getValue("statisticalyear");
        Calendar yearCal = Calendar.getInstance();
        yearCal.setTime(yearDate);
        Iterator iterator = rowData.iterator();
        int year = yearCal.get(1);
        while (iterator.hasNext()) {
            DynamicObject row = (DynamicObject)iterator.next();
            if ("null".equals(row.get("projectbillnos").toString()) || row.get("projectbillnos") == null) {
                row.set("projectbillnos", (Object)"");
                row.set("projectnames", (Object)"");
                row.set("planners", (Object)"");
            }
            BigDecimal sum = row.getBigDecimal("beforeyearhour").add(row.getBigDecimal("afteryearhour")).add(row.getBigDecimal("jan")).add(row.getBigDecimal("feb")).add(row.getBigDecimal("mar")).add(row.getBigDecimal("apr")).add(row.getBigDecimal("may")).add(row.getBigDecimal("jun")).add(row.getBigDecimal("jul")).add(row.getBigDecimal("aug")).add(row.getBigDecimal("sep")).add(row.getBigDecimal("oct")).add(row.getBigDecimal("nov")).add(row.getBigDecimal("dec"));
            row.set("totalwkhour2", (Object)sum);
            row.set("totalplannedwkhour", (Object)sum);
            row.set("year", (Object)year);
        }
    }

    public void setBeginTime(Date statisticalyearDate) {
        Calendar calInstance = Calendar.getInstance();
        calInstance.setTime(statisticalyearDate);
        int year = calInstance.get(1);
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.set(1, year);
        beginCalendar.set(2, 0);
        beginCalendar.set(5, 1);
        beginCalendar.set(11, 0);
        beginCalendar.set(12, 0);
        beginCalendar.set(13, 0);
        beginCalendar.set(14, 0);
        this.getModel().setValue("begintime", (Object)beginCalendar.getTime());
    }

    public void setEndTime(Date statisticalyearDate) {
        Calendar calInstance = Calendar.getInstance();
        calInstance.setTime(statisticalyearDate);
        int year = calInstance.get(1);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.set(1, year);
        endCalendar.set(2, 11);
        endCalendar.set(5, 31);
        endCalendar.set(11, 23);
        endCalendar.set(12, 59);
        endCalendar.set(13, 59);
        endCalendar.set(14, 59);
        this.getModel().setValue("endtime", (Object)endCalendar.getTime());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        StringBuilder sb = new StringBuilder();
        if (filter.getValue("projectorg") == null) {
            sb.append(ResManager.loadKDString((String)"\u9879\u76ee\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002\n", (String)"EstWorkloadReportPlugin_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
        if (filter.getValue("statisticalyear") == null) {
            sb.append(ResManager.loadKDString((String)"\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002\n", (String)"EstWorkloadReportPlugin_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
        if (filter.getValue("pulishstatusft") == null) {
            sb.append(ResManager.loadKDString((String)"\u53d1\u5e03\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002\n", (String)"EstWorkloadReportPlugin_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
        if (sb.length() != 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u67e5\u8be2\u6761\u4ef6\u3002", (String)"EstWorkloadReportPlugin_5", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (this.rowData != null && this.rowData.size() != 0) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("pmpd_resourceplan");
            String selectFields = "id";
            QFilter[] qFilters = new QFilter[]{new QFilter("billno", "=", ((DynamicObject)this.rowData.get(0)).get("resbillno")).and(new QFilter("pulishstatus", "=", this.getModel().getValue("pulishstatusft")))};
            DynamicObject object = QueryServiceHelper.queryOne((String)"pmpd_resourceplan", (String)selectFields, (QFilter[])qFilters);
            if (!ObjectUtils.isEmpty((Object)object)) {
                billShowParameter.setPkId((Object)object.getLong("id"));
                billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                billShowParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)billShowParameter);
            }
        }
    }

    private List getOrgIds() {
        QFilter[] filters = new QFilter[]{new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE), new QFilter("view.number", "=", (Object)"ProjectManageSchemeDefault")};
        Map structureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org", (QFilter[])filters);
        if (!structureMap.isEmpty()) {
            ArrayList ids = Lists.newArrayListWithExpectedSize((int)structureMap.size());
            for (Map.Entry entry : structureMap.entrySet()) {
                ids.add(((DynamicObject)entry.getValue()).get("org_id"));
            }
            ArrayList<Long> orgIds = new ArrayList<Long>(8);
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), null, (String)"pmpd_estimatewkloadreport", (String)"47150e89000000ac");
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                Iterator iterator = hasPermOrgResult.getHasPermOrgs().iterator();
                while (iterator.hasNext()) {
                    long orgId = (Long)iterator.next();
                    if (!ids.contains(orgId)) continue;
                    orgIds.add(orgId);
                }
                if (orgIds.isEmpty()) {
                    return ids;
                }
                return orgIds;
            }
            return ids;
        }
        return new ArrayList();
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        if (StringUtils.equals((CharSequence)args.getProperty().getName(), (CharSequence)"projectorg")) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)this.getOrgIds()));
        }
    }
}

