/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workinghours;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EstWorkloadReportPlugin
extends AbstractReportListDataPlugin {
    public static final String resPlanAlgoKey = EstWorkloadReportPlugin.class.getName();
    Date startDate;
    int year;
    private static final Log logger = LogFactory.getLog(EstWorkloadReportPlugin.class);
    public static String[] selectFields = new String[]{"resbillno", "customer", "overdevice", "mrtypemodel", "resourceplanstatus", "executestatus", "fixlevel", "workscope", "workcenter", "repaircycleroundup", "estiapproachtime", "estideparttime", "repaircycle", "preapproachtime", "predeparttime", "workrepaircycle", "projectbillnos", "projectnames", "totalsalehour", "beforeyearhour", "afteryearhour", "jan", "apr", "jul", "oct", "feb", "may", "aug", "nov", "mar", "jun", "sep", "dec", "planners", "id"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        logger.info("\u3010\u5f00\u59cb EstWorkloadReportPlugin\u3011\uff1a\u62a5\u8868\u67e5\u8be2query\u65b9\u6cd5");
        String selectedResProperty = this.getResSelectFields();
        List<QFilter> qResFilterList = this.createResFilters();
        QFilter[] qResFilters = qResFilterList.toArray(new QFilter[0]);
        logger.info("\u3010\u5f00\u59cb EstWorkloadReportPlugin01\u3011\uff1a\u6839\u636e\u62a5\u8868\u8fc7\u6ee4\u6761\u4ef6\u67e5\u8be2\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212");
        DataSet resDataSet = QueryServiceHelper.queryDataSet((String)(resPlanAlgoKey + "pmpd_resourceplan"), (String)"pmpd_resourceplan", (String)selectedResProperty, (QFilter[])qResFilters, null);
        logger.info("\u3010\u7ed3\u675f EstWorkloadReportPlugin01\u3011\uff1a\u6839\u636e\u62a5\u8868\u8fc7\u6ee4\u6761\u4ef6\u67e5\u8be2\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212");
        logger.info("\u3010\u5f00\u59cb EstWorkloadReportPlugin02\u3011\uff1a\u6574\u5408\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u7684\u591a\u4e2a\u9879\u76ee\u7f16\u7801\u3001\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u8ba1\u5212\u5458");
        DataSet resWithProDataSet = this.resWithProDataSet(resDataSet);
        resDataSet = resDataSet.leftJoin(resWithProDataSet).on("id", "id").select(resDataSet.getRowMeta().getFieldNames(), new String[]{"projectbillnos", "projectnames", "planners"}).finish();
        logger.info("\u3010\u7ed3\u675f EstWorkloadReportPlugin02\u3011\uff1a\u6574\u5408\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u7684\u591a\u4e2a\u9879\u76ee\u7f16\u7801\u3001\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u8ba1\u5212\u5458");
        HashSet<String> resIds = new HashSet<String>();
        resDataSet.copy().forEach(row -> resIds.add(row.getString("resbillno")));
        logger.info("\u3010\u5f00\u59cb EstWorkloadReportPlugin03\u3011\uff1a\u67e5\u8be2\u6708\u5de5\u65f6\u7edf\u8ba1\u5355");
        DataSet monthHourBillDataSet = this.createMonthHourBillDataSet(resIds);
        logger.info("\u3010\u7ed3\u675f EstWorkloadReportPlugin03\u3011\uff1a\u67e5\u8be2\u6708\u5de5\u65f6\u7edf\u8ba1\u5355");
        DataSet resultDataSet = !this.getQueryParam().getFilter().getBoolean("display") ? monthHourBillDataSet.leftJoin(resDataSet).on("billno1", "resbillno").select(monthHourBillDataSet.getRowMeta().getFieldNames(), resDataSet.getRowMeta().getFieldNames()).finish() : resDataSet.leftJoin(monthHourBillDataSet).on("resbillno", "billno1").select(resDataSet.getRowMeta().getFieldNames(), monthHourBillDataSet.getRowMeta().getFieldNames()).finish();
        logger.info("\u3010\u7ed3\u675f EstWorkloadReportPlugin\u3011\uff1a\u62a5\u8868\u67e5\u8be2query\u65b9\u6cd5");
        return resultDataSet.groupBy(selectFields).finish();
    }

    private DataSet createMonthHourBillDataSet(Set<String> resIds) {
        HashSet<Long> resIdLongs = new HashSet<Long>();
        DynamicObjectCollection resIdsCollection = QueryServiceHelper.query((String)"pmpd_resourceplan", (String)"id", (QFilter[])new QFilter("billno", "in", resIds).toArray());
        for (DynamicObject dObj : resIdsCollection) {
            resIdLongs.add(dObj.getLong("id"));
        }
        DataSet monthHourBillAllDataSet = this.getMonthHourBillAllDataSet(resIdLongs);
        DataSet currentYearMonthHourBillDataSet = this.getCurrentYearMonthHourBillDataSet(monthHourBillAllDataSet);
        DataSet beforeYearMonthHourBillDataSet = this.getBeforeYearMonthHourBillDataSet(monthHourBillAllDataSet);
        DataSet afterYearMonthHourBillDataSet = this.getAfterYearMonthHourBillDataSet(monthHourBillAllDataSet);
        DataSet monthHourBillDataSet = currentYearMonthHourBillDataSet.leftJoin(beforeYearMonthHourBillDataSet).on("resourceplan", "resourceplan").select(currentYearMonthHourBillDataSet.getRowMeta().getFieldNames(), new String[]{"beforeyearhour"}).finish();
        monthHourBillDataSet = monthHourBillDataSet.leftJoin(afterYearMonthHourBillDataSet).on("resourceplan", "resourceplan").select(monthHourBillDataSet.getRowMeta().getFieldNames(), new String[]{"afteryearhour"}).finish();
        return monthHourBillDataSet;
    }

    private DataSet getAfterYearMonthHourBillDataSet(DataSet monthHourBillAllDataSet) {
        DataSet afterYearMonthHourBillDataSet = monthHourBillAllDataSet.filter("tyear > " + this.year);
        afterYearMonthHourBillDataSet = afterYearMonthHourBillDataSet.addField("jan+feb+mar+apr+may+jun+jul+aug+sep+oct+nov+dec", "afterhour");
        afterYearMonthHourBillDataSet = afterYearMonthHourBillDataSet.filter("1=1").groupBy(new String[]{"resourceplan"}).sum("afterhour", "afteryearhour").finish();
        return afterYearMonthHourBillDataSet;
    }

    private DataSet getBeforeYearMonthHourBillDataSet(DataSet monthHourBillAllDataSet) {
        DataSet beforeYearMonthHourBillDataSet = monthHourBillAllDataSet.filter("tyear < " + this.year);
        beforeYearMonthHourBillDataSet = beforeYearMonthHourBillDataSet.addField("jan+feb+mar+apr+may+jun+jul+aug+sep+oct+nov+dec", "beforehour");
        beforeYearMonthHourBillDataSet = beforeYearMonthHourBillDataSet.filter("1=1").groupBy(new String[]{"resourceplan"}).sum("beforehour", "beforeyearhour").finish();
        return beforeYearMonthHourBillDataSet;
    }

    private DataSet getCurrentYearMonthHourBillDataSet(DataSet monthHourBillAllDataSet) {
        DataSet currentYearMonthHourBillDataSet = monthHourBillAllDataSet.filter("tyear=" + this.year);
        return currentYearMonthHourBillDataSet;
    }

    private DataSet getMonthHourBillAllDataSet(Set<Long> resIds) {
        String properties = this.getMonthHourBillSelectFields();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("resourceplan", "in", resIds));
        DataSet monthHourBillAllDataSet = QueryServiceHelper.queryDataSet((String)(resPlanAlgoKey + "pmpd_monthhourbill"), (String)"pmpd_monthhourbill", (String)properties, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        return monthHourBillAllDataSet;
    }

    private String getMonthHourBillSelectFields() {
        return "resourceplan,resourceplan.billno AS billno1,entryentity_total.tyear AS tyear,entryentity_total.tjanuary AS jan,entryentity_total.tfebruary AS feb,entryentity_total.tmarch AS mar,entryentity_total.tapril AS apr,entryentity_total.tmay AS may,entryentity_total.tjune AS jun,entryentity_total.tjuly AS jul,entryentity_total.taugust AS aug,entryentity_total.tseptember AS sep,entryentity_total.toctober AS oct,entryentity_total.tnovember AS nov,entryentity_total.tdecember AS dec,entryentity_total.ttotal AS ttotal";
    }

    private DataSet resWithProDataSet(DataSet resDataSet) {
        DataSet newDataSet = resDataSet.groupBy(new String[]{"id"}).groupConcat("projectbillno", "projectbillnos", "\uff0c").groupConcat("projectname", "projectnames", "\uff0c").groupConcat("planner", "planners", "\uff0c").finish();
        return newDataSet.groupBy(new String[]{"id", "projectbillnos", "projectnames", "planners"}).finish();
    }

    private List<QFilter> createResFilters() {
        FilterInfo filter = this.getQueryParam().getFilter();
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        this.createProjectOrgFilter(filter, qfList);
        this.createOrgFilter(filter, qfList);
        this.createYearFilterField(filter);
        this.createEstiapproachTimeFilter(filter, qfList);
        this.createCustomerFilter(filter, qfList);
        this.createOverDeviceFilter(filter, qfList);
        this.createFixModelFilter(filter, qfList);
        this.createWorkCenterFilter(filter, qfList);
        this.createPulishStatusFilter(filter, qfList);
        return qfList;
    }

    private void createYearFilterField(FilterInfo filter) {
        this.startDate = filter.getDate("statisticalyear");
        if (this.startDate != null) {
            Calendar calStart = Calendar.getInstance();
            calStart.setTime(this.startDate);
            this.year = calStart.get(1);
            calStart.set(this.year, 0, 0, 0, 0, 0);
            this.startDate = calStart.getTime();
        }
    }

    private void createProjectOrgFilter(FilterInfo filter, ArrayList<QFilter> qfList) {
        DynamicObject projectorg = filter.getDynamicObject("projectorg");
        if (projectorg != null) {
            qfList.add(new QFilter("projectorg", "=", projectorg.getPkValue()));
        }
    }

    private void createOrgFilter(FilterInfo filter, ArrayList<QFilter> qfList) {
        DynamicObject org = filter.getDynamicObject("org");
        if (org != null) {
            qfList.add(new QFilter("org", "=", org.getPkValue()));
        }
    }

    private void createEstiapproachTimeFilter(FilterInfo filter, ArrayList<QFilter> qfList) {
        Date beginDate = filter.getDate("begintime");
        Date endDate = filter.getDate("endtime");
        Calendar beginCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        QFilter qFilter = null;
        if (beginDate != null) {
            beginCal.setTime(beginDate);
            beginCal.set(10, 0);
            beginCal.set(11, 0);
            beginCal.set(12, 0);
            beginCal.set(13, 0);
            beginCal.set(14, 0);
        }
        if (endDate != null) {
            endCal.setTime(endDate);
            endCal.set(11, 23);
            endCal.set(12, 59);
            endCal.set(13, 59);
            endCal.set(14, 59);
        }
        if (endDate != null) {
            qFilter = new QFilter("estiapproachtime", "<=", (Object)endCal.getTime());
        }
        if (this.startDate != null && qFilter != null) {
            qFilter.and(new QFilter("estideparttime", ">=", (Object)beginCal.getTime()));
            qfList.add(qFilter);
        }
    }

    private void createCustomerFilter(FilterInfo filter, ArrayList<QFilter> qfList) {
        DynamicObject customerft = filter.getDynamicObject("customerft");
        if (customerft != null) {
            qfList.add(new QFilter("customer", "=", customerft.getPkValue()));
        }
    }

    private void createOverDeviceFilter(FilterInfo filter, ArrayList<QFilter> qfList) {
        DynamicObject overdeviceft = filter.getDynamicObject("overdeviceft");
        if (overdeviceft != null) {
            qfList.add(new QFilter("overdevice", "=", overdeviceft.getPkValue()));
        }
    }

    private void createFixModelFilter(FilterInfo filter, ArrayList<QFilter> qfList) {
        DynamicObjectCollection fixmodels = filter.getDynamicObjectCollection("fixmodels");
        HashSet fixmodelSet = new HashSet(8);
        if (!ObjectUtils.isEmpty((Object)fixmodels) && fixmodels.size() > 0) {
            fixmodels.forEach(t -> fixmodelSet.add((Long)t.getPkValue()));
        }
        if (fixmodelSet != null && fixmodelSet.size() > 0) {
            qfList.add(new QFilter("fixmodel", "in", fixmodelSet));
        }
    }

    private void createWorkCenterFilter(FilterInfo filter, ArrayList<QFilter> qfList) {
        DynamicObject workcenterft = filter.getDynamicObject("workcenterft");
        if (workcenterft != null) {
            qfList.add(new QFilter("workcenter", "=", workcenterft.getPkValue()));
        }
    }

    private void createPulishStatusFilter(FilterInfo filter, ArrayList<QFilter> qfList) {
        Object pulishstatusft = filter.getValue("pulishstatusft");
        if (pulishstatusft != null) {
            qfList.add(new QFilter("pulishstatus", "=", (Object)Character.valueOf(pulishstatusft.toString().charAt(0))));
        }
        qfList.add(new QFilter("version", "=", (Object)0L));
    }

    private String getResSelectFields() {
        String propertys = "id,billno AS resbillno,customer,overdevice,fixmodel AS mrtypemodel,resourceplanstatus,executestatus,fixlevel,workscope,workcenter,estiapproachtime,estideparttime,repaircycle,repaircycleroundup,preapproachtime,predeparttime,workrepaircycle,entry_project.projcet.number AS projectbillno,entry_project.projcet.name AS projectname,entry_project.projcet.planner AS planner,salehours AS totalsalehour";
        return propertys;
    }
}

