/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workinghours;

import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.pmc.pmpd.common.consts.WorkHourTemplateConsts;
import kd.pmc.pmpd.common.helper.IndustryMappingHelper;
import kd.pmc.pmpd.common.helper.LocaleStringHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.helper.control.EntryGridHelper;
import kd.pmc.pmpd.formplugin.model.IndustryWorkHourBo;
import kd.pmc.pmpd.formplugin.workinghours.AbstractWorkHourTemplateEditPlugin;
import kd.pmc.pmpd.formplugin.workinghours.CalculateFactory;
import kd.pmc.pmpd.formplugin.workinghours.strategy.AverageValueStrategy;
import kd.pmc.pmpd.formplugin.workinghours.strategy.ICalculateStrategy;

public class EstimatedHoursTemplateEditPlugin
extends AbstractWorkHourTemplateEditPlugin {
    private static final Log LOG = LogFactory.getLog(EstimatedHoursTemplateEditPlugin.class);

    @Override
    protected boolean calculate(ICalculateStrategy calculateStrategy, List<Object> projectIds) {
        QFilter[] filters = new QFilter[]{new QFilter("project", "in", projectIds), new QFilter("billstatus", "=", (Object)"C")};
        Table industryMappingCache = IndustryMappingHelper.getMappingFromCache();
        try (DataSet dataSet = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getSimpleName(), "sfc_mromanuftech", "project, oprentryentity.oprprofessiona, oprentryentity.oprworkhours, transactiontype, mftentryseq.area", filters);){
            HashMap<Long, IndustryWorkHourBo<ProjectWorkHourBo>> industryMap = new HashMap<Long, IndustryWorkHourBo<ProjectWorkHourBo>>(16);
            for (Row row : dataSet) {
                Long industryOneId = ObjectConverterWrapper.getLong((Object)row.get(1));
                if (industryOneId == 0L) continue;
                Long areaId = ObjectConverterWrapper.getLong((Object)row.get(4));
                Long industryTwoId = (Long)industryMappingCache.get((Object)industryOneId, (Object)areaId);
                if (industryTwoId == null || industryTwoId == 0L) {
                    industryTwoId = industryOneId;
                }
                IndustryWorkHourBo industryWorkHourBo = industryMap.computeIfAbsent(industryTwoId, k -> new IndustryWorkHourBo(industryOneId));
                ProjectWorkHourBo projectWorkHourBo = industryWorkHourBo.getProjectWorkHourBoMap().computeIfAbsent(row.getLong(0), k -> new ProjectWorkHourBo());
                Long transactionTypeId = ObjectConverterWrapper.getLong((Object)row.get(3));
                BigDecimal hour = ObjectConverterWrapper.getBigDecimal((Object)row.get(2));
                if (transactionTypeId.equals(1435381552417619968L)) {
                    projectWorkHourBo.addNonRoutineWorkHour(hour);
                    continue;
                }
                projectWorkHourBo.addRoutineWorkHour(hour);
            }
            if (industryMap.isEmpty()) {
                this.getView().showTipNotification(LocaleStringHelper.buildEmptyQueryResultMsg((String)"sfc_mromanuftech", (String)"oprentryentity.oprprofessiona"));
                boolean bl = false;
                return bl;
            }
            this.filterProject(calculateStrategy, industryMap);
            TableValueSetter tvs = this.buildEntryData(industryMap);
            this.getModel().deleteEntryData("entryentity");
            EntryGridHelper.batchCreateNewEntryRow((IFormView)this.getView(), (String)"entryentity", (TableValueSetter)tvs);
            boolean bl = true;
            return bl;
        }
    }

    private void filterProject(ICalculateStrategy calculateStrategy, Map<Long, IndustryWorkHourBo<ProjectWorkHourBo>> industryMap) {
        if (calculateStrategy instanceof AverageValueStrategy) {
            return;
        }
        for (Map.Entry<Long, IndustryWorkHourBo<ProjectWorkHourBo>> entry : industryMap.entrySet()) {
            IndustryWorkHourBo<ProjectWorkHourBo> industryWorkHourBo = entry.getValue();
            Map<Long, ProjectWorkHourBo> projectWorkHourBoMap = industryWorkHourBo.getProjectWorkHourBoMap();
            if (projectWorkHourBoMap.size() == 1) continue;
            List<Long> projectIds = projectWorkHourBoMap.entrySet().stream().sorted(Comparator.comparing(projectEntry -> ((ProjectWorkHourBo)projectEntry.getValue()).getRoutineWorkHours().add(((ProjectWorkHourBo)projectEntry.getValue()).getNonRoutineWorkHours()))).map(Map.Entry::getKey).collect(Collectors.toList());
            Set<Long> selectedProjectIds = calculateStrategy.peek(projectIds);
            projectWorkHourBoMap.entrySet().removeIf(o -> !selectedProjectIds.contains(o.getKey()));
            LOG.info("[{}]Select projects to participate in the calculation of working hours. industryId: {}, projectIds: {}", new Object[]{this.getModel().getDataEntityType().getName(), entry.getKey(), projectIds});
        }
    }

    private TableValueSetter buildEntryData(Map<Long, IndustryWorkHourBo<ProjectWorkHourBo>> industryMap) {
        TableValueSetter tvs = new TableValueSetter(WorkHourTemplateConsts.EstimatedWorkHourTemplateConsts.ENTRY_FIELDS.toArray(new String[0]));
        ICalculateStrategy averageValueStrategy = CalculateFactory.getAverageValueStrategy();
        for (Map.Entry<Long, IndustryWorkHourBo<ProjectWorkHourBo>> industryEntry : industryMap.entrySet()) {
            IndustryWorkHourBo<ProjectWorkHourBo> industryWorkHourBo = industryEntry.getValue();
            Map<Long, ProjectWorkHourBo> projectWorkHourBoMap = industryWorkHourBo.getProjectWorkHourBoMap();
            ArrayList routineHours = Lists.newArrayListWithExpectedSize((int)projectWorkHourBoMap.size());
            ArrayList nonRoutineHours = Lists.newArrayListWithExpectedSize((int)projectWorkHourBoMap.size());
            for (Map.Entry<Long, ProjectWorkHourBo> projectEntry : projectWorkHourBoMap.entrySet()) {
                ProjectWorkHourBo projectWorkHourBo = projectEntry.getValue();
                routineHours.add(projectWorkHourBo.getRoutineWorkHours());
                nonRoutineHours.add(projectWorkHourBo.getNonRoutineWorkHours());
            }
            BigDecimal routineHoursAverageResult = averageValueStrategy.calculate(routineHours);
            BigDecimal nonRoutineHoursAverageResult = averageValueStrategy.calculate(nonRoutineHours);
            tvs.addRow(new Object[]{industryWorkHourBo.getL1(), industryEntry.getKey(), routineHoursAverageResult, nonRoutineHoursAverageResult, routineHoursAverageResult, nonRoutineHoursAverageResult, routineHoursAverageResult.add(nonRoutineHoursAverageResult)});
        }
        return tvs;
    }

    private static class ProjectWorkHourBo {
        private BigDecimal routineWorkHours = BigDecimal.ZERO;
        private BigDecimal nonRoutineWorkHours = BigDecimal.ZERO;

        private ProjectWorkHourBo() {
        }

        private void addRoutineWorkHour(BigDecimal routineWorkHour) {
            this.routineWorkHours = this.routineWorkHours.add(routineWorkHour);
        }

        private void addNonRoutineWorkHour(BigDecimal nonRoutineWorkHour) {
            this.nonRoutineWorkHours = this.nonRoutineWorkHours.add(nonRoutineWorkHour);
        }

        public BigDecimal getRoutineWorkHours() {
            return this.routineWorkHours;
        }

        public BigDecimal getNonRoutineWorkHours() {
            return this.nonRoutineWorkHours;
        }
    }
}

