/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workinghours;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Series;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.pmc.pmpd.common.consts.WorkHourTemplateConsts;
import kd.pmc.pmpd.common.helper.LocaleStringHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.helper.control.EntryGridHelper;
import kd.pmc.pmpd.common.helper.control.PointLineChartHelper;
import kd.pmc.pmpd.common.model.EstimateContext;
import kd.pmc.pmpd.formplugin.model.IndustryWorkHourBo;
import kd.pmc.pmpd.formplugin.workinghours.AbstractWorkHourTemplateEditPlugin;
import kd.pmc.pmpd.formplugin.workinghours.CalculateFactory;
import kd.pmc.pmpd.formplugin.workinghours.strategy.ICalculateStrategy;
import org.apache.commons.lang3.time.DateUtils;

public class StageHoursTemplateEditPlugin
extends AbstractWorkHourTemplateEditPlugin
implements RowClickEventListener {
    private static final Log LOG = LogFactory.getLog(StageHoursTemplateEditPlugin.class);
    private static final String POINTLINECHART_RATIO = "pointlinechart_ratio";
    private static final String POINTLINECHART_TOTAL = "pointlinechart_total";
    private static final String EST_INDUSTRY_HOURS = "flexpanelap3";
    private static final String STAND_INDUSTRY_HOURS = "advconap";
    private static final String STAGR_HOURS_FLEX = "flexpanelap4";
    private static final BigDecimal ONE_HUNDRED = new BigDecimal("100");

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Container est_industry_hours = (Container)this.getControl(EST_INDUSTRY_HOURS);
        if (est_industry_hours != null) {
            est_industry_hours.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        Boolean est_collapse = null;
        if (EST_INDUSTRY_HOURS.equals(key)) {
            String setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)"collapse");
            if (StringUtils.isNotBlank((CharSequence)setting)) {
                est_collapse = (Boolean)SerializationUtils.fromJsonString((String)setting, Boolean.class);
            }
            if (ObjectUtils.isEmpty(est_collapse)) {
                est_collapse = Boolean.FALSE;
            }
            this.getView().setVisible(est_collapse, new String[]{STAND_INDUSTRY_HOURS});
            this.getView().setVisible(est_collapse, new String[]{STAGR_HOURS_FLEX});
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)"collapse", (String)SerializationUtils.toJsonString((Object)(est_collapse == false ? 1 : 0)));
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Container flexpanelap2 = (Container)this.getView().getControl(EST_INDUSTRY_HOURS);
        flexpanelap2.setCollapse(false);
        this.getView().setVisible(Boolean.TRUE, new String[]{STAND_INDUSTRY_HOURS});
        this.getView().setVisible(Boolean.TRUE, new String[]{STAGR_HOURS_FLEX});
        UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)"collapse");
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if ("entryentity".equals(entryGrid.getEntryKey())) {
            this.drawPointLineChart();
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int stage;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("newentry_indus".equals(formOperate.getOperateKey()) && (stage = ((Integer)this.getModel().getValue("stage")).intValue()) == 0) {
            this.getView().showTipNotification(LocaleStringHelper.buildEmptyFieldValueMsg((IDataEntityType)this.getModel().getDataEntityType(), (String)"stage"));
            args.setCancel(true);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if ("entryentity".equals(e.getEntryProp().getName())) {
            int stage = (Integer)this.getModel().getValue("stage");
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            for (RowDataEntity rowDataEntity : e.getRowDataEntities()) {
                this.getModel().setEntryCurrentRowIndex("entryentity", rowDataEntity.getRowIndex());
                TableValueSetter tvs = new TableValueSetter(new String[]{"stage_stage"});
                for (int i = 1; i <= stage; ++i) {
                    tvs.addRow(new Object[]{i});
                }
                model.batchCreateNewEntryRow("subentryentity", tvs);
            }
            model.endInit();
            this.getView().updateView("subentryentity");
            this.drawPointLineChart();
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if ("entryentity".equals(e.getEntryProp().getName())) {
            this.drawPointLineChart();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("stage_percentage".equals(name)) {
            this.percentageChanged(changeData);
        } else if ("industry".equals(name)) {
            this.industryChanged(changeData);
        } else if ("totalhours".equals(name)) {
            this.totalHoursChanged(changeData);
        } else if ("stage".equals(name)) {
            this.stageChanged(changeData);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("stage".equals(callBackId)) {
            this.stageConfirmCallBack(event);
        }
    }

    private void stageConfirmCallBack(MessageBoxClosedEvent event) {
        int oldStage = ObjectConverterWrapper.getInt((Object)event.getCustomVaule());
        if (event.getResult() == MessageBoxResult.Cancel) {
            this.getModel().beginInit();
            this.getModel().setValue("stage", (Object)oldStage);
            this.getModel().endInit();
            this.getView().updateView("stage");
        } else {
            int newStage = (Integer)this.getModel().getValue("stage");
            this.stageChanged(oldStage, newStage);
        }
    }

    private void stageChanged(int oldStage, int newStage) {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCount == 0) {
            return;
        }
        int differenceStage = newStage - oldStage;
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (differenceStage > 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            for (int parnetRowIndex = 0; parnetRowIndex < entryRowCount; ++parnetRowIndex) {
                this.getModel().setEntryCurrentRowIndex("entryentity", parnetRowIndex);
                Object industryId = this.getModel().getValue("industry_id", parnetRowIndex);
                TableValueSetter tvs = new TableValueSetter(new String[]{"stage_industry_id", "stage_stage"});
                int stage = oldStage;
                for (int i = 0; i < differenceStage; ++i) {
                    tvs.addRow(new Object[]{industryId, ++stage});
                }
                model.batchCreateNewEntryRow("subentryentity", tvs);
            }
            this.getModel().endInit();
            this.getModel().setEntryCurrentRowIndex("entryentity", entryCurrentRowIndex);
            this.getView().updateView("subentryentity");
        } else {
            for (int parnetRowIndex = 0; parnetRowIndex < entryRowCount; ++parnetRowIndex) {
                this.getModel().setEntryCurrentRowIndex("entryentity", parnetRowIndex);
                int[] rows = IntStream.range(newStage, oldStage).toArray();
                this.getModel().deleteEntryRows("subentryentity", rows);
            }
            this.getModel().setEntryCurrentRowIndex("entryentity", entryCurrentRowIndex);
        }
        this.drawPointLineChart();
    }

    private void stageChanged(ChangeData changeData) {
        int oldStage = ObjectConverterWrapper.getInt((Object)changeData.getOldValue());
        if (oldStage == 0) {
            this.stageChanged(0, (Integer)changeData.getNewValue());
            return;
        }
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCount == 0) {
            return;
        }
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        String title = String.format(ResManager.loadKDString((String)"\u66f4\u6539\u201c%1s\u201d\u5c06\u8c03\u6574\u201c%2s\u201d\u6570\u636e\u884c", (String)"StageHoursTemplateEditPlugin_14", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"stage"), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"entryentity.subentryentity"));
        this.getView().showConfirm(title + "\r\n" + ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u66f4\u6539\u5417\uff1f", (String)"StageHoursTemplateEditPlugin_15", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("stage", (IFormPlugin)this), null, String.valueOf(oldStage));
    }

    private void totalHoursChanged(ChangeData changeData) {
        BigDecimal totalHours = (BigDecimal)changeData.getNewValue();
        this.getModel().setEntryCurrentRowIndex("entryentity", changeData.getRowIndex());
        DynamicObjectCollection stageEntryCollection = this.getModel().getEntryEntity("subentryentity");
        for (DynamicObject stageEntry : stageEntryCollection) {
            BigDecimal percentage = stageEntry.getBigDecimal("stage_percentage");
            stageEntry.set("stage_totalhours", (Object)totalHours.multiply(percentage));
        }
        this.getView().updateView("subentryentity");
        this.drawPointLineChart();
    }

    private void industryChanged(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        int parentRowIndex = changeData.getRowIndex();
        this.getModel().setEntryCurrentRowIndex("entryentity", parentRowIndex);
        int entryRowCount = this.getModel().getEntryRowCount("subentryentity");
        if (entryRowCount != 0) {
            this.getModel().beginInit();
            for (int rowIndex = 0; rowIndex < entryRowCount; ++rowIndex) {
                this.getModel().setValue("stage_industry", newValue, rowIndex, parentRowIndex);
            }
            this.getModel().endInit();
            this.getView().updateView("subentryentity");
        }
    }

    public void afterLoadData(EventObject e) {
        this.drawPointLineChart();
    }

    @Override
    protected boolean calculate(ICalculateStrategy calculateStrategy, List<Object> projectIds) {
        int stage = (Integer)this.getModel().getValue("stage");
        if (stage == 0) {
            this.getView().showTipNotification(LocaleStringHelper.buildEmptyFieldValueMsg((IDataEntityType)this.getModel().getDataEntityType(), (String)"stage"));
            return false;
        }
        Map<Long, Long> mroOrderEntryMap = this.getMroOrderEntryMap(projectIds);
        if (mroOrderEntryMap.isEmpty()) {
            this.getView().showTipNotification(LocaleStringHelper.buildEmptyQueryResultMsg((String)"pom_mroorder", (String)"treeentryentity"));
            return false;
        }
        QFilter[] filters = new QFilter[]{new QFilter("sumentry.mroorderentryid", "in", mroOrderEntryMap.keySet()), new QFilter("billstatus", "=", (Object)"C")};
        Calendar calendar = Calendar.getInstance();
        try (DataSet dataSet = ORM.create().queryDataSet("getMroReport", "sfc_processreportbill", "reportdate, sumentry.childreportentity.personnelindustry, sumentry.childreportentity.activehours, sumentry.mroorderentryid", filters, "reportdate", -1);){
            HashMap<Long, IndustryWorkHourBo<ProjectWorkHourBo>> industryMap = new HashMap<Long, IndustryWorkHourBo<ProjectWorkHourBo>>(16);
            for (Row row : dataSet) {
                Long projectId;
                Long industryTwoId = ObjectConverterWrapper.getLong((Object)row.get(1));
                if (industryTwoId == 0L || (projectId = mroOrderEntryMap.get(ObjectConverterWrapper.getLong((Object)row.get(3)))) == null) continue;
                Date reportDate = row.getDate(0);
                reportDate = this.truncateDate(calendar, reportDate);
                IndustryWorkHourBo industryWorkHourBo = industryMap.computeIfAbsent(industryTwoId, k -> new IndustryWorkHourBo(0L));
                Map projectWorkHourBoMap = industryWorkHourBo.getProjectWorkHourBoMap();
                ProjectWorkHourBo projectWorkHourBo = projectWorkHourBoMap.computeIfAbsent(projectId, k -> new ProjectWorkHourBo());
                projectWorkHourBo.putWorkHour(reportDate, row.getBigDecimal(2));
            }
            if (industryMap.isEmpty()) {
                this.getView().showTipNotification(LocaleStringHelper.buildEmptyQueryResultMsg((String)"sfc_processreportbill", (String)"sumentry.childreportentity.personnelindustry"));
                boolean bl = false;
                return bl;
            }
            Set<Long> allProjectIds = this.filterProject(calculateStrategy, industryMap);
            Map<Long, BigDecimal> projectId2Trt = this.getTrtByProject(allProjectIds, stage);
            if (projectId2Trt.isEmpty()) {
                boolean industryTwoId = false;
                return industryTwoId;
            }
            Map<Long, BigDecimal> industryId2TotalHours = this.addEstimatedWorkHourEntry(industryMap);
            Map<Long, StageWorkHourBo> stageWorkHourBoMap = this.calculateStageWorkHour(projectId2Trt, stage, industryId2TotalHours, industryMap);
            this.addStageWorkHourSubEntry(industryId2TotalHours, stageWorkHourBoMap);
            boolean bl = true;
            return bl;
        }
    }

    private Map<Long, BigDecimal> getTrtByProject(Set<Long> allProjectIds, int stage) {
        DynamicObjectType dt = EntityMetadataCache.getSubDataEntityType((String)"pmpd_project", (Collection)Sets.newHashSet((Object[])new String[]{"number", "estperiod"}));
        Map cache = BusinessDataServiceHelper.loadFromCache((Object[])allProjectIds.toArray(), (DynamicObjectType)dt);
        HashMap result = Maps.newHashMapWithExpectedSize((int)cache.size());
        BigDecimal stageDecimal = BigDecimal.valueOf(stage);
        ArrayList<String> errorProjectNumbers = new ArrayList<String>(10);
        for (Map.Entry entry : cache.entrySet()) {
            DynamicObject project = (DynamicObject)entry.getValue();
            BigDecimal trt = project.getBigDecimal("estperiod");
            if (trt.compareTo(stageDecimal) < 0) {
                errorProjectNumbers.add(project.getString("number"));
                continue;
            }
            result.put((Long)entry.getKey(), trt);
        }
        if (errorProjectNumbers.isEmpty()) {
            return result;
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u9879\u76ee\u7684\u201c%1$s\u201d\u5b57\u6bb5\u503c\u5c0f\u4e8e\u201c%2$s\u201d\u5b57\u6bb5\u503c\uff1a[%3$s]", (String)"StageHoursTemplateEditPlugin_12", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dt, (String)"estperiod"), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)this.getModel().getDataEntityType(), (String)"stage"), String.join((CharSequence)"\uff0c", errorProjectNumbers));
        this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"StageHoursTemplateEditPlugin_13", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), errorMsg, MessageTypes.Default);
        return Collections.emptyMap();
    }

    private Date truncateDate(Calendar calendar, Date reportDate) {
        calendar.setTime(reportDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        reportDate = calendar.getTime();
        return reportDate;
    }

    private Set<Long> filterProject(ICalculateStrategy calculateStrategy, Map<Long, IndustryWorkHourBo<ProjectWorkHourBo>> industryMap) {
        HashSet<Long> allProjectIds = new HashSet<Long>(16);
        for (Map.Entry<Long, IndustryWorkHourBo<ProjectWorkHourBo>> entry : industryMap.entrySet()) {
            Map<Long, ProjectWorkHourBo> projectWorkHourBoMap = entry.getValue().getProjectWorkHourBoMap();
            List<Long> projectIds = projectWorkHourBoMap.entrySet().stream().sorted(Comparator.comparing(o -> ((ProjectWorkHourBo)o.getValue()).totalWorkHours)).map(Map.Entry::getKey).collect(Collectors.toList());
            Set<Long> selectedProjectIds = calculateStrategy.peek(projectIds);
            projectWorkHourBoMap.entrySet().removeIf(o -> !selectedProjectIds.contains(o.getKey()));
            LOG.info("[{}]Select projects to participate in the calculation of working hours. industryId: {}, projectIds: {}", new Object[]{this.getModel().getDataEntityType().getName(), entry.getKey(), projectIds});
            allProjectIds.addAll(selectedProjectIds);
        }
        return allProjectIds;
    }

    private void addStageWorkHourSubEntry(Map<Long, BigDecimal> industryId2TotalHours, Map<Long, StageWorkHourBo> stageWorkHourBoMap) {
        if (stageWorkHourBoMap.isEmpty()) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        int index = -1;
        ICalculateStrategy averageValueStrategy = CalculateFactory.getAverageValueStrategy();
        for (Map.Entry<Long, BigDecimal> industryEntry : industryId2TotalHours.entrySet()) {
            ++index;
            Long industryId = industryEntry.getKey();
            StageWorkHourBo stageWorkHourBo = stageWorkHourBoMap.get(industryId);
            Map<Integer, List<BigDecimal>> stageWorkHourMap = stageWorkHourBo.getStageWorkHourMap();
            if (stageWorkHourMap == null) continue;
            BigDecimal totalHours = industryEntry.getValue();
            model.setEntryCurrentRowIndex("entryentity", index);
            TableValueSetter tvs = this.buildStageEntry(averageValueStrategy, stageWorkHourBo.getL1(), industryId, stageWorkHourMap, totalHours);
            model.batchCreateNewEntryRow("subentryentity", tvs);
        }
        model.endInit();
        this.getView().updateView("subentryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.selectRows(0);
        this.getModel().setEntryCurrentRowIndex("entryentity", 0);
        this.drawPointLineChart();
    }

    private TableValueSetter buildStageEntry(ICalculateStrategy averageValueStrategy, long industryOneId, Long industryTwoId, Map<Integer, List<BigDecimal>> stageWorkHourMap, BigDecimal totalHours) {
        TableValueSetter tvs = new TableValueSetter(WorkHourTemplateConsts.StageWorkHourTemplateConsts.SUBENTRY_FIELDS.toArray(new String[0]));
        Set<Map.Entry<Integer, List<BigDecimal>>> entrySet = stageWorkHourMap.entrySet();
        int maxIndex = entrySet.size() - 1;
        int index = 0;
        BigDecimal summaryHours = BigDecimal.ZERO;
        BigDecimal summaryPercentage = BigDecimal.ZERO;
        for (Map.Entry<Integer, List<BigDecimal>> entry : entrySet) {
            BigDecimal tempResult;
            Integer stage = entry.getKey();
            if (summaryHours.compareTo(totalHours) == 0) {
                tvs.addRow(new Object[]{industryOneId, industryTwoId, stage, BigDecimal.ZERO, BigDecimal.ZERO});
                continue;
            }
            if (index == maxIndex) {
                tvs.addRow(new Object[]{industryOneId, industryTwoId, stage, BigDecimal.ONE.subtract(summaryPercentage), totalHours.subtract(summaryHours)});
                continue;
            }
            BigDecimal result = averageValueStrategy.calculate(entry.getValue());
            if (result.compareTo(tempResult = totalHours.subtract(summaryHours)) >= 0) {
                tvs.addRow(new Object[]{industryOneId, industryTwoId, stage, BigDecimal.ONE.subtract(summaryPercentage), tempResult});
                summaryHours = totalHours;
                continue;
            }
            summaryHours = summaryHours.add(result);
            BigDecimal percentage = result.divide(totalHours, 2, EstimateContext.getRoundingMode());
            summaryPercentage = summaryPercentage.add(percentage);
            tvs.addRow(new Object[]{industryOneId, industryTwoId, stage, percentage, result});
            ++index;
        }
        return tvs;
    }

    private Map<Long, StageWorkHourBo> calculateStageWorkHour(Map<Long, BigDecimal> projectId2Trt, int stage, Map<Long, BigDecimal> industryId2TotalHours, Map<Long, IndustryWorkHourBo<ProjectWorkHourBo>> industryMap) {
        BigDecimal stageDecimal = BigDecimal.valueOf(stage);
        HashMap<Long, StageWorkHourBo> stageWorkHourBoMap = new HashMap<Long, StageWorkHourBo>(16);
        for (Map.Entry<Long, BigDecimal> entry : industryId2TotalHours.entrySet()) {
            if (entry.getValue().compareTo(BigDecimal.ZERO) == 0) continue;
            Long industryId = entry.getKey();
            IndustryWorkHourBo<ProjectWorkHourBo> industryWorkHourBo = industryMap.get(industryId);
            StageWorkHourBo stageWorkHourBo = stageWorkHourBoMap.computeIfAbsent(industryId, k -> new StageWorkHourBo());
            stageWorkHourBo.setL1(industryWorkHourBo.getL1());
            Map<Integer, List<BigDecimal>> stageWorkHourMap = stageWorkHourBo.getStageWorkHourMap();
            Map<Long, ProjectWorkHourBo> projectWorkHourBoMap = industryWorkHourBo.getProjectWorkHourBoMap();
            for (Map.Entry<Long, ProjectWorkHourBo> projectWorkHourBoEntry : projectWorkHourBoMap.entrySet()) {
                BigDecimal trt = projectId2Trt.getOrDefault(projectWorkHourBoEntry.getKey(), BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(trt) == 0) continue;
                BigDecimal stageDays = trt.divide(stageDecimal, 10, EstimateContext.getRoundingMode());
                ProjectWorkHourBo projectWorkHourBo = projectWorkHourBoEntry.getValue();
                projectWorkHourBo.repair();
                List projectWokrHours = projectWorkHourBo.getProjectWokrHours();
                int size = projectWokrHours.size();
                int currentStage = 1;
                int currentIndex = 0;
                BigDecimal cueerntRemainingDays = BigDecimal.ZERO;
                while (currentIndex != size && currentStage <= stage) {
                    BigDecimal summary = cueerntRemainingDays.compareTo(BigDecimal.ZERO) > 0 ? ((BigDecimal)projectWokrHours.get(currentIndex++)).multiply(cueerntRemainingDays) : BigDecimal.ZERO;
                    BigDecimal stageRemainingDays = stageDays.subtract(cueerntRemainingDays);
                    while (stageRemainingDays.compareTo(BigDecimal.ONE) >= 0 && currentIndex < size) {
                        summary = summary.add((BigDecimal)projectWokrHours.get(currentIndex++));
                        stageRemainingDays = stageRemainingDays.subtract(BigDecimal.ONE);
                    }
                    if (currentIndex < size) {
                        if (stageRemainingDays.compareTo(BigDecimal.ZERO) > 0) {
                            summary = summary.add(((BigDecimal)projectWokrHours.get(currentIndex)).multiply(stageRemainingDays));
                            cueerntRemainingDays = BigDecimal.ONE.subtract(stageRemainingDays);
                        } else {
                            cueerntRemainingDays = BigDecimal.ZERO;
                        }
                    }
                    List workHours = stageWorkHourMap.computeIfAbsent(currentStage++, k -> new ArrayList(10));
                    workHours.add(summary);
                }
                for (int i = currentStage; i <= stage; ++i) {
                    List workHours = stageWorkHourMap.computeIfAbsent(i, k -> new ArrayList(10));
                    workHours.add(BigDecimal.ZERO);
                }
            }
        }
        return stageWorkHourBoMap;
    }

    private Map<Long, BigDecimal> addEstimatedWorkHourEntry(Map<Long, IndustryWorkHourBo<ProjectWorkHourBo>> industryMap) {
        LinkedHashMap industryId2TotalHours = Maps.newLinkedHashMapWithExpectedSize((int)industryMap.size());
        TableValueSetter tvs = new TableValueSetter(WorkHourTemplateConsts.StageWorkHourTemplateConsts.ENTRY_FIELDS.toArray(new String[0]));
        ICalculateStrategy averageValueStrategy = CalculateFactory.getAverageValueStrategy();
        for (Map.Entry<Long, IndustryWorkHourBo<ProjectWorkHourBo>> industryEntry : industryMap.entrySet()) {
            IndustryWorkHourBo<ProjectWorkHourBo> industryWorkHourBo = industryEntry.getValue();
            Map<Long, ProjectWorkHourBo> projectWorkHourBoMap = industryWorkHourBo.getProjectWorkHourBoMap();
            ArrayList totalHours = Lists.newArrayListWithExpectedSize((int)projectWorkHourBoMap.size());
            for (Map.Entry<Long, ProjectWorkHourBo> projectEntry : projectWorkHourBoMap.entrySet()) {
                totalHours.add(projectEntry.getValue().totalWorkHours);
            }
            Long industryId = industryEntry.getKey();
            BigDecimal result = averageValueStrategy.calculate(totalHours);
            tvs.addRow(new Object[]{industryWorkHourBo.getL1(), industryId, result});
            industryId2TotalHours.put(industryId, result);
        }
        this.getModel().deleteEntryData("entryentity");
        EntryGridHelper.batchCreateNewEntryRow((IFormView)this.getView(), (String)"entryentity", (TableValueSetter)tvs);
        return industryId2TotalHours;
    }

    private Map<Long, Long> getMroOrderEntryMap(List<Object> projectIds) {
        QFilter[] filters = new QFilter[]{new QFilter("treeentryentity.project", "in", projectIds), new QFilter("billstatus", "=", (Object)"C")};
        try (DataSet dataSet = ORM.create().queryDataSet("getMroOrderEntryId", "pom_mroorder", "treeentryentity.id, treeentryentity.project", filters, null, -1);){
            if (dataSet.isEmpty()) {
                Map<Long, Long> map = Collections.emptyMap();
                return map;
            }
            HashMap<Long, Long> result = new HashMap<Long, Long>(16);
            for (Row row : dataSet) {
                Long orderEntryId = ObjectConverterWrapper.getLong((Object)row.get(0));
                Long projectId = ObjectConverterWrapper.getLong((Object)row.get(1));
                result.put(orderEntryId, projectId);
            }
            HashMap<Long, Long> hashMap = result;
            return hashMap;
        }
    }

    private void percentageChanged(ChangeData changeData) {
        BigDecimal percentage = (BigDecimal)changeData.getNewValue();
        int parentRowIndex = changeData.getParentRowIndex();
        BigDecimal totalHours = (BigDecimal)this.getModel().getValue("totalhours", parentRowIndex);
        this.getModel().setValue("stage_totalhours", (Object)totalHours.multiply(percentage), changeData.getRowIndex(), changeData.getParentRowIndex());
        this.drawPointLineChart();
    }

    private void drawPercentagePointLineChart(String[] categorys, Number[] values) {
        PointLineChart pointLineChart = PointLineChartHelper.getPointLineChart((IFormView)this.getView(), (String)POINTLINECHART_RATIO);
        PointLineChartHelper.createXAxis((PointLineChart)pointLineChart, (String)this.getXAxisName(), (String[])categorys);
        Axis yAxis = PointLineChartHelper.createYAxis((PointLineChart)pointLineChart, (String)this.getRatioYAxisName());
        yAxis.setMax((Number)100);
        Series lineSeries = PointLineChartHelper.createLineSeries((PointLineChart)pointLineChart, (String)this.getRatioSeriesName(), (boolean)true, (Number[])values);
        PointLineChartHelper.setPercentageStyle((PointLineChart)pointLineChart, (Axis)yAxis, (Series)lineSeries);
        pointLineChart.refresh();
    }

    private void drawPointLineChart() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("subentryentity");
        if (entryEntity == null || entryEntity.isEmpty()) {
            this.clearPointLineChartData(POINTLINECHART_RATIO, POINTLINECHART_TOTAL);
            return;
        }
        int size = entryEntity.size();
        String[] categorys = new String[size];
        Number[] ratioValues = new Number[size];
        Number[] totalValues = new Number[size];
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            categorys[i] = dynamicObject.getString("stage_stage");
            ratioValues[i] = dynamicObject.getBigDecimal("stage_percentage").multiply(ONE_HUNDRED);
            totalValues[i] = dynamicObject.getBigDecimal("stage_totalhours");
        }
        this.drawPercentagePointLineChart(categorys, ratioValues);
        PointLineChart totalPointLineChart = PointLineChartHelper.getPointLineChart((IFormView)this.getView(), (String)POINTLINECHART_TOTAL);
        PointLineChartHelper.createXAxis((PointLineChart)totalPointLineChart, (String)this.getXAxisName(), (String[])categorys);
        PointLineChartHelper.createYAxis((PointLineChart)totalPointLineChart, (String)this.getTotalYAxisName());
        PointLineChartHelper.createLineSeries((PointLineChart)totalPointLineChart, (String)this.getTotalSeriesName(), (boolean)true, (Number[])totalValues);
        totalPointLineChart.refresh();
    }

    private void clearPointLineChartData(String ... keys) {
        for (String key : keys) {
            PointLineChart pointLineChart = PointLineChartHelper.getPointLineChart((IFormView)this.getView(), (String)key);
            pointLineChart.clearData();
            pointLineChart.refresh();
        }
    }

    private String getXAxisName() {
        return ResManager.loadKDString((String)"\u9636\u6bb5", (String)"StageHoursTemplateEditPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private String getRatioYAxisName() {
        return ResManager.loadKDString((String)"\u5360\u6bd4", (String)"StageHoursTemplateEditPlugin_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private String getTotalYAxisName() {
        return ResManager.loadKDString((String)"\u5408\u8ba1", (String)"StageHoursTemplateEditPlugin_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private String getRatioSeriesName() {
        return ResManager.loadKDString((String)"\u5de5\u65f6\u5360\u6bd4", (String)"StageHoursTemplateEditPlugin_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private String getTotalSeriesName() {
        return ResManager.loadKDString((String)"\u62a5\u5de5\u5de5\u65f6\u5408\u8ba1", (String)"StageHoursTemplateEditPlugin_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private static class ProjectWorkHourBo {
        private BigDecimal totalWorkHours = BigDecimal.ZERO;
        private final Map<Date, BigDecimal> date2WorkHour = new TreeMap<Date, BigDecimal>();

        private ProjectWorkHourBo() {
        }

        private void putWorkHour(Date date, BigDecimal workHour) {
            BigDecimal summary = this.date2WorkHour.getOrDefault(date, BigDecimal.ZERO);
            this.date2WorkHour.put(date, summary.add(workHour));
            this.totalWorkHours = this.totalWorkHours.add(workHour);
        }

        private List<BigDecimal> getProjectWokrHours() {
            return new ArrayList<BigDecimal>(this.date2WorkHour.values());
        }

        private void repair() {
            Calendar currentCalendar = Calendar.getInstance();
            Calendar nextCalendar = Calendar.getInstance();
            Date[] dateArray = this.date2WorkHour.keySet().toArray(new Date[0]);
            int maxIndex = dateArray.length - 1;
            block0: for (int i = 0; i < maxIndex; ++i) {
                Date current = dateArray[i];
                Date next = dateArray[i + 1];
                currentCalendar.setTime(current);
                nextCalendar.setTime(next);
                while (true) {
                    currentCalendar.add(5, 1);
                    if (DateUtils.isSameDay((Calendar)currentCalendar, (Calendar)nextCalendar)) continue block0;
                    this.date2WorkHour.put(currentCalendar.getTime(), BigDecimal.ZERO);
                }
            }
        }
    }

    private static class StageWorkHourBo {
        private long l1;
        private final Map<Integer, List<BigDecimal>> stageWorkHourMap = new LinkedHashMap<Integer, List<BigDecimal>>(16);

        private StageWorkHourBo() {
        }

        public void setL1(long l1) {
            this.l1 = l1;
        }

        public long getL1() {
            return this.l1;
        }

        public Map<Integer, List<BigDecimal>> getStageWorkHourMap() {
            return this.stageWorkHourMap;
        }
    }
}

