/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workinghours;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.pmc.pmpd.business.workhour.WorkHourEstimateHelper;
import kd.pmc.pmpd.business.workhour.WorkHourTemplateHelper;
import kd.pmc.pmpd.common.consts.WorkHourEstimateBillConsts;
import kd.pmc.pmpd.common.helper.LocaleStringHelper;
import kd.pmc.pmpd.common.helper.control.EntryGridHelper;
import kd.pmc.pmpd.common.model.EstimateContext;
import kd.pmc.pmpd.formplugin.utils.BillModelUtils;

public class WorkHourEstimateBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String BAR_MATCH = "bar_match";
    private static final String BAR_ESTIMATION_SETTINGS = "bar_estimationsettings";
    private static final String MATCH_CONDITION = "matchCondition";
    private static final String CACHEKEY_MATCH_STAGE_WORKHOUR_TEMPLATE_ID = "matchStageWorkHourTemplateId";
    private static final String EST_INDUSTRY_HOURS = "flexpanelap2";
    private static final String EST_INDUSTRY_HOURS_FLEX = "flexpanelap4";
    private static final String EST_PERIOD_HOURS = "flexpanelap1";
    private static final String STAND_INDUSTRY_HOURS = "flexpanelap";
    private static final String STAND_INDUSTRY_HOURS_FLEX = "flexpanelap5";
    private static final String STAND_PERIOD_HOURS = "flexpanelap3";

    public void registerListener(EventObject e) {
        Container stand_industry_hours;
        Container est_industry_hours;
        BasedataEdit stageWorkHour;
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit estimatedWorkHour = (BasedataEdit)this.getControl("estimate_workhour");
        if (estimatedWorkHour != null) {
            estimatedWorkHour.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((stageWorkHour = (BasedataEdit)this.getControl("stage_workhour")) != null) {
            stageWorkHour.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((est_industry_hours = (Container)this.getControl(EST_INDUSTRY_HOURS)) != null) {
            est_industry_hours.addClickListener((ClickListener)this);
        }
        if ((stand_industry_hours = (Container)this.getControl(STAND_INDUSTRY_HOURS)) != null) {
            stand_industry_hours.addClickListener((ClickListener)this);
        }
    }

    public void afterLoadData(EventObject e) {
        this.initDataByResourcePlan();
    }

    public void click(EventObject evt) {
        String setting;
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        Boolean est_collapse = null;
        Boolean stand_collapse = null;
        if (EST_INDUSTRY_HOURS.equals(key)) {
            setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)"est_collapse");
            if (StringUtils.isNotBlank((CharSequence)setting)) {
                est_collapse = (Boolean)SerializationUtils.fromJsonString((String)setting, Boolean.class);
            }
            if (ObjectUtils.isEmpty(est_collapse)) {
                est_collapse = Boolean.FALSE;
            }
            this.getView().setVisible(est_collapse, new String[]{EST_PERIOD_HOURS});
            this.getView().setVisible(est_collapse, new String[]{EST_INDUSTRY_HOURS_FLEX});
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)"est_collapse", (String)SerializationUtils.toJsonString((Object)(est_collapse == false ? 1 : 0)));
        }
        if (STAND_INDUSTRY_HOURS.equals(key)) {
            setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)"stand_collapse");
            if (StringUtils.isNotBlank((CharSequence)setting)) {
                stand_collapse = (Boolean)SerializationUtils.fromJsonString((String)setting, Boolean.class);
            }
            if (ObjectUtils.isEmpty(stand_collapse)) {
                stand_collapse = Boolean.FALSE;
            }
            this.getView().setVisible(stand_collapse, new String[]{STAND_PERIOD_HOURS});
            this.getView().setVisible(stand_collapse, new String[]{STAND_INDUSTRY_HOURS_FLEX});
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)"stand_collapse", (String)SerializationUtils.toJsonString((Object)(stand_collapse == false ? 1 : 0)));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Container flexpanelap2 = (Container)this.getView().getControl(EST_INDUSTRY_HOURS);
        flexpanelap2.setCollapse(false);
        this.getView().setVisible(Boolean.TRUE, new String[]{EST_PERIOD_HOURS});
        this.getView().setVisible(Boolean.TRUE, new String[]{EST_INDUSTRY_HOURS_FLEX});
        Container flexpanelap = (Container)this.getView().getControl(STAND_INDUSTRY_HOURS);
        flexpanelap.setCollapse(false);
        this.getView().setVisible(Boolean.TRUE, new String[]{STAND_PERIOD_HOURS});
        this.getView().setVisible(Boolean.TRUE, new String[]{STAND_INDUSTRY_HOURS_FLEX});
        UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)"stand_collapse");
        UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)"est_collapse");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BAR_MATCH.equals(itemKey)) {
            this.showMatchConditionConfigForm();
        } else if (BAR_ESTIMATION_SETTINGS.equals(itemKey)) {
            this.showEstimationSettings();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        String operateKey = args.getOperateKey();
        if ("getstandardworkhour".equals(operateKey) && operationResult.isSuccess()) {
            IBillView billView = (IBillView)this.getView();
            BillModelUtils.reloadEntry(billView, "s_entryentity");
        }
    }

    private void showEstimationSettings() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pmpd_estimation_settings");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BAR_ESTIMATION_SETTINGS));
        formShowParameter.setHasRight(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        String sourceMethod = beforeF7SelectEvent.getSourceMethod();
        List customFilters = beforeF7SelectEvent.getCustomQFilters();
        if ("estimate_workhour".equals(name)) {
            this.addFilters4WorkHourTemplate(sourceMethod, customFilters, true);
        } else if ("stage_workhour".equals(name)) {
            this.addFilters4WorkHourTemplate(sourceMethod, customFilters, false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (name) {
            case "estimate_workhour": {
                this.workHourChanged(name, changeData, (Consumer<ChangeData>)((Consumer)this::estimatedWorkHourChanged));
                break;
            }
            case "stage_workhour": {
                this.workHourChanged(name, changeData, (Consumer<ChangeData>)((Consumer)this::stageWorkHourChanged));
                break;
            }
            case "workhourtype": {
                this.workHourTypeChanged(changeData);
                break;
            }
            case "routineworkhour": 
            case "nonroutineworkhour": {
                this.summaryEstimateWorkHour("estimate", "entryentity", "routineworkhour", "nonroutineworkhour");
                break;
            }
            case "s_routineworkhour": 
            case "s_nonroutineworkhour": {
                this.summaryEstimateWorkHour("standard", "s_entryentity", "s_routineworkhour", "s_nonroutineworkhour");
                break;
            }
        }
    }

    private void workHourTypeChanged(ChangeData changeData) {
        String workHourType = (String)changeData.getNewValue();
        if ("estimate".equals(workHourType)) {
            this.summaryEstimateWorkHour(workHourType, "entryentity", "routineworkhour", "nonroutineworkhour");
        } else if ("standard".equals(workHourType)) {
            this.summaryEstimateWorkHour(workHourType, "s_entryentity", "s_routineworkhour", "s_nonroutineworkhour");
        }
    }

    private void workHourChanged(String name, ChangeData changeData, Consumer<ChangeData> consumer) {
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        if (oldValue == null) {
            consumer.accept((Object)changeData);
        } else {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u66f4\u6539\u201c%s\u201d\u5c06\u6e05\u7a7a\u5de5\u65f6\u6570\u636e", (String)"WorkHourEstimateBillEdit_11", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)this.getModel().getDataEntityType(), (String)name)) + "\r\n" + ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u66f4\u6539\u5417\uff1f", (String)"WorkHourEstimateBillEdit_12", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(name, (IFormPlugin)this), null, String.valueOf(oldValue.getPkValue()));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("estimate_workhour".equals(callBackId)) {
            this.workhourConfirmCallBack(event, callBackId, (Consumer<ChangeData>)((Consumer)this::estimatedWorkHourChanged));
        } else if ("stage_workhour".equals(callBackId)) {
            this.workhourConfirmCallBack(event, callBackId, (Consumer<ChangeData>)((Consumer)this::stageWorkHourChanged));
        }
    }

    private void workhourConfirmCallBack(MessageBoxClosedEvent event, String callBackId, Consumer<ChangeData> consumer) {
        if (event.getResult() == MessageBoxResult.Cancel) {
            Long originalId = Long.parseLong(event.getCustomVaule());
            this.getModel().beginInit();
            this.getModel().setValue(callBackId, (Object)originalId);
            this.getModel().endInit();
            this.getView().updateView(callBackId);
        } else {
            DynamicObject workhour = (DynamicObject)this.getModel().getValue(callBackId);
            ChangeData changeData = new ChangeData(-1, this.getModel().getDataEntity(), (Object)0, (Object)workhour);
            consumer.accept((Object)changeData);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (MATCH_CONDITION.equals(actionId) && returnData instanceof Map) {
            this.matchConditionCallBack((Map)returnData);
        } else if (BAR_ESTIMATION_SETTINGS.equals(actionId) && returnData instanceof Map) {
            Map returnMap = (Map)returnData;
            this.estimateWorkHoursBySettings(returnMap);
        }
    }

    private void estimateWorkHoursBySettings(Map<String, Object> settingsMap) {
        String method = (String)settingsMap.getOrDefault("method", "stage");
        boolean estimate = (Boolean)settingsMap.getOrDefault("estimate", Boolean.TRUE);
        boolean standard = (Boolean)settingsMap.getOrDefault("standard", Boolean.TRUE);
        this.estimateWorkHours(method, estimate, standard);
    }

    private void initDataByResourcePlan() {
        long resourcePlanId = (Long)this.getModel().getValue("resourceplanid");
        if (resourcePlanId == 0L) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)resourcePlanId)};
        try (DataSet dataSet = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getSimpleName(), "pmpd_resourceplan", "customer, model, fixlevel, fixlevel.checklevel, workscope, workrepaircycle, repaircycleday,fixmodel", filters, null, 1);){
            if (dataSet.isEmpty()) {
                return;
            }
            Row row = dataSet.next();
            this.getModel().setValue("customer", (Object)row.getLong(0));
            this.getModel().setValue("equipmenttype", (Object)row.getLong(1));
            this.getModel().setValue("checktype", (Object)row.getLong(2));
            this.getModel().setValue("checklevel", (Object)row.getLong(3));
            this.getModel().setValue("workscope", (Object)row.getLong(4));
            this.getModel().setValue("workrepaircycle", (Object)row.getBigDecimal(5));
            this.getModel().setValue("trt", (Object)row.getBigDecimal(6));
            this.getModel().setValue("equipmenttype", (Object)row.getLong(7));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.clearDirtyFlag();
    }

    private void clearDirtyFlag() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.clearHeaderDirtyFlag(dataEntity);
        this.clearEntryEntityDirtyFlag(dataEntity);
    }

    private void clearHeaderDirtyFlag(DynamicObject dataEntity) {
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        for (String emptyFieldName : this.getEmptyFieldNames()) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)emptyFieldName);
            if (property == null) continue;
            dataEntityState.setBizChanged(property.getOrdinal(), false);
        }
    }

    private List<String> getEmptyFieldNames() {
        return Lists.newArrayList((Object[])new String[]{"resourceplanid", "customer_id", "equipmenttype_id", "checktype_id", "checklevel_id", "workscope_id", "workrepaircycle", "trt"});
    }

    private void clearEntryEntityDirtyFlag(DynamicObject dataEntity) {
        DynamicObject dynamicObject;
        DynamicObjectCollection stageCollection;
        DynamicObjectType dynamicObjectType;
        DynamicProperty property;
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("s_entryentity");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && (property = (dynamicObjectType = (stageCollection = (dynamicObject = (DynamicObject)iterator.next()).getDynamicObjectCollection("s_subentryentity_stage")).getDynamicObjectType()).getProperty("s_stage_industry")) != null) {
            int ordinal = property.getOrdinal();
            for (DynamicObject stageWorkHourEntry : stageCollection) {
                stageWorkHourEntry.getDataEntityState().setBizChanged(ordinal, false);
            }
        }
    }

    private void matchConditionCallBack(Map<String, Boolean> returnMap) {
        QFilter[] filterArray = this.buildEstiFilters(returnMap);
        List estimatedWorkHourTemplateIds = QueryServiceHelper.queryPrimaryKeys((String)"pmpd_estimate_workhour", (QFilter[])filterArray, null, (int)1);
        QFilter[] filterArray2 = this.buildStageFilters(returnMap);
        List stageWorkHourTemplateIds = QueryServiceHelper.queryPrimaryKeys((String)"pmpd_stage_workhour", (QFilter[])filterArray2, null, (int)1);
        if (!estimatedWorkHourTemplateIds.isEmpty()) {
            if (stageWorkHourTemplateIds.isEmpty()) {
                this.getModel().setItemValueByID("estimate_workhour", estimatedWorkHourTemplateIds.get(0));
            } else {
                Object stageWorkHourTemplateId = stageWorkHourTemplateIds.get(0);
                this.getPageCache().put(CACHEKEY_MATCH_STAGE_WORKHOUR_TEMPLATE_ID, String.valueOf(stageWorkHourTemplateId));
                this.getModel().setItemValueByID("estimate_workhour", estimatedWorkHourTemplateIds.get(0));
                this.getPageCache().remove(CACHEKEY_MATCH_STAGE_WORKHOUR_TEMPLATE_ID);
                this.getModel().setItemValueByID("stage_workhour", stageWorkHourTemplateId);
            }
            return;
        }
        if (!stageWorkHourTemplateIds.isEmpty()) {
            this.getModel().setItemValueByID("stage_workhour", stageWorkHourTemplateIds.get(0));
        }
    }

    private QFilter[] buildStageFilters(Map<String, Boolean> returnMap) {
        this.getPageCache().put(MATCH_CONDITION, SerializationUtils.toJsonString(returnMap));
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("sourcebillid", "=", (Object)0));
        this.addFilters(filters, returnMap, false);
        filters.add(new QFilter("status", "=", (Object)Character.valueOf('C')));
        filters.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        long orgId = (Long)this.getModel().getValue("org_id");
        filters.add(BaseDataServiceHelper.getBaseDataFilter((String)"pmpd_stage_workhour", (Long)orgId));
        QFilter[] filterArray = filters.toArray(new QFilter[0]);
        return filterArray;
    }

    private QFilter[] buildEstiFilters(Map<String, Boolean> returnMap) {
        this.getPageCache().put(MATCH_CONDITION, SerializationUtils.toJsonString(returnMap));
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("sourcebillid", "=", (Object)0));
        this.addFilters(filters, returnMap, true);
        filters.add(new QFilter("status", "=", (Object)Character.valueOf('C')));
        filters.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        long orgId = (Long)this.getModel().getValue("org_id");
        filters.add(BaseDataServiceHelper.getBaseDataFilter((String)"pmpd_estimate_workhour", (Long)orgId));
        QFilter[] filterArray = filters.toArray(new QFilter[0]);
        return filterArray;
    }

    private void stageWorkHourChanged(ChangeData changeData) {
        DynamicObject stageWorkHourTemplate;
        DynamicObjectCollection collection;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection standardIndustryWorkHourEntryEntity = this.getModel().getEntryEntity("s_entryentity");
        if (entryEntity.isEmpty() && standardIndustryWorkHourEntryEntity.isEmpty()) {
            return;
        }
        Object newValue = changeData.getNewValue();
        if (newValue == null) {
            this.deleteStageWorkHourEntryData(entryEntity.size(), standardIndustryWorkHourEntryEntity.size());
            return;
        }
        if (changeData.getOldValue() != null) {
            this.deleteStageWorkHourEntryData4Estimate(entryEntity.size());
        }
        if ((collection = (stageWorkHourTemplate = (DynamicObject)newValue).getDynamicObjectCollection("entryentity")).isEmpty()) {
            return;
        }
        this.addStageEntryData4Estimate(entryEntity, collection);
        this.deleteStageWorkHourEntryData4Standard(standardIndustryWorkHourEntryEntity.size());
        this.addStageEntryData4Standard(standardIndustryWorkHourEntryEntity, collection);
    }

    private void deleteStageWorkHourEntryData(int estimatedRowCount, int standardRowCount) {
        this.deleteStageWorkHourEntryData4Estimate(estimatedRowCount);
        this.deleteStageWorkHourEntryData4Standard(standardRowCount);
    }

    private void addStageEntryData4Standard(DynamicObjectCollection entryEntity, DynamicObjectCollection industryWorkHourEntryCollection) {
        if (entryEntity.isEmpty()) {
            return;
        }
        HashMap industryId2StageCollection = Maps.newHashMapWithExpectedSize((int)industryWorkHourEntryCollection.size());
        for (DynamicObject industryWorkHourEntry : industryWorkHourEntryCollection) {
            DynamicObjectCollection collection = industryWorkHourEntry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject dynamicObject : collection) {
                List values = industryId2StageCollection.computeIfAbsent(dynamicObject.getLong("stage_industry_id"), k -> new ArrayList(10));
                values.add(Lists.newArrayList((Object[])new Object[]{dynamicObject.getLong("stage_industry_id"), dynamicObject.getInt("stage_stage"), dynamicObject.getBigDecimal("stage_percentage")}));
            }
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        int entryEntitySize = entryEntity.size();
        for (int i = 0; i < entryEntitySize; ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            List values = (List)industryId2StageCollection.get(dynamicObject.getLong("s_industry_id"));
            if (values == null || values.isEmpty()) continue;
            model.setEntryCurrentRowIndex("s_entryentity", i);
            TableValueSetter tvs = new TableValueSetter(new String[]{"s_stage_industry", "s_stage_stage", "s_stage_percentage"});
            for (List value : values) {
                tvs.addRow(value.toArray());
            }
            model.batchCreateNewEntryRow("s_subentryentity_stage", tvs);
        }
        model.endInit();
        EntryGrid entryGrid = (EntryGrid)this.getControl("s_entryentity");
        entryGrid.selectRows(0);
        this.getView().updateView("s_subentryentity_stage");
    }

    private void addStageEntryData4Estimate(DynamicObjectCollection entryEntity, DynamicObjectCollection collection) {
        if (entryEntity.isEmpty()) {
            return;
        }
        HashMap industry2Values = Maps.newHashMapWithExpectedSize((int)collection.size());
        for (DynamicObject dynamicObject : collection) {
            DynamicObjectCollection subCollection = dynamicObject.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntryEntity : subCollection) {
                long industryId = subEntryEntity.getLong("stage_industry_id");
                ArrayList value = Lists.newArrayListWithExpectedSize((int)7);
                value.add(subEntryEntity.get("stage_stage"));
                value.add(subEntryEntity.get("stage_industryone_id"));
                value.add(subEntryEntity.get("stage_industry_id"));
                value.add(subEntryEntity.get("stage_percentage"));
                List values = industry2Values.computeIfAbsent(industryId, k -> new ArrayList());
                values.add(value);
            }
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        int size = entryEntity.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            long industryId = dynamicObject.getLong("industry_id");
            List values = (List)industry2Values.get(industryId);
            if (values == null) continue;
            BigDecimal routineWorkHour = dynamicObject.getBigDecimal("routineworkhour");
            BigDecimal nonRoutineWorkHour = dynamicObject.getBigDecimal("nonroutineworkhour");
            BigDecimal totalHours = dynamicObject.getBigDecimal("totalhours");
            model.setEntryCurrentRowIndex("entryentity", i);
            TableValueSetter tvs = new TableValueSetter(WorkHourEstimateBillConsts.STAGE_SUBENTRY_FIELDS.toArray(new String[0]));
            for (List value : values) {
                BigDecimal percentage = (BigDecimal)value.get(value.size() - 1);
                value.add(routineWorkHour.multiply(percentage));
                value.add(nonRoutineWorkHour.multiply(percentage));
                value.add(totalHours.multiply(percentage));
                tvs.addRow(value.toArray());
            }
            model.batchCreateNewEntryRow("subentryentity_stage", tvs);
        }
        model.endInit();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.selectRows(0);
        this.getView().updateView("subentryentity_stage");
    }

    private void deleteStageWorkHourEntryData4Estimate(int rowCount) {
        this.getModel().deleteEntryData("entryentity_summary");
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setEntryCurrentRowIndex("entryentity", i);
            this.getModel().deleteEntryData("subentryentity_stage");
            this.getModel().deleteEntryData("subentryentity_daily");
        }
    }

    private void deleteStageWorkHourEntryData4Standard(int rowCount) {
        this.getModel().deleteEntryData("s_entryentity_summary");
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setEntryCurrentRowIndex("s_entryentity", i);
            this.getModel().deleteEntryData("s_subentryentity_stage");
            this.getModel().deleteEntryData("s_subentryentity_daily");
        }
    }

    private void deleteAllWorkHourEntryData4Estimate() {
        this.deleteStageWorkHourEntryData4Estimate(this.getModel().getEntryRowCount("entryentity"));
        this.getModel().deleteEntryData("entryentity");
    }

    private void estimatedWorkHourChanged(ChangeData changeData) {
        String matchStageWorkHourTemplateId;
        this.clearEstimateWorkHour();
        this.deleteAllWorkHourEntryData4Estimate();
        Object newValue = changeData.getNewValue();
        if (newValue == null) {
            return;
        }
        DynamicObject estimatedWorkHourTemplate = (DynamicObject)newValue;
        DynamicObjectCollection collection = estimatedWorkHourTemplate.getDynamicObjectCollection("entryentity");
        if (collection.isEmpty()) {
            return;
        }
        WorkHourTemplateHelper.sortByIndustry((DynamicObjectCollection)collection);
        TableValueSetter tvs = new TableValueSetter(WorkHourEstimateBillConsts.ENTRY_FIELDS.toArray(new String[0]));
        for (DynamicObject dynamicObject : collection) {
            Object[] values = new Object[]{dynamicObject.get("industryone_id"), dynamicObject.get("industry_id"), dynamicObject.get("routinestatisticalhour"), dynamicObject.get("nonroutinestatisticalhour"), dynamicObject.get("routineworkhour"), dynamicObject.get("nonroutineworkhour"), dynamicObject.get("totalhours")};
            tvs.addRow(values);
        }
        EntryGridHelper.batchCreateNewEntryRow((IFormView)this.getView(), (String)"entryentity", (TableValueSetter)tvs);
        this.summaryEstimateWorkHour("estimate", "entryentity", "routineworkhour", "nonroutineworkhour");
        DynamicObject stageWorkHourTemplate = (DynamicObject)this.getModel().getValue("stage_workhour");
        if (stageWorkHourTemplate != null && (StringUtils.isEmpty((CharSequence)(matchStageWorkHourTemplateId = this.getPageCache().get(CACHEKEY_MATCH_STAGE_WORKHOUR_TEMPLATE_ID))) || matchStageWorkHourTemplateId.equals(stageWorkHourTemplate.getString("id")))) {
            changeData = new ChangeData(-1, changeData.getDataEntity(), null, (Object)stageWorkHourTemplate);
            this.stageWorkHourChanged(changeData);
        }
    }

    private void addFilters(List<QFilter> filters, Map<String, Boolean> matchConditionMap, boolean isest) {
        if (isest) {
            for (Map.Entry<String, Boolean> entry : matchConditionMap.entrySet()) {
                String key;
                if (!entry.getValue().booleanValue() || (key = entry.getKey()).contains("s_")) continue;
                if (key.equals("customer_id")) {
                    QFilter cusfilter = new QFilter(key, "=", this.getModel().getValue(key));
                    cusfilter.or(new QFilter(key, "=", (Object)0L));
                    cusfilter.or(new QFilter(key, "is null", (Object)0L));
                    filters.add(cusfilter);
                    continue;
                }
                filters.add(new QFilter(key, "=", this.getModel().getValue(key)));
            }
        } else {
            for (Map.Entry<String, Boolean> entry : matchConditionMap.entrySet()) {
                String key;
                if (!entry.getValue().booleanValue() || !(key = entry.getKey()).contains("s_")) continue;
                if ((key = key.substring(2, key.length())).equals("customer_id")) {
                    QFilter cusfilter = new QFilter(key, "=", this.getModel().getValue(key));
                    cusfilter.or(new QFilter(key, "=", (Object)0L));
                    cusfilter.or(new QFilter(key, "is null", (Object)0L));
                    filters.add(cusfilter);
                    continue;
                }
                filters.add(new QFilter(key, "=", this.getModel().getValue(key)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void estimateWorkHours(String method, boolean estimate, boolean standard) {
        int stage;
        DynamicObject stageWorkHour = (DynamicObject)this.getModel().getValue("stage_workhour");
        int n = stage = stageWorkHour == null ? ((Integer)this.getModel().getValue("stage")).intValue() : stageWorkHour.getInt("stage");
        if (stage == 0) {
            this.getView().showTipNotification(LocaleStringHelper.buildEmptyFieldValueMsg((IDataEntityType)this.getModel().getDataEntityType(), (String)"stage"));
            return;
        }
        long resourcePlanId = (Long)this.getModel().getValue("resourceplanid");
        if (resourcePlanId == 0L) {
            this.getView().showTipNotification(LocaleStringHelper.buildEmptyFieldValueMsg((IDataEntityType)this.getModel().getDataEntityType(), (String)"resourceplan"));
            return;
        }
        Tuple tuple = WorkHourTemplateHelper.getResourcePlanInfo((long)resourcePlanId);
        Date startTime = (Date)tuple.item1;
        if (startTime == null) {
            this.getView().showTipNotification(LocaleStringHelper.buildEmptyQueryResultMsg((String)"pmpd_resourceplan", (String)"preapproachtime"));
            return;
        }
        BigDecimal trt = (BigDecimal)tuple.item2;
        if (trt.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(LocaleStringHelper.buildEmptyQueryResultMsg((String)"pmpd_resourceplan", (String)"workrepaircycle"));
            return;
        }
        if (trt.intValue() < stage) {
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u9700\u5927\u4e8e\u7b49\u4e8e\u201c%2$s\u201d\u3002", (String)"WorkHourEstimateBillEdit_16", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"trt"), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"stage")));
            return;
        }
        String errorMsg = null;
        try {
            DynamicObjectCollection industryWokrHourEntryCollection;
            EstimateContext estimateContext = EstimateContext.get();
            WorkHourTemplateHelper.resetContext((EstimateContext)estimateContext, (Date)startTime, (BigDecimal)trt, (DynamicObject)stageWorkHour, (DynamicObject)this.getModel().getDataEntity());
            DynamicObject workHourEstimateBill = this.getModel().getDataEntity(true);
            if (estimate) {
                industryWokrHourEntryCollection = this.getModel().getEntryEntity("entryentity");
                if (industryWokrHourEntryCollection.isEmpty()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c\u4f30\u7b97\u5de5\u65f6\u201d\u9875\u7b7e\u4e0b\u7684\u201c%s\u201d\u6570\u636e\u4e3a\u7a7a\u3002", (String)"WorkHourEstimateBillEdit_19", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getEntityDisplayName((IDataEntityType)industryWokrHourEntryCollection.getDynamicObjectType())));
                    return;
                }
                estimateContext.initEstimateContext();
                WorkHourEstimateHelper.estimateWorkHour((boolean)true, (DynamicObject)workHourEstimateBill, null);
            }
            if (standard) {
                industryWokrHourEntryCollection = this.getModel().getEntryEntity("s_entryentity");
                if (industryWokrHourEntryCollection.isEmpty()) {
                    errorMsg = String.format(ResManager.loadKDString((String)"\u201c\u6807\u51c6\u5de5\u65f6\u201d\u9875\u7b7e\u4e0b\u7684\u201c%s\u201d\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u83b7\u53d6\u6807\u51c6\u5de5\u65f6\u3002", (String)"WorkHourEstimateBillEdit_20", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getEntityDisplayName((IDataEntityType)industryWokrHourEntryCollection.getDynamicObjectType()));
                    standard = false;
                } else {
                    estimateContext.initStandardContext();
                    WorkHourEstimateHelper.estimateWorkHour((boolean)false, (DynamicObject)workHourEstimateBill, null);
                }
            }
        }
        finally {
            EstimateContext.remove();
        }
        this.afterEstimatedWorkHours(estimate, standard, errorMsg);
    }

    private void afterEstimatedWorkHours(boolean estimate, boolean standard, String errorMsg) {
        this.getModel().updateCache();
        if (estimate) {
            this.getView().updateView("subentryentity_daily");
            this.getView().updateView("entryentity_summary");
        }
        if (standard) {
            this.getView().updateView("s_subentryentity_daily");
            this.getView().updateView("s_entryentity_summary");
        }
        if (errorMsg == null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5de5\u65f6\u4f30\u7b97\u5b8c\u6210\u3002", (String)"WorkHourEstimateBillEdit_5", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            String billStatus = (String)this.getModel().getValue("billstatus");
            if ("B".equals(billStatus)) {
                SaveServiceHelper.saveOperate((String)"pmpd_hour_estimate", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, (OperateOption)OperateOption.create());
            }
        } else {
            String title = "";
            if (estimate) {
                title = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u8ba1\u7b97\u6210\u529f%2$s", (String)"WorkHourEstimateBillEdit_25", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f30\u7b97\u5de5\u65f6", (String)"WorkHourEstimateBillEdit_26", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), "\uff0c");
            }
            title = title + String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8ba1\u7b97\u5931\u8d25", (String)"WorkHourEstimateBillEdit_27", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6807\u51c6\u5de5\u65f6", (String)"WorkHourEstimateBillEdit_28", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            this.getView().showMessage(title, errorMsg, MessageTypes.Default);
        }
    }

    private void showMatchConditionConfigForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pmpd_match_condition");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MATCH_CONDITION));
        this.getView().showForm(formShowParameter);
    }

    private void addFilters4WorkHourTemplate(String sourceMethod, List<QFilter> customFilters, boolean isest) {
        String matchConditionStr;
        if ("getLookUpList".equals(sourceMethod)) {
            customFilters.add(new QFilter("sourcebillid", "=", (Object)0));
        }
        if (StringUtils.isEmpty((CharSequence)(matchConditionStr = this.getPageCache().get(MATCH_CONDITION)))) {
            return;
        }
        Map matchConditionMap = (Map)SerializationUtils.fromJsonString((String)matchConditionStr, HashMap.class);
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)matchConditionMap.size());
        this.addFilters(filters, matchConditionMap, isest);
        customFilters.addAll(filters);
    }

    protected void summaryEstimateWorkHour(String workHourType, String entryKey, String routineWorkHourKey, String nonRoutineWorkHourKey) {
        if (workHourType.equals(this.getModel().getValue("workhourtype"))) {
            BigDecimal totalRoutineWorkHour = BigDecimal.ZERO;
            BigDecimal totalNonRoutineWorkHour = BigDecimal.ZERO;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryKey);
            for (DynamicObject dynamicObject : entryEntity) {
                BigDecimal routineWorkhour = dynamicObject.getBigDecimal(routineWorkHourKey);
                BigDecimal nonroutineWorkhour = dynamicObject.getBigDecimal(nonRoutineWorkHourKey);
                totalRoutineWorkHour = totalRoutineWorkHour.add(routineWorkhour);
                totalNonRoutineWorkHour = totalNonRoutineWorkHour.add(nonroutineWorkhour);
            }
            this.setEstimateWorkHour(totalRoutineWorkHour, totalNonRoutineWorkHour);
        }
    }

    private void clearEstimateWorkHour() {
        if ("estimate".equals(this.getModel().getValue("workhourtype"))) {
            this.getModel().setValue("totalroutworkhour", (Object)BigDecimal.ZERO);
            this.getModel().setValue("totalnoroutworkhour", (Object)BigDecimal.ZERO);
            this.getModel().setValue("totalestimateworkhour", (Object)BigDecimal.ZERO);
        }
    }

    private void setEstimateWorkHour(BigDecimal totalRoutineWorkHour, BigDecimal totalNonRoutineWorkHour) {
        this.getModel().setValue("totalroutworkhour", (Object)totalRoutineWorkHour);
        this.getModel().setValue("totalnoroutworkhour", (Object)totalNonRoutineWorkHour);
        this.getModel().setValue("totalestimateworkhour", (Object)totalRoutineWorkHour.add(totalNonRoutineWorkHour));
    }
}

