/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workinghours;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.pmc.pmpd.business.workhour.WorkHourHelper;
import kd.pmc.pmpd.common.helper.control.EntryGridHelper;

public class WorkHourEstimateBillHourEdit
extends AbstractFormPlugin {
    private static String[] DAILY_FIELD = new String[]{"r_daily_industry", "r_daily_date", "r_daily_workhour"};

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("totalroutworkhour".equals(name) || "totalnoroutworkhour".equals(name)) {
            this.forecastWorkHourChanged();
        }
    }

    public void afterBindData(EventObject e) {
        boolean addnew;
        super.afterBindData(e);
        String resPlanNo = this.getPageCache().get("resplanno");
        String resourcePlanNo = (String)this.getModel().getValue("resourceplan");
        boolean bl = addnew = this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW;
        if (StringUtils.isEmpty((CharSequence)resPlanNo) && addnew || resPlanNo != null && !StringUtils.equals((CharSequence)resPlanNo, (CharSequence)resourcePlanNo)) {
            this.getReportWorkHour(resourcePlanNo, false);
        }
        this.getPageCache().put("resplanno", resourcePlanNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getReportWorkHour(String resourcePlanNo, boolean tip) {
        if (StringUtils.isEmpty((CharSequence)resourcePlanNo) && tip) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201d\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u201c\u3002", (String)"WorkHourEstimateBillHourEdit_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("r_entryentity_summary");
        model.deleteEntryData("r_entryentity");
        this.getView().updateView("r_subentryentity_daily");
        DataSet dataSet = WorkHourHelper.queryReportWorkHour((String)resourcePlanNo);
        if (dataSet == null || dataSet.isEmpty()) {
            if (tip) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6c47\u62a5\u5de5\u65f6\u83b7\u53d6\u5b8c\u6210\uff0c\u201d\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u201c\uff1a%s \u65e0\u6c47\u62a5\u5de5\u65f6\u3002", (String)"WorkHourEstimateBillHourEdit_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), resourcePlanNo));
            }
            return;
        }
        DataSet ds = dataSet.copy().select(new String[]{"reportdate", "activehours"}).groupBy(new String[]{"reportdate"}).sum("activehours").finish().select("TO_DATE(reportdate,'yyyy-MM-dd') reportdate,activehours").orderBy(new String[]{"reportdate"});
        try {
            TableValueSetter rptDailyTotal = new TableValueSetter(new String[]{"r_summary_date", "r_summary_workhour"});
            for (Row row : ds) {
                rptDailyTotal.addRow(new Object[]{row.get(0), row.get(1)});
            }
            EntryGridHelper.batchCreateNewEntryRow((IFormView)this.getView(), (String)"r_entryentity_summary", (TableValueSetter)rptDailyTotal);
            TableValueSetter rptEntryentity = new TableValueSetter(new String[]{"r_industry"});
            HashSet<Object> industrySet = new HashSet<Object>();
            ArrayList<TableValueSetter> dailys = new ArrayList<TableValueSetter>(4);
            dataSet = dataSet.select("industry,TO_DATE(reportdate,'yyyy-MM-dd'),activehours");
            TableValueSetter currentRpt = null;
            for (Row row : dataSet) {
                Object industry = row.get(0);
                if (industry == null || (Long)industry == 0L) continue;
                if (industrySet.add(industry)) {
                    rptEntryentity.addRow(new Object[]{industry});
                    currentRpt = new TableValueSetter(DAILY_FIELD);
                    dailys.add(currentRpt);
                }
                if (currentRpt == null) continue;
                currentRpt.addRow(new Object[]{industry, row.get(1), row.get(2)});
            }
            EntryGridHelper.batchCreateNewEntryRow((IFormView)this.getView(), (String)"r_entryentity", (TableValueSetter)rptEntryentity);
            model.beginInit();
            for (int i = 0; i < dailys.size(); ++i) {
                model.setEntryCurrentRowIndex("r_entryentity", i);
                model.deleteEntryData("r_subentryentity_daily");
                model.batchCreateNewEntryRow("r_subentryentity_daily", (TableValueSetter)dailys.get(i));
            }
            model.endInit();
            EntryGrid entryGrid = (EntryGrid)this.getControl("r_entryentity");
            entryGrid.selectRows(0);
            this.getView().updateView("r_subentryentity_daily");
            if (tip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u62a5\u5de5\u65f6\u83b7\u53d6\u5b8c\u6210\u3002", (String)"WorkHourEstimateBillHourEdit_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            }
        }
        finally {
            ds.close();
            dataSet.close();
        }
    }

    public void forecastWorkHourChanged() {
        BigDecimal totalRoutinewWorkHour = (BigDecimal)this.getModel().getValue("totalroutworkhour");
        BigDecimal totalNonRoutinewWorkHour = (BigDecimal)this.getModel().getValue("totalnoroutworkhour");
        BigDecimal workrepaircycle = (BigDecimal)this.getModel().getValue("workrepaircycle");
        if (totalRoutinewWorkHour != null && totalNonRoutinewWorkHour != null && workrepaircycle != null && workrepaircycle.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal dayavghours = totalRoutinewWorkHour.add(totalNonRoutinewWorkHour).divide(workrepaircycle, 2, 4);
            this.getModel().setValue("dayavghours", (Object)dayavghours);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("rptwkhour".equals(key)) {
            this.getReportWorkHour((String)this.getModel().getValue("resourceplan"), true);
        }
    }
}

