/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workinghours;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.pmc.pmpd.business.workhour.WorkHourTemplateHelper;
import kd.pmc.pmpd.common.bigtask.BigTaskHelper;

public class WorkHourTemplateListPlugin
extends AbstractListPlugin {
    private static final String OP_AUDIT = "audit";
    private static final String CALLBACKID_CHANGE = "change";

    public void setFilter(SetFilterEvent e) {
        QFilter filter;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object number = customParams.get("number");
        if (number != null) {
            String numberPrefix = number + "_";
            filter = new QFilter("number", "like", (Object)(numberPrefix + "%"));
            e.setOrderBy("version desc");
        } else {
            filter = new QFilter("sourcebillid", "=", (Object)0);
        }
        e.addCustomQFilter(filter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("number")) {
            args.setCancel(true);
            this.getView().invokeOperation("view");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData;
        List enableIds;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (OP_AUDIT.equals(formOperate.getOperateKey()) && !(enableIds = (listSelectedData = formOperate.getListSelectedData()).stream().filter(listSelectedRow -> "D".equals(listSelectedRow.getBillStatus())).map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList())).isEmpty()) {
            formOperate.getOption().setVariableValue("enableIds", SerializationUtils.toJsonString(enableIds));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (OP_AUDIT.equals(operateKey)) {
            List successPkIds = args.getOperationResult().getSuccessPkIds();
            if (successPkIds.isEmpty()) {
                return;
            }
            FormOperate formOperate = (FormOperate)args.getSource();
            OperateOption option = formOperate.getOption();
            String enableIdsStr = option.getVariableValue("enableIds", "");
            if (StringUtils.isEmpty((CharSequence)enableIdsStr)) {
                return;
            }
            HashSet successPkIdSet = Sets.newHashSet((Iterable)successPkIds);
            List enableIds = (List)SerializationUtils.fromJsonString((String)enableIdsStr, List.class);
            enableIds.removeIf(enableId -> !successPkIdSet.contains(enableId));
            if (enableIds.isEmpty()) {
                return;
            }
            String sourceEntityId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
            long createOrgId = formOperate.getListFocusRow().getMainOrgId();
            WorkHourTemplateHelper.afterAudit((AbstractFormPlugin)this, (String)sourceEntityId, (List)enableIds, (long)createOrgId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (CALLBACKID_CHANGE.equals(actionId) && returnData instanceof Map) {
            BigTaskHelper.showBigTaskResult((IFormView)this.getView(), (Map)((Map)returnData), data -> this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6a21\u677f\u53d8\u66f4\u6210\u529f\u3002", (String)"WorkHourTemplateListPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0])));
        }
    }
}

