/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workinghours;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class WorkHourTemplateReportEdit
extends AbstractFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid resourcePlanEntryGrid = (EntryGrid)this.getControl("resourceplan_entryentity");
        resourcePlanEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid estimatedEntryGrid = (EntryGrid)this.getControl("estimate_entryentity");
        estimatedEntryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("resourceplan".equals(fieldName)) {
            this.showBillForm("pmpd_resourceplan", this.getModel().getValue(fieldName + "id", hyperLinkClickEvent.getRowIndex()));
        } else if ("pre_estimatedbill".equals(fieldName) || "cur_estimatedbill".equals(fieldName)) {
            this.showBillForm("pmpd_hour_estimate", this.getModel().getValue(fieldName + "id", hyperLinkClickEvent.getRowIndex()));
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        if (row != -1) {
            this.showDifferentBySubEntry(row);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String reason = (String)this.getModel().getValue("reason");
        if ("estimate_workhour".equals(reason)) {
            this.showDifferentByEntry();
        } else {
            this.showStageView();
            this.showDifferentBySubEntry(0);
        }
    }

    private void showStageView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"pre_routineworkhour", "cur_routineworkhour", "pre_nonroutineworkhour", "cur_nonroutineworkhour"});
        HashMap<String, LocaleString> paramMap = new HashMap<String, LocaleString>(2);
        paramMap.put("text", new LocaleString(ResManager.loadKDString((String)"\u9636\u6bb5\u884c\u4e1a\u6570\u636e", (String)"WorkHourTemplateReportEdit_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0])));
        this.getView().updateControlMetadata("advconap1", paramMap);
    }

    private void showDifferentBySubEntry(int parentRowIndex) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("estimate_entryentity", parentRowIndex);
        if (entryRowEntity == null) {
            return;
        }
        DynamicObjectCollection subEntryEntity = entryRowEntity.getDynamicObjectCollection("subentryentity");
        if (subEntryEntity.isEmpty()) {
            return;
        }
        ArrayList<Integer> differentIndexs = new ArrayList<Integer>(10);
        int subEntryEntitySize = subEntryEntity.size();
        for (int i = 0; i < subEntryEntitySize; ++i) {
            boolean isDifferent;
            DynamicObject subEntry = (DynamicObject)subEntryEntity.get(i);
            boolean bl = isDifferent = subEntry.getBigDecimal("pre_percentage").compareTo(subEntry.getBigDecimal("cur_percentage")) != 0;
            if (!isDifferent) continue;
            differentIndexs.add(i);
        }
        if (differentIndexs.isEmpty()) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("subentryentity");
        entryGrid.setRowBackcolor("#FFF1DC", differentIndexs.stream().mapToInt(Integer::intValue).toArray());
    }

    private void showDifferentByEntry() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("estimate_entryentity");
        if (entryEntity.isEmpty()) {
            return;
        }
        ArrayList<Integer> differentIndexs = new ArrayList<Integer>(10);
        int size = entryEntity.size();
        for (int i = 0; i < size; ++i) {
            boolean isDifferent;
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            boolean bl = isDifferent = entry.getBigDecimal("pre_routineworkhour").compareTo(entry.getBigDecimal("cur_routineworkhour")) != 0 || entry.getBigDecimal("pre_nonroutineworkhour").compareTo(entry.getBigDecimal("cur_nonroutineworkhour")) != 0;
            if (!isDifferent) continue;
            differentIndexs.add(i);
        }
        if (differentIndexs.isEmpty()) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("estimate_entryentity");
        entryGrid.setRowBackcolor("#FFF1DC", differentIndexs.stream().mapToInt(Integer::intValue).toArray());
    }

    private void showBillForm(String formId, Object pkId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(formId);
        billShowParameter.setPkId(pkId);
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }
}

