/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workinghours.rpt;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class WPRptEditPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterItemInfo year = queryParam.getFilter().getFilterItem("year");
        Calendar instance = Calendar.getInstance();
        if (Objects.isNull(year.getValue())) {
            instance.setTime(new Date());
        } else {
            instance.setTime((Date)year.getValue());
        }
        if (Objects.isNull(year.getValue())) {
            instance.setTime(new Date());
        } else {
            instance.setTime((Date)year.getValue());
        }
        this.getPageCache().put("year", "" + instance.get(1));
        this.buildCols("reportlistap");
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterItemInfo year = queryParam.getFilter().getFilterItem("year");
        if (Objects.isNull(year.getValue())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e74\u5ea6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"WPRptEditPlugin_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            return false;
        }
        FilterItemInfo type = queryParam.getFilter().getFilterItem("rpttype");
        if (Objects.isNull(type.getValue())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5c55\u793a\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"WPRptEditPlugin_5", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            return false;
        }
        FilterItemInfo status = queryParam.getFilter().getFilterItem("pulishstatus");
        if (Objects.isNull(status.getValue())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u72b6\u6001\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"WPRptEditPlugin_6", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    private void buildCols(String marks) {
        ReportList ls = (ReportList)this.getControl(marks);
        List columns = ls.getColumns();
        columns.add(this.getProfessionaCol());
        columns.add(this.getIstotalCol());
        this.addMonthColunms(columns);
    }

    private ReportColumn getProfessionaCol() {
        ReportColumn newCol = new ReportColumn();
        ColumnStyle columnStyle = new ColumnStyle();
        newCol.setStyle(columnStyle);
        newCol.setFieldKey("professiona");
        newCol.setFieldType("text");
        newCol.setWidth(new LocaleString("80px"));
        newCol.setCaption(new LocaleString(this.getProDisplayname()));
        return newCol;
    }

    private ReportColumn getIstotalCol() {
        ReportColumn newCol = new ReportColumn();
        newCol.setFieldKey("istotal");
        newCol.setHide(true);
        newCol.setFieldType("integer");
        newCol.setCaption(new LocaleString(this.getHjDisplayname()));
        return newCol;
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        Object cellStyleRule;
        ReportColumn col;
        CellStyleRule cellStyleRule2;
        ReportColumn col2;
        ReportColumnGroup grp;
        int i;
        super.setCellStyleRules(cellStyleRules);
        ReportList ls = (ReportList)this.getControl("reportlistap");
        if (ls.getColumns().isEmpty()) {
            this.buildCols("reportlistap");
        }
        List columns = ls.getColumns();
        for (i = 0; i < columns.size(); ++i) {
            if (columns.get(i) instanceof ReportColumnGroup) {
                grp = (ReportColumnGroup)columns.get(i);
                for (AbstractReportColumn c : grp.getChildren()) {
                    col2 = (ReportColumn)c;
                    cellStyleRule2 = new CellStyleRule();
                    cellStyleRule2.setFieldKey(col2.getFieldKey());
                    cellStyleRule2.setForeColor("#fb2323");
                    cellStyleRule2.setCondition(String.format("%s_int > 0 and istotal < 1 ", col2.getFieldKey()));
                    cellStyleRules.add(cellStyleRule2);
                }
                continue;
            }
            col = (ReportColumn)columns.get(i);
            if (col.getFieldKey().equals("professiona")) {
                cellStyleRule = new CellStyleRule();
                cellStyleRule.setFieldKey(col.getFieldKey());
                cellStyleRule.setForeColor("#87ADFF");
                cellStyleRule.setCondition(" istotal < 1 ");
                cellStyleRules.add((CellStyleRule)cellStyleRule);
                continue;
            }
            cellStyleRule = new CellStyleRule();
            cellStyleRule.setFieldKey(col.getFieldKey());
            cellStyleRule.setForeColor("#fb2323");
            cellStyleRule.setCondition(String.format("%s_int > 0 and istotal < 1 ", col.getFieldKey()));
            cellStyleRules.add((CellStyleRule)cellStyleRule);
        }
        for (i = 0; i < columns.size(); ++i) {
            if (columns.get(i) instanceof ReportColumnGroup) {
                grp = (ReportColumnGroup)columns.get(i);
                for (AbstractReportColumn c : grp.getChildren()) {
                    col2 = (ReportColumn)c;
                    cellStyleRule2 = new CellStyleRule();
                    cellStyleRule2.setFieldKey(col2.getFieldKey());
                    cellStyleRule2.setDegree(1);
                    cellStyleRule2.setBackgroundColor("#FFFCF0");
                    cellStyleRule2.setCondition(String.format("%s_int < 1 and istotal > 0 ", col2.getFieldKey()));
                    cellStyleRules.add(cellStyleRule2);
                }
                continue;
            }
            col = (ReportColumn)columns.get(i);
            if (col.getFieldKey().equals("professiona")) {
                cellStyleRule = new CellStyleRule();
                cellStyleRule.setFieldKey(col.getFieldKey());
                cellStyleRule.setForeColor("#87ADFF");
                cellStyleRule.setCondition(" istotal < 1 ");
                cellStyleRules.add((CellStyleRule)cellStyleRule);
                continue;
            }
            cellStyleRule = new CellStyleRule();
            cellStyleRule.setFieldKey(col.getFieldKey());
            cellStyleRule.setBackgroundColor("#FFFCF0");
            cellStyleRule.setCondition(String.format("%s_int < 1 and istotal>0 ", col.getFieldKey()));
            cellStyleRules.add((CellStyleRule)cellStyleRule);
        }
        for (i = 0; i < columns.size(); ++i) {
            if (columns.get(i) instanceof ReportColumnGroup) {
                grp = (ReportColumnGroup)columns.get(i);
                for (AbstractReportColumn c : grp.getChildren()) {
                    col2 = (ReportColumn)c;
                    cellStyleRule2 = new CellStyleRule();
                    cellStyleRule2.setFieldKey(col2.getFieldKey());
                    cellStyleRule2.setForeColor("#fb2323");
                    cellStyleRule2.setBackgroundColor("#FFFCF0");
                    cellStyleRule2.setCondition(String.format("%s_int > 0 and istotal > 0 ", col2.getFieldKey()));
                    cellStyleRules.add(cellStyleRule2);
                }
                continue;
            }
            col = (ReportColumn)columns.get(i);
            if (col.getFieldKey().equals("professiona")) {
                cellStyleRule = new CellStyleRule();
                cellStyleRule.setFieldKey(col.getFieldKey());
                cellStyleRule.setForeColor("#87ADFF");
                cellStyleRule.setCondition(" istotal < 1 ");
                cellStyleRules.add((CellStyleRule)cellStyleRule);
                continue;
            }
            cellStyleRule = new CellStyleRule();
            cellStyleRule.setFieldKey(col.getFieldKey());
            cellStyleRule.setForeColor("#fb2323");
            cellStyleRule.setBackgroundColor("#FFFCF0");
            cellStyleRule.setCondition(String.format("%s_int > 0 and istotal>0 ", col.getFieldKey()));
            cellStyleRules.add((CellStyleRule)cellStyleRule);
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        if (Objects.nonNull(rowData) && !rowData.isEmpty()) {
            for (DynamicObject dy : rowData) {
                for (IDataEntityProperty p : dy.getDynamicObjectType().getProperties()) {
                    BigDecimal v;
                    if (!(dy.get(p.getName()) instanceof BigDecimal) || (v = dy.getBigDecimal(p.getName())).compareTo(BigDecimal.ZERO) >= 0) continue;
                    dy.set(String.format("%s_int", p.getName()), (Object)1);
                }
            }
        }
    }

    private void addMonthColunms(List<AbstractReportColumn> columns) {
        ReportColumnGroup yeargrp = new ReportColumnGroup();
        yeargrp.setFieldKey("yeargrp");
        yeargrp.setCaption(new LocaleString(this.getPageCache().get("year")));
        for (Month m : Month.values()) {
            yeargrp.getChildren().addAll(this.createMonthColunm(m));
        }
        columns.add((AbstractReportColumn)yeargrp);
    }

    private List<ReportColumn> createMonthColunm(Month m) {
        ArrayList<ReportColumn> list = new ArrayList<ReportColumn>(2);
        ReportColumn newCol = new ReportColumn();
        newCol.setHide(false);
        newCol.setWidth(new LocaleString("100px"));
        newCol.setScale(2);
        newCol.setFieldKey(m.getDisplayName(TextStyle.SHORT, Locale.ENGLISH));
        newCol.setFieldType("decimal");
        newCol.setScale(0);
        if ("en-US".equals(Lang.get().getLangTag())) {
            newCol.setCaption(new LocaleString(m.getDisplayName(TextStyle.SHORT, Locale.ENGLISH)));
        } else {
            newCol.setCaption(new LocaleString(m.getDisplayName(TextStyle.SHORT, Locale.SIMPLIFIED_CHINESE)));
        }
        list.add(newCol);
        ReportColumn newintCol = new ReportColumn();
        newintCol.setHide(true);
        newintCol.setFieldKey(String.format("%s_int", m.getDisplayName(TextStyle.SHORT, Locale.ENGLISH)));
        newintCol.setFieldType("integer");
        newintCol.setCaption(new LocaleString(m.getDisplayName(TextStyle.SHORT, Locale.SIMPLIFIED_CHINESE)));
        list.add(newintCol);
        return list;
    }

    private String getHjDisplayname() {
        return ResManager.loadKDString((String)"\u662f\u5426\u5408\u8ba1", (String)"WPRptEditPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private String getProDisplayname() {
        return ResManager.loadKDString((String)"\u4e13\u4e1a", (String)"WPRptEditPlugin_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }

    private Set getOrgIds() {
        QFilter[] filters = new QFilter[]{new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE), new QFilter("view.number", "=", (Object)"ProjectManageSchemeDefault")};
        Map structureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org", (QFilter[])filters);
        if (!structureMap.isEmpty()) {
            HashSet ids = Sets.newHashSetWithExpectedSize((int)structureMap.size());
            for (Map.Entry entry : structureMap.entrySet()) {
                ids.add(((DynamicObject)entry.getValue()).get("org_id"));
            }
            HashSet<Long> orgIds = new HashSet<Long>(8);
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), null, (String)"pmpd_workloadrpt", (String)"47150e89000000ac");
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                Iterator iterator = hasPermOrgResult.getHasPermOrgs().iterator();
                while (iterator.hasNext()) {
                    long orgId = (Long)iterator.next();
                    if (!ids.contains(orgId)) continue;
                    orgIds.add(orgId);
                }
                if (orgIds.isEmpty()) {
                    return ids;
                }
                return orgIds;
            }
            return ids;
        }
        return new HashSet();
    }

    public void initialize() {
        super.initialize();
        OrgEdit orgEdit = (OrgEdit)this.getControl("projectorg");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        if (StringUtils.equals((CharSequence)args.getProperty().getName(), (CharSequence)"projectorg")) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)this.getOrgIds()));
        }
    }
}

