/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workpackage;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.business.helper.TXServiceHelper;
import kd.pmc.pmpd.common.helper.LocaleStringHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.model.WorkPackageProjectInfo;
import kd.pmc.pmpd.common.util.WorkPackImportUtils;
import kd.pmc.pmpd.common.util.WorkPackageUtils;
import kd.pmc.pmpd.formplugin.helper.WorkPackUtils;
import kd.pmc.pmpd.formplugin.utils.BillModelUtils;

public class ExecuteWorkPackageEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Optional.ofNullable((BasedataEdit)this.getControl("project")).ifPresent(basedataEdit -> basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this));
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("source", (Object)"manuadd");
        this.getModel().setValue("manageid", this.getView().getFormShowParameter().getCustomParam("manageId"));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("project".equals(name)) {
            Long equipmentId = ObjectConverterWrapper.getLong((Object)this.getView().getFormShowParameter().getCustomParam("equipmentId"));
            List projectIdList = WorkPackageUtils.listProjectIdByEquipmentId((long)equipmentId);
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", (Object)projectIdList));
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if ("entryentity".equals(name)) {
            int[] rowIndexs = e.getRowIndexs();
            ArrayList<Integer> errorRowIndexs = new ArrayList<Integer>(10);
            for (int rowIndex2 : rowIndexs) {
                String jobNo = (String)this.getModel().getValue("jobno", rowIndex2);
                if (!StringUtils.isNotBlank((CharSequence)jobNo)) continue;
                errorRowIndexs.add(rowIndex2);
            }
            if (errorRowIndexs.isEmpty()) {
                return;
            }
            e.setCancel(true);
            int size = errorRowIndexs.size();
            String jobPropName = LocaleStringHelper.getPropertyDisplayName((IDataEntityType)this.getModel().getDataEntityType(), (String)"jobno");
            String formatStr = ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u201c%2$s\u201d\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u5220\u884c\u3002", (String)"ExecuteWorkPackageEdit_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
            if (size == 1) {
                this.getView().showTipNotification(String.format(formatStr, (Integer)errorRowIndexs.get(0) + 1, jobPropName));
            } else {
                StringBuilder errorMsg = new StringBuilder();
                for (Integer errorRowIndex : errorRowIndexs) {
                    errorMsg.append(String.format(formatStr, errorRowIndex + 1, jobPropName)).append('\n');
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u884c\u6821\u9a8c", (String)"ExecuteWorkPackageEdit_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), errorMsg.toString(), MessageTypes.Default);
            }
            int[] normalRowIndexs = Arrays.stream(rowIndexs).filter(rowIndex -> !errorRowIndexs.contains(rowIndex)).toArray();
            if (ArrayUtils.isNotEmpty((int[])normalRowIndexs)) {
                this.getModel().beginInit();
                this.getModel().deleteEntryRows("entryentity", normalRowIndexs);
                this.getModel().endInit();
                this.getView().updateView("entryentity");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("project".equals(name)) {
            this.projectChanged((Long)this.getModel().getValue("project_id"));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("bar_getproject".equals(itemKey)) {
            if (this.hasWorkOrder()) {
                evt.setCancel(true);
                MainEntityType dataEntityType = this.getModel().getDataEntityType();
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u751f\u6210\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u201c%2$s\u201d\u3002", (String)"ExecuteWorkPackageEdit_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"jobno"), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"project")));
                return;
            }
            if (this.checkSupplementNo()) {
                evt.setCancel(true);
                MainEntityType dataEntityType = this.getModel().getDataEntityType();
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u201c%1$s\u201d\u4e3a\u201c0\u201d\u7684\u6570\u636e\uff0c\u624d\u5141\u8bb8\u4fee\u6539\u201c%2$s\u201d\u3002", (String)"ExecuteWorkPackageEdit_6", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"supplement"), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"project")));
            }
        } else if ("bar_adjustseq".equals(itemKey) && this.hasWorkOrder()) {
            evt.setCancel(true);
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u751f\u6210\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"ExecuteWorkPackageEdit_5", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"jobno")));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_handle_multipage".equals(itemKey)) {
            WorkPackUtils.showMultiPageProcessingList((AbstractFormPlugin)this, Lists.newArrayList((Object[])new Object[]{this.getModel().getValue("id")}));
        } else if ("bar_getproject".equals(itemKey)) {
            this.showSingleProjectSelectForm();
        } else if ("bar_view_versionrpt".equals(itemKey)) {
            WorkPackUtils.showVersionReport(this.getView(), new QFilter("workpack_id", "=", this.getModel().getValue("id")));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("save".equals(operateKey)) {
            boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            if (!fromDatabase) {
                Long manageId = ObjectConverterWrapper.getLong((Object)this.getView().getFormShowParameter().getCustomParam("manageId"));
                String name = (String)this.getModel().getValue("name");
                Tuple tuple = WorkPackImportUtils.getMaxSupplementNoAndProject((String)"pmpd_exec_workpack", (long)manageId, (String)name);
                String supplementNo = (String)tuple.item1;
                this.getModel().setValue("supplement", (Object)supplementNo);
                if (!"0".equals(supplementNo)) {
                    Long projectId = (Long)tuple.item2;
                    this.getModel().setItemValueByID("project", (Object)projectId);
                }
            }
        } else if (("newentry".equals(operateKey) || "moveentryup".equals(operateKey) || "moveentrydown".equals(operateKey)) && this.hasWorkOrder()) {
            args.setCancel(true);
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u751f\u6210\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"ExecuteWorkPackageEdit_5", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"jobno")));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if ("multiPage".equals(actionId)) {
            this.refreshPagination();
        } else if ("project".equals(actionId) && returnData instanceof Long) {
            this.projectSelectedCallBack((Long)returnData);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent(WorkPackUtils.getDataChangeType(this.getPageCache()));
        this.clearDirtyFlag();
    }

    private void clearDirtyFlag() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DynamicObjectType mainEntityType = dataEntity.getDynamicObjectType();
        int ordinal = mainEntityType.getProperty("contractid").getOrdinal();
        dataEntityState.setBizChanged(ordinal, false);
        ordinal = mainEntityType.getProperty("contractno").getOrdinal();
        dataEntityState.setBizChanged(ordinal, false);
        ordinal = mainEntityType.getProperty("checktype_id").getOrdinal();
        dataEntityState.setBizChanged(ordinal, false);
        ordinal = mainEntityType.getProperty("workscope_id").getOrdinal();
        dataEntityState.setBizChanged(ordinal, false);
    }

    private void refreshPagination() {
        HashSet fieldKeys = Sets.newHashSet((Object[])new String[]{"pagination", "entry_modifier_id", "entry_modifytime"});
        BillModelUtils.reloadFields((IBillModel)this.getModel(), fieldKeys, () -> this.getView().updateView("entryentity"));
    }

    private void showSingleProjectSelectForm() {
        Object projectId = this.getModel().getValue("project_id");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pmpd_singleproject_select");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("projectId", projectId);
        formShowParameter.setCustomParam("equipmentId", this.getView().getFormShowParameter().getCustomParam("equipmentId"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "project"));
        this.getView().showForm(formShowParameter);
    }

    private void projectSelectedCallBack(Long targetProjectId) {
        Long sourceProjectId = (Long)this.getModel().getValue("project_id");
        if (!sourceProjectId.equals(targetProjectId)) {
            WorkPackageProjectInfo workPackageProjectInfo = WorkPackageUtils.getWorkPackageProjectInfo((Long)targetProjectId);
            String name = (String)this.getModel().getValue("name");
            Map<String, List<Long>> workPackageIdMap = this.getWorkPackageIdByName(name);
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            ArrayList updateDatas = Lists.newArrayListWithExpectedSize((int)workPackageIdMap.size());
            for (Map.Entry<String, List<Long>> entry : workPackageIdMap.entrySet()) {
                List<Long> workPackageIds = entry.getValue();
                for (Long workPackageId : workPackageIds) {
                    DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType, (Object)workPackageId);
                    dynamicObject.set("project_id", (Object)targetProjectId);
                    if (workPackageProjectInfo == null) {
                        workPackageProjectInfo = new WorkPackageProjectInfo();
                    }
                    dynamicObject.set("contractid", (Object)workPackageProjectInfo.getContractId());
                    dynamicObject.set("contractno", (Object)workPackageProjectInfo.getContractNo());
                    dynamicObject.set("checktype_id", (Object)workPackageProjectInfo.getCheckTypeId());
                    dynamicObject.set("workscope_id", (Object)workPackageProjectInfo.getWorkScopeId());
                    DataEntityState dataEntityState = dynamicObject.getDataEntityState();
                    dataEntityState.setDirty((ISimpleProperty)dataEntityType.findProperty("contractid"), true);
                    dataEntityState.setDirty((ISimpleProperty)dataEntityType.findProperty("contractno"), true);
                    dataEntityState.setDirty((ISimpleProperty)dataEntityType.findProperty("checktype_id"), true);
                    dataEntityState.setDirty((ISimpleProperty)dataEntityType.findProperty("workscope_id"), true);
                    updateDatas.add(dynamicObject);
                }
            }
            HashMap<String, Long> name2ProjectId = new HashMap<String, Long>(2);
            name2ProjectId.put(name, targetProjectId);
            DynamicObject[] versionReport = WorkPackUtils.updateVersionDifferenceReport(name2ProjectId, workPackageIdMap);
            TXServiceHelper.executeWithTX(() -> {
                SaveServiceHelper.update((DynamicObject[])versionReport);
                SaveServiceHelper.update((DynamicObject[])updateDatas.toArray(new DynamicObject[0]));
            });
            HashSet fieldKeys = Sets.newHashSet((Object[])new String[]{"project", "contractid", "contractno", "checktype", "workscope"});
            BillModelUtils.reloadFields((IBillModel)this.getModel(), fieldKeys, () -> {
                this.getView().updateView("project");
                this.getView().updateView("workscope");
                this.getView().updateView("checktype");
                this.getView().updateView("checktypenumber");
                this.getView().updateView("workscopedetails");
                this.getView().updateView("contractid");
                this.getView().updateView("contractno");
            });
            WorkPackUtils.addDataChangeType(this.getPageCache(), "project");
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u9879\u76ee\u53f7\u6210\u529f\u3002", (String)"ExecuteWorkPackageEdit_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
    }

    private Map<String, List<Long>> getWorkPackageIdByName(String name) {
        Object manageId = this.getModel().getValue("manageid");
        HashSet names = Sets.newHashSet((Object[])new String[]{(String)this.getModel().getValue("name")});
        return WorkPackUtils.getWorkPackageIdByName(manageId, names);
    }

    private void projectChanged(Long newProjectId) {
        WorkPackageProjectInfo workPackageProjectInfo = WorkPackageUtils.getWorkPackageProjectInfo((Long)newProjectId);
        if (workPackageProjectInfo == null) {
            workPackageProjectInfo = new WorkPackageProjectInfo();
        }
        this.getModel().beginInit();
        this.getModel().setValue("contractid", (Object)workPackageProjectInfo.getContractId());
        this.getModel().setValue("contractno", (Object)workPackageProjectInfo.getContractNo());
        this.getModel().setItemValueByID("checktype", (Object)workPackageProjectInfo.getCheckTypeId());
        this.getModel().setItemValueByID("workscope", (Object)workPackageProjectInfo.getWorkScopeId());
        this.getModel().endInit();
        this.getView().updateView("checktype");
        this.getView().updateView("workscope");
        this.getView().updateView("contractid");
        this.getView().updateView("contractno");
        this.getView().updateView("workscopedetails");
        this.getView().updateView("checktypenumber");
        WorkPackUtils.addDataChangeType(this.getPageCache(), "project");
    }

    private boolean hasWorkOrder() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        return entryEntity.stream().filter(dynamicObject -> !WorkPackageUtils.checkCustomerWorkCardStatus((String)dynamicObject.getString("customer_jobcardstatus"))).anyMatch(dynamicObject -> StringUtils.isNotBlank((CharSequence)dynamicObject.getString("jobno")));
    }

    private boolean checkSupplementNo() {
        String supplementNo = (String)this.getModel().getValue("supplement");
        return !"0".equals(supplementNo);
    }
}

