/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workpackage;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.common.helper.LocaleStringHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.helper.control.EntryGridHelper;
import kd.pmc.pmpd.common.util.WorkPackageUtils;
import kd.pmc.pmpd.formplugin.helper.WorkPackUtils;
import kd.pmc.pmpd.formplugin.utils.BillModelUtils;

public class ExecuteWorkPackageManageEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain", "toolbar_panel_jobcard", "toolbar_internal_jobcard"});
        Optional.ofNullable((TextEdit)this.getControl("customer_workpkg_manage")).ifPresent(textEdit -> textEdit.addButtonClickListener((ClickListener)this));
        Optional.ofNullable((BasedataEdit)this.getControl("equipment")).ifPresent(basedataEdit -> basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this));
    }

    public void afterCreateNewData(EventObject e) {
        long executeOrgId = this.getDefaultExecuteOrg();
        this.getModel().setValue("executeorg", (Object)executeOrgId);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("equipment".equals(beforeF7SelectEvent.getProperty().getName())) {
            if (this.boundProject()) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u83b7\u53d6\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ExecuteWorkPackageManageEdit_13", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((String)"pmpd_exec_workpack", (String)"project")));
                return;
            }
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
            IDataEntityProperty property = basedataEdit.getProperty();
            LocaleString displayName = property.getDisplayName();
            formShowParameter.setCaption(displayName.toString());
            long customerWorkPackManageId = (Long)this.getModel().getValue("customer_workpkgmanageid");
            if (customerWorkPackManageId != 0L) {
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", this.getEquipmentIdByCustomerWorkPackManage(customerWorkPackManageId)));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("customer_workpkg_manage".equals(key)) {
            if (this.boundProject()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u83b7\u53d6\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ExecuteWorkPackageManageEdit_13", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((String)"pmpd_exec_workpack", (String)"project")));
                return;
            }
            this.showCustomerWorkPackageManageList();
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key = e.getKey();
        if ("customer_workpkg_manage".equals(key) && this.boundProject()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u83b7\u53d6\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ExecuteWorkPackageManageEdit_13", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((String)"pmpd_exec_workpack", (String)"project")));
            this.getView().updateView("customer_workpkg_manage");
            e.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("customer_workpkgmanageid".equals(name)) {
            this.customerWorkPackManageChanged(changeData);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("generateinternalmroorder".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entry_internal_jobcard");
            int[] selectRows = entryGrid.getSelectRows();
            if (ArrayUtils.isEmpty((int[])selectRows)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ExecuteWorkPackageManageEdit_11", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entry_internal_jobcard");
            ArrayList selectedEntryIds = Lists.newArrayListWithExpectedSize((int)selectRows.length);
            for (int selectRow : selectRows) {
                selectedEntryIds.add(((DynamicObject)collection.get(selectRow)).getPkValue());
            }
            formOperate.getOption().setVariableValue("selectedEntryIds", SerializationUtils.toJsonString((Object)selectedEntryIds));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        if ("generatepaneljobcard".equals(operateKey)) {
            BillModelUtils.reloadEntry((IBillView)this.getView(), "entry_panel_jobcard");
        } else if ("generateinternaljobcard".equals(operateKey)) {
            BillModelUtils.reloadEntry((IBillView)this.getView(), "entry_internal_jobcard");
        } else if ("generatepanelmroorder".equals(operateKey)) {
            BillModelUtils.reloadFields((IBillModel)this.getModel(), Sets.newHashSet((Object[])new String[]{"panel_jobno", "panel_jobid"}), () -> this.getView().updateView("entry_panel_jobcard"));
        } else if ("generateinternalmroorder".equals(operateKey)) {
            BillModelUtils.reloadFields((IBillModel)this.getModel(), Sets.newHashSet((Object[])new String[]{"internal_jobno", "internal_jobid"}), () -> this.getView().updateView("entry_internal_jobcard"));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_internal_adjustseq": {
                WorkPackageUtils.showSequenceConfigurationForm((IFormView)this.getView(), (String)"entry_internal_jobcard", (CloseCallBack)new CloseCallBack((IFormPlugin)this, "entry_internal_jobcard"));
                break;
            }
            case "bar_panel_adjustseq": {
                WorkPackageUtils.showSequenceConfigurationForm((IFormView)this.getView(), (String)"entry_panel_jobcard", (CloseCallBack)new CloseCallBack((IFormPlugin)this, "entry_panel_jobcard"));
                break;
            }
            case "bar_internal_getworkcard": {
                this.showoOnDemandInternalJobCardForm();
                break;
            }
            case "bar_view_panelworkcard": {
                this.viewPanelWorkCardList();
                break;
            }
            case "bar_view_panelcomparsion": {
                this.viewPanelComparsionTable();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "entry_internal_jobcard": 
            case "entry_nonroutine_jobcard": 
            case "entry_panel_jobcard": {
                this.modifySeqCallBack(actionId, returnData);
                break;
            }
            case "customer_workpkg_manage": {
                this.customerWorkPackageSelectedCallBack(returnData);
                break;
            }
            case "jobCardSelector": {
                this.addInternalJobCard(returnData);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        IDataEntityProperty property = this.getModel().getProperty("customer_workpkgmanageid");
        dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
    }

    private void viewPanelComparsionTable() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pmpd_panel_comparsion", (boolean)true, (int)0, (boolean)false);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        OpenStyle openStyle = listShowParameter.getOpenStyle();
        openStyle.setInlineStyleCss(css);
        openStyle.setShowType(ShowType.Modal);
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        filters.add(new QFilter("manageid", "=", this.getModel().getValue("id")));
        Map customParams = listShowParameter.getCustomParams();
        customParams.put("manageId", this.getModel().getValue("id"));
        customParams.put("orgId", this.getModel().getValue("org_id"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void viewPanelWorkCardList() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pmpd_panelworkcard_list", (boolean)false);
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        filters.add(new QFilter("executeworkpackmanage_id", "=", this.getModel().getValue("id")));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void customerWorkPackageSelectedCallBack(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
            ListSelectedRow listSelectedRow = listSelectedRows.get(0);
            this.fillInfoByCustomerWorkPackageManage(listSelectedRow);
        }
    }

    private void modifySeqCallBack(String actionId, Object returnData) {
        if (returnData instanceof Integer) {
            int targetIndex = (Integer)returnData - 1;
            EntryGrid entryGrid = (EntryGrid)this.getControl(actionId);
            int[] selectRows = entryGrid.getSelectRows();
            EntryGridHelper.batchMoveEntryRow((IFormView)this.getView(), (String)actionId, (int[])selectRows, (int)targetIndex);
        }
    }

    private void fillInfoByCustomerWorkPackageManage(ListSelectedRow listSelectedRow) {
        Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
        this.getModel().setValue("customer_workpkg_manage", (Object)listSelectedRow.getBillNo());
        this.getModel().setValue("customer_workpkgmanageid", primaryKeyValue);
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", primaryKeyValue)};
        try (DataSet dataSet = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getSimpleName(), "pmpd_customer_workpkg_ma", "customer", filters, null, 1);){
            Row row = dataSet.next();
            this.getModel().setValue("customer", row.get(0));
        }
    }

    private void showCustomerWorkPackageManageList() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pmpd_customer_workpkg_ma", (boolean)false);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "customer_workpkg_manage"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showoOnDemandInternalJobCardForm() {
        long equipmentId;
        long maintenanceModelId;
        Map maintenanceModelMap;
        long modelOneId;
        long customerId = (Long)this.getModel().getValue("customer_id");
        DynamicObject maintenanceScheme = WorkPackageUtils.getMaintenanceScheme((long)customerId, (long)(modelOneId = (maintenanceModelMap = WorkPackageUtils.findMaintenanceModel((long)(maintenanceModelId = WorkPackageUtils.getMaintenanceModel((long)(equipmentId = ((Long)this.getModel().getValue("equipment_id")).longValue()))))).getOrDefault("modelone", maintenanceModelId).longValue()));
        if (maintenanceScheme == null) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_exec_workpack_manage");
            String errorMsg = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u201c%1$s\u201d\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u201c%2$s\u201d\u548c\u201c%3$s\u201d\u5b57\u6bb5\u503c\u6216\u65b0\u589e\u5bf9\u5e94\u201c%4$s\u201d\u540e\u91cd\u8bd5\u3002", (String)"ExecuteWorkPackageManageEdit_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getEntityDisplayName((String)"fmm_overhaulscheme"), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"customer"), LocaleStringHelper.getPropertyDisplayName((IDataEntityType)dataEntityType, (String)"equipment"), LocaleStringHelper.getEntityDisplayName((String)"fmm_overhaulscheme"));
            this.getView().showTipNotification(errorMsg);
            return;
        }
        long mainProjectId = WorkPackageUtils.getMainProjectId((long)equipmentId);
        if (mainProjectId == 0L) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u201c%1$s\u201d\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u201c%2$s\u201d\u5b57\u6bb5\u503c\u6216\u65b0\u589e\u5bf9\u5e94\u201c%3$s\u201d\u540e\u91cd\u8bd5\u3002", (String)"ExecuteWorkPackageManageEdit_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getEntityDisplayName((String)"pmpd_project"), LocaleStringHelper.getPropertyDisplayName((String)"pmpd_exec_workpack_manage", (String)"equipment"), LocaleStringHelper.getEntityDisplayName((String)"pmpd_project"));
            this.getView().showTipNotification(errorMsg);
            return;
        }
        long modelMpdOneId = maintenanceModelMap.getOrDefault("modelmpdone", maintenanceModelId);
        Object billPkId = this.getModel().getValue("id");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry_internal_jobcard");
        Set existedJobCardIdSet = entryEntity.stream().map(dynamicObject -> dynamicObject.getLong("internal_jobcard_id")).collect(Collectors.toSet());
        HashMap<String, List<Long>> jobCardId2RuleIds = new HashMap<String, List<Long>>(16);
        ArrayList<Long> ruleIdList = new ArrayList<Long>(10);
        DynamicObjectCollection entryCollection = maintenanceScheme.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject2 : entryCollection) {
            long workCardId;
            DynamicObject workCard = dynamicObject2.getDynamicObject("entryworkcard");
            if (workCard == null || existedJobCardIdSet.contains(workCardId = ((Long)workCard.getPkValue()).longValue())) continue;
            DynamicObjectCollection ruleCollection = dynamicObject2.getDynamicObjectCollection("entryapplicablerule");
            for (DynamicObject rule : ruleCollection) {
                ruleIdList.add(rule.getLong("fbasedataid_id"));
            }
            String result = (String)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"ApplicableruleValService", (String)"applicableruleVal", (Object[])new Object[]{billPkId, ruleIdList});
            if ("C".equals(result) && !existedJobCardIdSet.contains(workCardId) && WorkPackageUtils.checkInternalWorkCard((DynamicObject)workCard, (long)customerId, (long)modelMpdOneId)) {
                existedJobCardIdSet.add(workCardId);
                jobCardId2RuleIds.put(String.valueOf(workCardId), new ArrayList(ruleIdList));
            }
            ruleIdList.clear();
        }
        this.showoOnDemandInternalJobCardForm(jobCardId2RuleIds);
    }

    private void showoOnDemandInternalJobCardForm(Map<String, List<Long>> jobCardId2RuleIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pmpd_jobcard_selector");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("jobCardId2RuleIds", jobCardId2RuleIds);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "jobCardSelector"));
        this.getView().showForm(formShowParameter);
    }

    private void addInternalJobCard(Object returnData) {
        if (returnData instanceof Set) {
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entry_internal_jobcard");
            long mainProjectId = WorkPackageUtils.getMainProjectId((long)((Long)this.getModel().getValue("equipment_id")));
            Set jobCardIdSet = (Set)returnData;
            Map<Object, DynamicObject> workCardMap = this.loadWorkCardFromCache(jobCardIdSet.toArray());
            for (Long jobCardId : jobCardIdSet) {
                DynamicObject workCard = workCardMap.get(jobCardId);
                if (workCard == null) continue;
                WorkPackageUtils.addInternalWorkCard((long)mainProjectId, (long)jobCardId, (DynamicObject)workCard, (DynamicObjectCollection)collection);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            BillModelUtils.reloadEntry((IBillView)this.getView(), "entry_internal_jobcard");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u6210\u529f\u3002", (String)"ExecuteWorkPackageManageEdit_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
    }

    private Map<Object, DynamicObject> loadWorkCardFromCache(Object[] ids) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"mpdm_mrocardroute");
        EntityType subEntityType = dataEntityType.getSubEntityType((Collection)Sets.newHashSet((Object[])new String[]{"pageentity.pageseq"}));
        return BusinessDataServiceHelper.loadFromCache((Object[])ids, (DynamicObjectType)subEntityType);
    }

    private long getDefaultExecuteOrg() {
        QFilter[] filters = new QFilter[]{new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("org.fisproduce", "=", (Object)Boolean.TRUE), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE), new QFilter("view.number", "=", (Object)"ProjectManageSchemeDefault")};
        DynamicObject structure = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"org", (QFilter[])filters);
        return structure == null ? RequestContext.get().getOrgId() : structure.getLong("org_id");
    }

    private Set<Object> getEquipmentIdByCustomerWorkPackManage(long customerWorkPackManageId) {
        String selectFields = "materialmtcinfo";
        QFilter[] filters = new QFilter[]{new QFilter("wkpkgmaid", "=", (Object)customerWorkPackManageId), new QFilter("workpkgtype", "=", (Object)"2"), new QFilter("billstatus", "=", (Object)"C")};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_customer_wkpkg_model", (String)selectFields, (QFilter[])filters, null);){
            if (dataSet.isEmpty()) {
                Set<Object> set = Collections.emptySet();
                return set;
            }
            LinkedHashSet<Long> ids = new LinkedHashSet<Long>(16);
            for (Row row : dataSet) {
                Long id = ObjectConverterWrapper.getLong((Object)row.get(0));
                if (id == 0L) continue;
                ids.add(id);
            }
            LinkedHashSet<Long> linkedHashSet = ids;
            return linkedHashSet;
        }
    }

    private void customerWorkPackManageChanged(ChangeData changeData) {
        Long newId = ObjectConverterWrapper.getLong((Object)changeData.getNewValue());
        if (newId == 0L) {
            this.getModel().setValue("equipment", null);
        } else {
            Set<Object> equipmentIds = this.getEquipmentIdByCustomerWorkPackManage(newId);
            Long targetEquipmentId = equipmentIds.size() == 1 ? ObjectConverterWrapper.getLong((Object)equipmentIds.toArray()[0]) : null;
            this.getModel().setValue("equipment", (Object)targetEquipmentId);
        }
    }

    private boolean boundProject() {
        boolean result;
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (fromDatabase) {
            long manageId = (Long)this.getModel().getValue("id");
            result = WorkPackUtils.boundProject(manageId);
        } else {
            result = false;
        }
        return result;
    }
}

