/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workpackage;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import org.apache.commons.collections4.CollectionUtils;

public class PaginationSelectorFormPlugin
extends AbstractBillPlugIn {
    private int rowIndex = -1;

    public void afterLoadData(EventObject e) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        IFormView parentView = this.getView().getParentView();
        Object pkValue = dataEntity.getPkValue();
        if (parentView != null) {
            IPageCache parentPageCache = parentView.getPageCache();
            Map<String, Long> selectedEntryIdMap = this.getSelectedEntryIdMap(parentPageCache);
            Long selectedEntryId = selectedEntryIdMap.get(String.valueOf(pkValue));
            if (selectedEntryId != null) {
                this.fillBackColor4SelectedRow(selectedEntryId);
            } else {
                this.clearRowBackColor();
            }
            List allIdList = (List)parentView.getFormShowParameter().getCustomParam("currentIdList");
            if (CollectionUtils.isNotEmpty((Collection)allIdList)) {
                int index = allIdList.indexOf(pkValue);
                this.getModel().setValue("currentpage", (Object)String.format("%1$d/%2$d", index + 1, allIdList.size()));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setRowBackColor(this.rowIndex);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_previous", "btn_next"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        ChangeData changeData = e.getChangeSet()[0];
        String name = property.getName();
        if ("isselect".equals(name)) {
            this.selectChanged(changeData);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_next".equals(key) || "btn_previous".equals(key)) {
            this.getModel().setDataChanged(false);
            this.saveChanged();
        }
    }

    private void saveChanged() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache parentPageCache = parentView.getPageCache();
            Map<String, Long> selectedEntryIdMap = this.getSelectedEntryIdMap(parentPageCache);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : collection) {
                if (!dynamicObject.getBoolean("isselect")) continue;
                selectedEntryIdMap.put(String.valueOf(dataEntity.getPkValue()), (Long)dynamicObject.getPkValue());
                parentPageCache.put("selectedEntryIdMap", SerializationUtils.toJsonString(selectedEntryIdMap));
                parentPageCache.saveChanges();
                return;
            }
            selectedEntryIdMap.remove(String.valueOf(dataEntity.getPkValue()));
            parentPageCache.put("selectedEntryIdMap", SerializationUtils.toJsonString(selectedEntryIdMap));
            parentPageCache.saveChanges();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
        this.saveChanged();
    }

    private Map<String, Long> getSelectedEntryIdMap(IPageCache pageCache) {
        String selectedEntryIdMapJson = pageCache.get("selectedEntryIdMap");
        return selectedEntryIdMapJson == null ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)selectedEntryIdMapJson, HashMap.class);
    }

    private void selectChanged(ChangeData changeData) {
        boolean isSelect = (Boolean)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        if (isSelect) {
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                if (rowIndex == i) continue;
                this.getModel().setValue("isselect", (Object)false, i);
            }
            this.setRowBackColor(rowIndex);
        } else {
            this.clearRowBackColor(new int[]{rowIndex});
        }
    }

    private void setRowBackColor(int index) {
        if (index >= 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            entryGrid.setRowBackcolor("#87CEFA", new int[]{index});
            entryGrid.selectRows(index);
        }
    }

    private void clearRowBackColor(int[] rowIndexs) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.setRowBackcolor(null, rowIndexs);
    }

    private void clearRowBackColor() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCount > 0) {
            int[] rowIndexs = IntStream.range(0, entryRowCount).toArray();
            this.clearRowBackColor(rowIndexs);
        }
    }

    private void fillBackColor4SelectedRow(Long selectedEntryId) {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            Object entryId = this.getModel().getValue("entryentity.id", i);
            if (!selectedEntryId.equals(entryId)) continue;
            this.rowIndex = i;
            this.getModel().setValue("isselect", (Object)true, i);
            break;
        }
    }
}

