/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workpackage;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.business.helper.TXServiceHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.formplugin.helper.WorkPackUtils;
import org.apache.commons.collections4.CollectionUtils;

public class PaginationSelectorListPlugin
extends AbstractListPlugin {
    private static final List<String> ENTRY_FIELDS = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"pagination", "hours", "remarks", "isselect"}));
    private DynamicProperty isSelecteProp;
    private final List<Integer> rowIndexs = new ArrayList<Integer>(10);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        formShowParameter.setCustomParam("ismergerows", (Object)false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectType dt = e.getPageData().getDynamicObjectType();
        DynamicProperty idProp = dt.getProperty("id");
        DynamicProperty seqProp = dt.getProperty("fseq");
        DynamicProperty entryIdProp = dt.getProperty("entryentity.id");
        this.isSelecteProp = dt.getProperty("entryentity.isselect");
        Map<String, Long> selectedEntryIdMapCache = this.getSelectedEntryIdFromCache();
        if (selectedEntryIdMapCache.isEmpty()) {
            return;
        }
        DynamicObjectCollection pageData = e.getPageData();
        for (DynamicObject rowData : pageData) {
            String id;
            Long selectedEntryId;
            Long entryId = ObjectConverterWrapper.getLong((Object)entryIdProp.getValueFast((Object)rowData));
            if (entryId == 0L || !entryId.equals(selectedEntryId = selectedEntryIdMapCache.get(id = ObjectConverterWrapper.getString((Object)idProp.getValueFast((Object)rowData))))) continue;
            this.isSelecteProp.setValueFast((Object)rowData, (Object)true);
            this.rowIndexs.add(ObjectConverterWrapper.getInt((Object)seqProp.getValueFast((Object)rowData)) - 1);
        }
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc source = (ColumnDesc)e.getSource();
        if (source instanceof ListOperationColumnDesc) {
            DynamicObject rowData = e.getRowData();
            boolean isSelect = ObjectConverterWrapper.getBoolean((Object)this.isSelecteProp.getValueFast((Object)rowData));
            List operationColItemList = (List)e.getFormatValue();
            for (OperationColItem operationColItem : operationColItemList) {
                if (isSelect) {
                    if (!"select".equals(operationColItem.getOperationKey())) continue;
                    operationColItem.setVisible(false);
                    continue;
                }
                if (!"cancel".equals(operationColItem.getOperationKey())) continue;
                operationColItem.setVisible(false);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCellBackColor(this.rowIndexs);
    }

    private void setCellBackColor(List<Integer> rowIndexs) {
        if (CollectionUtils.isNotEmpty(rowIndexs)) {
            ArrayList cellStyleList = Lists.newArrayListWithExpectedSize((int)(rowIndexs.size() * ENTRY_FIELDS.size()));
            for (String entryField : ENTRY_FIELDS) {
                for (Integer rowIndex : rowIndexs) {
                    CellStyle cellStyle = new CellStyle();
                    cellStyle.setFieldKey(entryField);
                    cellStyle.setBackColor("#87CEFA");
                    cellStyle.setRow(rowIndex.intValue());
                    cellStyleList.add(cellStyle);
                }
            }
            BillList billList = (BillList)this.getControl("billlistap");
            billList.setCellStyle((List)cellStyleList);
            rowIndexs.clear();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("select".equals(operateKey)) {
            this.select(true);
        } else if ("cancel".equals(operateKey)) {
            this.select(false);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            Map<String, Long> selectedEntryIdMap = this.getSelectedEntryIdFromCache();
            if (selectedEntryIdMap.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9875\u7801\u540e\u6267\u884c\u3002", (String)"PaginationSelectorListPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            List<Object> allIdList = this.getAllIdList();
            List<Object> successedIdList = this.writeBackData(selectedEntryIdMap.values());
            if (!successedIdList.isEmpty()) {
                BillList billList = (BillList)this.getControl("billlistap");
                List filters = billList.getFilterParameter().getQFilters();
                filters.removeIf(filter -> "id".equals(filter.getProperty()));
                allIdList.removeAll(successedIdList);
                filters.add(new QFilter("id", "in", allIdList));
                billList.bindData(null);
                this.setAllIdList(allIdList);
                this.clearSuccessedEntryIdCache(selectedEntryIdMap, successedIdList);
                WorkPackUtils.addDataChangeType(this.getPageCache(), "other");
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent(WorkPackUtils.getDataChangeType(this.getPageCache()));
    }

    private List<Object> writeBackData(Collection<Long> entryIdSet) {
        String selectFields = "id, workpackentryid, jobid, entryentity.id, entryentity.pagination";
        QFilter[] filters = new QFilter[]{new QFilter("entryentity", "in", entryIdSet)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_pagination_selector", (String)selectFields, (QFilter[])filters, null);){
            JSONArray sucessPkIds;
            ArrayList<ThreeTuple<Object, Object, Object>> threeTuples = new ArrayList<ThreeTuple<Object, Object, Object>>(10);
            HashMap<Object, String> paginationMap = new HashMap<Object, String>(16);
            HashMap<Object, Object> workOrderMap = new HashMap<Object, Object>(16);
            JSONArray params = new JSONArray();
            this.buildParams(dataSet, params, threeTuples, paginationMap, workOrderMap);
            JSONArray resultArray = (JSONArray)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pom", (String)"BatchCreateMROOrder", (String)"batchCreateManftechFromPageSeq", (Object[])new Object[]{params});
            JSONObject result = resultArray.getJSONObject(0);
            String errorMsg = "";
            if (!result.getBooleanValue("status")) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5de5\u5355\u670d\u52a1\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"PaginationSelectorListPlugin_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), result.getString("msg"));
                sucessPkIds = result.getJSONArray("sucessPkIds");
                threeTuples.removeIf(threeTuple -> !sucessPkIds.contains(workOrderMap.get(threeTuple.item1)));
            }
            if (threeTuples.isEmpty()) {
                this.getView().showTipNotification(errorMsg);
                sucessPkIds = Collections.emptyList();
                return sucessPkIds;
            }
            ArrayList<DynamicObject> paginationDataEntities = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> paginationEntryEntities = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> executeWorkPackEntryEntities = new ArrayList<DynamicObject>(10);
            List<Object> successIds = this.fillDataEntity(threeTuples, paginationDataEntities, paginationEntryEntities, executeWorkPackEntryEntities, paginationMap);
            TXServiceHelper.executeWithTX(() -> {
                SaveServiceHelper.update((DynamicObject[])paginationDataEntities.toArray(new DynamicObject[0]));
                SaveServiceHelper.update((DynamicObject[])paginationEntryEntities.toArray(new DynamicObject[0]));
                SaveServiceHelper.update((DynamicObject[])executeWorkPackEntryEntities.toArray(new DynamicObject[0]));
            });
            int totalCount = entryIdSet.size();
            int successCount = successIds.size();
            if (successCount == totalCount) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u591a\u9875\u5904\u7406\u6210\u529f\u3002", (String)"PaginationSelectorListPlugin_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5171%1$d\u6761\u6570\u636e\uff0c\u5904\u7406\u6210\u529f%2$d\u6761\uff0c\u5931\u8d25%3$d\u6761", (String)"PaginationSelectorListPlugin_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), totalCount, successCount, totalCount - successCount), errorMsg, MessageTypes.Default);
            }
            List<Object> list = successIds;
            return list;
        }
    }

    private List<Object> fillDataEntity(List<ThreeTuple<Object, Object, Object>> threeTuples, List<DynamicObject> paginationDataEntities, List<DynamicObject> paginationEntryEntities, List<DynamicObject> executeWorkPackEntryEntities, Map<Object, String> paginationMap) {
        MainEntityType paginationEntityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_pagination_selector");
        EntryProp entryProp = (EntryProp)paginationEntityType.getProperty("entryentity");
        DynamicObjectType paginationEntryType = entryProp.getDynamicCollectionItemPropertyType();
        MainEntityType workPackEntityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_exec_workpack");
        entryProp = (EntryProp)workPackEntityType.getProperty("entryentity");
        DynamicObjectType workPackEntryType = entryProp.getDynamicCollectionItemPropertyType();
        ArrayList successIds = Lists.newArrayListWithExpectedSize((int)threeTuples.size());
        for (ThreeTuple<Object, Object, Object> threeTuple : threeTuples) {
            DynamicObject paginationEntity = new DynamicObject((DynamicObjectType)paginationEntityType, threeTuple.item1);
            paginationEntity.set("ishistory", (Object)Character.valueOf('1'));
            paginationDataEntities.add(paginationEntity);
            DynamicObject paginationEntry = new DynamicObject(paginationEntryType, threeTuple.item2);
            paginationEntry.set("isselect", (Object)Character.valueOf('1'));
            paginationEntryEntities.add(paginationEntry);
            DynamicObject workPackEntry = new DynamicObject(workPackEntryType, threeTuple.item3);
            workPackEntry.set("pagination", (Object)paginationMap.get(threeTuple.item3));
            executeWorkPackEntryEntities.add(workPackEntry);
            successIds.add(threeTuple.item1);
        }
        return successIds;
    }

    private void buildParams(DataSet dataSet, JSONArray params, List<ThreeTuple<Object, Object, Object>> threeTuples, Map<Object, String> paginationMap, Map<Object, Object> workOrderMap) {
        JSONArray entryEntity = new JSONArray();
        for (Row row : dataSet) {
            Object paginationId = row.get(0);
            Object workPackEntryId = row.get(1);
            Object workOrderId = row.get(2);
            Object paginationEntryId = row.get(3);
            String pagination = row.getString(4);
            JSONObject entryData = new JSONObject();
            entryData.put("orderid", workOrderId);
            entryData.put("pageseq", (Object)pagination);
            entryEntity.add((Object)entryData);
            threeTuples.add((ThreeTuple<Object, Object, Object>)new ThreeTuple(paginationId, paginationEntryId, workPackEntryId));
            paginationMap.put(workPackEntryId, pagination);
            workOrderMap.put(paginationId, workOrderId);
        }
        JSONObject param = new JSONObject();
        param.put("entryentity", (Object)entryEntity);
        params.add((Object)param);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("pmpd_pagination_selector");
        billShowParameter.setPkId(currentRow.getPrimaryKeyValue());
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshList"));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("refreshList".equals(closedCallBackEvent.getActionId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.bindData(null);
        }
    }

    private void select(boolean select) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
        Map<String, Long> selectedEntryIdMap = this.getSelectedEntryIdFromCache();
        if (select) {
            selectedEntryIdMap.put(String.valueOf(primaryKeyValue), (Long)currentSelectedRowInfo.getEntryPrimaryKeyValue());
        } else {
            selectedEntryIdMap.remove(String.valueOf(primaryKeyValue));
        }
        this.getPageCache().put("selectedEntryIdMap", SerializationUtils.toJsonString(selectedEntryIdMap));
        billList.bindData(null);
    }

    private Map<String, Long> getSelectedEntryIdFromCache() {
        String selectedEntryIdMapJson = this.getPageCache().get("selectedEntryIdMap");
        return selectedEntryIdMapJson == null ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)selectedEntryIdMapJson, HashMap.class);
    }

    private void clearSuccessedEntryIdCache(Map<String, Long> selectedEntryIdMap, List<Object> successedIdList) {
        selectedEntryIdMap.entrySet().removeIf(entry -> successedIdList.contains(Long.parseLong((String)entry.getKey())));
        this.getPageCache().put("selectedEntryIdMap", SerializationUtils.toJsonString(selectedEntryIdMap));
    }

    private List<Object> getAllIdList() {
        return (List)this.getView().getFormShowParameter().getCustomParam("currentIdList");
    }

    private void setAllIdList(List<Object> allIdList) {
        this.getView().getFormShowParameter().setCustomParam("currentIdList", allIdList);
        this.getView().cacheFormShowParameter();
    }
}

