/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workpackage;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.pmc.pmpd.common.helper.LocaleStringHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.util.WorkPackageUtils;
import kd.pmc.pmpd.formplugin.helper.WorkPackUtils;

public class ProjectSelectorPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("project");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object executeWorkPackageManageId = customParams.get("executeWorkPackageManageId");
        if (executeWorkPackageManageId == null) {
            return;
        }
        String selectFields = "id, billno, name, type, version, supplement, project";
        QFilter[] filters = new QFilter[]{new QFilter("manageid", "=", executeWorkPackageManageId)};
        try (DataSet dataSet = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getSimpleName(), "pmpd_exec_workpack", selectFields, filters, "id desc");){
            if (dataSet.isEmpty()) {
                return;
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            TableValueSetter tvs = new TableValueSetter(new String[]{"workpackageid", "billno", "name", "type", "version", "supplement", "originalproject"});
            for (Row row : dataSet) {
                String supplementNo = row.getString(5);
                if (!"0".equals(supplementNo)) continue;
                tvs.addRow(new Object[]{row.get(0), row.get(1), row.get(2), row.get(3), row.get(4), supplementNo, row.get(6)});
            }
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", tvs);
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("project".equals(beforeF7SelectEvent.getProperty().getName())) {
            List projectIdList;
            int row = beforeF7SelectEvent.getRow();
            if (this.hasWorkOrder(row)) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u751f\u6210\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ProjectSelectorPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), LocaleStringHelper.getPropertyDisplayName((String)"pmpd_exec_workpack", (String)"jobno")));
                return;
            }
            String cachedProjectListStr = this.getPageCache().get("cachedProjectList");
            if (cachedProjectListStr == null) {
                Long equipmentId = ObjectConverterWrapper.getLong((Object)this.getView().getFormShowParameter().getCustomParam("equipmentId"));
                projectIdList = WorkPackageUtils.listProjectIdByEquipmentId((long)equipmentId);
                this.getPageCache().put("cachedProjectList", SerializationUtils.toJsonString((Object)projectIdList));
            } else {
                projectIdList = (List)SerializationUtils.fromJsonString((String)cachedProjectListStr, List.class);
            }
            List customQFilters = beforeF7SelectEvent.getCustomQFilters();
            long originalProjectId = (Long)this.getModel().getValue("originalproject_id");
            projectIdList.remove(originalProjectId);
            customQFilters.add(new QFilter("id", "in", (Object)projectIdList));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
            Map<String, List> selectedProjectMap = collection.stream().filter(dynamicObject -> dynamicObject.getLong("project_id") != 0L).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("name"), dynamicObject -> Lists.newArrayList((Object[])new Long[]{dynamicObject.getLong("originalproject_id"), dynamicObject.getLong("project_id")}), (k1, k2) -> k1));
            this.getView().returnDataToParent(selectedProjectMap);
            this.getView().close();
        }
    }

    private boolean hasWorkOrder(int row) {
        String rowStr;
        String workOrderCacheStr = this.getPageCache().get("workOrderCache");
        Map workOrderCache = StringUtils.isEmpty((CharSequence)workOrderCacheStr) ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)workOrderCacheStr, HashMap.class);
        Boolean result = (Boolean)workOrderCache.get(rowStr = String.valueOf(row));
        if (result == null) {
            long workPackageId = (Long)this.getModel().getValue("workpackageid", row);
            result = WorkPackUtils.hasWorkOrder(workPackageId);
            workOrderCache.put(rowStr, result);
            this.getPageCache().put("workOrderCache", SerializationUtils.toJsonString(workOrderCache));
        }
        return result;
    }
}

