/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workpackage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.business.helper.OperationHelper;
import kd.pmc.pmpd.business.helper.TXServiceHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.model.WorkPackageProjectInfo;
import kd.pmc.pmpd.common.util.WorkPackImportUtils;
import kd.pmc.pmpd.common.util.WorkPackageUtils;
import kd.pmc.pmpd.formplugin.helper.WorkPackUtils;
import kd.pmc.pmpd.formplugin.utils.BillModelUtils;
import kd.pmc.pmpd.formplugin.workpackage.ContractWorkPackageImport;
import kd.pmc.pmpd.formplugin.workpackage.ExecuteWorkPackageImport;
import org.apache.commons.collections4.MapUtils;

public class WorkPackOperateEditPlugin
extends AbstractBillPlugIn
implements ListRowClickListener,
HyperLinkClickListener,
TabSelectListener {
    private static final String IMPORT_CALLBACKKEY_PREFIX = "import-";
    private static final String EDIT_CALLBACKKEY_PREFIX = "edit-";
    private static final String LIST_CONTRACT_WORKPACKAGE = "list_contract_workpackage";
    private static final String LIST_PROJECT = "list_project";
    private static final String LIST_EXEC_WORKPACKAGE = "list_exec_workpackage";
    private static final String TAB = "tabap";
    private static final String CACHEKEY_PROJECT = "cachedProject";
    private static final String CACHEKEY_ONLY_REFRESH_HEADER = "onlyRefreshHeader";
    private static final String CACHEKEY_ISNEW = "isNew";
    private static final String CACHEKEY_WORKPACKINFO = "workPackInfo";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbar_contract_workpack", "toolbar_execute_workpack"});
        Optional.ofNullable((BillList)this.getControl(LIST_PROJECT)).ifPresent(billList -> {
            billList.addListRowClickListener((ListRowClickListener)this);
            billList.addListRowSelectAllListeners(listRowSelectAllEvent -> this.filterDataBySelectedProject(new Object[0]));
            billList.addClearSelectionListener(eventObject -> this.filterDataBySelectedProject(new Object[0]));
        });
        Optional.ofNullable((Tab)this.getControl(TAB)).ifPresent(tab -> tab.addTabSelectListener((TabSelectListener)this));
        this.addWorkPackListListener(LIST_CONTRACT_WORKPACKAGE, LIST_EXEC_WORKPACKAGE);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            this.getPageCache().put(CACHEKEY_ISNEW, "true");
        }
        this.showWorkPackPanel(fromDatabase);
        this.initBillList(fromDatabase);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("tabpage_nrc".equals(tabKey)) {
            this.refreshNRCList(this.getProjectCountCache().keySet());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && this.getPageCache().get(CACHEKEY_ISNEW) != null) {
            this.showWorkPackPanel(Boolean.TRUE);
            this.resetWorkPackListFilter();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        Object source = hyperLinkClickEvent.getSource();
        if (source instanceof BillList) {
            BillList billList = (BillList)source;
            ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)hyperLinkClickEvent).getCurrentRow();
            BillShowParameter billShowParameter = new BillShowParameter();
            String entityId = billList.getEntityId();
            billShowParameter.setFormId(entityId);
            billShowParameter.setPkId(currentRow.getPrimaryKeyValue());
            billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            billShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
            billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDIT_CALLBACKKEY_PREFIX + entityId));
            billShowParameter.getCustomParams().putAll(this.getExtParam());
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private Map<String, Object> getExtParam() {
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        params.put("manageId", this.getModel().getValue("id"));
        params.put("customerId", this.getModel().getValue("customer_id"));
        params.put("equipmentId", this.getModel().getValue("equipment_id"));
        return params;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "bar_import_contractpkg": {
                this.importContractWorkPack();
                break;
            }
            case "bar_import_executepkg": {
                this.importExecuteWorkPack();
                break;
            }
            case "bar_workpack_getcontract": {
                this.executeOperateWithSelection(LIST_CONTRACT_WORKPACKAGE, false, this::getContractInfo);
                break;
            }
            case "bar_contractpkg_viewrpt": {
                this.executeOperateWithSelection(LIST_CONTRACT_WORKPACKAGE, false, listSelectedRows -> this.viewDifferenceReport(LIST_CONTRACT_WORKPACKAGE, (ListSelectedRowCollection)listSelectedRows));
                break;
            }
            case "bar_executetpkg_viewrpt": {
                this.executeOperateWithSelection(LIST_EXEC_WORKPACKAGE, false, listSelectedRows -> this.viewDifferenceReport(LIST_EXEC_WORKPACKAGE, (ListSelectedRowCollection)listSelectedRows));
                break;
            }
            case "bar_contractpkg_match": {
                this.executeOperateWithSelection(LIST_CONTRACT_WORKPACKAGE, true, listSelectedRows -> this.matchWorkCard(LIST_CONTRACT_WORKPACKAGE, "pmpd_contract_workpack", (ListSelectedRowCollection)listSelectedRows));
                break;
            }
            case "bar_executetpkg_match": {
                this.executeOperateWithSelection(LIST_EXEC_WORKPACKAGE, true, listSelectedRows -> this.matchWorkCard(LIST_EXEC_WORKPACKAGE, "pmpd_exec_workpack", (ListSelectedRowCollection)listSelectedRows));
                break;
            }
            case "bar_gen_executepkg": {
                this.executeOperateWithSelection(LIST_CONTRACT_WORKPACKAGE, true, this::genExecuteWorkPack);
                break;
            }
            case "bar_delete_contractpkg": {
                this.executeOperateWithSelection(LIST_CONTRACT_WORKPACKAGE, true, listSelectedRows -> this.deleteWorkPack("pmpd_contract_workpack", (ListSelectedRowCollection)listSelectedRows));
                break;
            }
            case "bar_delete_executepkg": {
                this.executeOperateWithSelection(LIST_EXEC_WORKPACKAGE, true, listSelectedRows -> this.deleteWorkPack("pmpd_exec_workpack", (ListSelectedRowCollection)listSelectedRows));
                break;
            }
            case "bar_ready": {
                this.executeOperateWithSelection(LIST_EXEC_WORKPACKAGE, true, listSelectedRows -> OperationHelper.executeOperateWithBusyTip((IFormView)this.getView(), () -> this.ready((ListSelectedRowCollection)listSelectedRows)));
                break;
            }
            case "bar_cancelready": {
                this.executeOperateWithSelection(LIST_EXEC_WORKPACKAGE, true, listSelectedRows -> OperationHelper.executeOperateWithBusyTip((IFormView)this.getView(), () -> this.cancelReady((ListSelectedRowCollection)listSelectedRows)));
                break;
            }
            case "bar_workpack_getproject": {
                this.showProjectSelector();
                break;
            }
            case "bar_handle_multipage": {
                this.showMultiPageProcessingList();
                break;
            }
            case "bar_workpack_genworkorder": {
                this.executeOperateWithSelection(LIST_EXEC_WORKPACKAGE, true, this::doGenerateWorkOrder);
                break;
            }
            case "bar_refresh_contractpkg": {
                this.refreshContractWorkPackList(false);
                this.refreshJobCardList(LIST_CONTRACT_WORKPACKAGE);
                break;
            }
            case "bar_refresh_executepkg": {
                this.refreshExecuteWorkPackList(false);
                this.refreshJobCardList(LIST_EXEC_WORKPACKAGE);
                break;
            }
            case "bar_view_version_report": {
                WorkPackUtils.showVersionReport(this.getView(), new QFilter("executeworkpackmanage_id", "=", this.getModel().getValue("id")));
                break;
            }
            case "bar_view_contractworkpkg_importdetails": {
                this.showImportDetailsList("pmpd_contract_workpack");
                break;
            }
            case "bar_view_executeworkpkg_importdetails": {
                this.showImportDetailsList("pmpd_exec_workpack");
                break;
            }
            case "bar_addnew_executepkg": {
                this.showAddExecWorkpack();
                break;
            }
            case "bar_workpkg_genwokordret": {
                this.executeOperateWithSelection(LIST_EXEC_WORKPACKAGE, true, this::shwoGenerateWorkOrder);
                break;
            }
        }
    }

    private void doGenerateWorkOrder(ListSelectedRowCollection listSelectedRows) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"bar_workpack_workorder"});
        this.showGenWorkOrderForm(listSelectedRows, true);
    }

    private void showAddExecWorkpack() {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("pmpd_exec_workpack");
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getCustomParams().putAll(this.getExtParam());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "manuadd"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (event.getResult() == MessageBoxResult.Yes) {
            if ("pmpd_exec_workpack".equals(callBackId)) {
                BillList billList = (BillList)this.getControl(LIST_EXEC_WORKPACKAGE);
                ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
                this.executeOperate("pmpd_exec_workpack", "delete", listSelectedRows.getPrimaryKeyValues(), this::refreshProjectAndExecuteWorkPackList);
            } else if ("pmpd_contract_workpack".equals(callBackId)) {
                BillList billList = (BillList)this.getControl(LIST_CONTRACT_WORKPACKAGE);
                ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
                this.executeOperate("pmpd_contract_workpack", "delete", listSelectedRows.getPrimaryKeyValues(), () -> this.refreshContractWorkPackList(true));
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList billList = (BillList)evt.getSource();
        String key = billList.getKey();
        if (LIST_PROJECT.equals(key)) {
            this.filterDataBySelectedProject(this.getSelectedProject());
            Optional.ofNullable((Tab)this.getControl(TAB)).ifPresent(tab -> tab.activeTab("tabpage_exec_workpkg"));
        } else if (this.showJobCardList() && (LIST_EXEC_WORKPACKAGE.equals(key) || LIST_CONTRACT_WORKPACKAGE.equals(key))) {
            if (this.getPageCache().get(CACHEKEY_ONLY_REFRESH_HEADER) != null) {
                this.getPageCache().remove(CACHEKEY_ONLY_REFRESH_HEADER);
                return;
            }
            ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
            Object headerId = currentListSelectedRow == null ? null : currentListSelectedRow.getPrimaryKeyValue();
            String cacheChildPageId = this.getPageCache().get(key);
            if (cacheChildPageId == null) {
                cacheChildPageId = this.initJobCardList(key, headerId);
            } else {
                this.refreshJobCardList(cacheChildPageId, headerId);
            }
            this.setLabelText(LIST_EXEC_WORKPACKAGE.equals(key), headerId, cacheChildPageId);
        }
    }

    private void setLabelText(boolean isExecuteWorkPack, Object workPackId, String childPageId) {
        IFormView childView = this.getView().getView(childPageId);
        if (childView == null) {
            return;
        }
        String entityNumber = isExecuteWorkPack ? "pmpd_exec_workpack" : "pmpd_contract_workpack";
        Tuple<String, String> tuple = this.getWorkPackInfoFromCache(entityNumber, workPackId);
        boolean isShow = tuple != null;
        childView.setVisible(Boolean.valueOf(isShow), new String[]{"advconsummarypanelap"});
        if (isShow) {
            Optional.ofNullable((Label)childView.getControl("label_namevalue")).ifPresent(label -> label.setText((String)tuple.item1));
            Optional.ofNullable((Label)childView.getControl("label_supplementnovalue")).ifPresent(label -> label.setText((String)tuple.item2));
        }
        this.getView().sendFormAction(childView);
    }

    private Tuple<String, String> getWorkPackInfoFromCache(String entityNumber, Object workPackId) {
        String workPackIdStr;
        if (workPackId == null) {
            return null;
        }
        String json = this.getPageCache().get(CACHEKEY_WORKPACKINFO);
        Map cache = StringUtils.isEmpty((CharSequence)json) ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)json, HashMap.class);
        List<String> workPackInfoList = (List<String>)cache.get(workPackIdStr = String.valueOf(workPackId));
        if (workPackInfoList == null) {
            workPackInfoList = this.getWorkPackInfo(entityNumber, workPackId);
            cache.put(workPackIdStr, workPackInfoList);
        }
        if (workPackInfoList.size() != 2) {
            return null;
        }
        this.getPageCache().put(CACHEKEY_WORKPACKINFO, SerializationUtils.toJsonString(cache));
        return new Tuple((Object)workPackInfoList.get(0), (Object)workPackInfoList.get(1));
    }

    private List<String> getWorkPackInfo(String entityNumber, Object workPackId) {
        String selectFields = "name, supplement";
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", workPackId)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)entityNumber, (String)selectFields, (QFilter[])filters, null, (int)1);){
            if (dataSet.isEmpty()) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Row row = dataSet.next();
            ArrayList arrayList = Lists.newArrayList((Object[])new String[]{row.getString(0), row.getString(1)});
            return arrayList;
        }
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        super.closedCallBack(callBackEvent);
        String actionId = callBackEvent.getActionId();
        Object returnData = callBackEvent.getReturnData();
        if (returnData == null) {
            this.importCallBack(actionId);
            return;
        }
        switch (actionId) {
            case "edit-pmpd_contract_workpack": {
                this.contractWorkPackEditedCallBack(returnData);
                break;
            }
            case "edit-pmpd_exec_workpack": {
                this.executeWorkPackEditedCallBack(returnData);
                break;
            }
            case "contractno": {
                this.contractSelectedCallBack(returnData);
                break;
            }
            case "list_contract_workpackage": 
            case "list_exec_workpackage": {
                this.workCardSelectedCallBack(actionId, returnData);
                break;
            }
            case "projectSelector": {
                this.fillProjectInfo(returnData);
                break;
            }
            case "multiPage": {
                this.refreshExecuteWorkPackList(false);
                this.refreshJobCardList(LIST_EXEC_WORKPACKAGE);
                break;
            }
            case "manuadd": {
                this.addNewExecuteWorkPackCallback(returnData);
                break;
            }
            case "generateWorkOrder": {
                this.refreshExecuteWorkPackList(false);
                this.refreshJobCardListForWorkOrder();
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_workpack_workorder"});
                break;
            }
        }
    }

    private void addNewExecuteWorkPackCallback(Object returnData) {
        this.refreshProjectAndExecuteWorkPackList();
        if (returnData instanceof Set) {
            Set changeTypes = (Set)returnData;
            if (changeTypes.isEmpty()) {
                return;
            }
            if (changeTypes.contains("delete")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WorkPackOperateEditPlugin_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            } else if (changeTypes.contains("project")) {
                WorkPackageUtils.updateExecuteWorkPackManageHeader((long)((Long)this.getModel().getValue("id")));
                this.refreshHeader();
            }
        }
    }

    private void refreshJobCardList(String cacheChildPageId, Object headerId) {
        IFormView childView = this.getView().getView(cacheChildPageId);
        if (childView == null) {
            return;
        }
        if (headerId == null) {
            childView.getModel().deleteEntryData("entryentity");
            this.getPageCache().remove(cacheChildPageId);
        } else {
            String cachedHeaderId = this.getPageCache().get(cacheChildPageId);
            String headerIdStr = String.valueOf(headerId);
            if (StringUtils.equals((CharSequence)headerIdStr, (CharSequence)cachedHeaderId)) {
                return;
            }
            BillModel model = (BillModel)childView.getModel();
            model.beginInit();
            model.load(headerId);
            model.endInit();
            this.getPageCache().put(cacheChildPageId, headerIdStr);
        }
        childView.updateView("entryentity");
        this.getView().sendFormAction(childView);
    }

    private String initJobCardList(String listKey, Object headerId) {
        String targetKey;
        String formId;
        BillShowParameter billShowParameter = new BillShowParameter();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (LIST_CONTRACT_WORKPACKAGE.equals(listKey)) {
            formId = "pmpd_contract_work_layout";
            targetKey = "flex_contract_jobcard";
        } else {
            formId = "pmpd_exec_workpack_layout";
            targetKey = "flex_exec_jobcard";
        }
        billShowParameter.setFormId(formId);
        billShowParameter.setParentFormId(formShowParameter.getFormId());
        billShowParameter.setPkId(headerId);
        billShowParameter.setCustomParam("deleteDefaultRows", (Object)Boolean.TRUE);
        Object showJobCardList = formShowParameter.getCustomParam("showJobCardList");
        if (showJobCardList != null) {
            billShowParameter.setStatus(OperationStatus.VIEW);
        }
        OpenStyle openStyle = billShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey(targetKey);
        String pageId = billShowParameter.getPageId();
        this.getView().showForm((FormShowParameter)billShowParameter);
        this.getPageCache().put(listKey, pageId);
        if (headerId != null) {
            this.getPageCache().put(pageId, String.valueOf(headerId));
        }
        return pageId;
    }

    private void filterDataBySelectedProject(Object[] projectIds) {
        BillList billList = (BillList)this.getControl(LIST_EXEC_WORKPACKAGE);
        List filters = billList.getFilterParameter().getQFilters();
        if (ArrayUtils.isNotEmpty((Object[])projectIds)) {
            filters.add(new QFilter("project", "in", (Object)projectIds));
        }
        billList.clearSelection();
        billList.refresh();
        billList.selectRows(0);
    }

    private boolean showJobCardList() {
        Object showJobCardList = this.getView().getFormShowParameter().getCustomParam("showJobCardList");
        return "pmpd_exec_workpack_manage".equals(this.getView().getFormShowParameter().getFormId()) || showJobCardList != null;
    }

    private void addWorkPackListListener(String ... keys) {
        for (String key : keys) {
            BillList billList = (BillList)this.getControl(key);
            if (billList == null) continue;
            billList.addListRowClickListener((ListRowClickListener)this);
            billList.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    private void executeOperate(String entityNumber, String operationKey, Object[] ids, Runnable refreshRunnable, OperateOption operateOption) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)operateOption);
        if (!operationResult.getSuccessPkIds().isEmpty() && refreshRunnable != null) {
            refreshRunnable.run();
        }
        OperationHelper.showOperationResult((IFormView)this.getView(), (OperationResult)operationResult, (String)entityNumber, (String)operationKey);
    }

    private void executeOperate(String entityNumber, String operationKey, Object[] ids, Runnable refreshRunnable) {
        this.executeOperate(entityNumber, operationKey, ids, refreshRunnable, OperateOption.create());
    }

    private void deleteWorkPack(String entityNumber, ListSelectedRowCollection listSelectedRows) {
        String deleteConfirmMsg = String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%1$s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d%2$s\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"WorkPackOperateEditPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), listSelectedRows.size(), "\uff0c");
        this.getView().showConfirm(deleteConfirmMsg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(entityNumber, (IFormPlugin)this));
    }

    private void genExecuteWorkPack(ListSelectedRowCollection listSelectedRows) {
        this.executeOperate("pmpd_contract_workpack", "generateexecworkpkg", listSelectedRows.getPrimaryKeyValues(), this::refreshProjectAndExecuteWorkPackList);
    }

    private void matchWorkCard(String billListKey, String entityNumber, ListSelectedRowCollection listSelectedRows) {
        if (this.saveWorkPackList(billListKey)) {
            this.executeOperate(entityNumber, "match", listSelectedRows.getPrimaryKeyValues(), () -> this.refreshJobCardList(billListKey));
        }
    }

    private boolean saveWorkPackList(String listKey) {
        String cacheChildPageId = this.getPageCache().get(listKey);
        if (cacheChildPageId == null) {
            return false;
        }
        IFormView childView = this.getView().getView(cacheChildPageId);
        if (childView == null) {
            return false;
        }
        if (childView.getModel().getDataChanged()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isshowmessage", "false");
            OperationResult operationResult = childView.invokeOperation("save", operateOption);
            boolean success = operationResult.isSuccess();
            if (!success) {
                childView.showOperationResult(operationResult);
            }
            this.getView().sendFormAction(childView);
            return success;
        }
        return true;
    }

    private void viewDifferenceReport(String billListKey, ListSelectedRowCollection listSelectedRows) {
        WorkPackUtils.viewDifferenceReport((AbstractFormPlugin)this, ObjectConverterWrapper.getLong((Object)listSelectedRows.get(0).getPrimaryKeyValue()), billListKey, this.getExtParam());
    }

    private void getContractInfo(ListSelectedRowCollection listSelectedRows) {
        ListSelectedRow selectedRow = listSelectedRows.get(0);
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", selectedRow.getPrimaryKeyValue())};
        try (DataSet dataSet = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getSimpleName(), "pmpd_contract_workpack", "contractid", filters, null, 1);){
            long contractId = dataSet.isEmpty() ? 0L : ObjectConverterWrapper.getLong((Object)dataSet.next().get(0));
            long customerId = (Long)this.getModel().getValue("customer_id");
            WorkPackUtils.getContractInfo((AbstractFormPlugin)this, customerId, contractId);
        }
    }

    private void executeOperateWithSelection(String billListKey, boolean isSupportMultiSelect, Consumer<ListSelectedRowCollection> consumer) {
        BillList billList = (BillList)this.getControl(billListKey);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"WorkPackOperateEditPlugin_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!isSupportMultiSelect && selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ec5\u9009\u62e9\u4e00\u6761\u6570\u636e\u6267\u884c\u3002", (String)"WorkPackOperateEditPlugin_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (consumer != null) {
            consumer.accept(selectedRows);
        }
    }

    private void executeWorkPackEditedCallBack(Object returnData) {
        if (returnData instanceof Set) {
            Set changeTypes = (Set)returnData;
            if (changeTypes.isEmpty()) {
                return;
            }
            if (changeTypes.contains("delete")) {
                this.refreshProjectAndExecuteWorkPackList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WorkPackOperateEditPlugin_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            } else if (changeTypes.contains("project")) {
                this.refreshProjectAndExecuteWorkPackList();
                WorkPackageUtils.updateExecuteWorkPackManageHeader((long)((Long)this.getModel().getValue("id")));
                this.refreshHeader();
            } else {
                this.refreshExecuteWorkPackList(false);
                this.refreshJobCardList(LIST_EXEC_WORKPACKAGE);
            }
        }
    }

    private void contractWorkPackEditedCallBack(Object returnData) {
        if (returnData instanceof Set) {
            Set changeTypes = (Set)returnData;
            boolean refreshExecuteWorkPack = changeTypes.remove("executeworkpack");
            if (!changeTypes.isEmpty()) {
                boolean isDelete = changeTypes.contains("delete");
                this.refreshContractWorkPackList(isDelete);
                if (isDelete) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WorkPackOperateEditPlugin_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                } else {
                    this.refreshJobCardList(LIST_CONTRACT_WORKPACKAGE);
                }
            }
            if (refreshExecuteWorkPack) {
                this.refreshProjectAndExecuteWorkPackList();
            }
        }
    }

    private void fillProjectInfo(Object returnData) {
        if (returnData instanceof Map) {
            Map selectedProjectMap = (Map)returnData;
            if (MapUtils.isEmpty((Map)selectedProjectMap)) {
                return;
            }
            Map<Long, Integer> projectCache = this.getProjectCountCache();
            HashSet<Long> originalProjects = new HashSet<Long>(projectCache.keySet());
            HashSet<Long> targetProjectIds = new HashSet<Long>(16);
            HashMap name2ProjectId = Maps.newHashMapWithExpectedSize((int)selectedProjectMap.size());
            for (Map.Entry entry : selectedProjectMap.entrySet()) {
                List tuple = (List)entry.getValue();
                Long targetProjectId = (Long)tuple.get(1);
                targetProjectIds.add(targetProjectId);
                name2ProjectId.put(entry.getKey(), targetProjectId);
            }
            Map<String, List<Long>> workPackageIdMap = WorkPackUtils.getWorkPackageIdByName(this.getModel().getValue("id"), name2ProjectId.keySet());
            Map workPackageProjectInfoMap = WorkPackageUtils.getWorkPackageProjectInfo((Object[])targetProjectIds.toArray());
            MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"pmpd_exec_workpack");
            ArrayList<DynamicObject> executeWorkPackgeList = new ArrayList<DynamicObject>(10);
            for (Map.Entry entry : selectedProjectMap.entrySet()) {
                String name = (String)entry.getKey();
                List tuple = (List)entry.getValue();
                Long originalProjectId = (Long)tuple.get(0);
                List<Long> workPackageIds = workPackageIdMap.get(name);
                int size = workPackageIds.size();
                Integer count = projectCache.getOrDefault(originalProjectId, 0);
                if ((count = Integer.valueOf(count - size)) <= 0) {
                    projectCache.remove(originalProjectId);
                }
                Long targetProjectId = (Long)tuple.get(1);
                count = projectCache.getOrDefault(targetProjectId, 0);
                projectCache.put(targetProjectId, count + size);
                WorkPackageProjectInfo workPackageProjectInfo = (WorkPackageProjectInfo)workPackageProjectInfoMap.get(targetProjectId);
                for (Long workPackageId : workPackageIds) {
                    DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dt, (Object)workPackageId);
                    dynamicObject.set("project_id", (Object)targetProjectId);
                    if (workPackageProjectInfo != null) {
                        dynamicObject.set("contractid", (Object)workPackageProjectInfo.getContractId());
                        dynamicObject.set("contractno", (Object)workPackageProjectInfo.getContractNo());
                        dynamicObject.set("checktype_id", (Object)workPackageProjectInfo.getCheckTypeId());
                        dynamicObject.set("workscope_id", (Object)workPackageProjectInfo.getWorkScopeId());
                        DataEntityState dataEntityState = dynamicObject.getDataEntityState();
                        dataEntityState.setDirty((ISimpleProperty)dt.getProperty("contractid"), true);
                        dataEntityState.setDirty((ISimpleProperty)dt.getProperty("contractno"), true);
                        dataEntityState.setDirty((ISimpleProperty)dt.getProperty("checktype_id"), true);
                        dataEntityState.setDirty((ISimpleProperty)dt.getProperty("workscope_id"), true);
                    }
                    executeWorkPackgeList.add(dynamicObject);
                }
            }
            DynamicObject[] versionReport = WorkPackUtils.updateVersionDifferenceReport(name2ProjectId, workPackageIdMap);
            TXServiceHelper.executeWithTX(() -> {
                SaveServiceHelper.update((DynamicObject[])versionReport);
                SaveServiceHelper.update((DynamicObject[])executeWorkPackgeList.toArray(new DynamicObject[0]));
            });
            WorkPackageUtils.updateExecuteWorkPackManageHeader((long)((Long)this.getModel().getValue("id")));
            this.refreshHeader();
            if (!originalProjects.equals(projectCache.keySet())) {
                this.refreshProjectList(projectCache.keySet());
                this.getPageCache().put(CACHEKEY_PROJECT, SerializationUtils.toJsonString(projectCache));
            }
            this.refreshExecuteWorkPackList(true);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u9879\u76ee\u53f7\u6210\u529f\u3002", (String)"WorkPackOperateEditPlugin_5", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
    }

    private void workCardSelectedCallBack(String billListKey, Object returnData) {
        DynamicObject workPack;
        Map returnMap;
        boolean success;
        if (returnData instanceof Map && (success = WorkPackUtils.handleSelectedWorkCard(returnMap = (Map)returnData, workPack = this.getCurrentSelectedWorkPack(billListKey)))) {
            this.refreshJobCardList(billListKey);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5de5\u5361\u9009\u62e9\u5339\u914d\u6210\u529f\u3002", (String)"WorkPackOperateEditPlugin_6", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject getCurrentSelectedWorkPack(String billListKey) {
        BillList billList = (BillList)this.getControl(billListKey);
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        boolean isContractWorkPack = LIST_CONTRACT_WORKPACKAGE.equals(billListKey);
        String entityNumber = isContractWorkPack ? "pmpd_contract_workpack" : "pmpd_exec_workpack";
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)entityNumber, WorkPackUtils.getWorkCardInfoFields(isContractWorkPack));
        return BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (DynamicObjectType)subDataEntityType);
    }

    private void contractSelectedCallBack(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
            ListSelectedRow listSelectedRow = listSelectedRows.get(0);
            BillList billList = (BillList)this.getControl(LIST_CONTRACT_WORKPACKAGE);
            Object contractWorkPackId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)"pmpd_contract_workpack", WorkPackUtils.getContractInfoFields());
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)contractWorkPackId, (DynamicObjectType)subDataEntityType);
            WorkPackUtils.saveContractInfo(dynamicObject, listSelectedRow);
            this.refreshContractWorkPackList(false);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5408\u540c\u4fe1\u606f\u83b7\u53d6\u6210\u529f\u3002", (String)"WorkPackOperateEditPlugin_7", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
    }

    private void refreshJobCardList(String listKey) {
        String cacheChildPageId = this.getPageCache().get(listKey);
        if (cacheChildPageId == null) {
            return;
        }
        IFormView childView = this.getView().getView(cacheChildPageId);
        if (childView == null) {
            return;
        }
        String cacheHeaderId = this.getPageCache().get(cacheChildPageId);
        if (cacheHeaderId == null) {
            return;
        }
        BillModel billModel = (BillModel)childView.getModel();
        billModel.load((Object)Long.parseLong(cacheHeaderId));
        childView.updateView("entryentity");
        this.getView().sendFormAction(childView);
    }

    private void refreshJobCardListForWorkOrder() {
        String cacheChildPageId = this.getPageCache().get(LIST_EXEC_WORKPACKAGE);
        if (cacheChildPageId == null) {
            return;
        }
        IFormView childView = this.getView().getView(cacheChildPageId);
        if (childView == null) {
            return;
        }
        String cacheHeaderId = this.getPageCache().get(cacheChildPageId);
        if (cacheHeaderId == null) {
            return;
        }
        BillModel billModel = (BillModel)childView.getModel();
        BillModelUtils.reloadFields((IBillModel)billModel, Sets.newHashSet((Object[])new String[]{"jobid", "jobno", "sequencenumber"}), () -> childView.updateView("entryentity"));
        this.getView().sendFormAction(childView);
    }

    private void importCallBack(String importType) {
        if ("import-pmpd_contract_workpack".equals(importType)) {
            this.refreshContractWorkPackList(true);
        } else if ("import-pmpd_exec_workpack".equals(importType)) {
            this.refreshProjectAndExecuteWorkPackList();
            this.refreshHeader();
        }
    }

    private Object[] getSelectedProject() {
        BillList billList = (BillList)this.getControl(LIST_PROJECT);
        return billList.getSelectedRows().getPrimaryKeyValues();
    }

    private void refreshExecuteWorkPackList(boolean clearSelection) {
        BillList billList = (BillList)this.getControl(LIST_EXEC_WORKPACKAGE);
        Object[] projectIds = this.getSelectedProject();
        List filters = billList.getFilterParameter().getQFilters();
        if (ArrayUtils.isNotEmpty((Object[])projectIds)) {
            filters.add(new QFilter("project", "in", (Object)projectIds));
        } else {
            filters.removeIf(filter -> "project".equals(filter.getProperty()));
        }
        billList.refresh();
        if (clearSelection) {
            billList.clearSelection();
            billList.selectRows(0);
        } else {
            this.getPageCache().put(CACHEKEY_ONLY_REFRESH_HEADER, "true");
        }
    }

    private void refreshHeader() {
        HashSet updateFields = Sets.newHashSet((Object[])new String[]{"checktype", "workscope", "estimatedentrytime"});
        BillModelUtils.reloadFields((IBillModel)this.getModel(), updateFields, () -> {
            for (String updateField : updateFields) {
                this.getView().updateView(updateField);
            }
        });
    }

    private void refreshProjectList(Set<Long> projectIds) {
        BillList billList = (BillList)this.getControl(LIST_PROJECT);
        billList.setFilterParameter(new FilterParameter(new QFilter("id", "in", projectIds), null));
        billList.clearSelection();
        billList.refresh();
    }

    private void refreshProjectAndExecuteWorkPackList() {
        boolean projectChanged;
        Map<Long, Integer> projectCache = this.getProjectCountCache();
        Set<Long> projectIds = this.initWorkPackProjectCountCache();
        boolean bl = projectChanged = !projectCache.keySet().equals(projectIds);
        if (projectChanged) {
            this.refreshProjectList(projectIds);
        }
        this.refreshExecuteWorkPackList(true);
    }

    private Set<Long> initWorkPackProjectCountCache() {
        HashMap<Long, Integer> projectCountCache = new HashMap<Long, Integer>(16);
        String selectFields = "project";
        QFilter[] filters = new QFilter[]{new QFilter("manageid", "=", this.getModel().getValue("id"))};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_exec_workpack", (String)selectFields, (QFilter[])filters, null);){
            for (Row row : dataSet) {
                Long projectId = ObjectConverterWrapper.getLong((Object)row.get(0));
                if (projectId == 0L) continue;
                Integer count = projectCountCache.computeIfAbsent(projectId, k -> 0);
                projectCountCache.put(projectId, count + 1);
            }
        }
        this.getPageCache().put(CACHEKEY_PROJECT, SerializationUtils.toJsonString(projectCountCache));
        return projectCountCache.keySet();
    }

    private void refreshContractWorkPackList(boolean clearSelection) {
        BillList billList = (BillList)this.getControl(LIST_CONTRACT_WORKPACKAGE);
        billList.refresh();
        if (clearSelection) {
            billList.clearSelection();
            billList.selectRows(0);
        } else {
            this.getPageCache().put(CACHEKEY_ONLY_REFRESH_HEADER, "true");
        }
    }

    private Map<Long, Integer> getProjectCountCache() {
        String cacheJson = this.getPageCache().get(CACHEKEY_PROJECT);
        if (cacheJson == null) {
            return Collections.emptyMap();
        }
        Map cacheMap = (Map)SerializationUtils.fromJsonString((String)cacheJson, HashMap.class);
        return cacheMap.entrySet().stream().collect(Collectors.toMap(entry -> Long.parseLong((String)entry.getKey()), Map.Entry::getValue));
    }

    private void importExecuteWorkPack() {
        this.executeWorkPackImport("pmpd_exec_workpack", ExecuteWorkPackageImport.class.getName());
    }

    private void importContractWorkPack() {
        this.executeWorkPackImport("pmpd_contract_workpack", ContractWorkPackageImport.class.getName());
    }

    private void executeWorkPackImport(String entityNumber, String importPluginName) {
        Object manageId = this.getModel().getValue("id");
        Object orgId = this.getModel().getValue("org_id");
        String pageId = WorkPackImportUtils.startImport((AbstractFormPlugin)this, (Object)manageId, (Object)orgId, (String)entityNumber, (String)importPluginName);
        IFormView childView = this.getView().getViewNoPlugin(pageId);
        if (childView != null) {
            childView.setEnable(Boolean.FALSE, new String[]{"radiofield1", "radiofield2"});
            this.getView().sendFormAction(childView);
        }
    }

    private void showWorkPackPanel(Boolean isShow) {
        this.getView().setVisible(isShow, new String[]{"flex_workpackinfo", "flex_project"});
    }

    private void initBillList(boolean fromDatabase) {
        this.initWorkPackList(fromDatabase);
        this.initProjectList(fromDatabase);
    }

    private void initWorkPackList(boolean fromDatabase) {
        boolean showJobCardList = this.showJobCardList();
        QFilter filter = fromDatabase ? new QFilter("manageid", "=", this.getModel().getValue("id")) : new QFilter("1", "!=", (Object)1);
        this.initWorkPackList(LIST_CONTRACT_WORKPACKAGE, filter, showJobCardList);
        this.initWorkPackList(LIST_EXEC_WORKPACKAGE, filter, showJobCardList);
    }

    private void initWorkPackList(String key, QFilter filter, boolean showJobCardList) {
        BillList billList = (BillList)this.getControl(key);
        billList.setFilterParameter(new FilterParameter(filter, null));
        billList.refresh();
        if (showJobCardList) {
            billList.selectRows(0);
        }
    }

    private void initProjectList(boolean fromDatabase) {
        Set<Long> projectIds = fromDatabase ? this.initWorkPackProjectCountCache() : Collections.emptySet();
        this.refreshProjectList(projectIds);
        this.refreshNRCList(projectIds);
    }

    private void showImportDetailsList(String entityNumber) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_importlog", (boolean)false, (int)0, (boolean)false);
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        String caption = ResManager.loadKDString((String)"\u5de5\u4f5c\u5305", (String)"WorkPackOperateEditPlugin_9", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
        filters.add(new QFilter("name", "=", (Object)WorkPackImportUtils.buildImportFormTitle((String)caption, (Object)this.getModel().getValue("id"))));
        filters.add(new QFilter("sourceobj", "=", (Object)entityNumber));
        listShowParameter.setCaption(caption + FormMetadataCache.getFormConfig((String)"bos_importlog").getCaption().toString());
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showMultiPageProcessingList() {
        List executeWorkPackageIdList = WorkPackageUtils.listExecuteWorkPackageId((Object)this.getModel().getValue("id"));
        WorkPackUtils.showMultiPageProcessingList((AbstractFormPlugin)this, executeWorkPackageIdList);
    }

    private void showProjectSelector() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pmpd_project_selector");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map customParams = formShowParameter.getCustomParams();
        customParams.put("executeWorkPackageManageId", this.getModel().getValue("id"));
        customParams.put("equipmentId", this.getModel().getValue("equipment_id"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "projectSelector"));
        this.getView().showForm(formShowParameter);
    }

    private void cancelReady(ListSelectedRowCollection listSelectedRows) {
        this.executeOperate("pmpd_exec_workpack", "cancelready", listSelectedRows.getPrimaryKeyValues(), () -> this.refreshExecuteWorkPackList(false));
    }

    private void ready(ListSelectedRowCollection listSelectedRows) {
        this.executeOperate("pmpd_exec_workpack", "ready", listSelectedRows.getPrimaryKeyValues(), () -> this.refreshExecuteWorkPackList(false));
    }

    private void refreshNRCList(Set<Long> projectIds) {
        BillList billList = (BillList)this.getControl("list_nrc");
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(new QFilter("treeentryentity.project", "in", projectIds));
        billList.setFilterParameter(filterParameter);
        billList.refresh();
    }

    private void resetWorkPackListFilter() {
        QFilter filter = new QFilter("manageid", "=", this.getModel().getValue("id"));
        FilterParameter filterParameter = new FilterParameter(filter, null);
        BillList billList = (BillList)this.getControl(LIST_CONTRACT_WORKPACKAGE);
        billList.setFilterParameter(filterParameter);
        billList.refresh();
        billList = (BillList)this.getControl(LIST_EXEC_WORKPACKAGE);
        billList.setFilterParameter(filterParameter);
        billList.refresh();
    }

    private void shwoGenerateWorkOrder(ListSelectedRowCollection listSelectedRows) {
        this.showGenWorkOrderForm(listSelectedRows, false);
    }

    private void showGenWorkOrderForm(ListSelectedRowCollection listSelectedRows, boolean gen) {
        Object[] ids = listSelectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"pmpd_exepkg_workorder", (boolean)false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "generateWorkOrder"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("sortedIds", (Object)SerializationUtils.toJsonString((Object)ids));
        showParameter.setLookUp(false);
        if (gen) {
            showParameter.setCustomParam("newtask", (Object)"1");
        }
        showParameter.setCustomParam("manageid", this.getModel().getValue("id"));
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

