/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.workpackage;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;
import kd.pmc.pmpd.common.util.WorkPackageUtils;

public class WorkPackageDifferenceReportList
extends AbstractListPlugin {
    private static final String WORKCARD_PREFIX = "workcard-";
    private DynamicProperty differenceTypeProp;
    private DynamicProperty isSelecteProp;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        formShowParameter.setCustomParam("ismergerows", (Object)false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectType dt = e.getPageData().getDynamicObjectType();
        DynamicProperty entryIdProp = dt.getProperty("entryentity.id");
        DynamicProperty idProp = dt.getProperty("id");
        this.isSelecteProp = dt.getProperty("entryentity.isselect");
        this.differenceTypeProp = dt.getProperty("differencetype");
        Map<String, Long> selectedEntryIdMapCache = this.getSelectedEntryIdMap();
        if (selectedEntryIdMapCache.isEmpty()) {
            return;
        }
        for (DynamicObject rowData : e.getPageData()) {
            String id;
            Long selectedEntryId;
            Long entryId = ObjectConverterWrapper.getLong((Object)entryIdProp.getValueFast((Object)rowData));
            if (entryId == 0L || !entryId.equals(selectedEntryId = selectedEntryIdMapCache.get(id = ObjectConverterWrapper.getString((Object)idProp.getValueFast((Object)rowData))))) continue;
            this.isSelecteProp.setValueFast((Object)rowData, (Object)true);
        }
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc source = (ColumnDesc)e.getSource();
        if (source instanceof ListOperationColumnDesc) {
            DynamicObject rowData = e.getRowData();
            String differenceType = ObjectConverterWrapper.getString((Object)this.differenceTypeProp.getValueFast((Object)rowData));
            boolean isMulti = StringUtils.contains((CharSequence)differenceType, (CharSequence)"multi");
            boolean isSelect = ObjectConverterWrapper.getBoolean((Object)this.isSelecteProp.getValueFast((Object)rowData));
            List operationColItemList = (List)e.getFormatValue();
            for (OperationColItem operationColItem : operationColItemList) {
                String operationKey = operationColItem.getOperationKey();
                operationColItem.setVisible(false);
                if ("create".equals(operationKey)) {
                    if (!StringUtils.contains((CharSequence)differenceType, (CharSequence)"defect")) continue;
                    operationColItem.setVisible(true);
                    continue;
                }
                if ("check".equals(operationKey)) {
                    if (!StringUtils.contains((CharSequence)differenceType, (CharSequence)"inconformity")) continue;
                    operationColItem.setVisible(true);
                    continue;
                }
                if ("maintain".equals(operationKey)) {
                    if (!StringUtils.contains((CharSequence)differenceType, (CharSequence)"nopagehours")) continue;
                    operationColItem.setVisible(true);
                    continue;
                }
                if (!isMulti) continue;
                if ("select".equals(operationKey)) {
                    operationColItem.setVisible(!isSelect);
                    continue;
                }
                operationColItem.setVisible(isSelect);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("select".equals(operateKey)) {
            this.select(true);
        } else if ("cancel".equals(operateKey)) {
            this.select(false);
        } else if ("create".equals(operateKey) || "check".equals(operateKey) || "maintain".equals(operateKey)) {
            this.showWorkCardBillForm();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            this.getView().returnDataToParent(this.getSelectedEntryIdMap());
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String[] splitArray;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.startsWith((CharSequence)actionId, (CharSequence)WORKCARD_PREFIX) && (splitArray = StringUtils.split((String)actionId, (String)WORKCARD_PREFIX)).length == 1) {
            String workCardId = splitArray[0];
            Map<Object, String> verifyResultCache = this.getVerifyResultCache();
            verifyResultCache.remove(workCardId);
            this.getPageCache().put("verifyResult", SerializationUtils.toJsonString(verifyResultCache));
        }
    }

    private void showWorkCardBillForm() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        Object entryPrimaryKeyValue = currentSelectedRowInfo.getEntryPrimaryKeyValue();
        String selectFields = "entryentity.jobcard";
        QFilter[] filters = new QFilter[]{new QFilter("entryentity", "=", entryPrimaryKeyValue)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"pmpd_difference_report", (String)selectFields, (QFilter[])filters, null, (int)1);){
            if (dataSet.isEmpty()) {
                this.showNewWorkCardBill(currentSelectedRowInfo);
            } else {
                Row row = dataSet.next();
                Long workCardId = ObjectConverterWrapper.getLong((Object)row.get(0));
                if (workCardId == 0L) {
                    this.showNewWorkCardBill(currentSelectedRowInfo);
                } else {
                    this.showEditWorkCardBill(workCardId);
                }
            }
        }
    }

    private void showEditWorkCardBill(Long jobCardId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("mpdm_mrocardroute");
        billShowParameter.setPkId((Object)jobCardId);
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, WORKCARD_PREFIX + jobCardId));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void showNewWorkCardBill(ListSelectedRow currentSelectedRowInfo) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("pmpd_difference_report");
        pushArgs.setTargetEntityNumber("mpdm_mrocardroute");
        ArrayList selectedRows = Lists.newArrayList((Object[])new ListSelectedRow[]{new ListSelectedRow(currentSelectedRowInfo.getPrimaryKeyValue())});
        pushArgs.setSelectedRows((List)selectedRows);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        pushArgs.addCustomParam("customerId", ObjectConverterWrapper.getString(customParams.get("customerId")));
        long maintenanceModelId = this.getMaintenanceModelIdFromCache(customParams);
        pushArgs.addCustomParam("maintenanceModelId", String.valueOf(maintenanceModelId));
        ConvertOperationResult convertOperationResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (convertOperationResult.isSuccess() && convertOperationResult.getCachePageIds().size() == 1) {
            Push.showTargetBill((IFormView)this.getView(), (PushArgs)pushArgs, (ConvertOperationResult)convertOperationResult, (boolean)false);
        } else {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)pushArgs, (ConvertOperationResult)convertOperationResult);
        }
    }

    private long getMaintenanceModelIdFromCache(Map<String, Object> customParams) {
        long maintenanceModelId;
        String maintenanceModelIdStr = this.getPageCache().get("maintenanceModelId");
        if (maintenanceModelIdStr == null) {
            maintenanceModelId = WorkPackageUtils.getMaintenanceModel((long)ObjectConverterWrapper.getLong((Object)customParams.get("equipmentId")), (String)"modelmpdone");
            this.getPageCache().put("maintenanceModelId", String.valueOf(maintenanceModelId));
        } else {
            maintenanceModelId = Long.parseLong(maintenanceModelIdStr);
        }
        return maintenanceModelId;
    }

    private void select(boolean select) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        if (this.verifySelectedJobCard(currentSelectedRowInfo.getEntryPrimaryKeyValue())) {
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            Map<String, Long> selectedEntryIdMap = this.getSelectedEntryIdMap();
            if (select) {
                selectedEntryIdMap.put(String.valueOf(primaryKeyValue), (Long)currentSelectedRowInfo.getEntryPrimaryKeyValue());
            } else {
                selectedEntryIdMap.remove(String.valueOf(primaryKeyValue));
            }
            this.getPageCache().put("selectedEntryIdMap", SerializationUtils.toJsonString(selectedEntryIdMap));
            billList.bindData(null);
        }
    }

    private boolean verifySelectedJobCard(Object entryId) {
        boolean verifyResult;
        long selectedJobCardId = this.getSelectedJobCardIdFromCache(entryId);
        String selectedJobCardIdStr = String.valueOf(selectedJobCardId);
        Map<Object, String> verifyResultMap = this.getVerifyResultCache();
        String verifyResultMsg = verifyResultMap.get(selectedJobCardIdStr);
        if (verifyResultMsg == null) {
            verifyResultMsg = this.verify(selectedJobCardId);
            verifyResultMap.put(selectedJobCardIdStr, verifyResultMsg);
            this.getPageCache().put("verifyResult", SerializationUtils.toJsonString(verifyResultMap));
        }
        if (!(verifyResult = StringUtils.isEmpty((CharSequence)verifyResultMsg))) {
            this.getView().showTipNotification(verifyResultMsg);
        }
        return verifyResult;
    }

    private Map<Object, String> getVerifyResultCache() {
        String verifyResultStr = this.getPageCache().get("verifyResult");
        return verifyResultStr == null ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)verifyResultStr, Map.class);
    }

    private long getSelectedJobCardIdFromCache(Object entryId) {
        long selectedJobCardId;
        String entryIdStr = String.valueOf(entryId);
        String jobCardIdCacheStr = this.getPageCache().get("entryId2JobCardId");
        Map entryId2JobCardId = jobCardIdCacheStr == null ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)jobCardIdCacheStr, Map.class);
        String cacheJobCardIdStr = (String)entryId2JobCardId.get(entryIdStr);
        if (cacheJobCardIdStr == null) {
            selectedJobCardId = this.getSelectedJobCardId(entryId);
            entryId2JobCardId.put(entryIdStr, String.valueOf(selectedJobCardId));
            this.getPageCache().put("entryId2JobCardId", SerializationUtils.toJsonString(entryId2JobCardId));
        } else {
            selectedJobCardId = Long.parseLong(cacheJobCardIdStr);
        }
        return selectedJobCardId;
    }

    private String verify(long selectedJobCardId) {
        DynamicObject workCard = this.getJobCard(selectedJobCardId);
        if (workCard == null) {
            return "";
        }
        ArrayList<String> verifyResultMsgList = new ArrayList<String>(10);
        if (WorkPackageUtils.verifyWorkHourInfo((DynamicObject)workCard)) {
            verifyResultMsgList.add(ResManager.loadKDString((String)"\u65e0\u9875\u9762\u5de5\u65f6", (String)"WorkPackageDifferenceReportList_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
        return verifyResultMsgList.isEmpty() ? "" : String.join((CharSequence)",", verifyResultMsgList) + "\u3002";
    }

    private long getSelectedJobCardId(Object entryId) {
        String selectFields = "entryentity.jobcard";
        QFilter[] filters = new QFilter[]{new QFilter("entryentity", "=", entryId)};
        try (DataSet dataSet = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getSimpleName(), "pmpd_difference_report", selectFields, filters, null, 1);){
            long l = dataSet.next().getLong(0);
            return l;
        }
    }

    private DynamicObject getJobCard(long jobCardId) {
        HashSet selectFields = Sets.newHashSet((Object[])new String[]{"pageentity.pageseq", "pageentity.pagesumhours"});
        DynamicObjectType queryType = EntityMetadataCache.getSubDataEntityType((String)"mpdm_mrocardroute", (Collection)selectFields);
        return BusinessDataServiceHelper.loadSingleFromCache((Object)jobCardId, (DynamicObjectType)queryType);
    }

    private Map<String, Long> getSelectedEntryIdMap() {
        String selectedEntryIdMapJson = this.getPageCache().get("selectedEntryIdMap");
        return selectedEntryIdMapJson == null ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)selectedEntryIdMapJson, HashMap.class);
    }
}

