/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmc.pmps.enums.RelatedEventsEnum;

public class BusinessStageEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_BUSINESSSTAGEENTRYENTITY = "businessstageentryentity";
    private static final String KEY_BUSINESSTYPEENTRYENTITY = "businesstypeentryentity";
    private static final String KEY_STAGENAME = "stagename";
    private static final String KEY_BUSINESSLEVEL = "businesslevel";
    private static final String KEY_EVENTSRELATED = "eventsrelated";
    private static final String KEY_BUSINESSTYPENUMBER = "businesstypenumber";
    private static final String KEY_PMPS_BUSINESSTYPE = "pmps_businesstype";
    private static final String KEY_PMPS_BUSINESSLEVEL = "pmps_businesslevel";
    private static final String KEY_SUBENTRYENTITY = "subentryentity";
    private static final String KEY_NUMBER = "number";
    private static final String BAR_NEWENTRY = "newentry";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initRelatedEvents();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.initRelatedEvents();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit stageNameEdit = (BasedataEdit)this.getView().getControl("bizopportunityphase");
        stageNameEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit businessTypeNumEdit = (BasedataEdit)this.getView().getControl("bizopportunitycategory");
        businessTypeNumEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (StringUtils.equals((CharSequence)BAR_NEWENTRY, (CharSequence)afterDoOperationEventArgs.getOperateKey())) {
            this.initBusinessOpportunityLevel();
        }
    }

    private void initRelatedEvents() {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(KEY_EVENTSRELATED);
        List<ComboItem> comboItems = this.getRelatedEventsComboItems();
        comboEdit.setComboItems(comboItems);
    }

    private ArrayList<DynamicObject> getEntryEntityPropertyDynamicObjectList(String propertyName, String entryEntityName) {
        ArrayList<DynamicObject> values = new ArrayList<DynamicObject>();
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryEntityName);
        if (rows != null) {
            for (int i = 0; i < rows.getRowCount(); ++i) {
                values.add(((DynamicObject)rows.get(i)).getDynamicObject(propertyName));
            }
        }
        return values;
    }

    private ArrayList<String> getEntryEntityPropertyStringList(String propertyName, String entryEntityName) {
        ArrayList<String> values = new ArrayList<String>();
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryEntityName);
        if (rows != null) {
            for (int i = 0; i < rows.getRowCount(); ++i) {
                values.add(((DynamicObject)rows.get(i)).getString(propertyName));
            }
        }
        return values;
    }

    private List<ComboItem> getRelatedEventsComboItems() {
        ComboItem relatedEventSix;
        ComboItem relatedEventFive;
        ComboItem relatedEventFour;
        ComboItem relatedEventThree;
        ComboItem relatedEventTwo;
        ComboItem relatedEventOne;
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ArrayList<String> entryEntityPropertyList = this.getEntryEntityPropertyStringList(KEY_EVENTSRELATED, KEY_BUSINESSSTAGEENTRYENTITY);
        if (entryEntityPropertyList.contains(RelatedEventsEnum.RELATEDEVENT_ONE.getVal())) {
            relatedEventOne = this.createComboItem(RelatedEventsEnum.RELATEDEVENT_ONE, Boolean.FALSE);
            comboItems.add(relatedEventOne);
        } else {
            relatedEventOne = this.createComboItem(RelatedEventsEnum.RELATEDEVENT_ONE, Boolean.TRUE);
            comboItems.add(relatedEventOne);
        }
        if (entryEntityPropertyList.contains(RelatedEventsEnum.RELATEDEVENT_TWO.getVal())) {
            relatedEventTwo = this.createComboItem(RelatedEventsEnum.RELATEDEVENT_TWO, Boolean.FALSE);
            comboItems.add(relatedEventTwo);
        } else {
            relatedEventTwo = this.createComboItem(RelatedEventsEnum.RELATEDEVENT_TWO, Boolean.TRUE);
            comboItems.add(relatedEventTwo);
        }
        if (entryEntityPropertyList.contains(RelatedEventsEnum.RELATEDEVENT_THREE.getVal())) {
            relatedEventThree = this.createComboItem(RelatedEventsEnum.RELATEDEVENT_THREE, Boolean.FALSE);
            comboItems.add(relatedEventThree);
        } else {
            relatedEventThree = this.createComboItem(RelatedEventsEnum.RELATEDEVENT_THREE, Boolean.TRUE);
            comboItems.add(relatedEventThree);
        }
        if (entryEntityPropertyList.contains(RelatedEventsEnum.RELATEDEVENT_FOUR.getVal())) {
            relatedEventFour = this.createComboItem(RelatedEventsEnum.RELATEDEVENT_FOUR, Boolean.FALSE);
            comboItems.add(relatedEventFour);
        } else {
            relatedEventFour = this.createComboItem(RelatedEventsEnum.RELATEDEVENT_FOUR, Boolean.TRUE);
            comboItems.add(relatedEventFour);
        }
        if (entryEntityPropertyList.contains(RelatedEventsEnum.RELATEDEVENT_FIVE.getVal())) {
            relatedEventFive = this.createComboItem(RelatedEventsEnum.RELATEDEVENT_FIVE, Boolean.FALSE);
            comboItems.add(relatedEventFive);
        } else {
            relatedEventFive = this.createComboItem(RelatedEventsEnum.RELATEDEVENT_FIVE, Boolean.TRUE);
            comboItems.add(relatedEventFive);
        }
        if (entryEntityPropertyList.contains(RelatedEventsEnum.RELATEDEVENT_SIX.getVal())) {
            relatedEventSix = this.createComboItem(RelatedEventsEnum.RELATEDEVENT_SIX, Boolean.FALSE);
            comboItems.add(relatedEventSix);
        } else {
            relatedEventSix = this.createComboItem(RelatedEventsEnum.RELATEDEVENT_SIX, Boolean.TRUE);
            comboItems.add(relatedEventSix);
        }
        return comboItems;
    }

    private ComboItem createComboItem(RelatedEventsEnum commondimension, Boolean flag) {
        ComboItem comboItem = new ComboItem();
        comboItem.setId(commondimension.getVal());
        comboItem.setCaption(new LocaleString(commondimension.getName()));
        comboItem.setValue(commondimension.getVal());
        comboItem.setItemVisible(flag.booleanValue());
        return comboItem;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("bizopportunitycategory".equals(name)) {
            this.beforeBizOpportunityCategorySelect(beforeF7SelectEvent);
        }
    }

    private void beforeBizOpportunityCategorySelect(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_BUSINESSTYPEENTRYENTITY);
        Set ids = entryEntity.stream().map(dynamicObject -> dynamicObject.getLong("bizopportunitycategory_id")).filter(id -> id != 0L).collect(Collectors.toSet());
        if (ids.isEmpty()) {
            return;
        }
        beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", ids));
    }

    private void initBusinessOpportunityLevel() {
        Map businessOpportunityLevelCache = BusinessDataServiceHelper.loadFromCache((String)"bos_assistantdata_detail", (String)"id", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)2017351758048658432L)});
        if (!businessOpportunityLevelCache.isEmpty()) {
            int index = 0;
            int[] rows = this.getModel().batchCreateNewEntryRow(KEY_SUBENTRYENTITY, businessOpportunityLevelCache.size());
            for (Object id : businessOpportunityLevelCache.keySet()) {
                this.getModel().setValue("businessopportunitylevel", id, rows[index++]);
            }
        }
    }
}

