/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmps.formplugin.common.YzjContextCommonPlugin;
import kd.pmc.pmps.util.ClueManagerOrgUtils;

public class ClueManagePlugin
extends AbstractListPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        showParameter.setListentimerElapsed(true);
        RequestContext requestContext = RequestContext.get();
        long userId = requestContext.getCurrUserId();
        if (!ClueManagerOrgUtils.checkFunctionPermission((Long)userId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u201c\u7ebf\u7d22\u7ba1\u7406\u5458\u201d\u67e5\u770b\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ClueManagePlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar tbmain = (Toolbar)this.getView().getControl("toolbarap");
        tbmain.addItemClickListener((ItemClickListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operateKey = evt.getOperationKey();
        BillList control = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = control.getSelectedRows();
        StringBuilder buffer = new StringBuilder();
        buffer.append("assignmanager");
        buffer.append("assignorg");
        buffer.append("cooperation");
        buffer.append("sure");
        buffer.append("unsure");
        buffer.append("openon");
        buffer.append("invalidclue");
        buffer.append("unaudit");
        if (selectedRows.isEmpty() && buffer.toString().contains(operateKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ClueManagePlugin_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            evt.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)"cooperation", (CharSequence)operateKey) && selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5355\u884c\u7ebf\u7d22\u6c9f\u901a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ClueManagePlugin_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            evt.setCancel(true);
            return;
        }
        List pks = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObjectCollection clueManageObjs = QueryServiceHelper.query((String)"pmps_clue", (String)"id,billno,cluestatus,speciallogo", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
        Iterator iterator = clueManageObjs.iterator();
        String assignAllowStatus = "2,3";
        ArrayList<String> tips = new ArrayList<String>();
        while (iterator.hasNext()) {
            DynamicObject clueManageObj = (DynamicObject)iterator.next();
            if (null == clueManageObj) continue;
            String clueStatusObj = clueManageObj.getString("cluestatus");
            boolean speciallogo = clueManageObj.getBoolean("speciallogo");
            String billNo = clueManageObj.getString("billno");
            if ((StringUtils.equals((CharSequence)"assignmanager", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"assignorg", (CharSequence)operateKey)) && !assignAllowStatus.contains(clueStatusObj)) {
                tips.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u5206\u914d\u201c\u9500\u552e\u7ec4\u7ec7\u201d\u6216\u201c\u5546\u673a\u7ecf\u7406\u201d\u9700\u201c\u7ebf\u7d22\u72b6\u6001\u201d\u4e3a\u5f85\u5206\u914d\u6216\u5df2\u5206\u914d\u3002", (String)"ClueManagePlugin_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), billNo));
                continue;
            }
            if (!StringUtils.equals((CharSequence)"assignmanager", (CharSequence)operateKey) || !speciallogo) continue;
            tips.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u7ebf\u7d22\u4e3a\u767b\u8bb0\u4eba\u4e13\u6709\uff0c\u4e0d\u80fd\u5206\u914d\u201c\u5546\u673a\u7ecf\u7406\u201d\u3002", (String)"ClueManagePlugin_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), billNo));
        }
        if (!tips.isEmpty()) {
            for (String tip : tips) {
                this.getView().showTipNotification(tip, Integer.valueOf(5000));
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        ListSelectedRow listSelectedRow;
        String clueBilNo;
        QFilter filter;
        DynamicObject clueManageObj;
        Object creator;
        super.itemClick(evt);
        String operateKey = evt.getOperationKey();
        BillList control = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = control.getSelectedRows();
        if (StringUtils.equals((CharSequence)"cooperation", (CharSequence)operateKey) && null != (creator = (clueManageObj = BusinessDataServiceHelper.loadSingle((String)"pmps_clue", (String)"creator", (QFilter[])new QFilter[]{filter = new QFilter("billno", "=", (Object)(clueBilNo = (listSelectedRow = selectedRows.get(0)).getBillNo()))})).get("creator"))) {
            long managernumber = Long.parseLong(((DynamicObject)creator).getPkValue().toString());
            ArrayList<Long> lstUserId = new ArrayList<Long>();
            lstUserId.add(managernumber);
            YzjContextCommonPlugin yp = new YzjContextCommonPlugin();
            yp.setView(this.getView());
            yp.chatYZJ(lstUserId);
        }
        if (StringUtils.equals((CharSequence)"assignmanager", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"assignorg", (CharSequence)operateKey)) {
            this.assignManagerOrOrg(operateKey);
        }
        BillList grid = (BillList)this.getView().getControl("billlistap");
        grid.refresh();
    }

    private void assignManagerOrOrg(String operateKey) {
        ListShowParameter listShowParameter = null;
        if (StringUtils.equals((CharSequence)"assignorg", (CharSequence)operateKey)) {
            listShowParameter = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true);
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            ListFilterParameter filterParam = new ListFilterParameter();
            filterParam.getQFilters().add(new QFilter("fissale", "=", (Object)"1"));
            listShowParameter.setListFilterParameter(filterParam);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "assignorg"));
            listShowParameter.setMultiSelect(false);
        } else if (StringUtils.equals((CharSequence)"assignmanager", (CharSequence)operateKey)) {
            listShowParameter = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "assignmanager"));
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5546\u673a\u7ba1\u7406\u5458", (String)"ClueManagePlugin_5", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
            QFilter filter = new QFilter("id", "in", (Object)ClueManagerOrgUtils.getClueManagerOrgUser());
            listShowParameter.getListFilterParameter().getQFilters().add(filter);
            listShowParameter.setMultiSelect(false);
            listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        }
        if (null != listShowParameter) {
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (StringUtils.equals((CharSequence)"assignorg", (CharSequence)closedCallBackEvent.getActionId()) || StringUtils.equals((CharSequence)"assignmanager", (CharSequence)closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            String assignAllowStatus = "2,3";
            for (ListSelectedRow listSelectedRow : selectedRows) {
                String billNo = listSelectedRow.getBillNo();
                QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
                DynamicObject clueManageObj = BusinessDataServiceHelper.loadSingle((String)"pmps_clue", (String)"businessmanager, saleorg, precluestatus, cluestatus", (QFilter[])new QFilter[]{qFilter});
                DynamicObject clueGetObj = BusinessDataServiceHelper.loadSingle((String)"pmps_clueget", (String)"speciallogo, precluestatus, cluestatus", (QFilter[])new QFilter[]{qFilter});
                Object clueStatusObj = clueGetObj.get("cluestatus");
                if (!assignAllowStatus.contains(clueStatusObj.toString())) continue;
                if (StringUtils.equals((CharSequence)"assignorg", (CharSequence)closedCallBackEvent.getActionId())) {
                    clueManageObj.set("saleorg", returnData);
                } else if (StringUtils.equals((CharSequence)"assignmanager", (CharSequence)closedCallBackEvent.getActionId()) && !clueGetObj.getBoolean("speciallogo")) {
                    clueManageObj.set("businessmanager", returnData);
                }
                Object object = clueManageObj.get("businessmanager");
                Object object2 = clueManageObj.get("saleorg");
                if (object != null && object2 != null) {
                    clueGetObj.set("precluestatus", (Object)"2");
                    clueGetObj.set("cluestatus", (Object)"3");
                    clueManageObj.set("precluestatus", (Object)"2");
                    clueManageObj.set("cluestatus", (Object)"3");
                } else {
                    clueGetObj.set("precluestatus", (Object)"3");
                    clueGetObj.set("cluestatus", (Object)"2");
                    clueManageObj.set("precluestatus", (Object)"3");
                    clueManageObj.set("cluestatus", (Object)"2");
                }
                SaveServiceHelper.update((DynamicObject)clueGetObj);
                SaveServiceHelper.update((DynamicObject)clueManageObj);
            }
            BillList list = (BillList)this.getView().getControl("billlistap");
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ClueManagePlugin_6", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        RequestContext requestContext = RequestContext.get();
        long userId = Long.parseLong(requestContext.getUserId());
        QFilter managernumber = new QFilter("managernumber", "=", (Object)userId);
        QFilter businessmanager = new QFilter("businessmanager", "=", (Object)userId);
        DynamicObject manager = BusinessDataServiceHelper.loadSingle((String)"pmps_cluemanagerorg", (String)"group", (QFilter[])new QFilter[]{managernumber});
        if (manager == null) {
            return;
        }
        DynamicObject group = manager.getDynamicObject("group");
        String groupNumber = group.getString("number");
        if (!StringUtils.equals((CharSequence)"administrator", (CharSequence)groupNumber)) {
            QFilter clueManageId = new QFilter("cluemanager", "=", manager.getPkValue());
            businessmanager.or(clueManageId);
            e.getQFilters().add(businessmanager);
        }
    }
}

