/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.formplugin.businessmanage;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BusinessManageFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String KEY_MAINBAR = "tbmain";
    private static final String PMPS_BUSINESSSTAGE = "pmps_businessstage";
    private static final String PMPS_BUSINESSTYPE = "pmps_businesstype";
    private static final String BOS_USER = "bos_user";
    private static final String NUMBER = "number";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
        BasedataEdit kind = (BasedataEdit)this.getView().getControl("bizopportunitycategory");
        kind.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit stageid = (BasedataEdit)this.getView().getControl("bizopportunityphase");
        stageid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit strategyid = (BasedataEdit)this.getView().getControl("businessstrategyid");
        strategyid.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit registerpid = (BasedataEdit)this.getView().getControl("registerpid");
        registerpid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName;
        super.propertyChanged(event);
        if (event == null) {
            return;
        }
        super.propertyChanged(event);
        IDataEntityProperty dataEntityProperty = event.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            this.propertyChanged(changeData, propertyName);
        }
    }

    private void propertyChanged(ChangeData changeData, String propertyName) {
        String key = propertyName;
        Object oldObject = changeData.getOldValue();
        Object newObject = changeData.getNewValue();
        DynamicObject propertyValueCDDE = changeData.getDataEntity();
        int index = changeData.getRowIndex();
        if (key.equals("memberid")) {
            DynamicObject obj = (DynamicObject)newObject;
            DynamicObjectCollection enCol = (DynamicObjectCollection)obj.get("entryentity");
            for (DynamicObject tmp : enCol) {
                if (tmp.getBoolean("ispartjob")) continue;
                this.getModel().setValue("dptid", tmp.get("dpt.id"), index);
                this.getModel().setValue("position", tmp.get("position"), index);
                break;
            }
        } else if (key.equals("infoentitymaterial")) {
            DynamicObject material = (DynamicObject)this.getModel().getValue("infoentitymaterial", index);
            if (material != null) {
                this.getModel().setValue("infoentityqty", null, index);
                this.getModel().setValue("infoentitybaseunit", material.getDynamicObject("baseunit").getPkValue(), index);
            } else {
                this.getModel().setValue("infoentityqty", null, index);
                this.getModel().setValue("infoentitybaseunit", null, index);
            }
        } else if (key.equals("infoentityprice") || key.equals("infoentityqty")) {
            BigDecimal bdQty = (BigDecimal)this.getModel().getValue("infoentityqty", index);
            BigDecimal bdPrice = (BigDecimal)this.getModel().getValue("infoentityprice", index);
            this.getModel().setValue("infoentityamount", (Object)bdQty.multiply(bdPrice), index);
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject bussiness;
        Object businessmid;
        if (this.getModel().getValue("name") == null) {
            this.getModel().setValue("name", this.getModel().getValue("billno"));
        }
        if (this.getModel().getValue("businessmid") == null) {
            this.getModel().setValue("businessmid", (Object)RequestContext.get().getUserId());
        }
        if ((businessmid = this.getModel().getValue("businessmid")) != null && !(bussiness = (DynamicObject)businessmid).getString("id").equals(RequestContext.get().getUserId())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_MAINBAR});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_close"});
        }
        String billno = this.getModel().getDataEntity().getString("billno");
        QFilter filter = new QFilter("businessno.billno", "=", (Object)billno);
        filter.and(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject bisfollowup = BusinessDataServiceHelper.loadSingleFromCache((String)"pmps_bisfollowup", (QFilter[])filters);
        if (bisfollowup != null) {
            DynamicObjectCollection colls = bisfollowup.getDynamicObjectCollection("entryentity");
            for (int n = 0; n < colls.size(); ++n) {
                DynamicObject entryrow = this.getModel().getDataEntity().getDynamicObjectCollection("entrybisfollowup").addNew();
                entryrow.set("e_bizopportunityphase", (Object)((DynamicObject)colls.get(n)).getDynamicObject("bizopportunityphase"));
                entryrow.set("plandate", (Object)((DynamicObject)colls.get(n)).getDate("plandate"));
                entryrow.set("actualdate", (Object)((DynamicObject)colls.get(n)).getDate("actualdate"));
                entryrow.set("accordingcontent", (Object)((DynamicObject)colls.get(n)).getString("accordingcontent"));
                entryrow.set("accordingperson", (Object)((DynamicObject)colls.get(n)).getDynamicObject("accordingperson"));
                entryrow.set("remark", (Object)((DynamicObject)colls.get(n)).getString("remark"));
            }
            this.getView().updateView("entrybisfollowup");
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("bizopportunitycategory".equals(name)) {
            this.beforeBizPpportunityCategorySelect(beforeF7SelectEvent);
        } else if ("bizopportunityphase".equals(name)) {
            this.beforeBizOpportunityPhaseSelect(beforeF7SelectEvent);
        }
    }

    private void beforeBizOpportunityPhaseSelect(BeforeF7SelectEvent beforeF7SelectEvent) {
        long bizOpportunityStrategyId = (Long)this.getModel().getValue("businessstrategyid_id");
        if (bizOpportunityStrategyId == 0L) {
            return;
        }
        DynamicObject bizOpportunityStrategyCache = BusinessDataServiceHelper.loadSingleFromCache((Object)bizOpportunityStrategyId, (String)"pmps_businessstrategy", (String)"businessstageentryentity.bizopportunityphase_id");
        if (bizOpportunityStrategyCache == null) {
            return;
        }
        DynamicObjectCollection entryEntitiy = bizOpportunityStrategyCache.getDynamicObjectCollection("businessstageentryentity");
        Set bizOpportunityPhaseIds = entryEntitiy.stream().map(dynamicObject -> dynamicObject.getLong("bizopportunityphase_id")).collect(Collectors.toSet());
        beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", bizOpportunityPhaseIds));
    }

    private void beforeBizPpportunityCategorySelect(BeforeF7SelectEvent beforeF7SelectEvent) {
        long bizOpportunityStrategyId = (Long)this.getModel().getValue("businessstrategyid_id");
        if (bizOpportunityStrategyId == 0L) {
            return;
        }
        DynamicObject bizOpportunityStrategyCache = BusinessDataServiceHelper.loadSingleFromCache((Object)bizOpportunityStrategyId, (String)"pmps_businessstrategy", (String)"businesstypeentryentity.bizopportunitycategory_id");
        if (bizOpportunityStrategyCache == null) {
            return;
        }
        DynamicObjectCollection entryEntitiy = bizOpportunityStrategyCache.getDynamicObjectCollection("businesstypeentryentity");
        Set bizOpportunityCategoryIds = entryEntitiy.stream().map(dynamicObject -> dynamicObject.getLong("bizopportunitycategory_id")).collect(Collectors.toSet());
        beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", bizOpportunityCategoryIds));
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject businessmid = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)BOS_USER);
        this.getModel().createNewEntryRow("boteam");
        this.getModel().setValue("memberid", (Object)businessmid, 0);
        DynamicObjectCollection enCol = (DynamicObjectCollection)businessmid.get("entryentity");
        for (DynamicObject tmp : enCol) {
            if (tmp.getBoolean("ispartjob")) continue;
            this.getModel().setValue("dptid", tmp.get("dpt.id"), 0);
            this.getModel().setValue("position", tmp.get("position"), 0);
            break;
        }
    }

    public void afterF7Select(AfterF7SelectEvent paramAfterF7SelectEvent) {
        ListSelectedRow sr;
        BasedataEdit beidt = (BasedataEdit)paramAfterF7SelectEvent.getSource();
        if (StringUtils.equals((CharSequence)beidt.getKey(), (CharSequence)"businessstrategyid") && (sr = paramAfterF7SelectEvent.getListSelectedRow()) != null) {
            DynamicObject o = BusinessDataServiceHelper.loadSingle((Object)sr.getPrimaryKeyValue(), (String)"pmps_businessstrategy");
            this.judgeIfSelect(o, "businesstypeentryentity", "bizopportunitycategory", "bizopportunitycategory");
            this.judgeIfSelect(o, "businessstageentryentity", "bizopportunityphase", "bizopportunityphase");
        }
    }

    private void judgeIfSelect(DynamicObject o, String entityName, String baseDataName, String fieldName) {
        DynamicObject obj = this.getModel().getDataEntity().getDynamicObject(fieldName);
        if (obj != null) {
            DynamicObjectCollection colection = o.getDynamicObjectCollection(entityName);
            boolean flag = false;
            for (DynamicObject dynamicObject : colection) {
                DynamicObject baseDataObj = dynamicObject.getDynamicObject(baseDataName);
                if (baseDataObj == null || obj == null || !StringUtils.equals((CharSequence)baseDataObj.getString(NUMBER), (CharSequence)obj.getString(NUMBER))) continue;
                flag = true;
                break;
            }
            if (!flag) {
                this.getModel().setValue(fieldName, null);
            }
        }
    }
}

