/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.formplugin.businessmanage;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmc.pmps.business.common.ProjectOrgManageTplHelper;
import kd.pmc.pmps.consts.BusinessManageButtonConst;
import kd.pmc.pmps.util.ClueManagerOrgUtils;

public class BusinessManageListPlugin
extends AbstractListPlugin {
    public static final String KEY_ORG = "org";
    public static final String KEY_NAME = "name";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (!ClueManagerOrgUtils.checkFunctionSuperPermission((Long)RequestContext.get().getCurrUserId())) {
            QFilter qfilter = new QFilter("businessmid.id", "=", (Object)RequestContext.get().getCurrUserId());
            qfilter.or("boteam.memberid.id", "=", (Object)RequestContext.get().getCurrUserId());
            e.addCustomQFilter(qfilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List orgIds = ProjectOrgManageTplHelper.getAllManageOrg();
        HashSet mapOrgIds = new HashSet(orgIds);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        String orgFldName = String.format("%s.%s", KEY_ORG, KEY_NAME);
        for (int i = filterColumnList.size() - 1; i >= 0; --i) {
            CommonFilterColumn col = (CommonFilterColumn)filterColumnList.get(i);
            if (!StringUtils.equalsIgnoreCase((CharSequence)orgFldName, (CharSequence)col.getFieldName())) continue;
            List items = col.getComboItems();
            for (int j = items.size() - 1; j >= 0; --j) {
                ComboItem item = (ComboItem)items.get(j);
                String itemVal = item.getValue();
                if (mapOrgIds.contains(Long.valueOf(itemVal.toString()))) continue;
                items.remove(item);
            }
            col.setComboItems(items);
            if (this.haveDefOrg(orgIds, col)) continue;
            col.setDefaultValues((List)new ArrayList<Object>(){});
        }
    }

    private boolean haveDefOrg(List<Long> orgIds, CommonFilterColumn col) {
        List defVals = col.getDefaultValues();
        boolean haveDefOrg = false;
        for (Object defVal : defVals) {
            if (!orgIds.contains(Long.valueOf(defVal.toString()))) continue;
            haveDefOrg = true;
            break;
        }
        return haveDefOrg;
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        evt.getOperationKey();
        if (StringUtils.equals((CharSequence)((CharSequence)BusinessManageButtonConst.getButtonflaggroup().get(key)), (CharSequence)"0")) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            Object[] pks = list.getSelectedRows().getPrimaryKeyValues();
            if (pks.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BusinessManageListPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            if (pks.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u9009\u62e9\u591a\u884c\u64cd\u4f5c\u3002", (String)"BusinessManageListPlugin_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pks[0], (String)"pmps_bismanage");
            this.judgeIsOpt(obj, key, pks);
        }
        super.itemClick(evt);
    }

    private void judgeIsOpt(DynamicObject obj, String key, Object[] pks) {
        HashMap<String, String> buttonGroup = new HashMap<String, String>(3);
        buttonGroup.put("tblboteam", ResManager.loadKDString((String)"\u5546\u673a\u56e2\u961f", (String)"BusinessManageListPlugin_33", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        buttonGroup.put("tblcompetitorinfo", ResManager.loadKDString((String)"\u7ade\u4e89\u5bf9\u624b", (String)"BusinessManageListPlugin_34", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        buttonGroup.put("tblcontract", ResManager.loadKDString((String)"\u5408\u540c\u7b7e\u8ba2", (String)"BusinessManageListPlugin_35", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
        if (!obj.getString("selfstatus").equals("9") || !obj.getString("billstatus").equals("C")) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u662f\u5df2\u5ba1\u6838\u4e14\u5546\u673a\u5904\u4e8e\u8d62\u5355\u72b6\u6001\u624d\u80fd\u8fdb\u884c%s\u64cd\u4f5c\u3002", (String)"BusinessManageListPlugin_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]), buttonGroup.get(key)));
        } else {
            String k = key.substring(3, key.length());
            this.showForm(pks[0], obj.get(k), "pmps_" + k, obj);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        list.refresh();
    }

    private void showForm(Object pkId, Object obj, String entityName, DynamicObject object) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(entityName);
        showParameter.setCustomParam("pkId", pkId);
        showParameter.setCustomParam("businessmid", (Object)object.getDynamicObject("businessmid").getLong(0));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("obj", obj);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("880");
        styleCss.setHeight("480");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm(showParameter);
    }
}

