/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.formplugin.businessoffer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmc.pmps.business.common.CommonUtils;

public class BusinessOfferFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener,
RowClickEventListener {
    protected static final String[] MATERIELCOST_FIELDS = new String[]{"wkind", "materielno", "specifmodel", "meteringunit", "quantity", "price", "amount"};
    protected static final String[] MANMADECOST_FIELDS = new String[]{"kind", "workhourunit", "rnumber", "rprice", "ramount"};
    protected static final String[] DEVICECOST_FIELDS = new String[]{"devicekind", "deviceno", "devicename", "devicehourunit", "deviceqty", "deviceprice", "deviceamount"};
    protected static final String[] OTHERDIRECTCOST_FIELDS = new String[]{"otherkind", "costproject", "costname", "otheramount"};
    protected static final String[] EXTPROCESSCOST_FIELDS = new String[]{"outkind", "outmaterielno", "spmodel", "outmeteringunit", "outprocess", "outqty", "outprice", "outamount"};

    public void registerListener(EventObject e) {
        BasedataEdit businessid = (BasedataEdit)this.getView().getControl("businessid");
        businessid.addAfterF7SelectListener((AfterF7SelectListener)this);
        businessid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit offerplanid = (BasedataEdit)this.getView().getControl("offerplanid");
        offerplanid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("biscostestimate");
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        this.addClickListeners(new String[]{"ebillnoid"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)"ebillnoid", (CharSequence)source.getKey())) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"pmps_biscostestimate", (boolean)false);
            ArrayList<QFilter> lFilters = new ArrayList<QFilter>();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u7ec4\u7ec7\u3002", (String)"BusinessOfferFormPlugin_0", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject businessno = (DynamicObject)this.getModel().getValue("businessid");
            QFilter qFilterEnable = new QFilter("org", "=", org.getPkValue());
            lFilters.add(qFilterEnable);
            if (businessno == null) {
                QFilter qFilter = new QFilter("1", "!=", (Object)1);
                lFilters.add(qFilter);
            }
            lFilters.add(this.getBiscostestimateData());
            showParameter.getListFilterParameter().setQFilters(lFilters);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ebillnoid");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"ebillnoid") && null != closedCallBackEvent.getReturnData()) {
            ListSelectedRowCollection lsc = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            Long id = (Long)lsc.getPrimaryKeyValues()[0];
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmps_biscostestimate");
            this.setFormData(this.getSelectEntryRowIndex(), obj);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        QFilter qfilter = null;
        String sourceID = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        switch (sourceID) {
            case "ebillnoid": {
                qfilter = this.getBiscostestimateData();
                break;
            }
            case "offerplanid": {
                DynamicObject businessno = this.getModel().getDataEntity().getDynamicObject("businessid");
                qfilter = CommonUtils.getOffPlan((DynamicObject)businessno);
                break;
            }
            case "businessid": {
                qfilter = CommonUtils.getBusinessNoData();
                break;
            }
        }
        if (qfilter != null) {
            showParameter.getListFilterParameter().setFilter(qfilter);
        }
    }

    public void afterF7Select(AfterF7SelectEvent paramAfterF7SelectEvent) {
        BasedataEdit beidt = (BasedataEdit)paramAfterF7SelectEvent.getSource();
        if (StringUtils.equals((CharSequence)beidt.getKey(), (CharSequence)"businessid")) {
            DynamicObject businessno = this.getModel().getDataEntity().getDynamicObject("businessid");
            DynamicObject offerplan = this.getModel().getDataEntity().getDynamicObject("offerplanid");
            if (businessno != null && offerplan != null) {
                QFilter qfilter = new QFilter("businessno", "=", (Object)businessno.getString("id"));
                DynamicObject[] plans = BusinessDataServiceHelper.load((String)"pmps_businessofferplan", (String)"id", (QFilter[])qfilter.toArray());
                boolean flag = false;
                for (DynamicObject plan : plans) {
                    if (!StringUtils.equals((CharSequence)offerplan.getString("billno"), (CharSequence)plan.getString("billno"))) continue;
                    flag = true;
                    break;
                }
                if (!flag) {
                    this.getModel().setValue("offerplanid", null);
                }
            }
        }
    }

    public QFilter getBiscostestimateData() {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        DynamicObjectCollection rows = this.getModel().getEntryEntity("biscostestimate");
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject object = (DynamicObject)rows.get(i);
            ids.add(object.getLong("eid"));
        }
        QFilter qfilter = new QFilter("1", "=", (Object)1);
        if (!ids.isEmpty()) {
            qfilter = new QFilter("id", "not in", ids);
        }
        return qfilter;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "amount": {
                this.statisticsAmount("materielcost", "amount", "tdatacost");
                this.setTotalData("tdatacost", "datacost");
                break;
            }
            case "ramount": {
                this.statisticsAmount("manmadecost", "ramount", "tartificialcost");
                this.setTotalData("tartificialcost", "artificialcost");
                break;
            }
            case "deviceamount": {
                this.statisticsAmount("devicecost", "deviceamount", "tequipmentcost");
                this.setTotalData("tequipmentcost", "equipmentcost");
                break;
            }
            case "outamount": {
                this.statisticsAmount("extprocesscostentity", "outamount", "textprocesscost");
                this.setTotalData("textprocesscost", "extprocesscost");
                break;
            }
            case "otheramount": {
                this.statisticsAmount("otherdirectcostentity", "otheramount", "totherdirectcost");
                this.setTotalData("totherdirectcost", "otherdirectcost");
                break;
            }
        }
    }

    private void setEntityHeadData(String amountName, String totalkey) {
        DynamicObjectCollection costSummary = this.getModel().getEntryEntity("biscostestimate");
        BigDecimal amountTotal = new BigDecimal(0);
        for (int i = 0; i < costSummary.size(); ++i) {
            DynamicObject obj = (DynamicObject)costSummary.get(i);
            amountTotal = amountTotal.add(obj.getBigDecimal(amountName));
        }
        this.getModel().setValue(totalkey, (Object)amountTotal);
        this.getView().setEnable(Boolean.FALSE, new String[]{totalkey});
    }

    private void statisticsAmount(String entityName, String name, String costAmount) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entityName);
        BigDecimal totalCost = new BigDecimal(0);
        for (DynamicObject dynamicObject : rows) {
            totalCost = totalCost.add(dynamicObject.getBigDecimal(name));
        }
        this.setModelValue(costAmount, totalCost, (DynamicObject)rows.getParent());
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("biscostestimate");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    private void setModelValue(String costAmount, BigDecimal materielCost, DynamicObject parent) {
        DynamicObjectCollection costSummary = this.getModel().getEntryEntity("biscostestimate");
        for (int i = 0; i < costSummary.size(); ++i) {
            DynamicObject obj = (DynamicObject)costSummary.get(i);
            if (obj.get(1) != parent.get(1)) continue;
            this.getModel().setValue(costAmount, (Object)materielCost, i);
        }
        this.getModel().updateEntryCache(costSummary);
    }

    private void setFormData(int index, DynamicObject obj) {
        this.getModel().setValue("eid", (Object)obj.getLong("id"), index);
        this.getModel().setValue("ebillnoid", (Object)obj.getString("billno"), index);
        this.getModel().setValue("tdatacost", (Object)obj.getBigDecimal("datacost"), index);
        this.setEntityHeadData("tdatacost", "datacost");
        this.getModel().setValue("tartificialcost", (Object)obj.getBigDecimal("artificialcost"), index);
        this.setEntityHeadData("tartificialcost", "artificialcost");
        this.getModel().setValue("tequipmentcost", (Object)obj.getBigDecimal("equipmentcost"), index);
        this.setEntityHeadData("tequipmentcost", "equipmentcost");
        this.getModel().setValue("textprocesscost", (Object)obj.getBigDecimal("extprocesscost"), index);
        this.setEntityHeadData("textprocesscost", "extprocesscost");
        this.getModel().setValue("totherdirectcost", (Object)obj.getBigDecimal("otherdirectcost"), index);
        this.setEntityHeadData("totherdirectcost", "otherdirectcost");
        DynamicObject o = BusinessDataServiceHelper.loadSingle((Object)obj.get("id"), (String)"pmps_biscostestimate");
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("biscostestimate");
        DynamicObject parentObj = (DynamicObject)dynamicObjectCollection.get(index);
        this.setEntityData(o, "materielcost", MATERIELCOST_FIELDS, parentObj);
        this.setEntityData(o, "manmadecost", MANMADECOST_FIELDS, parentObj);
        this.setEntityData(o, "devicecost", DEVICECOST_FIELDS, parentObj);
        this.setEntityData(o, "otherdirectcostentity", OTHERDIRECTCOST_FIELDS, parentObj);
        this.setEntityData(o, "extprocesscostentity", EXTPROCESSCOST_FIELDS, parentObj);
    }

    private void setTotalData(String key, String totalkey) {
        BigDecimal amountTotal = (BigDecimal)this.getModel().getValue(totalkey);
        amountTotal = amountTotal.add((BigDecimal)this.getModel().getValue(key));
        this.getModel().setValue(totalkey, (Object)amountTotal);
    }

    private void setEntityData(DynamicObject obj, String entityName, String[] filedNames, DynamicObject parentObj) {
        DynamicObjectCollection wlcollection = obj.getDynamicObjectCollection(entityName);
        DynamicObjectCollection dynamicObjectCollection = parentObj.getDynamicObjectCollection(entityName);
        this.getModel().deleteEntryData(entityName);
        for (int i = 0; i < wlcollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)wlcollection.get(i);
            DynamicObject addNew = dynamicObjectCollection.addNew();
            for (int j = 0; j < filedNames.length; ++j) {
                String filed = filedNames[j];
                addNew.set(filed, dynamicObject.get(filed));
            }
        }
        this.getModel().updateEntryCache(dynamicObjectCollection);
        this.getView().updateView(entityName);
    }

    private void deleteEntityData(BeforeDeleteRowEventArgs e, String costAmount, String amountName, String totalAmoutName) {
        DynamicObjectCollection costSummary = this.getModel().getEntryEntity(e.getEntryProp().getName());
        for (int i = 0; i < e.getRowIndexs().length; ++i) {
            int num = e.getRowIndexs()[i];
            DynamicObject deleteObj = (DynamicObject)costSummary.get(num);
            DynamicObject parent = (DynamicObject)deleteObj.getParent();
            BigDecimal totalCost = parent.getBigDecimal(costAmount);
            totalCost = totalCost.subtract(deleteObj.getBigDecimal(amountName));
            this.setModelValue(costAmount, totalCost, parent);
        }
        this.deleteBisCostEstimate(e, amountName, totalAmoutName);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        switch (e.getEntryProp().getName()) {
            case "materielcost": {
                this.deleteEntityData(e, "tdatacost", "amount", "datacost");
                break;
            }
            case "manmadecost": {
                this.deleteEntityData(e, "tartificialcost", "ramount", "artificialcost");
                break;
            }
            case "devicecost": {
                this.deleteEntityData(e, "tequipmentcost", "deviceamount", "equipmentcost");
                break;
            }
            case "extprocesscostentity": {
                this.deleteEntityData(e, "textprocesscost", "outamount", "extprocesscost");
                break;
            }
            case "otherdirectcostentity": {
                this.deleteEntityData(e, "totherdirectcost", "otheramount", "otherdirectcost");
                break;
            }
            case "biscostestimate": {
                this.deleteAllRowBisCostEstimate(e);
                break;
            }
        }
    }

    private void deleteAllRowBisCostEstimate(BeforeDeleteRowEventArgs e) {
        BigDecimal totalDataCost = (BigDecimal)this.getModel().getValue("datacost");
        BigDecimal totalArtificialCost = (BigDecimal)this.getModel().getValue("artificialcost");
        BigDecimal totalEquipmentCost = (BigDecimal)this.getModel().getValue("equipmentcost");
        BigDecimal totalExtprocessCost = (BigDecimal)this.getModel().getValue("extprocesscost");
        BigDecimal totalOtherdirectCost = (BigDecimal)this.getModel().getValue("otherdirectcost");
        DynamicObjectCollection costSummary = this.getModel().getEntryEntity(e.getEntryProp().getName());
        for (int i = 0; i < e.getRowIndexs().length; ++i) {
            int num = e.getRowIndexs()[i];
            DynamicObject deleteObj = (DynamicObject)costSummary.get(num);
            totalDataCost = totalDataCost.subtract(deleteObj.getBigDecimal("tdatacost"));
            totalArtificialCost = totalArtificialCost.subtract(deleteObj.getBigDecimal("tartificialcost"));
            totalEquipmentCost = totalEquipmentCost.subtract(deleteObj.getBigDecimal("tequipmentcost"));
            totalExtprocessCost = totalExtprocessCost.subtract(deleteObj.getBigDecimal("textprocesscost"));
            totalOtherdirectCost = totalOtherdirectCost.subtract(deleteObj.getBigDecimal("totherdirectcost"));
        }
        if (costSummary.size() == 1) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"datacost", "artificialcost", "equipmentcost", "extprocesscost", "otherdirectcost"});
        }
        this.getModel().setValue("datacost", (Object)totalDataCost);
        this.getModel().setValue("artificialcost", (Object)totalArtificialCost);
        this.getModel().setValue("equipmentcost", (Object)totalEquipmentCost);
        this.getModel().setValue("extprocesscost", (Object)totalExtprocessCost);
        this.getModel().setValue("otherdirectcost", (Object)totalOtherdirectCost);
    }

    private void deleteBisCostEstimate(BeforeDeleteRowEventArgs e, String amountName, String totalAmountName) {
        DynamicObjectCollection costSummary = this.getModel().getEntryEntity(e.getEntryProp().getName());
        BigDecimal totalCost = (BigDecimal)this.getModel().getValue(totalAmountName);
        for (int i = 0; i < e.getRowIndexs().length; ++i) {
            int num = e.getRowIndexs()[i];
            DynamicObject deleteObj = (DynamicObject)costSummary.get(num);
            totalCost = totalCost.subtract(deleteObj.getBigDecimal(amountName));
        }
        this.getModel().setValue(totalAmountName, (Object)totalCost);
    }
}

