/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.formplugin.tpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.pmc.pmps.business.common.ProjectOrgManageTplHelper;

public class ProjectOrgManageTplListPlugin
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    public static final String KEY_ORG = "org";
    public static final String KEY_ID = "id";
    public static final String KEY_NAME = "name";
    private static final String ORG_ENTITY = "bos_org";

    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
        String orgFldName = String.format("%s.%s", KEY_ORG, KEY_NAME);
        if (StringUtils.equals((CharSequence)orgFldName, (CharSequence)evt.getFieldName())) {
            evt.setRefEntityId(ORG_ENTITY);
            evt.setRefPropKey(KEY_ID);
            QFilter qfilter = ProjectOrgManageTplHelper.getAllManageOrgFilter();
            evt.setQfilters(Arrays.asList(qfilter.toArray()));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List orgIds = ProjectOrgManageTplHelper.getAllManageOrg();
        HashSet mapOrgIds = new HashSet(orgIds);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        String orgFldName = String.format("%s.%s", KEY_ORG, KEY_NAME);
        for (int i = filterColumnList.size() - 1; i >= 0; --i) {
            CommonFilterColumn col = (CommonFilterColumn)filterColumnList.get(i);
            if (!StringUtils.equalsIgnoreCase((CharSequence)orgFldName, (CharSequence)col.getFieldName())) continue;
            List items = col.getComboItems();
            for (int j = items.size() - 1; j >= 0; --j) {
                ComboItem item = (ComboItem)items.get(j);
                String itemVal = item.getValue();
                if (mapOrgIds.contains(Long.valueOf(itemVal.toString()))) continue;
                items.remove(item);
            }
            col.setComboItems(items);
            if (this.haveDefOrg(orgIds, col).booleanValue()) continue;
            col.setDefaultValues((List)new ArrayList<Object>(){});
        }
    }

    private Boolean haveDefOrg(List<Long> orgIds, CommonFilterColumn col) {
        List defVals = col.getDefaultValues();
        boolean haveDefOrg = false;
        for (Object defVal : defVals) {
            if (!orgIds.contains(Long.valueOf(defVal.toString()))) continue;
            haveDefOrg = true;
            break;
        }
        return haveDefOrg;
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
    }
}

