/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.pmc.pmts.business.task.BindCardData;
import kd.pmc.pmts.business.task.TaskBindCardCollect;

public class CalSysPercentHelper {
    public static final String TASK_SYSACTUALPER = "sysactualper";
    public static final String BCARD_TARGETBILLID = "targetbillid";
    public static final String BCARD_SOURCEBILLID = "sourcebillid";
    public static final String BCARD_SOURCEBILLENTRYID = "sourcebillentryid";
    public static final String SFC_TASKSTATUS = "taskstatus";
    public static final String SFC_STHOURS = "oprworkhours";
    public static final String SFC_ACHOURS = "oprcustomhours";

    public static void calSysPercent() {
        QFilter filter = new QFilter(BCARD_TARGETBILLID, "is not null", null);
        HashSet taskSet = Sets.newHashSet();
        TaskBindCardCollect tcollect = new TaskBindCardCollect();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"QUERY_BINGCARD", (String)"fmm_task_relations", (String)"sourcebillid,sourcebillentryid,targetbillid", (QFilter[])filter.toArray(), (String)"");){
            for (Row row : dataSet) {
                Long sid = Long.parseLong(row.getString(BCARD_SOURCEBILLID));
                Long seid = Long.parseLong(row.getString(BCARD_SOURCEBILLENTRYID));
                Long tid = Long.parseLong(row.getString(BCARD_TARGETBILLID));
                taskSet.add(tid);
                tcollect.putBcDataToMap(tid, new BindCardData(tid, sid, seid));
            }
        }
        QFilter bcfilter = new QFilter("id", "in", (Object)taskSet);
        CalSysPercentHelper.calBindCardTaskPercent(tcollect, bcfilter);
        QFilter ubcfilter = new QFilter("id", "not in", (Object)taskSet);
        CalSysPercentHelper.calUnBindCardTaskPercent(ubcfilter);
    }

    public static void calSysPercent(Set<Long> ids) {
        QFilter filter = new QFilter(BCARD_TARGETBILLID, "in", ids.stream().map(id -> String.valueOf(id)).collect(Collectors.toSet()));
        HashSet taskSet = Sets.newHashSet();
        TaskBindCardCollect tcollect = new TaskBindCardCollect();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"QUERY_BINGCARD", (String)"fmm_task_relations", (String)"sourcebillid,sourcebillentryid,targetbillid", (QFilter[])filter.toArray(), (String)"");){
            for (Row row : dataSet) {
                Long sid = Long.parseLong(row.getString(BCARD_SOURCEBILLID));
                Long seid = Long.parseLong(row.getString(BCARD_SOURCEBILLENTRYID));
                Long tid = Long.parseLong(row.getString(BCARD_TARGETBILLID));
                taskSet.add(tid);
                tcollect.putBcDataToMap(tid, new BindCardData(tid, sid, seid));
            }
        }
        QFilter bcfilter = new QFilter("id", "in", (Object)taskSet);
        CalSysPercentHelper.calBindCardTaskPercent(tcollect, bcfilter);
        Set remandids = ids.stream().filter(id -> !taskSet.contains(id)).collect(Collectors.toSet());
        if (!remandids.isEmpty()) {
            QFilter ubcfilter = new QFilter("id", "in", remandids);
            CalSysPercentHelper.calUnBindCardTaskPercent(ubcfilter);
        }
    }

    private static void calUnBindCardTaskPercent(QFilter ubcfilter) {
        Object[] taskobjs;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)1570895031550671872L, (String)"pmts_calsysprecentparam");
        for (Object task : taskobjs = BusinessDataServiceHelper.load((String)"pmts_task", (String)"id,executestatus,projectnum,releasetime,actualstartdate,actualenddate,sysactualper,plantime,finishpercent,planstartdate,planenddate", (QFilter[])new QFilter[]{ubcfilter})) {
            if (Objects.isNull(task.getDynamicObject("projectnum"))) continue;
            BigDecimal pbcent = BigDecimal.ZERO;
            BigDecimal plantime = task.getBigDecimal("plantime").multiply(new BigDecimal(86400000));
            BigDecimal endtime = Objects.isNull(task.get("planenddate")) ? BigDecimal.ZERO : new BigDecimal(task.getDate("planenddate").getTime());
            BigDecimal actime = BigDecimal.ZERO;
            if (dynamicObject.getBoolean("isstart")) {
                if (Objects.isNull(task.get("actualstartdate")) || StringUtils.equals((CharSequence)task.getString("executestatus"), (CharSequence)"1") || StringUtils.equals((CharSequence)task.getString("executestatus"), (CharSequence)"4")) continue;
                actime = new BigDecimal(task.getDate("actualstartdate").getTime());
                endtime = Objects.isNull(task.get("actualenddate")) ? endtime : new BigDecimal(task.getDate("actualenddate").getTime());
            } else {
                if (!dynamicObject.getBoolean("isfirstday") || Objects.isNull(task.get("planstartdate"))) continue;
                actime = new BigDecimal(task.getDate("planstartdate").getTime());
            }
            BigDecimal curtime = new BigDecimal(System.currentTimeMillis());
            if (endtime.compareTo(curtime) <= 0) {
                pbcent = BigDecimal.ONE;
            } else if (actime.compareTo(curtime) > 0) {
                pbcent = BigDecimal.ZERO;
            } else if (actime.compareTo(curtime) <= 0) {
                BigDecimal diftime = curtime.subtract(actime);
                if (diftime.compareTo(BigDecimal.ZERO) < 0) {
                    diftime = BigDecimal.ZERO;
                }
                if ((pbcent = diftime.divide(plantime, 2, RoundingMode.HALF_UP)).compareTo(BigDecimal.ONE) >= 0) {
                    pbcent = new BigDecimal("0.99");
                }
            }
            task.set(TASK_SYSACTUALPER, (Object)pbcent);
            if (!Objects.isNull(task.get("finishpercent")) && task.getBigDecimal("finishpercent").compareTo(BigDecimal.ZERO) > 0) continue;
            task.set("finishpercent", (Object)pbcent.multiply(new BigDecimal("100")));
        }
        if (ArrayUtils.isNotEmpty((Object[])taskobjs)) {
            SaveServiceHelper.save((DynamicObject[])taskobjs);
        }
    }

    private static void calBindCardTaskPercent(final TaskBindCardCollect tcollect, QFilter taskfilter) {
        Map<DynamicObject, List<DynamicObject>> bccolects = tcollect.receiveSfcColls();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)1570895031550671872L, (String)"pmts_calsysprecentparam");
        DynamicObject[] taskobjs = BusinessDataServiceHelper.load((String)"pmts_task", (String)"id,projectnum,executestatus,releasetime,actualstartdate,actualenddate,sysactualper,finishpercent,planstartdate,planenddate", (QFilter[])taskfilter.toArray());
        Set pjids = Arrays.stream(taskobjs).map(task -> task.getDynamicObject("projectnum").getLong("id")).collect(Collectors.toSet());
        List doneids = Arrays.stream(taskobjs).filter(task -> task.get("executestatus").equals("4")).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        doneids.stream().forEach(new Consumer<Object>(){

            @Override
            public void accept(Object o) {
                tcollect.getTbcollect().remove(o);
            }
        });
        ArrayList<DynamicObject> totalobjs = new ArrayList<DynamicObject>(2);
        for (Map.Entry<DynamicObject, List<DynamicObject>> tbc : bccolects.entrySet()) {
            DynamicObject task2 = tbc.getKey();
            Long project = task2.getDynamicObject("projectnum").getLong("id");
            String percenttype = task2.getString("percenttype");
            if (StringUtils.equals((CharSequence)percenttype, (CharSequence)"1")) continue;
            totalobjs.add(task2);
            String executestatus = task2.getString("executestatus");
            List<DynamicObject> sfcs = tbc.getValue();
            boolean isdone = false;
            Map<Long, Boolean> stcollect = tcollect.getStcollect();
            if (stcollect.containsKey(task2.getLong("id"))) {
                isdone = stcollect.get(task2.getLong("id"));
            }
            if (isdone) {
                task2.set("executestatus", (Object)"4");
                task2.set(TASK_SYSACTUALPER, (Object)1);
                continue;
            }
            if (StringUtils.equals((CharSequence)executestatus, (CharSequence)"1")) {
                boolean isstart = sfcs.stream().anyMatch(dy -> {
                    String taskstatus = dy.getString(SFC_TASKSTATUS);
                    return !StringUtils.equals((CharSequence)taskstatus, (CharSequence)"A");
                });
                if (isstart) {
                    task2.set("executestatus", (Object)"2");
                    task2.set("actualstartdate", (Object)new Date());
                    task2.set(TASK_SYSACTUALPER, (Object)0);
                } else if (Objects.isNull(task2.get("plantime")) || Objects.isNull(task2.get("actualstartdate")) && Objects.isNull(task2.get("releasetime"))) continue;
            }
            BigDecimal pbcent = BigDecimal.ZERO;
            if (StringUtils.equals((CharSequence)percenttype, (CharSequence)"3")) {
                ArrayList collect = sfcs.stream().collect(ArrayList::new, (l1, dy) -> {
                    BigDecimal sysprecent = BigDecimal.ZERO;
                    if (Objects.nonNull(dy.get(SFC_STHOURS)) || Objects.nonNull(dy.get(SFC_ACHOURS))) {
                        BigDecimal sthour = dy.getBigDecimal(SFC_STHOURS);
                        BigDecimal achour = dy.getBigDecimal(SFC_ACHOURS);
                        sysprecent = achour.divide(sthour, 2, RoundingMode.HALF_UP);
                    }
                    l1.add(sysprecent);
                }, (l1, l2) -> l1.addAll(l2));
                BigDecimal sysprecent = ((BigDecimal)collect.stream().reduce((d1, d2) -> d1.add((BigDecimal)d2)).get()).multiply(new BigDecimal(100));
                pbcent = CalSysPercentHelper.matchPbcent(sysprecent, project, tcollect);
                pbcent = pbcent.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
            } else {
                BigDecimal plantime = task2.getBigDecimal("plantime").multiply(new BigDecimal(86400000));
                BigDecimal endtime = Objects.isNull(task2.get("planenddate")) ? BigDecimal.ZERO : new BigDecimal(task2.getDate("planenddate").getTime());
                BigDecimal actime = BigDecimal.ZERO;
                if (dynamicObject.getBoolean("isstart")) {
                    if (Objects.isNull(task2.get("actualstartdate")) || StringUtils.equals((CharSequence)task2.getString("executestatus"), (CharSequence)"1") || StringUtils.equals((CharSequence)task2.getString("executestatus"), (CharSequence)"4")) continue;
                    actime = new BigDecimal(task2.getDate("actualstartdate").getTime());
                    endtime = Objects.isNull(task2.get("actualenddate")) ? endtime : new BigDecimal(task2.getDate("actualenddate").getTime());
                } else {
                    if (!dynamicObject.getBoolean("isfirstday") || Objects.isNull(task2.get("planstartdate"))) continue;
                    actime = new BigDecimal(task2.getDate("planstartdate").getTime());
                }
                BigDecimal curtime = new BigDecimal(System.currentTimeMillis());
                if (endtime.compareTo(curtime) <= 0) {
                    pbcent = BigDecimal.ONE;
                } else if (actime.compareTo(curtime) > 0) {
                    pbcent = BigDecimal.ZERO;
                } else if (actime.compareTo(curtime) <= 0) {
                    BigDecimal diftime = curtime.subtract(actime);
                    if (diftime.compareTo(BigDecimal.ZERO) < 0) {
                        diftime = BigDecimal.ZERO;
                    }
                    if ((pbcent = diftime.divide(plantime, 2, RoundingMode.HALF_UP)).compareTo(BigDecimal.ONE) >= 0) {
                        pbcent = new BigDecimal("0.99");
                    }
                }
            }
            task2.set(TASK_SYSACTUALPER, (Object)pbcent);
            if (!Objects.isNull(task2.get("finishpercent")) && task2.getBigDecimal("finishpercent").compareTo(BigDecimal.ZERO) > 0) continue;
            task2.set("finishpercent", (Object)pbcent.multiply(new BigDecimal("100")));
        }
        if (!totalobjs.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])totalobjs.toArray(new DynamicObject[totalobjs.size()]));
        }
    }

    private static BigDecimal matchPbcent(BigDecimal sysprecent, Long project, TaskBindCardCollect tcollect) {
        List<DynamicObject> obj;
        Map<Long, List<DynamicObject>> pbcollect = tcollect.getPbcollect();
        if (pbcollect.isEmpty()) {
            return sysprecent;
        }
        List<Object> pbdetail = new ArrayList(2);
        if (pbcollect.containsKey(project)) {
            obj = pbcollect.get(project);
            if (Objects.nonNull(obj)) {
                pbdetail = obj;
            }
        } else {
            obj = pbcollect.get(0L);
            if (Objects.nonNull(obj)) {
                pbdetail = obj;
            }
        }
        if (pbdetail.isEmpty()) {
            return BigDecimal.ZERO;
        }
        List collect = pbdetail.stream().filter(dy -> {
            BigDecimal low = dy.getBigDecimal("lower");
            BigDecimal up = dy.getBigDecimal("ceiling");
            if (up.compareTo(low) < 0) {
                return false;
            }
            String lcondition = dy.getString("lcondition");
            String ccondition = dy.getString("ccondition");
            if (StringUtils.isBlank((CharSequence)lcondition) || StringUtils.isBlank((CharSequence)ccondition)) {
                return false;
            }
            if (StringUtils.equals((CharSequence)lcondition, (CharSequence)"0")) {
                if (StringUtils.equals((CharSequence)ccondition, (CharSequence)"0")) {
                    if (low.compareTo(up) != 0) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (StringUtils.equals((CharSequence)ccondition, (CharSequence)"0")) {
                if (StringUtils.equals((CharSequence)lcondition, (CharSequence)"0")) {
                    if (low.compareTo(up) != 0) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            boolean lmatch = false;
            lmatch = StringUtils.equals((CharSequence)lcondition, (CharSequence)"0") ? sysprecent.compareTo(low) == 0 : (StringUtils.equals((CharSequence)lcondition, (CharSequence)"1") ? sysprecent.compareTo(low) > 0 : sysprecent.compareTo(low) >= 0);
            boolean cmatch = false;
            cmatch = StringUtils.equals((CharSequence)ccondition, (CharSequence)"0") ? sysprecent.compareTo(up) == 0 : (StringUtils.equals((CharSequence)lcondition, (CharSequence)"1") ? sysprecent.compareTo(up) < 0 : sysprecent.compareTo(up) <= 0);
            boolean match = lmatch && cmatch;
            return match;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return sysprecent;
        }
        Map<BigDecimal, List<DynamicObject>> maps = collect.stream().collect(Collectors.groupingBy(col -> col.getBigDecimal("ceiling").subtract(sysprecent)));
        BigDecimal decimal = (BigDecimal)maps.keySet().stream().min((m1, m2) -> m1.compareTo((BigDecimal)m2)).get();
        return maps.get(decimal).get(0).getBigDecimal("ratio");
    }
}

