/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmc.pmts.business.helper.PmtsTaskHelper;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskRunTimeInfo;

public class PmtsProjectCalendarHelper {
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("pmts_workcalendar");
    private static final Log log = LogFactory.getLog(PmtsProjectCalendarHelper.class);
    private static final String WORKDATE = "workdate";
    private static final String WORKFINISHTIME = "workfinshtime";
    private static final String WORKSTARTTIME = "workstarttime";

    public static boolean isEffective(Map todayMap, long caid, PmtsTaskRunTimeInfo ctx) {
        try {
            SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
            Map calMap = PmtsProjectCalendarHelper.getCalMap(caid, ctx);
            Date stDate = SDF.parse((String)calMap.get("expirstartdate"));
            Date edDate = SDF.parse((String)calMap.get("expirendate"));
            long today = PmtsProjectCalendarHelper.getWorkDate(todayMap);
            return stDate.getTime() <= today && edDate.getTime() >= today;
        }
        catch (ParseException e) {
            log.error((Throwable)e);
            return false;
        }
    }

    public static long getWorkDate(Map todayMap) {
        return Long.parseLong(todayMap.get(WORKDATE).toString());
    }

    public static long getWorkStartDate(Map todayMap) {
        return Long.parseLong(todayMap.get(WORKSTARTTIME).toString());
    }

    public static long getWorkFinshDate(Map todayMap) {
        return Long.parseLong(todayMap.get(WORKFINISHTIME).toString());
    }

    public static boolean isRest(Map currDateMap, long caid) {
        switch (currDateMap.get("datetype").toString()) {
            case "3": {
                return true;
            }
            case "4": {
                return true;
            }
        }
        return false;
    }

    public static Map getScheduleNextDate(BigDecimal totalcost, Map todayMap, long caid, PmtsTaskRunTimeInfo ctx) {
        if (totalcost.compareTo(BigDecimal.ZERO) > 0) {
            long wkDate = PmtsProjectCalendarHelper.getWorkDate(todayMap);
            Map details = PmtsProjectCalendarHelper.getCalendarList(wkDate, caid, "next", ctx);
            Iterator itor = details.keySet().iterator();
            int size = details.size();
            int cost = totalcost.intValue();
            BigDecimal xs = totalcost.remainder(BigDecimal.ONE).setScale(2, 4);
            if (xs.compareTo(BigDecimal.ZERO) > 0) {
                ++cost;
            }
            if (cost > 0) {
                int index = 0;
                for (int i = 0; i < cost; ++i) {
                    if (PmtsProjectCalendarHelper.isOutOfCalendar(index, size, todayMap, caid, ctx)) {
                        return new HashMap();
                    }
                    todayMap = (Map)((List)details.get(itor.next())).get(0);
                    while (PmtsProjectCalendarHelper.isRest(todayMap, caid)) {
                        if (PmtsProjectCalendarHelper.isOutOfCalendar(++index, size, todayMap, caid, ctx)) {
                            new HashMap();
                        }
                        todayMap = (Map)((List)details.get(itor.next())).get(0);
                    }
                    ++index;
                }
            }
            if (xs.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal value = new BigDecimal(todayMap.get("diftime").toString());
                BigDecimal xsdate = xs.multiply(value);
                todayMap.put("xs", xsdate.longValue());
            }
        } else {
            todayMap = totalcost.compareTo(BigDecimal.ZERO) < 0 ? PmtsProjectCalendarHelper.getSchedulePrevDate(totalcost.abs(), todayMap, caid, ctx) : PmtsProjectCalendarHelper.getUnRestNextDate(todayMap, caid, ctx);
        }
        return todayMap;
    }

    public static Map getSchedulePrevDate(BigDecimal totalcost, Map todayMap, long caid, PmtsTaskRunTimeInfo ctx) {
        long wkDate = PmtsProjectCalendarHelper.getWorkDate(todayMap);
        if (totalcost.compareTo(BigDecimal.ZERO) > 0) {
            int cost = totalcost.intValue();
            Map details = PmtsProjectCalendarHelper.getCalendarList(PmtsProjectCalendarHelper.getWorkDate(todayMap), caid, "prev", ctx);
            Iterator itor = details.keySet().iterator();
            int size = details.size();
            int index = 0;
            for (int i = 0; i < cost; ++i) {
                if (PmtsProjectCalendarHelper.isOutOfCalendar(index, size, todayMap, caid, ctx)) {
                    return new HashMap();
                }
                todayMap = (Map)((List)details.get(itor.next())).get(0);
                while (PmtsProjectCalendarHelper.isRest(todayMap, caid)) {
                    if (PmtsProjectCalendarHelper.isOutOfCalendar(++index, size, todayMap, caid, ctx)) {
                        return new HashMap();
                    }
                    todayMap = (Map)((List)details.get(itor.next())).get(0);
                }
                ++index;
            }
            BigDecimal xs = totalcost.remainder(BigDecimal.ONE).setScale(2, 4);
            if (xs.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal value = new BigDecimal(todayMap.get("diftime").toString());
                BigDecimal xsdate = xs.multiply(value);
                todayMap.put("xs", xsdate.longValue());
            }
        } else {
            todayMap = totalcost.compareTo(BigDecimal.ZERO) < 0 ? PmtsProjectCalendarHelper.getScheduleNextDate(totalcost.abs(), todayMap, caid, ctx) : PmtsProjectCalendarHelper.getUnRestPrevDate(todayMap, caid, ctx);
        }
        return todayMap;
    }

    public static Map getUnRestNextDate(Map todayMap, long caid, PmtsTaskRunTimeInfo ctx) {
        if (PmtsProjectCalendarHelper.isEffective(todayMap, caid, ctx)) {
            long wkDate = PmtsProjectCalendarHelper.getWorkDate(todayMap);
            Map details = PmtsProjectCalendarHelper.getCalendarList(wkDate, caid, "next", ctx);
            Iterator itor = details.keySet().iterator();
            int size = details.size();
            int index = 0;
            while (PmtsProjectCalendarHelper.isRest(todayMap, caid)) {
                Map tomorrowMap;
                if (PmtsProjectCalendarHelper.isOutOfCalendar(index, size, todayMap, caid, ctx)) {
                    return new HashMap();
                }
                todayMap = tomorrowMap = (Map)((List)details.get(itor.next())).get(0);
                ++index;
            }
        }
        return todayMap;
    }

    public static Map getUnRestPrevDate(Map todayMap, long caid, PmtsTaskRunTimeInfo ctx) {
        if (PmtsProjectCalendarHelper.isEffective(todayMap, caid, ctx)) {
            long wkDate = PmtsProjectCalendarHelper.getWorkDate(todayMap);
            Map details = PmtsProjectCalendarHelper.getCalendarList(wkDate, caid, "prev", ctx);
            Iterator itor = details.keySet().iterator();
            int size = details.size();
            int index = 0;
            while (PmtsProjectCalendarHelper.isRest(todayMap, caid)) {
                Map tomorrowMap;
                if (PmtsProjectCalendarHelper.isOutOfCalendar(index, size, todayMap, caid, ctx)) {
                    return new HashMap();
                }
                todayMap = tomorrowMap = (Map)((List)details.get(itor.next())).get(0);
                ++index;
            }
        }
        return todayMap;
    }

    public static Map getCurrDateMap(long currdate, long caid, PmtsTaskRunTimeInfo ctx) {
        long sdfdate = PmtsProjectCalendarHelper.getSwitchDate(currdate);
        String dateKey = String.format("%s%s%s", caid, "_", sdfdate);
        Map<String, Object> dayMap = ctx.getWcf().getDayMap();
        if (dayMap.containsKey(dateKey)) {
            return (Map)dayMap.get(dateKey);
        }
        Map detailList = PmtsProjectCalendarHelper.getCalDetailList(caid, ctx);
        Map currDateMap = new HashMap();
        HashMap daMap = new HashMap();
        if (detailList.containsKey(String.valueOf(sdfdate))) {
            List ls = (List)detailList.get(String.valueOf(sdfdate));
            currDateMap = (Map)ls.get(0);
        }
        if (currDateMap.isEmpty()) {
            String dateString = PmtsProjectCalendarHelper.getDateString(currdate);
            Map calMap = PmtsProjectCalendarHelper.getCalMap(caid, ctx);
            PmtsTaskHelper.hasError(ctx, String.format(ResManager.loadKDString((String)"[%1$s]\u8d85\u51fa\u65e5\u5386[%2$s]\u65e5\u671f\u8303\u56f4", (String)"PmtsProjectCalendarHelper_1", (String)"mmc-pmts-business", (Object[])new Object[0]), dateString, calMap.get("number")));
        }
        daMap.putAll(currDateMap);
        dayMap.put(dateKey, daMap);
        return currDateMap;
    }

    public static Map getCalendarList(long currdate, long caid, String type, PmtsTaskRunTimeInfo ctx) {
        if (type.equals("next")) {
            return PmtsProjectCalendarHelper.getNextCalendars(currdate, caid, ctx);
        }
        return PmtsProjectCalendarHelper.getPrevCalendars(currdate, caid, ctx);
    }

    private static Map getNextCalendars(long currdate, long caid, PmtsTaskRunTimeInfo ctx) {
        String dateKey = String.valueOf(currdate) + "_" + String.valueOf(caid);
        Map<String, Object> nextColl = ctx.getWcf().getNextCollections();
        if (nextColl.containsKey(dateKey)) {
            return (Map)nextColl.get(dateKey);
        }
        Map details = PmtsProjectCalendarHelper.getCalDetailList(caid, ctx);
        LinkedHashMap tempList = new LinkedHashMap();
        tempList.putAll(details);
        Iterator iterator = details.keySet().iterator();
        while (iterator.hasNext()) {
            String mapKey = iterator.next().toString();
            long date = Long.parseLong(mapKey);
            if (date > currdate) continue;
            tempList.remove(mapKey);
        }
        nextColl.put(dateKey, tempList);
        return tempList;
    }

    private static Map getPrevCalendars(long currdate, long caid, PmtsTaskRunTimeInfo ctx) {
        String dateKey = String.valueOf(currdate) + "_" + String.valueOf(caid);
        Map<String, Object> prevColl = ctx.getWcf().getPrevCollections();
        if (prevColl.containsKey(dateKey)) {
            return (Map)prevColl.get(dateKey);
        }
        Map details = PmtsProjectCalendarHelper.getCalDetailList(caid, ctx);
        LinkedHashMap tempList = new LinkedHashMap();
        tempList.putAll(details);
        Iterator iterator = details.keySet().iterator();
        while (iterator.hasNext()) {
            String mapKey = iterator.next().toString();
            long date = Long.parseLong(mapKey);
            if (date < currdate) continue;
            tempList.remove(mapKey);
        }
        tempList = new LinkedHashMap(PmtsProjectCalendarHelper.sortMapByKey(tempList));
        prevColl.put(dateKey, tempList);
        return tempList;
    }

    private static Map getCalMap(long caid, PmtsTaskRunTimeInfo ctx) {
        Map<Object, Object> calCollections = ctx.getWcf().getCalCollections();
        if (calCollections.containsKey(caid)) {
            return (Map)calCollections.get(caid);
        }
        ArrayList calImf = (ArrayList)SerializationUtils.fromJsonString((String)((String)CACHE.get(String.valueOf(caid))), ArrayList.class);
        Map calMap = (Map)calImf.get(0);
        calCollections.put(caid, calMap);
        return calMap;
    }

    private static Map getCalDetailList(long caid, PmtsTaskRunTimeInfo ctx) {
        Map<Object, Object> detailCollections = ctx.getWcf().getDetailCollections();
        if (detailCollections.containsKey(caid)) {
            return (Map)detailCollections.get(caid);
        }
        ArrayList calImf = new ArrayList(2);
        calImf = !ctx.getWcf().getDayMap().containsKey(String.valueOf(caid)) ? (ArrayList)SerializationUtils.fromJsonString((String)((String)CACHE.get(String.valueOf(caid))), ArrayList.class) : (ArrayList)ctx.getWcf().getDayMap().get(String.valueOf(caid));
        Map map = (Map)calImf.get(0);
        Map details = (Map)map.get("detail");
        detailCollections.put(caid, details);
        return details;
    }

    private static String getDateString(long currdate) {
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        Calendar d = Calendar.getInstance();
        d.setTimeInMillis(currdate);
        return SDF.format(d.getTime());
    }

    private static long getSwitchDate(long currdate) {
        Calendar d = Calendar.getInstance();
        d.setTimeInMillis(currdate);
        long sdfdate = 0L;
        try {
            SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
            sdfdate = SDF.parse(SDF.format(d.getTime())).getTime();
        }
        catch (ParseException e) {
            log.error((Throwable)e);
        }
        return sdfdate;
    }

    private static boolean isOutOfCalendar(int index, int size, Map todayMap, long caid, PmtsTaskRunTimeInfo ctx) {
        boolean rs;
        boolean bl = rs = index >= size;
        if (rs) {
            DynamicObject dyObj = BusinessDataServiceHelper.loadSingleFromCache((Object)caid, (String)"pmbd_calendar", (String)"number");
            String errorStr = String.format(ResManager.loadKDString((String)"\u6392\u7a0b\u65e5\u671f\u8d85\u51fa%s\u65e5\u5386\u6709\u6548\u65f6\u95f4\u8303\u56f4\u3002", (String)"PmtsProjectCalendarHelper_3", (String)"mmc-pmts-business", (Object[])new Object[0]), dyObj.getString("number"));
            PmtsTaskHelper.hasError(ctx, errorStr);
        }
        return rs;
    }

    public static Map sortMapByKey(Map map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        TreeMap sortMap = new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                long value = Long.parseLong(o1) - Long.parseLong(o2);
                if (value > 0L) {
                    return -1;
                }
                if (value == 0L) {
                    return 0;
                }
                return 1;
            }
        });
        sortMap.putAll(map);
        return sortMap;
    }
}

