/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmc.pmts.business.helper.PmtsTaskHelper;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskRunTimeInfo;
import org.apache.commons.collections.MapUtils;

public class PmtsProjectCalendarNewHelper {
    private static final DistributeSessionlessCache HOUR_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("pmts_workcalendar_hour");
    private static final Log log = LogFactory.getLog(PmtsProjectCalendarNewHelper.class);
    private static long ONEDAYMS = 28800000L;

    public static long getScheduleNextDate(BigDecimal totalcost, long today, long caid, PmtsTaskRunTimeInfo ctx) {
        if (totalcost.compareTo(BigDecimal.ZERO) == 0) {
            totalcost = BigDecimal.ONE;
        }
        if (totalcost.compareTo(BigDecimal.ZERO) > 0) {
            Map details = PmtsProjectCalendarNewHelper.getCalendarList(today, caid, "next", ctx);
            Map detail = (Map)details.get("detail");
            Map detail_total = (Map)details.get("detail_total");
            if (MapUtils.isEmpty((Map)detail) || MapUtils.isEmpty((Map)detail_total)) {
                PmtsProjectCalendarNewHelper.isOutCalendar(totalcost, today, ctx, caid, 1);
            }
            long wft = 0L;
            long total = 0L;
            Map hMap = new HashMap();
            Set set = detail_total.entrySet();
            long cost = 0L;
            for (Map.Entry s : set) {
                int i;
                ArrayList hours = (ArrayList)detail.get(s.getKey());
                if (totalcost.compareTo(BigDecimal.ONE) == 0) {
                    for (i = 0; i < hours.size(); ++i) {
                        wft = (Long)((Map)hours.get(i)).get("workfinshtime");
                        long curwst = (Long)((Map)hours.get(i)).get("workstarttime");
                        if (wft <= today) continue;
                        if (today > curwst) {
                            return today;
                        }
                        return curwst;
                    }
                    if (wft <= today) continue;
                }
                for (i = 0; i < hours.size(); ++i) {
                    long rem;
                    Map hourMap = (Map)hours.get(i);
                    long curwft = (Long)hourMap.get("workfinshtime");
                    int cur = (Integer)hourMap.get("diftime");
                    long curwst = (Long)hourMap.get("workstarttime");
                    if (today >= curwft) continue;
                    total = today > curwst ? ((rem = today - curwst) > 0L && rem < (long)cur ? total + (long)cur - rem : (total += (long)cur)) : (total += (long)cur);
                    if (total < totalcost.longValue()) continue;
                    hMap = hourMap;
                    break;
                }
                if (total == totalcost.longValue()) {
                    long curwst = (Long)hMap.get("workstarttime");
                    int curdif = (Integer)hMap.get("diftime");
                    long as = totalcost.longValue() - (total - (long)curdif);
                    return curwst + as;
                }
                if (total <= totalcost.longValue()) continue;
                long curwst = (Long)hMap.get("workstarttime");
                int curdif = (Integer)hMap.get("diftime");
                long as = totalcost.longValue() - (total - (long)curdif);
                return curwst + as;
            }
            if (wft == 0L) {
                PmtsProjectCalendarNewHelper.isOutCalendar(totalcost, today, ctx, caid, 1);
            }
            return wft;
        }
        return PmtsProjectCalendarNewHelper.getSchedulePrevDate(totalcost.abs(), today, caid, ctx);
    }

    public static long getSchedulePrevDate(BigDecimal totalcost, long today, long caid, PmtsTaskRunTimeInfo ctx) {
        if (totalcost.compareTo(BigDecimal.ZERO) == 0) {
            totalcost = BigDecimal.ONE;
        }
        if (totalcost.compareTo(BigDecimal.ZERO) > 0) {
            Map details = PmtsProjectCalendarNewHelper.getCalendarList(today, caid, "prev", ctx);
            Map detail = (Map)details.get("detail");
            Map detail_total = (Map)details.get("detail_total");
            if (MapUtils.isEmpty((Map)detail) || MapUtils.isEmpty((Map)detail_total)) {
                PmtsProjectCalendarNewHelper.isOutCalendar(totalcost, today, ctx, caid, 1);
            }
            long wst = 0L;
            long total = 0L;
            Set set = detail_total.entrySet();
            long cost = 0L;
            Map hMap = new HashMap();
            for (Map.Entry s : set) {
                int curdif;
                long curwft;
                ArrayList hours = (ArrayList)detail.get(s.getKey());
                if (totalcost.compareTo(BigDecimal.ONE) == 0) {
                    long curwst = 0L;
                    for (int i = hours.size(); i > 0; --i) {
                        Map hourMap = (Map)hours.get(i - 1);
                        curwst = (Long)hourMap.get("workstarttime");
                        curwft = (Long)hourMap.get("workfinshtime");
                        if (today <= curwst) continue;
                        if (today < curwft) {
                            return today;
                        }
                        return curwft;
                    }
                    if (today <= curwst) continue;
                }
                for (int i = hours.size(); i > 0; --i) {
                    long rem;
                    Map hourMap = (Map)hours.get(i - 1);
                    long curwst = (Long)hourMap.get("workstarttime");
                    curwft = (Long)hourMap.get("workfinshtime");
                    int cur = (Integer)hourMap.get("diftime");
                    if (today <= curwst) continue;
                    total = today < curwft ? ((rem = curwft - today) > 0L && rem < (long)cur ? total + (long)cur - rem : (total += (long)cur)) : (total += (long)cur);
                    if (total < totalcost.longValue()) continue;
                    hMap = hourMap;
                    break;
                }
                if (total == totalcost.longValue()) {
                    long curwft2 = (Long)hMap.get("workfinshtime");
                    curdif = (Integer)hMap.get("diftime");
                    long as = totalcost.longValue() - (total - (long)curdif);
                    return curwft2 - as;
                }
                if (total <= totalcost.longValue()) continue;
                long curwft3 = (Long)hMap.get("workfinshtime");
                curdif = (Integer)hMap.get("diftime");
                long as = totalcost.longValue() - (total - (long)curdif);
                return curwft3 - as;
            }
            if (wst == 0L) {
                PmtsProjectCalendarNewHelper.isOutCalendar(totalcost, today, ctx, caid, 2);
            }
            return wst;
        }
        return PmtsProjectCalendarNewHelper.getScheduleNextDate(totalcost.abs(), today, caid, ctx);
    }

    public static Map getCalendarList(long currdate, long caid, String type, PmtsTaskRunTimeInfo ctx) {
        if (type.equals("next")) {
            return PmtsProjectCalendarNewHelper.getNextCalendars(currdate, caid, ctx);
        }
        return PmtsProjectCalendarNewHelper.getPrevCalendars(currdate, caid, ctx);
    }

    private static Map getNextCalendars(long currdate, long caid, PmtsTaskRunTimeInfo ctx) {
        String dateKey = String.valueOf(currdate) + "_" + String.valueOf(caid);
        Map<String, Object> nextColl = ctx.getWcf().getNextCollections();
        if (nextColl.containsKey(dateKey)) {
            return (Map)nextColl.get(dateKey);
        }
        Map details = PmtsProjectCalendarNewHelper.getCalDetailList(caid, ctx);
        HashMap<String, Map> copyDetails = new HashMap<String, Map>(details);
        Map detail = (Map)details.get("detail");
        detail = PmtsProjectCalendarNewHelper.removeObjAsc(detail, currdate);
        copyDetails.put("detail", PmtsProjectCalendarNewHelper.sortMapByKeyAsc(detail));
        Map detail_total = (Map)details.get("detail_total");
        detail_total = PmtsProjectCalendarNewHelper.removeObjAsc(detail_total, currdate);
        copyDetails.put("detail_total", PmtsProjectCalendarNewHelper.sortMapByKeyAsc(detail_total));
        return copyDetails;
    }

    private static Map getPrevCalendars(long currdate, long caid, PmtsTaskRunTimeInfo ctx) {
        String dateKey = String.valueOf(currdate) + "_" + String.valueOf(caid);
        Map<String, Object> prevColl = ctx.getWcf().getPrevCollections();
        if (prevColl.containsKey(dateKey)) {
            return (Map)prevColl.get(dateKey);
        }
        Map details = PmtsProjectCalendarNewHelper.getCalDetailList(caid, ctx);
        HashMap<String, Map> copyDetails = new HashMap<String, Map>(details);
        Map detail = (Map)details.get("detail");
        detail = PmtsProjectCalendarNewHelper.removeObjDesc(detail, currdate);
        copyDetails.put("detail", PmtsProjectCalendarNewHelper.sortMapByKeyDesc(detail));
        Map detail_total = (Map)details.get("detail_total");
        detail_total = PmtsProjectCalendarNewHelper.removeObjDesc(detail_total, currdate);
        copyDetails.put("detail_total", PmtsProjectCalendarNewHelper.sortMapByKeyDesc(detail_total));
        return copyDetails;
    }

    private static Map getCalDetailList(long caid, PmtsTaskRunTimeInfo ctx) {
        Map<Object, Object> detailCollections = ctx.getWcf().getDetailCollections();
        if (detailCollections.containsKey(caid)) {
            return (Map)detailCollections.get(caid);
        }
        ArrayList calImf = new ArrayList(2);
        calImf = !ctx.getWcf().getDayMap().containsKey(String.valueOf(caid)) ? (ArrayList)SerializationUtils.fromJsonString((String)((String)HOUR_CACHE.get(String.valueOf(caid))), ArrayList.class) : (ArrayList)ctx.getWcf().getDayMap().get(String.valueOf(caid));
        if (calImf.isEmpty()) {
            String esg = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u65e5\u5386\u662f\u5426\u5b58\u5728\u3002", (String)"PmtsProjectCalendarNewHelper_5", (String)"mmc-pmts-business", (Object[])new Object[0]);
            PmtsTaskHelper.hasError(ctx, esg);
        }
        Map map = (Map)calImf.get(0);
        detailCollections.put(caid, map);
        return map;
    }

    public static Map sortMapByKeyAsc(Map map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        TreeMap sortMap = new TreeMap(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                long l2;
                if (o1 instanceof Long) {
                    long value = (Long)o1 - (Long)o2;
                    if (value > 0L) {
                        return 1;
                    }
                    if (value == 0L) {
                        return 0;
                    }
                    return -1;
                }
                String s1 = (String)o1;
                String s2 = (String)o2;
                long l1 = Long.parseLong(s1.split("_")[0]);
                long value = l1 - (l2 = Long.parseLong(s2.split("_")[0]));
                if (value > 0L) {
                    return 1;
                }
                if (value == 0L) {
                    return 0;
                }
                return -1;
            }
        });
        sortMap.putAll(map);
        return sortMap;
    }

    public static Map sortMapByKeyDesc(Map map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        TreeMap sortMap = new TreeMap(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                long l2;
                if (o1 instanceof Long) {
                    long value = (Long)o1 - (Long)o2;
                    if (value > 0L) {
                        return -1;
                    }
                    if (value == 0L) {
                        return 0;
                    }
                    return 1;
                }
                String s1 = (String)o1;
                String s2 = (String)o2;
                long l1 = Long.parseLong(s1.split("_")[0]);
                long value = l1 - (l2 = Long.parseLong(s2.split("_")[0]));
                if (value > 0L) {
                    return -1;
                }
                if (value == 0L) {
                    return 0;
                }
                return 1;
            }
        });
        sortMap.putAll(map);
        return sortMap;
    }

    public static Map removeObjAsc(Map m, long date) {
        LinkedHashMap map = new LinkedHashMap();
        map.putAll(m);
        for (Object mK : m.keySet()) {
            long wkt = Long.parseLong(mK.toString());
            if (wkt >= date || PmtsProjectCalendarNewHelper.getSwitchDate(date) == wkt) continue;
            map.remove(mK);
        }
        return map;
    }

    private static Map removeObjDesc(Map m, long date) {
        LinkedHashMap map = new LinkedHashMap();
        map.putAll(m);
        for (Object mK : m.keySet()) {
            long wkt = Long.parseLong(mK.toString());
            if (wkt <= date || PmtsProjectCalendarNewHelper.getSwitchDate(date) == wkt) continue;
            map.remove(mK);
        }
        return map;
    }

    private static long getSwitchDate(long currdate) {
        Calendar d = Calendar.getInstance();
        d.setTimeInMillis(currdate);
        long sdfdate = 0L;
        try {
            SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
            sdfdate = SDF.parse(SDF.format(d.getTime())).getTime();
        }
        catch (ParseException e) {
            log.error((Throwable)e);
        }
        return sdfdate;
    }

    public static void isOutCalendar(BigDecimal dut, long date, PmtsTaskRunTimeInfo ctx, long calid, int type) {
        SimpleDateFormat hour = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject pmbd_calendar = BusinessDataServiceHelper.loadSingleFromCache((Object)calid, (String)"pmbd_calendar");
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date);
        String format = hour.format(c.getTime());
        StringBuilder sbr = new StringBuilder();
        sbr.append("[");
        sbr.append(format);
        sbr.append("]");
        String gq = ResManager.loadKDString((String)"\u6309\u7167\u5de5\u671f", (String)"PmtsProjectCalendarNewHelper_0", (String)"mmc-pmts-business", (Object[])new Object[0]);
        sbr.append(gq);
        sbr.append(dut);
        if (type == 1) {
            String zp = ResManager.loadKDString((String)"\u6b63\u6392\u65f6\u95f4", (String)"PmtsProjectCalendarNewHelper_1", (String)"mmc-pmts-business", (Object[])new Object[0]);
            sbr.append(zp);
        } else {
            String dp = ResManager.loadKDString((String)"\u5012\u6392\u65f6\u95f4", (String)"PmtsProjectCalendarNewHelper_2", (String)"mmc-pmts-business", (Object[])new Object[0]);
            sbr.append(dp);
        }
        String ot = ResManager.loadKDString((String)"\u8d85\u51fa\u65e5\u5386", (String)"PmtsProjectCalendarNewHelper_3", (String)"mmc-pmts-business", (Object[])new Object[0]);
        sbr.append(ot).append(pmbd_calendar.getString("number"));
        String rg = ResManager.loadKDString((String)"\u8303\u56f4", (String)"PmtsProjectCalendarNewHelper_4", (String)"mmc-pmts-business", (Object[])new Object[0]);
        sbr.append(rg);
        PmtsTaskHelper.hasError(ctx, sbr.toString());
    }
}

